/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.skel;

import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.PartialFunction;
import scala.collection.Factory;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Cloneable;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.SeqOps;
import scala.concurrent.stm.skel.AtomicArray$;
import scala.concurrent.stm.skel.AtomicArrayBuilder;
import scala.math.Integral;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;

public abstract class AtomicArray<T>
implements IndexedSeq<T> {
    private final SeqFactory iterableFactory;

    public static Factory evidenceIterableFactory(Object object) {
        return AtomicArray$.MODULE$.evidenceIterableFactory(object);
    }

    public static scala.collection.SeqOps fill(int n, Function0 function0, ClassTag classTag) {
        return AtomicArray$.MODULE$.fill(n, function0, classTag);
    }

    public static Object fill(int n, Function0 function0, Object object) {
        return AtomicArray$.MODULE$.fill(n, function0, object);
    }

    public static Object fill(int n, int n2, Function0 function0, ClassTag classTag) {
        return AtomicArray$.MODULE$.fill(n, n2, function0, classTag);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0, ClassTag classTag) {
        return AtomicArray$.MODULE$.fill(n, n2, n3, function0, classTag);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0, ClassTag classTag) {
        return AtomicArray$.MODULE$.fill(n, n2, n3, n4, function0, classTag);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0, ClassTag classTag) {
        return AtomicArray$.MODULE$.fill(n, n2, n3, n4, n5, function0, classTag);
    }

    public static <T> AtomicArray<T> from(IterableOnce<T> iterableOnce, ClassTag<T> classTag) {
        return AtomicArray$.MODULE$.from(iterableOnce, classTag);
    }

    public static Object iterate(Object object, int n, Function1 function1, Object object2) {
        return AtomicArray$.MODULE$.iterate(object, n, function1, object2);
    }

    public static <T> Builder<T, AtomicArray<T>> newBuilder(ClassTag<T> classTag) {
        return AtomicArray$.MODULE$.newBuilder(classTag);
    }

    public static Object range(Object object, Object object2, Integral integral, ClassTag classTag) {
        return AtomicArray$.MODULE$.range(object, object2, integral, classTag);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral, ClassTag classTag) {
        return AtomicArray$.MODULE$.range(object, object2, object3, integral, classTag);
    }

    public static scala.collection.SeqOps tabulate(int n, Function1 function1, ClassTag classTag) {
        return AtomicArray$.MODULE$.tabulate(n, function1, classTag);
    }

    public static Object tabulate(int n, Function1 function1, Object object) {
        return AtomicArray$.MODULE$.tabulate(n, function1, object);
    }

    public static Object tabulate(int n, int n2, Function2 function2, ClassTag classTag) {
        return AtomicArray$.MODULE$.tabulate(n, n2, function2, classTag);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3, ClassTag classTag) {
        return AtomicArray$.MODULE$.tabulate(n, n2, n3, function3, classTag);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4, ClassTag classTag) {
        return AtomicArray$.MODULE$.tabulate(n, n2, n3, n4, function4, classTag);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5, ClassTag classTag) {
        return AtomicArray$.MODULE$.tabulate(n, n2, n3, n4, n5, function5, classTag);
    }

    public static scala.collection.SeqOps unapplySeq(scala.collection.SeqOps seqOps) {
        return AtomicArray$.MODULE$.unapplySeq(seqOps);
    }

    public static Object unfold(Object object, Function1 function1, Object object2) {
        return AtomicArray$.MODULE$.unfold(object, function1, object2);
    }

    public static SeqFactory untagged() {
        return AtomicArray$.MODULE$.untagged();
    }

    public <T> AtomicArray() {
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        scala.collection.mutable.Iterable.$init$((scala.collection.mutable.Iterable)this);
        PartialFunction.$init$((PartialFunction)this);
        scala.collection.SeqOps.$init$((scala.collection.SeqOps)this);
        Seq.$init$((Seq)this);
        Cloneable.$init$((Cloneable)this);
        SeqOps.$init$((SeqOps)this);
        scala.collection.mutable.Seq.$init$((scala.collection.mutable.Seq)this);
        IndexedSeqOps.$init$((IndexedSeqOps)this);
        scala.collection.IndexedSeq.$init$((scala.collection.IndexedSeq)this);
        scala.collection.mutable.IndexedSeqOps.$init$((scala.collection.mutable.IndexedSeqOps)this);
        IndexedSeq.$init$((IndexedSeq)this);
        this.iterableFactory = AtomicArray$.MODULE$.untagged();
    }

    public <B> AtomicArray<B> scala$collection$SeqOps$$super$concat(IterableOnce<B> suffix) {
        return (AtomicArray)IterableOps.concat$((IterableOps)this, suffix);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(int otherSize) {
        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
    }

    public int scala$collection$SeqOps$$super$sizeCompare(Iterable<?> that) {
        return IterableOps.sizeCompare$((IterableOps)this, that);
    }

    public Object scala$collection$mutable$Cloneable$$super$clone() {
        return super.clone();
    }

    public SeqFactory<AtomicArray> iterableFactory() {
        return this.iterableFactory;
    }

    public abstract int length();

    public abstract T apply(int var1);

    public abstract void update(int var1, T var2);

    public abstract T swap(int var1, T var2);

    public abstract boolean compareAndSet(int var1, T var2, T var3);

    public final T getAndTransform(int index, Function1<T, T> f) {
        T before;
        AtomicArray atomicArray = this;
        while (!atomicArray.compareAndSet(index, before = atomicArray.apply(index), f.apply(before))) {
        }
        return before;
    }

    public String className() {
        return "AtomicArray";
    }

    public AtomicArray<T> clone() {
        Builder b = this.newSpecificBuilder();
        b.sizeHint(this.length());
        b.$plus$plus$eq((IterableOnce)this);
        return (AtomicArray)b.result();
    }

    public static final class ofBoolean
    extends AtomicArray<Object> {
        private final AtomicIntegerArray elems;

        public ofBoolean(AtomicIntegerArray elems) {
            this.elems = elems;
        }

        public ofBoolean(int size) {
            this(new AtomicIntegerArray(size));
        }

        private boolean decode(int v) {
            return v != 0;
        }

        private int encode(boolean elem) {
            return elem ? 1 : 0;
        }

        @Override
        public int length() {
            return this.elems.length();
        }

        @Override
        public boolean apply(int index) {
            return this.apply$mcZI$sp(index);
        }

        @Override
        public boolean apply$mcZI$sp(int index) {
            return this.decode(this.elems.get(index));
        }

        @Override
        public void update(int index, boolean elem) {
            this.elems.set(index, this.encode(elem));
        }

        @Override
        public boolean swap(int index, boolean elem) {
            return this.decode(this.elems.getAndSet(index, this.encode(elem)));
        }

        @Override
        public boolean compareAndSet(int index, boolean expected, boolean elem) {
            return this.elems.compareAndSet(index, this.encode(expected), this.encode(elem));
        }

        @Override
        public Builder<Object, AtomicArray<Object>> newSpecificBuilder() {
            return new AtomicArrayBuilder.ofBoolean();
        }
    }

    public static final class ofByte
    extends AtomicArray<Object> {
        private final AtomicIntegerArray elems;

        public ofByte(AtomicIntegerArray elems) {
            this.elems = elems;
        }

        public ofByte(int size) {
            this(new AtomicIntegerArray(size));
        }

        @Override
        public int length() {
            return this.elems.length();
        }

        @Override
        public byte apply(int index) {
            return (byte)this.elems.get(index);
        }

        @Override
        public void update(int index, byte elem) {
            this.elems.set(index, elem);
        }

        @Override
        public byte swap(int index, byte elem) {
            return (byte)this.elems.getAndSet(index, elem);
        }

        @Override
        public boolean compareAndSet(int index, byte expected, byte elem) {
            return this.elems.compareAndSet(index, expected, elem);
        }

        @Override
        public Builder<Object, AtomicArray<Object>> newSpecificBuilder() {
            return new AtomicArrayBuilder.ofByte();
        }
    }

    public static final class ofChar
    extends AtomicArray<Object> {
        private final AtomicIntegerArray elems;

        public ofChar(AtomicIntegerArray elems) {
            this.elems = elems;
        }

        public ofChar(int size) {
            this(new AtomicIntegerArray(size));
        }

        @Override
        public int length() {
            return this.elems.length();
        }

        @Override
        public char apply(int index) {
            return (char)this.elems.get(index);
        }

        @Override
        public void update(int index, char elem) {
            this.elems.set(index, elem);
        }

        @Override
        public char swap(int index, char elem) {
            return (char)this.elems.getAndSet(index, elem);
        }

        @Override
        public boolean compareAndSet(int index, char expected, char elem) {
            return this.elems.compareAndSet(index, expected, elem);
        }

        @Override
        public Builder<Object, AtomicArray<Object>> newSpecificBuilder() {
            return new AtomicArrayBuilder.ofChar();
        }
    }

    public static final class ofDouble
    extends AtomicArray<Object> {
        private final AtomicLongArray elems;

        public ofDouble(AtomicLongArray elems) {
            this.elems = elems;
        }

        public ofDouble(int size) {
            this(new AtomicLongArray(size));
        }

        private double decode(long v) {
            return Double.longBitsToDouble(v);
        }

        private long encode(double elem) {
            return Double.doubleToLongBits(elem);
        }

        @Override
        public int length() {
            return this.elems.length();
        }

        @Override
        public double apply(int index) {
            return this.apply$mcDI$sp(index);
        }

        @Override
        public double apply$mcDI$sp(int index) {
            return this.decode(this.elems.get(index));
        }

        @Override
        public void update(int index, double elem) {
            this.elems.set(index, this.encode(elem));
        }

        @Override
        public double swap(int index, double elem) {
            return this.decode(this.elems.getAndSet(index, this.encode(elem)));
        }

        @Override
        public boolean compareAndSet(int index, double expected, double elem) {
            return this.elems.compareAndSet(index, this.encode(expected), this.encode(elem));
        }

        @Override
        public Builder<Object, AtomicArray<Object>> newSpecificBuilder() {
            return new AtomicArrayBuilder.ofDouble();
        }
    }

    public static final class ofFloat
    extends AtomicArray<Object> {
        private final AtomicIntegerArray elems;

        public ofFloat(AtomicIntegerArray elems) {
            this.elems = elems;
        }

        public ofFloat(int size) {
            this(new AtomicIntegerArray(size));
        }

        private float decode(int v) {
            return Float.intBitsToFloat(v);
        }

        private int encode(float elem) {
            return Float.floatToIntBits(elem);
        }

        @Override
        public int length() {
            return this.elems.length();
        }

        @Override
        public float apply(int index) {
            return this.apply$mcFI$sp(index);
        }

        @Override
        public float apply$mcFI$sp(int index) {
            return this.decode(this.elems.get(index));
        }

        @Override
        public void update(int index, float elem) {
            this.elems.set(index, this.encode(elem));
        }

        @Override
        public float swap(int index, float elem) {
            return this.decode(this.elems.getAndSet(index, this.encode(elem)));
        }

        @Override
        public boolean compareAndSet(int index, float expected, float elem) {
            return this.elems.compareAndSet(index, this.encode(expected), this.encode(elem));
        }

        @Override
        public Builder<Object, AtomicArray<Object>> newSpecificBuilder() {
            return new AtomicArrayBuilder.ofFloat();
        }
    }

    public static final class ofInt
    extends AtomicArray<Object> {
        private final AtomicIntegerArray elems;

        public ofInt(AtomicIntegerArray elems) {
            this.elems = elems;
        }

        public ofInt(int size) {
            this(new AtomicIntegerArray(size));
        }

        @Override
        public int length() {
            return this.elems.length();
        }

        @Override
        public int apply(int index) {
            return this.apply$mcII$sp(index);
        }

        @Override
        public int apply$mcII$sp(int index) {
            return this.elems.get(index);
        }

        @Override
        public void update(int index, int elem) {
            this.elems.set(index, elem);
        }

        @Override
        public int swap(int index, int elem) {
            return this.elems.getAndSet(index, elem);
        }

        @Override
        public boolean compareAndSet(int index, int expected, int elem) {
            return this.elems.compareAndSet(index, expected, elem);
        }

        @Override
        public Builder<Object, AtomicArray<Object>> newSpecificBuilder() {
            return new AtomicArrayBuilder.ofInt();
        }
    }

    public static final class ofLong
    extends AtomicArray<Object> {
        private final AtomicLongArray elems;

        public ofLong(AtomicLongArray elems) {
            this.elems = elems;
        }

        public ofLong(int size) {
            this(new AtomicLongArray(size));
        }

        @Override
        public int length() {
            return this.elems.length();
        }

        @Override
        public long apply(int index) {
            return this.apply$mcJI$sp(index);
        }

        @Override
        public long apply$mcJI$sp(int index) {
            return this.elems.get(index);
        }

        @Override
        public void update(int index, long elem) {
            this.elems.set(index, elem);
        }

        @Override
        public long swap(int index, long elem) {
            return this.elems.getAndSet(index, elem);
        }

        @Override
        public boolean compareAndSet(int index, long expected, long elem) {
            return this.elems.compareAndSet(index, expected, elem);
        }

        @Override
        public Builder<Object, AtomicArray<Object>> newSpecificBuilder() {
            return new AtomicArrayBuilder.ofLong();
        }
    }

    public static final class ofRef<T>
    extends AtomicArray<T> {
        private final AtomicReferenceArray<T> elems;

        public <T> ofRef(AtomicReferenceArray<T> elems) {
            this.elems = elems;
        }

        public <T> ofRef(int size) {
            this(new AtomicReferenceArray(size));
        }

        @Override
        public int length() {
            return this.elems.length();
        }

        @Override
        public T apply(int index) {
            return this.elems.get(index);
        }

        @Override
        public void update(int index, T elem) {
            this.elems.set(index, elem);
        }

        @Override
        public T swap(int index, T elem) {
            return this.elems.getAndSet(index, elem);
        }

        @Override
        public boolean compareAndSet(int index, T expected, T elem) {
            return this.elems.compareAndSet(index, expected, elem);
        }

        @Override
        public Builder<T, AtomicArray<T>> newSpecificBuilder() {
            return new AtomicArrayBuilder.ofRef();
        }
    }

    public static final class ofShort
    extends AtomicArray<Object> {
        private final AtomicIntegerArray elems;

        public ofShort(AtomicIntegerArray elems) {
            this.elems = elems;
        }

        public ofShort(int size) {
            this(new AtomicIntegerArray(size));
        }

        @Override
        public int length() {
            return this.elems.length();
        }

        @Override
        public short apply(int index) {
            return (short)this.elems.get(index);
        }

        @Override
        public void update(int index, short elem) {
            this.elems.set(index, elem);
        }

        @Override
        public short swap(int index, short elem) {
            return (short)this.elems.getAndSet(index, elem);
        }

        @Override
        public boolean compareAndSet(int index, short expected, short elem) {
            return this.elems.compareAndSet(index, expected, elem);
        }

        @Override
        public Builder<Object, AtomicArray<Object>> newSpecificBuilder() {
            return new AtomicArrayBuilder.ofShort();
        }
    }

    public static final class ofUnit
    extends AtomicArray<BoxedUnit> {
        private final int length;
        private final AtomicReference<BoxedUnit> dummy;

        public ofUnit(int length) {
            this.length = length;
            this.dummy = new AtomicReference<BoxedUnit>(BoxedUnit.UNIT);
        }

        @Override
        public int length() {
            return this.length;
        }

        private AtomicReference<BoxedUnit> ref(int index) {
            if (index < 0 || index >= this.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this.dummy;
        }

        @Override
        public void apply(int index) {
            this.apply$mcVI$sp(index);
        }

        @Override
        public void apply$mcVI$sp(int index) {
            this.ref(index).get();
        }

        @Override
        public void update(int index, BoxedUnit elem) {
            this.ref(index).set(elem);
        }

        @Override
        public void swap(int index, BoxedUnit elem) {
            this.ref(index).getAndSet(elem);
        }

        @Override
        public boolean compareAndSet(int index, BoxedUnit expected, BoxedUnit elem) {
            return this.ref(index).compareAndSet(expected, elem);
        }

        @Override
        public Builder<BoxedUnit, AtomicArray<BoxedUnit>> newSpecificBuilder() {
            return new AtomicArrayBuilder.ofUnit();
        }
    }
}

