/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.skel;

import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import scala.Array$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.concurrent.stm.skel.AtomicArray;
import scala.concurrent.stm.skel.AtomicArrayBuilder$;
import scala.runtime.BoxedUnit;

public interface AtomicArrayBuilder<A>
extends Builder<A, AtomicArray<A>> {

    public static abstract class IntBacked<T>
    implements AtomicArrayBuilder<T> {
        private int[] elems;
        private int size;

        public <T> IntBacked() {
            Growable.$init$((Growable)this);
            Builder.$init$((Builder)this);
            this.elems = AtomicArrayBuilder$.scala$concurrent$stm$skel$AtomicArrayBuilder$$$EmptyIntArray;
            this.size = 0;
        }

        public int[] elems() {
            return this.elems;
        }

        public void elems_$eq(int[] x$1) {
            this.elems = x$1;
        }

        public int size() {
            return this.size;
        }

        public void size_$eq(int x$1) {
            this.size = x$1;
        }

        public void setCapacity(int newCap) {
            if (newCap != this.elems().length) {
                int[] newElems = new int[newCap];
                if (this.size() > 0) {
                    Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newElems, 0, this.size());
                }
                this.elems_$eq(newElems);
            }
        }

        public void sizeHint(int sizeHint) {
            if (this.elems().length < sizeHint) {
                this.setCapacity(sizeHint);
            }
        }

        public void ensureSpace() {
            int cap = this.elems().length;
            if (this.size() == cap) {
                this.setCapacity(cap == 0 ? 16 : cap * 2);
            }
        }

        public void clear() {
            this.size_$eq(0);
        }
    }

    public static abstract class LongBacked<T>
    implements AtomicArrayBuilder<T> {
        private long[] elems;
        private int size;

        public <T> LongBacked() {
            Growable.$init$((Growable)this);
            Builder.$init$((Builder)this);
            this.elems = AtomicArrayBuilder$.scala$concurrent$stm$skel$AtomicArrayBuilder$$$EmptyLongArray;
            this.size = 0;
        }

        public long[] elems() {
            return this.elems;
        }

        public void elems_$eq(long[] x$1) {
            this.elems = x$1;
        }

        public int size() {
            return this.size;
        }

        public void size_$eq(int x$1) {
            this.size = x$1;
        }

        public void setCapacity(int newCap) {
            if (newCap != this.elems().length) {
                long[] newElems = new long[newCap];
                if (this.size() > 0) {
                    Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newElems, 0, this.size());
                }
                this.elems_$eq(newElems);
            }
        }

        public void sizeHint(int sizeHint) {
            if (this.elems().length < sizeHint) {
                this.setCapacity(sizeHint);
            }
        }

        public void ensureSpace() {
            int cap = this.elems().length;
            if (this.size() == cap) {
                this.setCapacity(cap == 0 ? 16 : cap * 2);
            }
        }

        public void clear() {
            this.size_$eq(0);
        }
    }

    public static class ofBoolean
    extends IntBacked<Object> {
        public ofBoolean addOne(boolean elem) {
            this.ensureSpace();
            this.elems()[this.size()] = elem ? 1 : 0;
            this.size_$eq(this.size() + 1);
            return this;
        }

        public AtomicArray<Object> result() {
            this.setCapacity(this.size());
            return new AtomicArray.ofBoolean(new AtomicIntegerArray(this.elems()));
        }
    }

    public static class ofByte
    extends IntBacked<Object> {
        public ofByte addOne(byte elem) {
            this.ensureSpace();
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        public AtomicArray<Object> result() {
            this.setCapacity(this.size());
            return new AtomicArray.ofByte(new AtomicIntegerArray(this.elems()));
        }
    }

    public static class ofChar
    extends IntBacked<Object> {
        public ofChar addOne(char elem) {
            this.ensureSpace();
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        public AtomicArray<Object> result() {
            this.setCapacity(this.size());
            return new AtomicArray.ofChar(new AtomicIntegerArray(this.elems()));
        }
    }

    public static class ofDouble
    extends LongBacked<Object> {
        public ofDouble addOne(double elem) {
            this.ensureSpace();
            this.elems()[this.size()] = Double.doubleToRawLongBits(elem);
            this.size_$eq(this.size() + 1);
            return this;
        }

        public AtomicArray<Object> result() {
            this.setCapacity(this.size());
            return new AtomicArray.ofDouble(new AtomicLongArray(this.elems()));
        }
    }

    public static class ofFloat
    extends IntBacked<Object> {
        public ofFloat addOne(float elem) {
            this.ensureSpace();
            this.elems()[this.size()] = Float.floatToRawIntBits(elem);
            this.size_$eq(this.size() + 1);
            return this;
        }

        public AtomicArray<Object> result() {
            this.setCapacity(this.size());
            return new AtomicArray.ofFloat(new AtomicIntegerArray(this.elems()));
        }
    }

    public static class ofInt
    extends IntBacked<Object> {
        public ofInt addOne(int elem) {
            this.ensureSpace();
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        public AtomicArray<Object> result() {
            this.setCapacity(this.size());
            return new AtomicArray.ofInt(new AtomicIntegerArray(this.elems()));
        }
    }

    public static class ofLong
    extends LongBacked<Object> {
        public ofLong addOne(long elem) {
            this.ensureSpace();
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        public AtomicArray<Object> result() {
            this.setCapacity(this.size());
            return new AtomicArray.ofLong(new AtomicLongArray(this.elems()));
        }
    }

    public static class ofRef<T>
    implements AtomicArrayBuilder<T> {
        private Object[] elems;
        private int size;

        public <T> ofRef() {
            Growable.$init$((Growable)this);
            Builder.$init$((Builder)this);
            this.elems = AtomicArrayBuilder$.scala$concurrent$stm$skel$AtomicArrayBuilder$$$EmptyRefArray;
            this.size = 0;
        }

        public Object[] elems() {
            return this.elems;
        }

        public void elems_$eq(Object[] x$1) {
            this.elems = x$1;
        }

        public int size() {
            return this.size;
        }

        public void size_$eq(int x$1) {
            this.size = x$1;
        }

        public void setCapacity(int newCap) {
            if (newCap != this.elems().length) {
                Object[] newElems = new Object[newCap];
                if (this.size() > 0) {
                    Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newElems, 0, this.size());
                }
                this.elems_$eq(newElems);
            }
        }

        public void sizeHint(int sizeHint) {
            if (this.elems().length < sizeHint) {
                this.setCapacity(sizeHint);
            }
        }

        public void ensureSpace() {
            int cap = this.elems().length;
            if (this.size() == cap) {
                this.setCapacity(cap == 0 ? 16 : cap * 2);
            }
        }

        public void clear() {
            this.size_$eq(0);
        }

        public ofRef addOne(T elem) {
            this.ensureSpace();
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        public AtomicArray<T> result() {
            this.setCapacity(this.size());
            return new AtomicArray.ofRef<Object>(new AtomicReferenceArray<Object>(this.elems()));
        }
    }

    public static class ofShort
    extends IntBacked<Object> {
        public ofShort addOne(short elem) {
            this.ensureSpace();
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        public AtomicArray<Object> result() {
            this.setCapacity(this.size());
            return new AtomicArray.ofShort(new AtomicIntegerArray(this.elems()));
        }
    }

    public static class ofUnit
    implements AtomicArrayBuilder<BoxedUnit> {
        private int size;

        public ofUnit() {
            Growable.$init$((Growable)this);
            Builder.$init$((Builder)this);
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public void size_$eq(int x$1) {
            this.size = x$1;
        }

        public void clear() {
            this.size_$eq(0);
        }

        public ofUnit addOne(BoxedUnit elem) {
            this.size_$eq(this.size() + 1);
            return this;
        }

        public AtomicArray<BoxedUnit> result() {
            return new AtomicArray.ofUnit(this.size());
        }
    }
}

