/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.skel;

import java.util.Arrays;
import scala.Function1;
import scala.concurrent.stm.NestingLevel;
import scala.concurrent.stm.Txn;
import scala.concurrent.stm.Txn$UncaughtExceptionCause$;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;

public class CallbackList<A> {
    private int _size;
    private Function1<A, BoxedUnit>[] _data;

    public <A> CallbackList() {
        int InitialCapacity = 128;
        int MaxEmptyCapacity = 8192;
        this._size = 0;
        this._data = new Function1[128];
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    public void size_$eq(int newSize) {
        if (newSize != this._size) {
            this.changeSize(newSize);
        }
    }

    private void changeSize(int newSize) {
        if (newSize < 0 || newSize > this._size) {
            throw new IllegalArgumentException();
        }
        if (newSize == 0 && this._data.length > 8192) {
            this.reset();
        } else {
            Arrays.fill(this._data, newSize, this._size, null);
            this._size = newSize;
        }
    }

    private void reset() {
        this._data = new Function1[128];
        this._size = 0;
    }

    public void $plus$eq(Function1<A, BoxedUnit> handler) {
        if (this._size == this._data.length) {
            this.grow();
        }
        this._data[this._size] = handler;
        ++this._size;
    }

    private void grow() {
        Function1[] a = new Function1[this._data.length * 2];
        System.arraycopy(this._data, 0, a, 0, this._data.length);
        this._data = a;
    }

    public Function1<A, BoxedUnit> apply(int i) {
        return this._data[i];
    }

    public void fire(NestingLevel level, A arg) {
        if (this._size > 0) {
            this.fire(level, arg, 0);
        }
    }

    private void fire(NestingLevel level, A arg, int i) {
        CallbackList callbackList = this;
        int n = i;
        while (n < callbackList._size && callbackList.shouldFire(level)) {
            block3: {
                try {
                    callbackList._data[n].apply(arg);
                }
                catch (Throwable x) {
                    Txn.Status s = level.requestRollback(Txn$UncaughtExceptionCause$.MODULE$.apply(x));
                    if (s instanceof Txn.RolledBack) break block3;
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
            }
            CallbackList callbackList2 = callbackList;
            int n2 = n + 1;
            callbackList = callbackList2;
            n = n2;
        }
    }

    private boolean shouldFire(NestingLevel level) {
        return !(level.status() instanceof Txn.RolledBack);
    }

    /*
     * WARNING - void declaration
     */
    public Function1<A, BoxedUnit>[] truncate(int newSize) {
        Function1[] function1Array;
        if (this._size == newSize) {
            function1Array = null;
        } else {
            void var2_2;
            Function1[] z = new Function1[this._size - newSize];
            System.arraycopy(this._data, newSize, z, 0, z.length);
            this.size_$eq(newSize);
            function1Array = var2_2;
        }
        return function1Array;
    }
}

