/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.skel;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.MaybeTxn$;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.concurrent.stm.impl.STMImpl$;
import scala.concurrent.stm.package$;
import scala.concurrent.stm.skel.SimpleRandom$;
import scala.concurrent.stm.skel.TxnHashTrie$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class TxnHashTrie<A, B> {
    private Ref.View root;
    private int contentionEstimate;

    public static int BF() {
        return TxnHashTrie$.MODULE$.BF();
    }

    public static int LogBF() {
        return TxnHashTrie$.MODULE$.LogBF();
    }

    public static int MaxLeafCapacity() {
        return TxnHashTrie$.MODULE$.MaxLeafCapacity();
    }

    public static <A> BuildingNode<A, Object> buildingAdd(BuildingNode<A, Object> buildingNode, A a) {
        return TxnHashTrie$.MODULE$.buildingAdd(buildingNode, a);
    }

    public static <A, B> BuildingNode<A, B> buildingPut(BuildingNode<A, B> buildingNode, A a, B b) {
        return TxnHashTrie$.MODULE$.buildingPut(buildingNode, a, b);
    }

    public static Leaf emptyLeaf() {
        return TxnHashTrie$.MODULE$.emptyLeaf();
    }

    public static BuildingNode emptyMapBuildingNode() {
        return TxnHashTrie$.MODULE$.emptyMapBuildingNode();
    }

    public static Node emptyMapNode() {
        return TxnHashTrie$.MODULE$.emptyMapNode();
    }

    public static BuildingNode emptySetBuildingNode() {
        return TxnHashTrie$.MODULE$.emptySetBuildingNode();
    }

    public static Node emptySetNode() {
        return TxnHashTrie$.MODULE$.emptySetNode();
    }

    public static int indexFor(int n, int n2) {
        return TxnHashTrie$.MODULE$.indexFor(n, n2);
    }

    public static <A> int keyHash(A a) {
        return TxnHashTrie$.MODULE$.keyHash(a);
    }

    public static int mixBits(int n) {
        return TxnHashTrie$.MODULE$.mixBits(n);
    }

    public <A, B> TxnHashTrie(Ref.View<Node<A, B>> root) {
        this.root = root;
        int pct = 10000;
        int contentionThreshold = 10000;
        this.contentionEstimate = 0;
    }

    public Ref.View<Node<A, B>> root() {
        return this.root;
    }

    public void root_$eq(Ref.View<Node<A, B>> x$1) {
        this.root = x$1;
    }

    private void recordNoContention() {
        if (SimpleRandom$.MODULE$.nextInt(32) == 0) {
            int e = this.contentionEstimate;
            this.contentionEstimate = e - (e >> 4);
        }
    }

    private void recordContention() {
        int e = this.contentionEstimate;
        this.contentionEstimate = e + (1000000 - e >> 9);
    }

    private boolean isContended() {
        return this.contentionEstimate > 10000;
    }

    public Node<A, B> frozenRoot() {
        Node node;
        Node node2 = (Node)this.root().apply();
        if (node2 instanceof Leaf) {
            Leaf leaf;
            node = leaf = (Leaf)node2;
        } else if (node2 instanceof Branch) {
            Branch branch = (Branch)node2;
            Branch branch2 = branch;
            if (branch2.frozen()) {
                node = branch2;
            } else {
                Branch branch3 = branch;
                Branch b = branch3.withFreeze();
                this.root().compareAndSetIdentity(branch3, b);
                node = b;
            }
        } else {
            throw new MatchError((Object)node2);
        }
        return node;
    }

    public Ref.View<Node<A, B>> cloneRoot() {
        return Ref$.MODULE$.apply(this.frozenRoot()).single();
    }

    public Iterator<A> setIterator() {
        return this.frozenRoot().keyIterator();
    }

    public Iterator<Tuple2<A, B>> mapIterator() {
        return this.frozenRoot().mapIterator();
    }

    public Iterator<A> mapKeyIterator() {
        return this.frozenRoot().keyIterator();
    }

    public Iterator<B> mapValueIterator() {
        return this.frozenRoot().valueIterator();
    }

    public boolean singleIsEmpty() {
        boolean bl;
        InTxn inTxn = STMImpl$.MODULE$.instance().dynCurrentOrNull();
        if (inTxn == null) {
            bl = this.frozenRoot().cappedSize(1) == 0;
        } else {
            InTxn txn = inTxn;
            bl = this.txnIsEmpty(txn);
        }
        return bl;
    }

    public int singleSize() {
        return this.frozenRoot().cappedSize(Integer.MAX_VALUE);
    }

    public <U> void singleSetForeach(Function1<A, U> f) {
        InTxn inTxn = STMImpl$.MODULE$.instance().dynCurrentOrNull();
        if (inTxn == null) {
            this.frozenRoot().keyForeach(f);
        } else {
            InTxn txn = inTxn;
            this.txnSetForeach(f, txn);
        }
    }

    public <U> void singleMapForeach(Function1<Tuple2<A, B>, U> f) {
        InTxn inTxn = STMImpl$.MODULE$.instance().dynCurrentOrNull();
        if (inTxn == null) {
            this.frozenRoot().mapForeach(f);
        } else {
            InTxn txn = inTxn;
            this.txnMapForeach(f, txn);
        }
    }

    public boolean singleContains(A key) {
        return this.singleContains(null, this.root(), 0, TxnHashTrie$.MODULE$.keyHash(key), key);
    }

    private boolean singleContains(Node<A, B> rootNode, Ref.View<Node<A, B>> n, int shift, int hash, A key) {
        Leaf leaf;
        block3: {
            Node node;
            TxnHashTrie txnHashTrie = this;
            int n2 = shift;
            Ref.View<Node<A, B>> view = n;
            Node node2 = rootNode;
            while (true) {
                if ((node = (Node)view.apply()) instanceof Leaf) {
                    leaf = (Leaf)node;
                    if (n2 != 0 && node2 != txnHashTrie.root().apply()) {
                        TxnHashTrie txnHashTrie2 = txnHashTrie;
                        Object var13_13 = null;
                        Ref.View<Node<Node<A, B>, B>> view2 = txnHashTrie.root();
                        int n3 = 0;
                        txnHashTrie = txnHashTrie2;
                        node2 = var13_13;
                        view = view2;
                        n2 = n3;
                        continue;
                    }
                    break block3;
                }
                if (!(node instanceof Branch)) break;
                Branch branch = (Branch)node;
                Node rn = n2 == 0 ? branch : node2;
                TxnHashTrie txnHashTrie3 = txnHashTrie;
                Node node3 = rn;
                Ref.View view3 = branch.children()[TxnHashTrie$.MODULE$.indexFor(n2, hash)];
                int n4 = n2 + 4;
                txnHashTrie = txnHashTrie3;
                node2 = node3;
                view = view3;
                n2 = n4;
            }
            throw new MatchError((Object)node);
        }
        return leaf.contains(hash, key);
    }

    public B singleGetOrThrow(A key) {
        return this.singleGetOrThrow(null, this.root(), 0, TxnHashTrie$.MODULE$.keyHash(key), key);
    }

    private B singleGetOrThrow(Node<A, B> rootNode, Ref.View<Node<A, B>> n, int shift, int hash, A key) {
        int i;
        Leaf leaf;
        block4: {
            Node node;
            TxnHashTrie txnHashTrie = this;
            int n2 = shift;
            Ref.View<Node<A, B>> view = n;
            Node node2 = rootNode;
            while (true) {
                if ((node = (Node)view.apply()) instanceof Leaf) {
                    leaf = (Leaf)node;
                    if (n2 != 0 && node2 != txnHashTrie.root().apply()) {
                        TxnHashTrie txnHashTrie2 = txnHashTrie;
                        Object var13_13 = null;
                        Ref.View<Node<Node<A, B>, B>> view2 = txnHashTrie.root();
                        int n3 = 0;
                        txnHashTrie = txnHashTrie2;
                        node2 = var13_13;
                        view = view2;
                        n2 = n3;
                        continue;
                    }
                    i = leaf.find(hash, key);
                    if (i < 0) {
                        throw new NoSuchElementException("key not found: " + key);
                    }
                    break block4;
                }
                if (!(node instanceof Branch)) break;
                Branch branch = (Branch)node;
                Node rn = n2 == 0 ? branch : node2;
                TxnHashTrie txnHashTrie3 = txnHashTrie;
                Node node3 = rn;
                Ref.View view3 = branch.children()[TxnHashTrie$.MODULE$.indexFor(n2, hash)];
                int n4 = n2 + 4;
                txnHashTrie = txnHashTrie3;
                node2 = node3;
                view = view3;
                n2 = n4;
            }
            throw new MatchError((Object)node);
        }
        return leaf.getValue(i);
    }

    public Option<B> singleGet(A key) {
        return this.singleGet(null, this.root(), 0, TxnHashTrie$.MODULE$.keyHash(key), key);
    }

    private Option<B> singleGet(Node<A, B> rootNode, Ref.View<Node<A, B>> n, int shift, int hash, A key) {
        Leaf leaf;
        block3: {
            Node node;
            TxnHashTrie txnHashTrie = this;
            int n2 = shift;
            Ref.View<Node<A, B>> view = n;
            Node node2 = rootNode;
            while (true) {
                if ((node = (Node)view.apply()) instanceof Leaf) {
                    leaf = (Leaf)node;
                    if (n2 != 0 && node2 != txnHashTrie.root().apply()) {
                        TxnHashTrie txnHashTrie2 = txnHashTrie;
                        Object var13_13 = null;
                        Ref.View<Node<Node<A, B>, B>> view2 = txnHashTrie.root();
                        int n3 = 0;
                        txnHashTrie = txnHashTrie2;
                        node2 = var13_13;
                        view = view2;
                        n2 = n3;
                        continue;
                    }
                    break block3;
                }
                if (!(node instanceof Branch)) break;
                Branch branch = (Branch)node;
                Node rn = n2 == 0 ? branch : node2;
                TxnHashTrie txnHashTrie3 = txnHashTrie;
                Node node3 = rn;
                Ref.View view3 = branch.children()[TxnHashTrie$.MODULE$.indexFor(n2, hash)];
                int n4 = n2 + 4;
                txnHashTrie = txnHashTrie3;
                node2 = node3;
                view = view3;
                n2 = n4;
            }
            throw new MatchError((Object)node);
        }
        return leaf.get(hash, key);
    }

    public Option<B> singlePut(A key, B value) {
        return this.singleRootPut(TxnHashTrie$.MODULE$.keyHash(key), key, value, 0);
    }

    private Option<B> singleRootPut(int hash, A key, B value, int failures) {
        Option<B> option;
        block5: {
            TxnHashTrie txnHashTrie = this;
            int n = failures;
            while (n < 10) {
                Node node = (Node)txnHashTrie.root().apply();
                if (node instanceof Leaf) {
                    Leaf leaf = (Leaf)node;
                    int i = leaf.find(hash, key);
                    if (leaf.noChange(i, value) || txnHashTrie.root().compareAndSetIdentity(leaf, leaf.withPut(0L, 0, hash, key, value, i, false))) {
                        option = leaf.get(i);
                        break block5;
                    }
                    TxnHashTrie txnHashTrie2 = txnHashTrie;
                    int n2 = n + 1;
                    txnHashTrie = txnHashTrie2;
                    n = n2;
                    continue;
                }
                if (node instanceof Branch) {
                    Branch<A, B> b;
                    Branch<A, B> branch = (Branch<A, B>)node;
                    Branch<A, B> branch2 = b = !branch.frozen() ? branch : txnHashTrie.singleUnshare(branch.gen() + 1L, txnHashTrie.root(), branch);
                    if (b != null) {
                        option = txnHashTrie.singleChildPut(b, b.children()[TxnHashTrie$.MODULE$.indexFor(0, hash)], 4, hash, key, value, 0);
                        break block5;
                    }
                    TxnHashTrie txnHashTrie3 = txnHashTrie;
                    int n3 = n + 1;
                    txnHashTrie = txnHashTrie3;
                    n = n3;
                    continue;
                }
                throw new MatchError((Object)node);
            }
            option = txnHashTrie.failingPut(hash, key, value);
        }
        return option;
    }

    private Branch<A, B> singleUnshare(long rootGen, Ref.View<Node<A, B>> current, Branch<A, B> branch) {
        Branch<A, B> b = branch.clone(rootGen);
        return current.compareAndSetIdentity(branch, b) ? b : null;
    }

    private Option<B> failingPut(int hash, A key, B value) {
        return (Option)package$.MODULE$.atomic().apply((Function1 & Serializable)txn -> this.txnRootPut(hash, key, value, (InTxn)txn), MaybeTxn$.MODULE$.unknown());
    }

    private Option<B> singleChildPut(Branch<A, B> rootNode, Ref.View<Node<A, B>> current, int shift, int hash, A key, B value, int failures) {
        Option<B> option;
        block6: {
            TxnHashTrie txnHashTrie = this;
            int n = shift;
            Ref.View<Node<A, B>> view = current;
            int n2 = failures;
            while (n2 < 10) {
                Node node = (Node)view.apply();
                if (node instanceof Leaf) {
                    Leaf leaf = (Leaf)node;
                    int i = leaf.find(hash, key);
                    if (leaf.noChange(i, value) || package$.MODULE$.atomic().compareAndSetIdentity(txnHashTrie.root().ref(), rootNode, rootNode, view.ref(), leaf, leaf.withPut(rootNode.gen(), n, hash, key, value, i, n2 > 0))) {
                        option = leaf.get(i);
                        break block6;
                    }
                    if (txnHashTrie.root().apply() != rootNode) {
                        option = txnHashTrie.failingPut(hash, key, value);
                        break block6;
                    }
                    TxnHashTrie txnHashTrie2 = txnHashTrie;
                    int n3 = n2 + 1;
                    txnHashTrie = txnHashTrie2;
                    n2 = n3;
                    continue;
                }
                if (node instanceof Branch) {
                    Branch<A, B> b;
                    Branch<A, B> branch = (Branch<A, B>)node;
                    Branch<A, B> branch2 = b = branch.gen() == rootNode.gen() ? branch : txnHashTrie.singleUnshare(rootNode.gen(), view, branch);
                    if (b != null) {
                        TxnHashTrie txnHashTrie3 = txnHashTrie;
                        Ref.View<Node<Node<A, B>, B>> view2 = b.children()[TxnHashTrie$.MODULE$.indexFor(n, hash)];
                        int n4 = n + 4;
                        txnHashTrie = txnHashTrie3;
                        view = view2;
                        n = n4;
                        continue;
                    }
                    TxnHashTrie txnHashTrie4 = txnHashTrie;
                    int n5 = n2 + 1;
                    txnHashTrie = txnHashTrie4;
                    n2 = n5;
                    continue;
                }
                throw new MatchError((Object)node);
            }
            option = txnHashTrie.failingPut(hash, key, value);
        }
        return option;
    }

    public Option<B> singleRemove(A key) {
        return this.singleRootRemove(TxnHashTrie$.MODULE$.keyHash(key), key, 0);
    }

    private Option<B> singleRootRemove(int hash, A key, int failures) {
        Option<B> option;
        block6: {
            TxnHashTrie txnHashTrie = this;
            int n = failures;
            while (n < 10) {
                Node node = (Node)txnHashTrie.root().apply();
                if (node instanceof Leaf) {
                    Leaf leaf = (Leaf)node;
                    int i = leaf.find(hash, key);
                    if (i < 0 || txnHashTrie.root().compareAndSetIdentity(leaf, leaf.withRemove(i))) {
                        option = leaf.get(i);
                        break block6;
                    }
                    TxnHashTrie txnHashTrie2 = txnHashTrie;
                    int n2 = n + 1;
                    txnHashTrie = txnHashTrie2;
                    n = n2;
                    continue;
                }
                if (node instanceof Branch) {
                    Branch<A, B> b;
                    Branch<A, B> branch = (Branch<A, B>)node;
                    int i = TxnHashTrie$.MODULE$.indexFor(0, hash);
                    if (branch.frozen() && !txnHashTrie.singleContains(branch, branch.children()[i], 4, hash, key)) {
                        option = None$.MODULE$;
                        break block6;
                    }
                    Branch<A, B> branch2 = b = !branch.frozen() ? branch : txnHashTrie.singleUnshare(branch.gen() + 1L, txnHashTrie.root(), branch);
                    if (b != null) {
                        option = txnHashTrie.singleChildRemove(b, b.children()[i], 4, hash, key, b != branch, 0);
                        break block6;
                    }
                    TxnHashTrie txnHashTrie3 = txnHashTrie;
                    int n3 = n + 1;
                    txnHashTrie = txnHashTrie3;
                    n = n3;
                    continue;
                }
                throw new MatchError((Object)node);
            }
            option = txnHashTrie.failingRemove(hash, key);
        }
        return option;
    }

    private Option<B> failingRemove(int hash, A key) {
        return (Option)package$.MODULE$.atomic().apply((Function1 & Serializable)txn -> this.txnRootRemove(hash, key, (InTxn)txn), MaybeTxn$.MODULE$.unknown());
    }

    private Option<B> singleChildRemove(Branch<A, B> rootNode, Ref.View<Node<A, B>> current, int shift, int hash, A key, boolean checked, int failures) {
        Option<B> option;
        block8: {
            TxnHashTrie txnHashTrie = this;
            boolean bl = checked;
            int n = shift;
            Ref.View<Node<A, B>> view = current;
            int n2 = failures;
            while (n2 < 10) {
                Node node = (Node)view.apply();
                if (node instanceof Leaf) {
                    Leaf leaf = (Leaf)node;
                    int i = leaf.find(hash, key);
                    if (i < 0) {
                        option = None$.MODULE$;
                        break block8;
                    }
                    if (package$.MODULE$.atomic().compareAndSetIdentity(txnHashTrie.root().ref(), rootNode, rootNode, view.ref(), leaf, leaf.withRemove(i))) {
                        option = leaf.get(i);
                        break block8;
                    }
                    if (txnHashTrie.root().apply() != rootNode) {
                        option = txnHashTrie.failingRemove(hash, key);
                        break block8;
                    }
                    TxnHashTrie txnHashTrie2 = txnHashTrie;
                    int n3 = n2 + 1;
                    txnHashTrie = txnHashTrie2;
                    n2 = n3;
                    continue;
                }
                if (node instanceof Branch) {
                    Branch<A, B> b;
                    Branch<A, B> branch = (Branch<A, B>)node;
                    int i = TxnHashTrie$.MODULE$.indexFor(n, hash);
                    if (!bl && branch.gen() != rootNode.gen() && !txnHashTrie.singleContains(rootNode, branch.children()[i], n + 4, hash, key)) {
                        option = None$.MODULE$;
                        break block8;
                    }
                    Branch<A, B> branch2 = b = branch.gen() == rootNode.gen() ? branch : txnHashTrie.singleUnshare(rootNode.gen(), view, branch);
                    if (b != null) {
                        TxnHashTrie txnHashTrie3 = txnHashTrie;
                        Ref.View<Node<Node<A, B>, B>> view2 = b.children()[i];
                        int n4 = n + 4;
                        boolean bl2 = bl || b != branch;
                        txnHashTrie = txnHashTrie3;
                        view = view2;
                        n = n4;
                        bl = bl2;
                        continue;
                    }
                    TxnHashTrie txnHashTrie4 = txnHashTrie;
                    int n5 = n2 + 1;
                    txnHashTrie = txnHashTrie4;
                    n2 = n5;
                    continue;
                }
                throw new MatchError((Object)node);
            }
            option = txnHashTrie.failingRemove(hash, key);
        }
        return option;
    }

    public boolean txnIsEmpty(InTxn txn) {
        return ((Node)this.root().apply()).txnIsEmpty(txn);
    }

    public <U> void txnSetForeach(Function1<A, U> f, InTxn txn) {
        ((Node)this.root().apply()).keyForeach(f);
    }

    public <U> void txnMapForeach(Function1<Tuple2<A, B>, U> f, InTxn txn) {
        ((Node)this.root().apply()).mapForeach(f);
    }

    public boolean txnContains(A key, InTxn txn) {
        return this.txnContains(this.root().ref(), 0, TxnHashTrie$.MODULE$.keyHash(key), key, txn);
    }

    private boolean txnContains(Ref<Node<A, B>> n, int shift, int hash, A key, InTxn txn) {
        Node node;
        block1: {
            TxnHashTrie txnHashTrie = this;
            int n2 = shift;
            Ref<Node<A, B>> ref = n;
            while (true) {
                if ((node = (Node)ref.apply(txn)) instanceof Leaf) break block1;
                if (!(node instanceof Branch)) break;
                Branch branch = (Branch)node;
                TxnHashTrie txnHashTrie2 = txnHashTrie;
                Ref ref2 = branch.children()[TxnHashTrie$.MODULE$.indexFor(n2, hash)].ref();
                int n3 = n2 + 4;
                txnHashTrie = txnHashTrie2;
                ref = ref2;
                n2 = n3;
            }
            throw new MatchError((Object)node);
        }
        Leaf leaf = (Leaf)node;
        return leaf.contains(hash, key);
    }

    public B txnGetOrThrow(A key, InTxn txn) {
        return this.txnGetOrThrow(this.root().ref(), 0, TxnHashTrie$.MODULE$.keyHash(key), key, txn);
    }

    private B txnGetOrThrow(Ref<Node<A, B>> n, int shift, int hash, A key, InTxn txn) {
        int i;
        Leaf leaf;
        block3: {
            Node node;
            TxnHashTrie txnHashTrie = this;
            int n2 = shift;
            Ref<Node<A, B>> ref = n;
            while (true) {
                if ((node = (Node)ref.apply(txn)) instanceof Leaf) {
                    leaf = (Leaf)node;
                    i = leaf.find(hash, key);
                    if (i < 0) {
                        throw new NoSuchElementException("key not found: " + key);
                    }
                    break block3;
                }
                if (!(node instanceof Branch)) break;
                Branch branch = (Branch)node;
                TxnHashTrie txnHashTrie2 = txnHashTrie;
                Ref ref2 = branch.children()[TxnHashTrie$.MODULE$.indexFor(n2, hash)].ref();
                int n3 = n2 + 4;
                txnHashTrie = txnHashTrie2;
                ref = ref2;
                n2 = n3;
            }
            throw new MatchError((Object)node);
        }
        return leaf.getValue(i);
    }

    public Option<B> txnGet(A key, InTxn txn) {
        return this.txnGet(this.root().ref(), 0, TxnHashTrie$.MODULE$.keyHash(key), key, txn);
    }

    private Option<B> txnGet(Ref<Node<A, B>> n, int shift, int hash, A key, InTxn txn) {
        Node node;
        block1: {
            TxnHashTrie txnHashTrie = this;
            int n2 = shift;
            Ref<Node<A, B>> ref = n;
            while (true) {
                if ((node = (Node)ref.apply(txn)) instanceof Leaf) break block1;
                if (!(node instanceof Branch)) break;
                Branch branch = (Branch)node;
                TxnHashTrie txnHashTrie2 = txnHashTrie;
                Ref ref2 = branch.children()[TxnHashTrie$.MODULE$.indexFor(n2, hash)].ref();
                int n3 = n2 + 4;
                txnHashTrie = txnHashTrie2;
                ref = ref2;
                n2 = n3;
            }
            throw new MatchError((Object)node);
        }
        Leaf leaf = (Leaf)node;
        return leaf.get(hash, key);
    }

    public Option<B> txnPut(A key, B value, InTxn txn) {
        return this.txnRootPut(TxnHashTrie$.MODULE$.keyHash(key), key, value, txn);
    }

    private Option<B> txnRootPut(int hash, A key, B value, InTxn txn) {
        Option option;
        Node node = (Node)this.root().apply();
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            int i = leaf.find(hash, key);
            if (!leaf.noChange(i, value)) {
                this.set(this.root().ref(), leaf.withPut(0L, 0, hash, key, value, i, this.isContended()), txn);
            }
            option = leaf.get(i);
        } else if (node instanceof Branch) {
            Branch<A, B> branch = (Branch<A, B>)node;
            Branch<A, B> b = !branch.frozen() ? branch : this.txnUnshare(branch.gen() + 1L, this.root().ref(), branch, txn);
            option = this.txnChildPut(b.gen(), b.children()[TxnHashTrie$.MODULE$.indexFor(0, hash)].ref(), 4, hash, key, value, txn);
        } else {
            throw new MatchError((Object)node);
        }
        return option;
    }

    private void set(Ref<Node<A, B>> ref, Node<A, B> node, InTxn txn) {
        if (!ref.trySet(node, txn)) {
            this.recordContention();
            ref.update(node, txn);
        } else {
            this.recordNoContention();
        }
    }

    private Branch<A, B> txnUnshare(long rootGen, Ref<Node<A, B>> current, Branch<A, B> branch, InTxn txn) {
        Branch<A, B> b = branch.clone(rootGen);
        current.update(b, txn);
        return b;
    }

    private Option<B> txnChildPut(long rootGen, Ref<Node<A, B>> current, int shift, int hash, A key, B value, InTxn txn) {
        int i;
        Leaf leaf;
        block3: {
            Node node;
            TxnHashTrie txnHashTrie = this;
            int n = shift;
            Ref<Node<A, B>> ref = current;
            while (true) {
                if ((node = (Node)ref.apply(txn)) instanceof Leaf) {
                    leaf = (Leaf)node;
                    i = leaf.find(hash, key);
                    if (!leaf.noChange(i, value)) {
                        txnHashTrie.set(ref, leaf.withPut(rootGen, n, hash, key, value, i, txnHashTrie.isContended()), txn);
                    }
                    break block3;
                }
                if (!(node instanceof Branch)) break;
                Branch<A, B> branch = (Branch<A, B>)node;
                Branch<A, B> b = branch.gen() == rootGen ? branch : txnHashTrie.txnUnshare(rootGen, ref, branch, txn);
                TxnHashTrie txnHashTrie2 = txnHashTrie;
                Ref<Node<Node<A, B>, B>> ref2 = b.children()[TxnHashTrie$.MODULE$.indexFor(n, hash)].ref();
                int n2 = n + 4;
                txnHashTrie = txnHashTrie2;
                ref = ref2;
                n = n2;
            }
            throw new MatchError((Object)node);
        }
        return leaf.get(i);
    }

    public Option<B> txnRemove(A key, InTxn txn) {
        return this.txnRootRemove(TxnHashTrie$.MODULE$.keyHash(key), key, txn);
    }

    private Option<B> txnRootRemove(int hash, A key, InTxn txn) {
        Option option;
        Node node = (Node)this.root().apply();
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            int i = leaf.find(hash, key);
            if (i >= 0) {
                this.set(this.root().ref(), leaf.withRemove(i), txn);
            }
            option = leaf.get(i);
        } else if (node instanceof Branch) {
            Branch<A, B> branch = (Branch<A, B>)node;
            int i = TxnHashTrie$.MODULE$.indexFor(0, hash);
            if (branch.frozen() && !this.txnContains(branch.children()[i].ref(), 4, hash, key, txn)) {
                option = None$.MODULE$;
            } else {
                Branch<A, B> b = !branch.frozen() ? branch : this.txnUnshare(branch.gen() + 1L, this.root().ref(), branch, txn);
                option = this.txnChildRemove(b.gen(), b.children()[i].ref(), 4, hash, key, b != branch, txn);
            }
        } else {
            throw new MatchError((Object)node);
        }
        return option;
    }

    private Option<B> txnChildRemove(long rootGen, Ref<Node<A, B>> current, int shift, int hash, A key, boolean checked, InTxn txn) {
        None$ none$;
        block4: {
            Node node;
            TxnHashTrie txnHashTrie = this;
            boolean bl = checked;
            int n = shift;
            Ref<Node<A, B>> ref = current;
            while (true) {
                if ((node = (Node)ref.apply(txn)) instanceof Leaf) {
                    Leaf leaf = (Leaf)node;
                    int i = leaf.find(hash, key);
                    if (i >= 0) {
                        txnHashTrie.set(ref, leaf.withRemove(i), txn);
                    }
                    none$ = leaf.get(i);
                    break block4;
                }
                if (!(node instanceof Branch)) break;
                Branch<A, B> branch = (Branch<A, B>)node;
                int i = TxnHashTrie$.MODULE$.indexFor(n, hash);
                if (!bl && branch.gen() != rootGen && !txnHashTrie.txnContains(branch.children()[i].ref(), n + 4, hash, key, txn)) {
                    none$ = None$.MODULE$;
                    break block4;
                }
                Branch<A, B> b = branch.gen() == rootGen ? branch : txnHashTrie.txnUnshare(rootGen, ref, branch, txn);
                TxnHashTrie txnHashTrie2 = txnHashTrie;
                Ref<Node<Node<A, B>, B>> ref2 = b.children()[i].ref();
                int n2 = n + 4;
                boolean bl2 = bl || b != branch;
                txnHashTrie = txnHashTrie2;
                ref = ref2;
                n = n2;
                bl = bl2;
            }
            throw new MatchError((Object)node);
        }
        return none$;
    }

    public static class Branch<A, B>
    extends Node<A, B> {
        private final long gen;
        private final boolean frozen;
        private final Ref.View[] children;
        private int _cachedSize;

        public <A, B> Branch(long gen, boolean frozen, Ref.View<Node<A, B>>[] children) {
            this.gen = gen;
            this.frozen = frozen;
            this.children = children;
            this._cachedSize = -1;
        }

        public long gen() {
            return this.gen;
        }

        public boolean frozen() {
            return this.frozen;
        }

        public Ref.View<Node<A, B>>[] children() {
            return this.children;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int cappedSize(int cap) {
            int n;
            int n0 = this._cachedSize;
            if (n0 >= 0) {
                n = n0;
            } else {
                void var3_3;
                int n2 = 0;
                for (int i = 0; i < 16 && n2 < cap; n2 += ((Node)this.children()[i].apply()).cappedSize(cap - n2), ++i) {
                }
                if (n2 < cap) {
                    this._cachedSize = n2;
                }
                n = var3_3;
            }
            return n;
        }

        @Override
        public boolean txnIsEmpty(InTxn txn) {
            for (int i = 0; i < 16; ++i) {
                Node c = (Node)this.children()[i].ref().get(txn);
                if (c.txnIsEmpty(txn)) continue;
                return false;
            }
            return true;
        }

        public Branch<A, B> withFreeze() {
            return new Branch<A, B>(this.gen(), true, this.children());
        }

        public Branch<A, B> clone(long newGen) {
            Ref.View[] cc = (Ref.View[])this.children().clone();
            for (int i = 0; i < cc.length; ++i) {
                cc[i] = Ref$.MODULE$.apply(cc[i].apply()).single();
            }
            return new Branch<A, B>(newGen, false, cc);
        }

        @Override
        public <U> void keyForeach(Function1<A, U> f) {
            for (int i = 0; i < 16; ++i) {
                ((Node)this.children()[i].apply()).keyForeach(f);
            }
        }

        @Override
        public <U> void mapForeach(Function1<Tuple2<A, B>, U> f) {
            for (int i = 0; i < 16; ++i) {
                ((Node)this.children()[i].apply()).mapForeach(f);
            }
        }

        @Override
        public Iterator<A> keyIterator() {
            return new Iter<A>(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer);
                }

                public Iterator childIter(Node c) {
                    return c.keyIterator();
                }
            };
        }

        @Override
        public Iterator<B> valueIterator() {
            return new Iter<B>(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer);
                }

                public Iterator childIter(Node c) {
                    return c.valueIterator();
                }
            };
        }

        @Override
        public Iterator<Tuple2<A, B>> mapIterator() {
            return new Iter<Tuple2<A, B>>(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    super($outer);
                }

                public Iterator childIter(Node c) {
                    return c.mapIterator();
                }
            };
        }

        private abstract class Iter<Z>
        implements Iterator<Z> {
            private int pos;
            private Iterator<Z> iter;
            private final Branch<A, B> $outer;

            public <Z> Iter(Branch $outer) {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.pos = -1;
                this.iter = null;
                this.advance();
            }

            public abstract Iterator<Z> childIter(Node<A, B> var1);

            private boolean advance() {
                boolean bl;
                block2: {
                    Iter iter = this;
                    while (true) {
                        if (iter.pos == 15) {
                            iter.iter = null;
                            bl = false;
                            break block2;
                        }
                        ++iter.pos;
                        Node c = (Node)iter.$outer.children()[iter.pos].apply();
                        if (c == TxnHashTrie$.MODULE$.emptyLeaf()) continue;
                        iter.iter = iter.childIter(c);
                        if (iter.iter.hasNext()) break;
                    }
                    bl = true;
                }
                return bl;
            }

            public boolean hasNext() {
                return this.iter != null && this.iter.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            public Z next() {
                void var1_1;
                Object z = this.iter.next();
                if (!this.iter.hasNext()) {
                    this.advance();
                }
                return var1_1;
            }

            public final Branch<A, B> scala$concurrent$stm$skel$TxnHashTrie$Branch$Iter$$$outer() {
                return this.$outer;
            }
        }
    }

    public static class BuildingBranch<A, B>
    implements BuildingNode<A, B> {
        private final BuildingNode[] children;

        public <A, B> BuildingBranch(BuildingNode<A, B>[] children) {
            this.children = children;
        }

        public BuildingNode<A, B>[] children() {
            return this.children;
        }

        @Override
        public Node<A, B> endBuild() {
            Ref.View[] refs = new Ref.View[16];
            for (int i = 0; i < 16; ++i) {
                refs[i] = Ref$.MODULE$.apply(this.children()[i].endBuild()).single();
            }
            return new Branch(0L, false, refs);
        }
    }

    public static interface BuildingNode<A, B> {
        public Node<A, B> endBuild();
    }

    public static final class Leaf<A, B>
    extends Node<A, B>
    implements BuildingNode<A, B> {
        private final int[] hashes;
        private final Object[] kvs;

        public <A, B> Leaf(int[] hashes, Object[] kvs) {
            this.hashes = hashes;
            this.kvs = kvs;
        }

        public int[] hashes() {
            return this.hashes;
        }

        public Object[] kvs() {
            return this.kvs;
        }

        @Override
        public Node<A, B> endBuild() {
            return this;
        }

        @Override
        public int cappedSize(int cap) {
            return this.hashes().length;
        }

        @Override
        public boolean txnIsEmpty(InTxn txn) {
            return this.hashes().length == 0;
        }

        public A getKey(int i) {
            return (A)this.kvs()[2 * i];
        }

        public void setKey(int i, A k) {
            this.kvs()[2 * i] = k;
        }

        public B getValue(int i) {
            return (B)this.kvs()[2 * i + 1];
        }

        public void setValue(int i, B v) {
            this.kvs()[2 * i + 1] = v;
        }

        public Tuple2<A, B> getKeyValue(int i) {
            return Tuple2$.MODULE$.apply(this.getKey(i), this.getValue(i));
        }

        public boolean contains(int hash, A key) {
            return this.find(hash, key) >= 0;
        }

        public Option<B> get(int hash, A key) {
            int i = this.find(hash, key);
            return i < 0 ? None$.MODULE$ : Some$.MODULE$.apply(this.getValue(i));
        }

        public Option<B> get(int i) {
            return i < 0 ? None$.MODULE$ : Some$.MODULE$.apply(this.getValue(i));
        }

        public int find(int hash, A key) {
            int i = this.hashes().length;
            while (i > 0) {
                int h = this.hashes()[--i];
                if (h == hash && this.keyEqual(key, this.kvs()[2 * i])) {
                    return i;
                }
                if (h >= hash) continue;
                return ~(i + 1);
            }
            return -1;
        }

        private boolean keyEqual(Object lhs, Object rhs) {
            return lhs == rhs ? true : (lhs == null || rhs == null ? false : (lhs.getClass() == rhs.getClass() ? (lhs instanceof Integer ? true : (lhs instanceof Long ? ((Long)lhs).longValue() == ((Long)rhs).longValue() : lhs.equals(rhs))) : BoxesRunTime.equals2((Object)lhs, (Object)rhs)));
        }

        public <C> boolean noChange(int i, C value) {
            return i >= 0 && this.kvs()[2 * i + 1] == value;
        }

        public Node<A, B> withPut(long gen, int shift, int hash, A key, B value, int i, boolean contended) {
            return i < 0 ? this.withInsert(~i, hash, key, value).splitIfNeeded(gen, shift, contended) : this.withUpdate(i, value);
        }

        public BuildingNode<A, B> withBuildingPut(int shift, int hash, A key, B value, int i) {
            return i < 0 ? this.withInsert(~i, hash, key, value).buildingSplitIfNeeded(shift) : this.withUpdate(i, value);
        }

        private Leaf<A, B> withUpdate(int i, B value) {
            Object[] nkvs = (Object[])this.kvs().clone();
            nkvs[2 * i + 1] = value;
            return new Leaf<A, B>(this.hashes(), nkvs);
        }

        private Leaf<A, B> withInsert(int i, int hash, A key, B value) {
            Leaf<A, B> z = this.newLeaf(this.hashes().length + 1);
            int j = this.hashes().length - i;
            System.arraycopy(this.hashes(), 0, z.hashes(), 0, i);
            System.arraycopy(this.hashes(), i, z.hashes(), i + 1, j);
            z.hashes()[i] = hash;
            System.arraycopy(this.kvs(), 0, z.kvs(), 0, 2 * i);
            System.arraycopy(this.kvs(), 2 * i, z.kvs(), 2 * i + 2, 2 * j);
            z.setKey(i, key);
            z.setValue(i, value);
            return z;
        }

        /*
         * WARNING - void declaration
         */
        public Leaf<A, B> withRemove(int i) {
            Leaf leaf;
            if (i < 0) {
                leaf = this;
            } else {
                void var2_2;
                Leaf<A, B> z = this.newLeaf(this.hashes().length - 1);
                if (z.hashes().length > 0) {
                    int j = z.hashes().length - i;
                    System.arraycopy(this.hashes(), 0, z.hashes(), 0, i);
                    System.arraycopy(this.hashes(), i + 1, z.hashes(), i, j);
                    System.arraycopy(this.kvs(), 0, z.kvs(), 0, 2 * i);
                    System.arraycopy(this.kvs(), 2 * i + 2, z.kvs(), 2 * i, 2 * j);
                }
                leaf = var2_2;
            }
            return leaf;
        }

        public Node<A, B> splitIfNeeded(long gen, int shift, boolean contended) {
            return !this.shouldSplit(contended) ? this : this.split(gen, shift);
        }

        public BuildingNode<A, B> buildingSplitIfNeeded(int shift) {
            return !this.shouldSplit(false) ? this : this.buildingSplit(shift);
        }

        public boolean shouldSplit(boolean contended) {
            return (contended || this.hashes().length > 14) && this.hashes()[this.hashes().length - 1] != this.hashes()[0];
        }

        public Branch<A, B> split(long gen, int shift) {
            Node[] children = new Node[16];
            this.splitInto(shift, children);
            ClassTag cm = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(Node.class));
            Ref.View[] refs = new Ref.View[16];
            for (int i = 0; i < 16; ++i) {
                ClassTag icm = cm;
                refs[i] = Ref$.MODULE$.apply(children[i]).single();
            }
            return new Branch(gen, false, refs);
        }

        public BuildingBranch<A, B> buildingSplit(int shift) {
            BuildingNode[] children = new BuildingNode[16];
            this.splitInto(shift, children);
            return new BuildingBranch(children);
        }

        private <L> void splitInto(int shift, Object children) {
            int i;
            int[] sizes = new int[16];
            for (i = 0; i < this.hashes().length; ++i) {
                int n = TxnHashTrie$.MODULE$.indexFor(shift, this.hashes()[i]);
                sizes[n] = sizes[n] + 1;
            }
            for (i = 0; i < 16; ++i) {
                ScalaRunTime$.MODULE$.array_update(children, i, this.newLeaf(sizes[i]));
            }
            for (i = this.hashes().length - 1; i >= 0; --i) {
                int slot = TxnHashTrie$.MODULE$.indexFor(shift, this.hashes()[i]);
                sizes[slot] = sizes[slot] - 1;
                int pos = sizes[slot];
                Leaf dst = (Leaf)ScalaRunTime$.MODULE$.array_apply(children, slot);
                dst.hashes()[pos] = this.hashes()[i];
                dst.setKey(pos, this.getKey(i));
                dst.setValue(pos, this.getValue(i));
            }
        }

        private Leaf<A, B> newLeaf(int n) {
            return n == 0 ? TxnHashTrie$.MODULE$.emptyLeaf() : new Leaf<A, B>(new int[n], new Object[2 * n]);
        }

        @Override
        public <U> void keyForeach(Function1<A, U> f) {
            for (int i = 0; i < this.hashes().length; ++i) {
                f.apply(this.getKey(i));
            }
        }

        @Override
        public <U> void mapForeach(Function1<Tuple2<A, B>, U> f) {
            for (int i = 0; i < this.hashes().length; ++i) {
                f.apply(this.getKeyValue(i));
            }
        }

        @Override
        public Iterator<A> keyIterator() {
            return new Iterator<A>(this){
                private int pos;
                private final Leaf $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                    this.pos = 0;
                }

                public int pos() {
                    return this.pos;
                }

                public void pos_$eq(int x$1) {
                    this.pos = x$1;
                }

                public boolean hasNext() {
                    return this.pos() < this.$outer.hashes().length;
                }

                /*
                 * WARNING - void declaration
                 */
                public Object next() {
                    void var1_1;
                    A z = this.$outer.getKey(this.pos());
                    this.pos_$eq(this.pos() + 1);
                    return var1_1;
                }
            };
        }

        @Override
        public Iterator<B> valueIterator() {
            return new Iterator<B>(this){
                private int pos;
                private final Leaf $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                    this.pos = 0;
                }

                public int pos() {
                    return this.pos;
                }

                public void pos_$eq(int x$1) {
                    this.pos = x$1;
                }

                public boolean hasNext() {
                    return this.pos() < this.$outer.hashes().length;
                }

                /*
                 * WARNING - void declaration
                 */
                public Object next() {
                    void var1_1;
                    B z = this.$outer.getValue(this.pos());
                    this.pos_$eq(this.pos() + 1);
                    return var1_1;
                }
            };
        }

        @Override
        public Iterator<Tuple2<A, B>> mapIterator() {
            return new Iterator<Tuple2<A, B>>(this){
                private int pos;
                private final Leaf $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                    this.pos = 0;
                }

                public int pos() {
                    return this.pos;
                }

                public void pos_$eq(int x$1) {
                    this.pos = x$1;
                }

                public boolean hasNext() {
                    return this.pos() < this.$outer.hashes().length;
                }

                /*
                 * WARNING - void declaration
                 */
                public Tuple2 next() {
                    void var1_1;
                    Tuple2<A, B> z = this.$outer.getKeyValue(this.pos());
                    this.pos_$eq(this.pos() + 1);
                    return var1_1;
                }
            };
        }
    }

    public static abstract class Node<A, B> {
        public abstract int cappedSize(int var1);

        public abstract boolean txnIsEmpty(InTxn var1);

        public abstract <U> void keyForeach(Function1<A, U> var1);

        public abstract <U> void mapForeach(Function1<Tuple2<A, B>, U> var1);

        public abstract Iterator<A> keyIterator();

        public abstract Iterator<B> valueIterator();

        public abstract Iterator<Tuple2<A, B>> mapIterator();
    }
}

