/*
 * Decompiled with CFR 0.152.
 */
package gridscale.effectaside;

import gridscale.effectaside.package$FileSystem$;
import gridscale.effectaside.package$Path$;
import gridscale.effectaside.package$Random$;
import gridscale.effectaside.package$System$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.BuildFrom$;
import scala.collection.immutable.Vector;
import scala.io.Codec$;
import scala.io.Source$;
import squants.time.Time;

public final class package {

    public static class Effect<T> {
        private final Function0<T> effect;

        public Effect(Function0<T> effect) {
            this.effect = effect;
        }

        public T apply() {
            return (T)this.effect.apply();
        }
    }

    public static class FileSystem {
        public static Effect<FileSystem> apply() {
            return package$FileSystem$.MODULE$.apply();
        }

        public String read(File path) {
            return (String)this.readStream(path, (Function1 & Serializable)is -> Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString());
        }

        public Vector<File> list(File p) {
            return Predef$.MODULE$.wrapRefArray((Object[])p.listFiles()).toVector();
        }

        public <T> T readStream(File path, Function1<InputStream, T> f) {
            Object object;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(path));){
                object = f.apply((Object)is);
            }
            return (T)object;
        }

        public <T> T writeStream(File path, Function1<OutputStream, T> f) {
            Object object;
            try (BufferedOutputStream is = new BufferedOutputStream(new FileOutputStream(path));){
                object = f.apply((Object)is);
            }
            return (T)object;
        }
    }

    public static class IO {
        public <T> Function0<T> apply(Function0<T> f) {
            return f;
        }
    }

    public static final class Path
    implements Product,
    Serializable {
        private final File path;

        public static File apply(File file) {
            return package$Path$.MODULE$.apply(file);
        }

        public static File fileToPath(File file) {
            return package$Path$.MODULE$.fileToPath(file);
        }

        public static File stringToPath(String string) {
            return package$Path$.MODULE$.stringToPath(string);
        }

        public static File unapply(File file) {
            return package$Path$.MODULE$.unapply(file);
        }

        public static File _1$extension(File file) {
            return package$Path$.MODULE$._1$extension(file);
        }

        public static boolean canEqual$extension(File file, Object object) {
            return package$Path$.MODULE$.canEqual$extension(file, object);
        }

        public static File copy$extension(File file, File file2) {
            return package$Path$.MODULE$.copy$extension(file, file2);
        }

        public static boolean equals$extension(File file, Object object) {
            return package$Path$.MODULE$.equals$extension(file, object);
        }

        public static int hashCode$extension(File file) {
            return package$Path$.MODULE$.hashCode$extension(file);
        }

        public static int productArity$extension(File file) {
            return package$Path$.MODULE$.productArity$extension(file);
        }

        public static Object productElement$extension(File file, int n) {
            return package$Path$.MODULE$.productElement$extension(file, n);
        }

        public static String productElementName$extension(File file, int n) {
            return package$Path$.MODULE$.productElementName$extension(file, n);
        }

        public static String productPrefix$extension(File file) {
            return package$Path$.MODULE$.productPrefix$extension(file);
        }

        public static String toString$extension(File file) {
            return package$Path$.MODULE$.toString$extension(file);
        }

        public static File copy$default$1$extension(File file) {
            return package$Path$.MODULE$.copy$default$1$extension(file);
        }

        public Path(File path) {
            this.path = path;
        }

        public int hashCode() {
            return package$Path$.MODULE$.hashCode$extension(this.path());
        }

        public boolean equals(Object x$0) {
            return package$Path$.MODULE$.equals$extension(this.path(), x$0);
        }

        public boolean canEqual(Object that) {
            return package$Path$.MODULE$.canEqual$extension(this.path(), that);
        }

        public int productArity() {
            return package$Path$.MODULE$.productArity$extension(this.path());
        }

        public String productPrefix() {
            return package$Path$.MODULE$.productPrefix$extension(this.path());
        }

        public Object productElement(int n) {
            return package$Path$.MODULE$.productElement$extension(this.path(), n);
        }

        public String productElementName(int n) {
            return package$Path$.MODULE$.productElementName$extension(this.path(), n);
        }

        public File path() {
            return this.path;
        }

        public String toString() {
            return package$Path$.MODULE$.toString$extension(this.path());
        }

        public File copy(File path) {
            return package$Path$.MODULE$.copy$extension(this.path(), path);
        }

        public File copy$default$1() {
            return package$Path$.MODULE$.copy$default$1$extension(this.path());
        }

        public File _1() {
            return package$Path$.MODULE$._1$extension(this.path());
        }
    }

    public static class Random {
        private final scala.util.Random random;

        public static Effect<Random> apply(long l) {
            return package$Random$.MODULE$.apply(l);
        }

        public static Effect<Random> apply(scala.util.Random random) {
            return package$Random$.MODULE$.apply(random);
        }

        public Random(scala.util.Random random) {
            this.random = random;
        }

        public scala.util.Random random() {
            return this.random;
        }

        public double nextDouble() {
            return this.random().nextDouble();
        }

        public int nextInt(int n) {
            return this.random().nextInt(n);
        }

        public boolean nextBoolean() {
            return this.random().nextBoolean();
        }

        public <A> Vector<A> shuffle(Vector<A> s) {
            return (Vector)this.random().shuffle(s, BuildFrom$.MODULE$.buildFromIterableOps());
        }

        public <T> T use(Function1<scala.util.Random, T> f) {
            return (T)f.apply((Object)this.random());
        }
    }

    public static class System {
        public static Effect<System> apply() {
            return package$System$.MODULE$.apply();
        }

        public UUID randomUUID() {
            return UUID.randomUUID();
        }

        public void sleep(Time d) {
            Thread.sleep(d.millis());
        }

        public long currentTime() {
            return java.lang.System.currentTimeMillis();
        }
    }
}

