/*
 * Decompiled with CFR 0.152.
 */
package gridscale.tools.cache;

import gridscale.tools.cache.package$DisposableCache$;
import gridscale.tools.cache.package$KeyValueCache$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class package {

    public static class DisposableCache<T>
    implements Product,
    Serializable {
        private final Function0 f;
        private Option<T> cached;

        public static <T> DisposableCache<T> apply(Function0<T> function0) {
            return package$DisposableCache$.MODULE$.apply(function0);
        }

        public static DisposableCache<?> fromProduct(Product product) {
            return package$DisposableCache$.MODULE$.fromProduct(product);
        }

        public static <T> DisposableCache<T> unapply(DisposableCache<T> disposableCache) {
            return package$DisposableCache$.MODULE$.unapply(disposableCache);
        }

        public DisposableCache(Function0<T> f) {
            this.f = f;
            this.cached = None$.MODULE$;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DisposableCache)) return false;
            DisposableCache disposableCache = (DisposableCache)object;
            Function0<T> function0 = this.f();
            Function0<T> function02 = disposableCache.f();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            if (!disposableCache.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DisposableCache;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DisposableCache";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "f";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function0<T> f() {
            return this.f;
        }

        public T get() {
            Object object;
            DisposableCache disposableCache = this;
            synchronized (disposableCache) {
                Object object2;
                Option<T> option = this.cached;
                if (None$.MODULE$.equals(option)) {
                    Object res = this.f().apply();
                    this.cached = Some$.MODULE$.apply(res);
                    object2 = res;
                } else if (option instanceof Some) {
                    Object t;
                    object2 = t = ((Some)option).value();
                } else {
                    throw new MatchError(option);
                }
                object = object2;
            }
            return (T)object;
        }

        public <A> Option<A> map(Function1<T, A> f) {
            Option option;
            DisposableCache disposableCache = this;
            synchronized (disposableCache) {
                option = this.cached.map(f);
            }
            return option;
        }

        public <A> void foreach(Function1<T, A> f) {
            DisposableCache disposableCache = this;
            synchronized (disposableCache) {
                this.cached.foreach(f);
            }
        }

        public void dispose() {
            DisposableCache disposableCache = this;
            synchronized (disposableCache) {
                this.cached = None$.MODULE$;
            }
        }

        public <T> DisposableCache<T> copy(Function0<T> f) {
            return new DisposableCache<T>(f);
        }

        public <T> Function0<T> copy$default$1() {
            return this.f();
        }

        public Function0<T> _1() {
            return this.f();
        }
    }

    public static class KeyValueCache<K, V>
    implements Product,
    Serializable {
        private final Function1 f;
        private final LockRepository locks;
        private final HashMap cached;

        public static <K, V> KeyValueCache<K, V> apply(Function1<K, V> function1) {
            return package$KeyValueCache$.MODULE$.apply(function1);
        }

        public static KeyValueCache<?, ?> fromProduct(Product product) {
            return package$KeyValueCache$.MODULE$.fromProduct(product);
        }

        public static <K, V> KeyValueCache<K, V> unapply(KeyValueCache<K, V> keyValueCache) {
            return package$KeyValueCache$.MODULE$.unapply(keyValueCache);
        }

        public KeyValueCache(Function1<K, V> f) {
            this.f = f;
            this.locks = new LockRepository();
            this.cached = new HashMap();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof KeyValueCache)) return false;
            KeyValueCache keyValueCache = (KeyValueCache)object;
            Function1<K, V> function1 = this.f();
            Function1<K, V> function12 = keyValueCache.f();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!keyValueCache.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof KeyValueCache;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "KeyValueCache";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "f";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<K, V> f() {
            return this.f;
        }

        public LockRepository<K> locks() {
            return this.locks;
        }

        public HashMap<K, V> cached() {
            return this.cached;
        }

        public V get(K k) {
            return (V)this.locks().withLock(k, () -> this.get$$anonfun$1(k));
        }

        public V getValidOrInvalidate(K k, Function1<V, Object> valid, Function1<V, BoxedUnit> clean) {
            return (V)this.locks().withLock(k, () -> this.getValidOrInvalidate$$anonfun$1(k, valid, clean));
        }

        public Function1<V, BoxedUnit> getValidOrInvalidate$default$3() {
            return (JProcedure1 & Serializable)_$1 -> {};
        }

        public Vector<V> values() {
            Vector vector;
            HashMap<K, V> hashMap = this.cached();
            synchronized (hashMap) {
                vector = this.cached().values().toVector();
            }
            return vector;
        }

        private V insert(K k, V v) {
            V v2;
            HashMap<K, V> hashMap = this.cached();
            synchronized (hashMap) {
                this.cached().put(k, v);
                v2 = v;
            }
            return v2;
        }

        private Option<V> value(K k) {
            Option option;
            HashMap<K, V> hashMap = this.cached();
            synchronized (hashMap) {
                option = this.cached().get(k);
            }
            return option;
        }

        private boolean contains(K k) {
            boolean bl;
            HashMap<K, V> hashMap = this.cached();
            synchronized (hashMap) {
                bl = this.cached().contains(k);
            }
            return bl;
        }

        private Option<V> remove(K k) {
            Option option;
            HashMap<K, V> hashMap = this.cached();
            synchronized (hashMap) {
                option = this.cached().remove(k);
            }
            return option;
        }

        public void clear() {
            this.locks().clear();
            this.cached().clear();
        }

        public <K, V> KeyValueCache<K, V> copy(Function1<K, V> f) {
            return new KeyValueCache<K, V>(f);
        }

        public <K, V> Function1<K, V> copy$default$1() {
            return this.f();
        }

        public Function1<K, V> _1() {
            return this.f();
        }

        private final Object get$$anonfun$1(Object k$1) {
            Option<V> option = this.value(k$1);
            if (option instanceof Some) {
                Object v = ((Some)option).value();
                return v;
            }
            if (None$.MODULE$.equals(option)) {
                return this.insert(k$1, this.f().apply(k$1));
            }
            throw new MatchError(option);
        }

        private final Object getValidOrInvalidate$$anonfun$1(Object k$2, Function1 valid$1, Function1 clean$1) {
            Option<V> option = this.value(k$2);
            if (option instanceof Some) {
                Object v = ((Some)option).value();
                if (BoxesRunTime.unboxToBoolean((Object)valid$1.apply(v))) {
                    return v;
                }
                clean$1.apply(v);
                this.remove(k$2);
                return this.insert(k$2, this.f().apply(k$2));
            }
            if (None$.MODULE$.equals(option)) {
                return this.insert(k$2, this.f().apply(k$2));
            }
            throw new MatchError(option);
        }
    }

    public static class LockRepository<T> {
        private final HashMap locks = new HashMap();

        public HashMap<T, Tuple2<Lock, AtomicInteger>> locks() {
            return this.locks;
        }

        public void clear() {
            this.locks().clear();
        }

        public int nbLocked(T k) {
            int n;
            LockRepository lockRepository = this;
            synchronized (lockRepository) {
                n = BoxesRunTime.unboxToInt((Object)this.locks().get(k).map((Function1 & Serializable)_$2 -> ((AtomicInteger)_$2._2()).get()).getOrElse(this::nbLocked$$anonfun$2));
            }
            return n;
        }

        private void lock(T obj) {
            Lock lock;
            LockRepository lockRepository = this;
            synchronized (lockRepository) {
                Tuple2 lock2 = (Tuple2)this.locks().getOrElseUpdate(obj, this::$anonfun$1);
                ((AtomicInteger)lock2._2()).incrementAndGet();
                lock = (Lock)lock2._1();
            }
            lock.lock();
        }

        private void unlock(T obj) {
            LockRepository lockRepository = this;
            synchronized (lockRepository) {
                this.locks().get(obj).foreach((Function1)(JProcedure1 & Serializable)lock -> {
                    int value = ((AtomicInteger)lock._2()).decrementAndGet();
                    if (value <= 0) {
                        this.locks().remove(obj);
                    }
                    ((Lock)lock._1()).unlock();
                });
            }
        }

        public <A> A withLock(T obj, Function0<A> op) {
            Object object;
            this.lock(obj);
            try {
                object = op.apply();
            }
            finally {
                this.unlock(obj);
            }
            return (A)object;
        }

        private final int nbLocked$$anonfun$2() {
            return 0;
        }

        private final Tuple2 $anonfun$1() {
            return Tuple2$.MODULE$.apply((Object)new ReentrantLock(), (Object)new AtomicInteger(0));
        }
    }
}

