/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.lock;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.openmole.tool.lock.LockRepository$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxesRunTime;

public class LockRepository<T> {
    private final HashMap locks = new HashMap();

    public static <T> LockRepository<T> apply() {
        return LockRepository$.MODULE$.apply();
    }

    public HashMap<T, Tuple2<ReentrantLock, AtomicInteger>> locks() {
        return this.locks;
    }

    public int nbLocked(T k) {
        int n;
        HashMap<T, Tuple2<ReentrantLock, AtomicInteger>> hashMap = this.locks();
        synchronized (hashMap) {
            n = BoxesRunTime.unboxToInt((Object)this.locks().get(k).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    AtomicInteger users = (AtomicInteger)tuple2._2();
                    return users.get();
                }
                throw new MatchError((Object)tuple2);
            }).getOrElse(LockRepository::nbLocked$$anonfun$2));
        }
        return n;
    }

    private ReentrantLock getLock(T obj) {
        ReentrantLock reentrantLock;
        HashMap<T, Tuple2<ReentrantLock, AtomicInteger>> hashMap = this.locks();
        synchronized (hashMap) {
            Tuple2 tuple2 = (Tuple2)this.locks().getOrElseUpdate(obj, LockRepository::$anonfun$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ReentrantLock lock = (ReentrantLock)tuple2._1();
            AtomicInteger users = (AtomicInteger)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)lock, (Object)users);
            ReentrantLock lock2 = (ReentrantLock)tuple22._1();
            AtomicInteger users2 = (AtomicInteger)tuple22._2();
            users2.incrementAndGet();
            reentrantLock = lock2;
        }
        return reentrantLock;
    }

    private ReentrantLock cleanLock(T obj) {
        ReentrantLock reentrantLock;
        HashMap<T, Tuple2<ReentrantLock, AtomicInteger>> hashMap = this.locks();
        synchronized (hashMap) {
            ReentrantLock lock;
            Tuple2 tuple2;
            Option option = this.locks().get(obj);
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                lock = (ReentrantLock)tuple2._1();
                AtomicInteger users = (AtomicInteger)tuple2._2();
                int value = users.decrementAndGet();
                if (value <= 0) {
                    this.locks().remove(obj);
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException("Unlocking an object that has not been locked.");
                }
                throw new MatchError((Object)option);
            }
            reentrantLock = lock;
        }
        return reentrantLock;
    }

    public <A> A withLock(T obj, Function0<A> op) {
        Object object;
        ReentrantLock lock = this.getLock(obj);
        lock.lock();
        try {
            object = op.apply();
        }
        catch (Throwable throwable) {
            try {
                this.cleanLock(obj);
            }
            finally {
                lock.unlock();
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            this.cleanLock(obj);
        }
        finally {
            lock.unlock();
        }
        return (A)object2;
    }

    private static final int nbLocked$$anonfun$2() {
        return 0;
    }

    private static final Tuple2 $anonfun$1() {
        return Tuple2$.MODULE$.apply((Object)new ReentrantLock(), (Object)new AtomicInteger(0));
    }
}

