/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.workflow.execution;

import java.util.concurrent.atomic.AtomicLong;
import org.openmole.core.event.Event;
import org.openmole.core.event.EventDispatcher;
import org.openmole.core.threadprovider.ThreadProvider;
import org.openmole.core.workflow.execution.Environment;
import org.openmole.core.workflow.execution.Environment$JobStateChanged$;
import org.openmole.core.workflow.execution.Environment$JobSubmitted$;
import org.openmole.core.workflow.execution.ExecutionState$;
import org.openmole.core.workflow.execution.ExecutorPool;
import org.openmole.core.workflow.execution.LocalEnvironment$;
import org.openmole.core.workflow.execution.LocalEnvironmentProvider;
import org.openmole.core.workflow.execution.LocalExecutionJob;
import org.openmole.core.workflow.execution.LocalExecutionJob$;
import org.openmole.core.workflow.job.Job;
import org.openmole.core.workflow.job.JobGroup;
import org.openmole.core.workflow.job.JobGroup$;
import org.openmole.core.workflow.mole.MoleExecution;
import org.openmole.core.workflow.task.TaskExecutionContext;
import org.openmole.tool.cache.Cache;
import org.openmole.tool.cache.Cache$;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.ref.WeakReference;
import scala.ref.WeakReference$;
import scala.runtime.ScalaRunTime$;
import sourcecode.Name;

public class LocalEnvironment
implements org.openmole.core.workflow.tools.Name,
Environment {
    private final int threads;
    private final boolean deinterleave;
    private final Option name;
    private final ThreadProvider threadProvider;
    private final EventDispatcher eventDispatcherService;
    private final Cache pool;
    private final AtomicLong jobId;
    private final AtomicLong _done;
    private final AtomicLong _failed;

    public static LocalEnvironmentProvider apply(int n, boolean bl) {
        return LocalEnvironment$.MODULE$.apply(n, bl);
    }

    public static LocalEnvironmentProvider apply(Option<Object> option, boolean bl, Option<String> option2, Name name) {
        return LocalEnvironment$.MODULE$.apply(option, bl, option2, name);
    }

    public static Option<Object> apply$default$1() {
        return LocalEnvironment$.MODULE$.apply$default$1();
    }

    public static boolean apply$default$2() {
        return LocalEnvironment$.MODULE$.apply$default$2();
    }

    public static Option<String> apply$default$3() {
        return LocalEnvironment$.MODULE$.apply$default$3();
    }

    public LocalEnvironment(int threads, boolean deinterleave, Option<String> name, ThreadProvider threadProvider, EventDispatcher eventDispatcherService) {
        this.threads = threads;
        this.deinterleave = deinterleave;
        this.name = name;
        this.threadProvider = threadProvider;
        this.eventDispatcherService = eventDispatcherService;
        this.pool = Cache$.MODULE$.apply(() -> this.$init$$$anonfun$2(threads, threadProvider));
        this.jobId = new AtomicLong(0L);
        this._done = new AtomicLong(0L);
        this._failed = new AtomicLong(0L);
    }

    public int threads() {
        return this.threads;
    }

    public boolean deinterleave() {
        return this.deinterleave;
    }

    @Override
    public Option<String> name() {
        return this.name;
    }

    public ThreadProvider threadProvider() {
        return this.threadProvider;
    }

    public EventDispatcher eventDispatcherService() {
        return this.eventDispatcherService;
    }

    public Cache<ExecutorPool> pool() {
        return this.pool;
    }

    public scala.collection.mutable.Iterable<Job> runningJobs() {
        return ((ExecutorPool)this.pool().apply()).runningJobs();
    }

    public int nbJobInQueue() {
        return ((ExecutorPool)this.pool().apply()).waiting();
    }

    public long submit(JobGroup job, TaskExecutionContext.Partial executionContext) {
        long id = this.jobId.getAndIncrement();
        this.submit(LocalExecutionJob$.MODULE$.apply(id, executionContext, (Iterable<Job>)JobGroup$.MODULE$.moleJobs(job), (Option<MoleExecution>)Some$.MODULE$.apply((Object)JobGroup$.MODULE$.moleExecution(job))));
        return id;
    }

    public long submit(Job moleJob, TaskExecutionContext.Partial executionContext) {
        long id = this.jobId.getAndIncrement();
        this.submit(LocalExecutionJob$.MODULE$.apply(id, executionContext, (Iterable<Job>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Job[]{moleJob}))), (Option<MoleExecution>)None$.MODULE$));
        return id;
    }

    private void submit(LocalExecutionJob ejob) {
        ((ExecutorPool)this.pool().apply()).enqueue(ejob);
        this.eventDispatcherService().trigger((Object)this, (Event)Environment$JobSubmitted$.MODULE$.apply(ejob.id(), ejob));
        this.eventDispatcherService().trigger((Object)this, (Event)Environment$JobStateChanged$.MODULE$.apply(ejob.id(), ejob, ExecutionState$.MODULE$.SUBMITTED(), ExecutionState$.MODULE$.READY()));
    }

    @Override
    public long submitted() {
        return Int$.MODULE$.int2long(((ExecutorPool)this.pool().apply()).waiting());
    }

    @Override
    public long running() {
        return Int$.MODULE$.int2long(((ExecutorPool)this.pool().apply()).running());
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        ((ExecutorPool)this.pool().apply()).stop();
    }

    public AtomicLong _done() {
        return this._done;
    }

    public AtomicLong _failed() {
        return this._failed;
    }

    @Override
    public long done() {
        return this._done().get();
    }

    @Override
    public long failed() {
        return this._failed().get();
    }

    private final ExecutorPool $init$$$anonfun$2(int threads$1, ThreadProvider threadProvider$1) {
        return new ExecutorPool(threads$1, (WeakReference<LocalEnvironment>)WeakReference$.MODULE$.apply((Object)this), threadProvider$1);
    }
}

