/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.workflow.job;

import java.io.Serializable;
import org.openmole.core.context.CompactedContext$;
import org.openmole.core.context.Context;
import org.openmole.core.workflow.job.Job$;
import org.openmole.core.workflow.job.Job$CallBack$;
import org.openmole.core.workflow.job.Job$CallBack$Instance$;
import org.openmole.core.workflow.job.Job$Changed$;
import org.openmole.core.workflow.job.RuntimeTask;
import org.openmole.core.workflow.task.Task$;
import org.openmole.core.workflow.task.TaskExecutionContext;
import scala.Function0;
import scala.Function2;
import scala.Product;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

public class Job {
    private final RuntimeTask task;
    private final Object[] compressedContext;
    private final long id;
    private final CallBack callBack;

    public static Job apply(RuntimeTask runtimeTask, Context context, long l, CallBack callBack) {
        return Job$.MODULE$.apply(runtimeTask, context, l, callBack);
    }

    public static Job apply(RuntimeTask runtimeTask, Context context, long l, Function2<Object, Either<Context, Throwable>, BoxedUnit> function2, Function0<Object> function0) {
        return Job$.MODULE$.apply(runtimeTask, context, l, function2, function0);
    }

    public static void finish(Job job, Either<Context, Throwable> either) {
        Job$.MODULE$.finish(job, either);
    }

    public static Ordering<Job> moleJobOrdering() {
        return Job$.MODULE$.moleJobOrdering();
    }

    public Job(RuntimeTask task, Object[] compressedContext, long id, CallBack callBack) {
        this.task = task;
        this.compressedContext = compressedContext;
        this.id = id;
        this.callBack = callBack;
    }

    public RuntimeTask task() {
        return this.task;
    }

    public long id() {
        return this.id;
    }

    public CallBack callBack() {
        return this.callBack;
    }

    public Context context() {
        return CompactedContext$.MODULE$.expand(this.compressedContext);
    }

    public Either<Context, Throwable> perform(TaskExecutionContext executionContext) {
        if (!this.callBack().subMoleCanceled()) {
            Right right;
            Context ctx = this.context();
            try {
                Context performResult = Task$.MODULE$.perform(this.task().task(), ctx, executionContext);
                right = package$.MODULE$.Left().apply((Object)(this.task().strain() ? ctx.$plus(performResult) : performResult));
            }
            catch (Throwable t) {
                right = package$.MODULE$.Right().apply((Object)t);
            }
            return right;
        }
        return package$.MODULE$.Right().apply((Object)new SubMoleCanceled());
    }

    public static interface CallBack {
        public static Instance apply(Function2<Object, Either<Context, Throwable>, BoxedUnit> function2, Function0<Object> function0) {
            return Job$CallBack$.MODULE$.apply(function2, function0);
        }

        public void jobFinished(long var1, Either<Context, Throwable> var3);

        public boolean subMoleCanceled();

        public static class Instance
        implements CallBack,
        Product,
        Serializable {
            private final Function2 _jobFinished;
            private final Function0 _canceled;

            public static Instance apply(Function2<Object, Either<Context, Throwable>, BoxedUnit> function2, Function0<Object> function0) {
                return Job$CallBack$Instance$.MODULE$.apply(function2, function0);
            }

            public static Instance fromProduct(Product product) {
                return Job$CallBack$Instance$.MODULE$.fromProduct(product);
            }

            public static Instance unapply(Instance instance) {
                return Job$CallBack$Instance$.MODULE$.unapply(instance);
            }

            public Instance(Function2<Object, Either<Context, Throwable>, BoxedUnit> _jobFinished, Function0<Object> _canceled) {
                this._jobFinished = _jobFinished;
                this._canceled = _canceled;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Instance)) return false;
                Instance instance = (Instance)object;
                Function2<Object, Either<Context, Throwable>, BoxedUnit> function2 = this._jobFinished();
                Function2<Object, Either<Context, Throwable>, BoxedUnit> function22 = instance._jobFinished();
                if (function2 == null) {
                    if (function22 != null) {
                        return false;
                    }
                } else if (!function2.equals(function22)) return false;
                Function0<Object> function0 = this._canceled();
                Function0<Object> function02 = instance._canceled();
                if (function0 == null) {
                    if (function02 != null) {
                        return false;
                    }
                } else if (!function0.equals(function02)) return false;
                if (!instance.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Instance;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "Instance";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "_jobFinished";
                }
                if (1 == n2) {
                    return "_canceled";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Function2<Object, Either<Context, Throwable>, BoxedUnit> _jobFinished() {
                return this._jobFinished;
            }

            public Function0<Object> _canceled() {
                return this._canceled;
            }

            @Override
            public boolean subMoleCanceled() {
                return this._canceled().apply$mcZ$sp();
            }

            @Override
            public void jobFinished(long job, Either<Context, Throwable> result) {
                this._jobFinished().apply((Object)BoxesRunTime.boxToLong((long)job), result);
            }

            public Instance copy(Function2<Object, Either<Context, Throwable>, BoxedUnit> _jobFinished, Function0<Object> _canceled) {
                return new Instance(_jobFinished, _canceled);
            }

            public Function2<Object, Either<Context, Throwable>, BoxedUnit> copy$default$1() {
                return this._jobFinished();
            }

            public Function0<Object> copy$default$2() {
                return this._canceled();
            }

            public Function2<Object, Either<Context, Throwable>, BoxedUnit> _1() {
                return this._jobFinished();
            }

            public Function0<Object> _2() {
                return this._canceled();
            }
        }
    }

    public static class Changed
    implements StateChange,
    Product,
    Serializable {
        private final byte old;
        private final byte state;
        private final Context context;

        public static Changed apply(byte by, byte by2, Context context) {
            return Job$Changed$.MODULE$.apply(by, by2, context);
        }

        public static Changed fromProduct(Product product) {
            return Job$Changed$.MODULE$.fromProduct(product);
        }

        public static Changed unapply(Changed changed) {
            return Job$Changed$.MODULE$.unapply(changed);
        }

        public Changed(byte old, byte state, Context context) {
            this.old = old;
            this.state = state;
            this.context = context;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.old());
            n = Statics.mix((int)n, (int)this.state());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.context()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Changed)) return false;
            Changed changed = (Changed)object;
            if (this.old() != changed.old()) return false;
            if (this.state() != changed.state()) return false;
            Context context = this.context();
            Context context2 = changed.context();
            if (context == null) {
                if (context2 != null) {
                    return false;
                }
            } else if (!context.equals(context2)) return false;
            if (!changed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Changed;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Changed";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToByte((byte)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToByte((byte)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "old";
                }
                case 1: {
                    return "state";
                }
                case 2: {
                    return "context";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public byte old() {
            return this.old;
        }

        public byte state() {
            return this.state;
        }

        public Context context() {
            return this.context;
        }

        public Changed copy(byte old, byte state, Context context) {
            return new Changed(old, state, context);
        }

        public byte copy$default$1() {
            return this.old();
        }

        public byte copy$default$2() {
            return this.state();
        }

        public Context copy$default$3() {
            return this.context();
        }

        public byte _1() {
            return this.old();
        }

        public byte _2() {
            return this.state();
        }

        public Context _3() {
            return this.context();
        }
    }

    public static interface StateChange {
    }

    public static class SubMoleCanceled
    extends Exception {
    }
}

