/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.workflow.validation;

import java.io.Serializable;
import org.openmole.core.context.Val;
import org.openmole.core.context.ValType;
import org.openmole.core.workflow.hook.Hook;
import org.openmole.core.workflow.mole.MoleCapsule;
import org.openmole.core.workflow.mole.Source;
import org.openmole.core.workflow.transition.TransitionSlot;
import org.openmole.core.workflow.validation.DataflowProblem$DuplicatedName$;
import org.openmole.core.workflow.validation.DataflowProblem$IncoherentTypeAggregation$;
import org.openmole.core.workflow.validation.DataflowProblem$IncoherentTypesBetweenSlots$;
import org.openmole.core.workflow.validation.DataflowProblem$MissingHookInput$;
import org.openmole.core.workflow.validation.DataflowProblem$MissingInput$;
import org.openmole.core.workflow.validation.DataflowProblem$MissingMoleTaskImplicit$;
import org.openmole.core.workflow.validation.DataflowProblem$MissingSourceInput$;
import org.openmole.core.workflow.validation.DataflowProblem$MoleTaskDataFlowProblem$;
import org.openmole.core.workflow.validation.DataflowProblem$WrongHookType$;
import org.openmole.core.workflow.validation.DataflowProblem$WrongSourceType$;
import org.openmole.core.workflow.validation.DataflowProblem$WrongType$;
import org.openmole.core.workflow.validation.Problem;
import org.openmole.core.workflow.validation.TypeUtil;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface DataflowProblem
extends Problem {
    public MoleCapsule capsule();

    public static class DuplicatedName
    implements DataflowProblem,
    Product,
    Serializable {
        private final MoleCapsule capsule;
        private final String name;
        private final Iterable prototype;
        private final SlotType slotType;

        public static DuplicatedName apply(MoleCapsule moleCapsule, String string, Iterable<Val<?>> iterable, SlotType slotType) {
            return DataflowProblem$DuplicatedName$.MODULE$.apply(moleCapsule, string, iterable, slotType);
        }

        public static DuplicatedName fromProduct(Product product) {
            return DataflowProblem$DuplicatedName$.MODULE$.fromProduct(product);
        }

        public static DuplicatedName unapply(DuplicatedName duplicatedName) {
            return DataflowProblem$DuplicatedName$.MODULE$.unapply(duplicatedName);
        }

        public DuplicatedName(MoleCapsule capsule, String name, Iterable<Val<?>> prototype, SlotType slotType) {
            this.capsule = capsule;
            this.name = name;
            this.prototype = prototype;
            this.slotType = slotType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DuplicatedName)) return false;
            DuplicatedName duplicatedName = (DuplicatedName)object;
            MoleCapsule moleCapsule = this.capsule();
            MoleCapsule moleCapsule2 = duplicatedName.capsule();
            if (moleCapsule == null) {
                if (moleCapsule2 != null) {
                    return false;
                }
            } else if (!moleCapsule.equals(moleCapsule2)) return false;
            String string = this.name();
            String string2 = duplicatedName.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Iterable<Val<?>> iterable = this.prototype();
            Iterable<Val<?>> iterable2 = duplicatedName.prototype();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            SlotType slotType = this.slotType();
            SlotType slotType2 = duplicatedName.slotType();
            if (slotType == null) {
                if (slotType2 != null) {
                    return false;
                }
            } else if (!slotType.equals(slotType2)) return false;
            if (!duplicatedName.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof DuplicatedName;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "DuplicatedName";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "capsule";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "prototype";
                }
                case 3: {
                    return "slotType";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public MoleCapsule capsule() {
            return this.capsule;
        }

        public String name() {
            return this.name;
        }

        public Iterable<Val<?>> prototype() {
            return this.prototype;
        }

        public SlotType slotType() {
            return this.slotType;
        }

        public String toString() {
            return this.name() + " has been found several time with different types in " + this.slotType() + " of capsule " + this.capsule() + ": " + this.prototype().mkString(", ") + ".";
        }

        public DuplicatedName copy(MoleCapsule capsule, String name, Iterable<Val<?>> prototype, SlotType slotType) {
            return new DuplicatedName(capsule, name, prototype, slotType);
        }

        public MoleCapsule copy$default$1() {
            return this.capsule();
        }

        public String copy$default$2() {
            return this.name();
        }

        public Iterable<Val<?>> copy$default$3() {
            return this.prototype();
        }

        public SlotType copy$default$4() {
            return this.slotType();
        }

        public MoleCapsule _1() {
            return this.capsule();
        }

        public String _2() {
            return this.name();
        }

        public Iterable<Val<?>> _3() {
            return this.prototype();
        }

        public SlotType _4() {
            return this.slotType();
        }
    }

    public static interface HookProblem
    extends DataflowProblem {
    }

    public static class IncoherentTypeAggregation
    implements SlotDataflowProblem,
    Product,
    Serializable {
        private final TransitionSlot slot;
        private final TypeUtil.InvalidType type;

        public static IncoherentTypeAggregation apply(TransitionSlot transitionSlot, TypeUtil.InvalidType invalidType) {
            return DataflowProblem$IncoherentTypeAggregation$.MODULE$.apply(transitionSlot, invalidType);
        }

        public static IncoherentTypeAggregation fromProduct(Product product) {
            return DataflowProblem$IncoherentTypeAggregation$.MODULE$.fromProduct(product);
        }

        public static IncoherentTypeAggregation unapply(IncoherentTypeAggregation incoherentTypeAggregation) {
            return DataflowProblem$IncoherentTypeAggregation$.MODULE$.unapply(incoherentTypeAggregation);
        }

        public IncoherentTypeAggregation(TransitionSlot slot, TypeUtil.InvalidType type) {
            this.slot = slot;
            this.type = type;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IncoherentTypeAggregation)) return false;
            IncoherentTypeAggregation incoherentTypeAggregation = (IncoherentTypeAggregation)object;
            TransitionSlot transitionSlot = this.slot();
            TransitionSlot transitionSlot2 = incoherentTypeAggregation.slot();
            if (transitionSlot == null) {
                if (transitionSlot2 != null) {
                    return false;
                }
            } else if (!transitionSlot.equals(transitionSlot2)) return false;
            TypeUtil.InvalidType invalidType = this.type();
            TypeUtil.InvalidType invalidType2 = incoherentTypeAggregation.type();
            if (invalidType == null) {
                if (invalidType2 != null) {
                    return false;
                }
            } else if (!((Object)invalidType).equals(invalidType2)) return false;
            if (!incoherentTypeAggregation.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof IncoherentTypeAggregation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "IncoherentTypeAggregation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "slot";
            }
            if (1 == n2) {
                return "type";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public TransitionSlot slot() {
            return this.slot;
        }

        public TypeUtil.InvalidType type() {
            return this.type;
        }

        public String toString() {
            return "Cannot aggregate type for slot " + this.slot() + ", the incoming data type are inconsistent (it may be because variables with the same name but not the same type reach the slot): " + this.type() + ".";
        }

        public IncoherentTypeAggregation copy(TransitionSlot slot, TypeUtil.InvalidType type) {
            return new IncoherentTypeAggregation(slot, type);
        }

        public TransitionSlot copy$default$1() {
            return this.slot();
        }

        public TypeUtil.InvalidType copy$default$2() {
            return this.type();
        }

        public TransitionSlot _1() {
            return this.slot();
        }

        public TypeUtil.InvalidType _2() {
            return this.type();
        }
    }

    public static class IncoherentTypesBetweenSlots
    implements DataflowProblem,
    Product,
    Serializable {
        private final MoleCapsule capsule;
        private final String name;
        private final Iterable types;

        public static IncoherentTypesBetweenSlots apply(MoleCapsule moleCapsule, String string, Iterable<ValType<?>> iterable) {
            return DataflowProblem$IncoherentTypesBetweenSlots$.MODULE$.apply(moleCapsule, string, iterable);
        }

        public static IncoherentTypesBetweenSlots fromProduct(Product product) {
            return DataflowProblem$IncoherentTypesBetweenSlots$.MODULE$.fromProduct(product);
        }

        public static IncoherentTypesBetweenSlots unapply(IncoherentTypesBetweenSlots incoherentTypesBetweenSlots) {
            return DataflowProblem$IncoherentTypesBetweenSlots$.MODULE$.unapply(incoherentTypesBetweenSlots);
        }

        public IncoherentTypesBetweenSlots(MoleCapsule capsule, String name, Iterable<ValType<?>> types) {
            this.capsule = capsule;
            this.name = name;
            this.types = types;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IncoherentTypesBetweenSlots)) return false;
            IncoherentTypesBetweenSlots incoherentTypesBetweenSlots = (IncoherentTypesBetweenSlots)object;
            MoleCapsule moleCapsule = this.capsule();
            MoleCapsule moleCapsule2 = incoherentTypesBetweenSlots.capsule();
            if (moleCapsule == null) {
                if (moleCapsule2 != null) {
                    return false;
                }
            } else if (!moleCapsule.equals(moleCapsule2)) return false;
            String string = this.name();
            String string2 = incoherentTypesBetweenSlots.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Iterable<ValType<?>> iterable = this.types();
            Iterable<ValType<?>> iterable2 = incoherentTypesBetweenSlots.types();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            if (!incoherentTypesBetweenSlots.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof IncoherentTypesBetweenSlots;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "IncoherentTypesBetweenSlots";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "capsule";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "types";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public MoleCapsule capsule() {
            return this.capsule;
        }

        public String name() {
            return this.name;
        }

        public Iterable<ValType<?>> types() {
            return this.types;
        }

        public String toString() {
            return this.name() + " is present in multiple slot of capsule " + this.capsule() + " but has different types: " + this.types().mkString(", ") + ".";
        }

        public IncoherentTypesBetweenSlots copy(MoleCapsule capsule, String name, Iterable<ValType<?>> types) {
            return new IncoherentTypesBetweenSlots(capsule, name, types);
        }

        public MoleCapsule copy$default$1() {
            return this.capsule();
        }

        public String copy$default$2() {
            return this.name();
        }

        public Iterable<ValType<?>> copy$default$3() {
            return this.types();
        }

        public MoleCapsule _1() {
            return this.capsule();
        }

        public String _2() {
            return this.name();
        }

        public Iterable<ValType<?>> _3() {
            return this.types();
        }
    }

    public static class MissingHookInput
    implements HookProblem,
    Product,
    Serializable {
        private final MoleCapsule capsule;
        private final Hook hook;
        private final Val input;

        public static MissingHookInput apply(MoleCapsule moleCapsule, Hook hook, Val<?> val) {
            return DataflowProblem$MissingHookInput$.MODULE$.apply(moleCapsule, hook, val);
        }

        public static MissingHookInput fromProduct(Product product) {
            return DataflowProblem$MissingHookInput$.MODULE$.fromProduct(product);
        }

        public static MissingHookInput unapply(MissingHookInput missingHookInput) {
            return DataflowProblem$MissingHookInput$.MODULE$.unapply(missingHookInput);
        }

        public MissingHookInput(MoleCapsule capsule, Hook hook, Val<?> input) {
            this.capsule = capsule;
            this.hook = hook;
            this.input = input;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingHookInput)) return false;
            MissingHookInput missingHookInput = (MissingHookInput)object;
            MoleCapsule moleCapsule = this.capsule();
            MoleCapsule moleCapsule2 = missingHookInput.capsule();
            if (moleCapsule == null) {
                if (moleCapsule2 != null) {
                    return false;
                }
            } else if (!moleCapsule.equals(moleCapsule2)) return false;
            Hook hook = this.hook();
            Hook hook2 = missingHookInput.hook();
            if (hook == null) {
                if (hook2 != null) {
                    return false;
                }
            } else if (!hook.equals(hook2)) return false;
            Val<?> val = this.input();
            Val<?> val2 = missingHookInput.input();
            if (val == null) {
                if (val2 != null) {
                    return false;
                }
            } else if (!val.equals(val2)) return false;
            if (!missingHookInput.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingHookInput;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "MissingHookInput";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "capsule";
                }
                case 1: {
                    return "hook";
                }
                case 2: {
                    return "input";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public MoleCapsule capsule() {
            return this.capsule;
        }

        public Hook hook() {
            return this.hook;
        }

        public Val<?> input() {
            return this.input;
        }

        public String toString() {
            return "Input " + this.input() + " is missing for misc " + this.hook();
        }

        public MissingHookInput copy(MoleCapsule capsule, Hook hook, Val<?> input) {
            return new MissingHookInput(capsule, hook, input);
        }

        public MoleCapsule copy$default$1() {
            return this.capsule();
        }

        public Hook copy$default$2() {
            return this.hook();
        }

        public Val<?> copy$default$3() {
            return this.input();
        }

        public MoleCapsule _1() {
            return this.capsule();
        }

        public Hook _2() {
            return this.hook();
        }

        public Val<?> _3() {
            return this.input();
        }
    }

    public static class MissingInput
    implements SlotDataflowProblem,
    Product,
    Serializable {
        private final TransitionSlot slot;
        private final Val data;
        private final Seq reaches;

        public static MissingInput apply(TransitionSlot transitionSlot, Val<?> val, Seq<Val<?>> seq) {
            return DataflowProblem$MissingInput$.MODULE$.apply(transitionSlot, val, seq);
        }

        public static MissingInput fromProduct(Product product) {
            return DataflowProblem$MissingInput$.MODULE$.fromProduct(product);
        }

        public static MissingInput unapply(MissingInput missingInput) {
            return DataflowProblem$MissingInput$.MODULE$.unapply(missingInput);
        }

        public MissingInput(TransitionSlot slot, Val<?> data, Seq<Val<?>> reaches) {
            this.slot = slot;
            this.data = data;
            this.reaches = reaches;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingInput)) return false;
            MissingInput missingInput = (MissingInput)object;
            TransitionSlot transitionSlot = this.slot();
            TransitionSlot transitionSlot2 = missingInput.slot();
            if (transitionSlot == null) {
                if (transitionSlot2 != null) {
                    return false;
                }
            } else if (!transitionSlot.equals(transitionSlot2)) return false;
            Val<?> val = this.data();
            Val<?> val2 = missingInput.data();
            if (val == null) {
                if (val2 != null) {
                    return false;
                }
            } else if (!val.equals(val2)) return false;
            Seq<Val<?>> seq = this.reaches();
            Seq<Val<?>> seq2 = missingInput.reaches();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!missingInput.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingInput;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "MissingInput";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "slot";
                }
                case 1: {
                    return "data";
                }
                case 2: {
                    return "reaches";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public TransitionSlot slot() {
            return this.slot;
        }

        public Val<?> data() {
            return this.data;
        }

        public Seq<Val<?>> reaches() {
            return this.reaches;
        }

        public String toString() {
            return "Input " + this.data() + " is missing when reaching the " + this.slot() + (", available inputs are " + this.reaches().mkString(",") + ".");
        }

        public MissingInput copy(TransitionSlot slot, Val<?> data, Seq<Val<?>> reaches) {
            return new MissingInput(slot, data, reaches);
        }

        public TransitionSlot copy$default$1() {
            return this.slot();
        }

        public Val<?> copy$default$2() {
            return this.data();
        }

        public Seq<Val<?>> copy$default$3() {
            return this.reaches();
        }

        public TransitionSlot _1() {
            return this.slot();
        }

        public Val<?> _2() {
            return this.data();
        }

        public Seq<Val<?>> _3() {
            return this.reaches();
        }
    }

    public static class MissingMoleTaskImplicit
    implements DataflowProblem,
    Product,
    Serializable {
        private final MoleCapsule capsule;
        private final String implicit;

        public static MissingMoleTaskImplicit apply(MoleCapsule moleCapsule, String string) {
            return DataflowProblem$MissingMoleTaskImplicit$.MODULE$.apply(moleCapsule, string);
        }

        public static MissingMoleTaskImplicit fromProduct(Product product) {
            return DataflowProblem$MissingMoleTaskImplicit$.MODULE$.fromProduct(product);
        }

        public static MissingMoleTaskImplicit unapply(MissingMoleTaskImplicit missingMoleTaskImplicit) {
            return DataflowProblem$MissingMoleTaskImplicit$.MODULE$.unapply(missingMoleTaskImplicit);
        }

        public MissingMoleTaskImplicit(MoleCapsule capsule, String implicit) {
            this.capsule = capsule;
            this.implicit = implicit;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingMoleTaskImplicit)) return false;
            MissingMoleTaskImplicit missingMoleTaskImplicit = (MissingMoleTaskImplicit)object;
            MoleCapsule moleCapsule = this.capsule();
            MoleCapsule moleCapsule2 = missingMoleTaskImplicit.capsule();
            if (moleCapsule == null) {
                if (moleCapsule2 != null) {
                    return false;
                }
            } else if (!moleCapsule.equals(moleCapsule2)) return false;
            String string = this.implicit();
            String string2 = missingMoleTaskImplicit.implicit();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!missingMoleTaskImplicit.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingMoleTaskImplicit;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MissingMoleTaskImplicit";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "capsule";
            }
            if (1 == n2) {
                return "implicit";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public MoleCapsule capsule() {
            return this.capsule;
        }

        public String implicit() {
            return this.implicit;
        }

        public String toString() {
            return "Implicit " + this.implicit() + " not found in input of " + this.capsule();
        }

        public MissingMoleTaskImplicit copy(MoleCapsule capsule, String implicit) {
            return new MissingMoleTaskImplicit(capsule, implicit);
        }

        public MoleCapsule copy$default$1() {
            return this.capsule();
        }

        public String copy$default$2() {
            return this.implicit();
        }

        public MoleCapsule _1() {
            return this.capsule();
        }

        public String _2() {
            return this.implicit();
        }
    }

    public static class MissingSourceInput
    implements SlotDataflowProblem,
    SourceProblem,
    Product,
    Serializable {
        private final TransitionSlot slot;
        private final Source source;
        private final Val input;

        public static MissingSourceInput apply(TransitionSlot transitionSlot, Source source, Val<?> val) {
            return DataflowProblem$MissingSourceInput$.MODULE$.apply(transitionSlot, source, val);
        }

        public static MissingSourceInput fromProduct(Product product) {
            return DataflowProblem$MissingSourceInput$.MODULE$.fromProduct(product);
        }

        public static MissingSourceInput unapply(MissingSourceInput missingSourceInput) {
            return DataflowProblem$MissingSourceInput$.MODULE$.unapply(missingSourceInput);
        }

        public MissingSourceInput(TransitionSlot slot, Source source, Val<?> input) {
            this.slot = slot;
            this.source = source;
            this.input = input;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MissingSourceInput)) return false;
            MissingSourceInput missingSourceInput = (MissingSourceInput)object;
            TransitionSlot transitionSlot = this.slot();
            TransitionSlot transitionSlot2 = missingSourceInput.slot();
            if (transitionSlot == null) {
                if (transitionSlot2 != null) {
                    return false;
                }
            } else if (!transitionSlot.equals(transitionSlot2)) return false;
            Source source = this.source();
            Source source2 = missingSourceInput.source();
            if (source == null) {
                if (source2 != null) {
                    return false;
                }
            } else if (!source.equals(source2)) return false;
            Val<?> val = this.input();
            Val<?> val2 = missingSourceInput.input();
            if (val == null) {
                if (val2 != null) {
                    return false;
                }
            } else if (!val.equals(val2)) return false;
            if (!missingSourceInput.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MissingSourceInput;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "MissingSourceInput";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "slot";
                }
                case 1: {
                    return "source";
                }
                case 2: {
                    return "input";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public TransitionSlot slot() {
            return this.slot;
        }

        public Source source() {
            return this.source;
        }

        public Val<?> input() {
            return this.input;
        }

        public String toString() {
            return "Input " + this.input() + " is missing for source " + this.source() + " at " + this.slot();
        }

        public MissingSourceInput copy(TransitionSlot slot, Source source, Val<?> input) {
            return new MissingSourceInput(slot, source, input);
        }

        public TransitionSlot copy$default$1() {
            return this.slot();
        }

        public Source copy$default$2() {
            return this.source();
        }

        public Val<?> copy$default$3() {
            return this.input();
        }

        public TransitionSlot _1() {
            return this.slot();
        }

        public Source _2() {
            return this.source();
        }

        public Val<?> _3() {
            return this.input();
        }
    }

    public static class MoleTaskDataFlowProblem
    implements DataflowProblem,
    Product,
    Serializable {
        private final MoleCapsule capsule;
        private final DataflowProblem problem;

        public static MoleTaskDataFlowProblem apply(MoleCapsule moleCapsule, DataflowProblem dataflowProblem) {
            return DataflowProblem$MoleTaskDataFlowProblem$.MODULE$.apply(moleCapsule, dataflowProblem);
        }

        public static MoleTaskDataFlowProblem fromProduct(Product product) {
            return DataflowProblem$MoleTaskDataFlowProblem$.MODULE$.fromProduct(product);
        }

        public static MoleTaskDataFlowProblem unapply(MoleTaskDataFlowProblem moleTaskDataFlowProblem) {
            return DataflowProblem$MoleTaskDataFlowProblem$.MODULE$.unapply(moleTaskDataFlowProblem);
        }

        public MoleTaskDataFlowProblem(MoleCapsule capsule, DataflowProblem problem) {
            this.capsule = capsule;
            this.problem = problem;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MoleTaskDataFlowProblem)) return false;
            MoleTaskDataFlowProblem moleTaskDataFlowProblem = (MoleTaskDataFlowProblem)object;
            MoleCapsule moleCapsule = this.capsule();
            MoleCapsule moleCapsule2 = moleTaskDataFlowProblem.capsule();
            if (moleCapsule == null) {
                if (moleCapsule2 != null) {
                    return false;
                }
            } else if (!moleCapsule.equals(moleCapsule2)) return false;
            DataflowProblem dataflowProblem = this.problem();
            DataflowProblem dataflowProblem2 = moleTaskDataFlowProblem.problem();
            if (dataflowProblem == null) {
                if (dataflowProblem2 != null) {
                    return false;
                }
            } else if (!dataflowProblem.equals(dataflowProblem2)) return false;
            if (!moleTaskDataFlowProblem.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MoleTaskDataFlowProblem;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MoleTaskDataFlowProblem";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "capsule";
            }
            if (1 == n2) {
                return "problem";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public MoleCapsule capsule() {
            return this.capsule;
        }

        public DataflowProblem problem() {
            return this.problem;
        }

        public String toString() {
            return "Error in mole task " + this.capsule() + ": " + this.problem();
        }

        public MoleTaskDataFlowProblem copy(MoleCapsule capsule, DataflowProblem problem) {
            return new MoleTaskDataFlowProblem(capsule, problem);
        }

        public MoleCapsule copy$default$1() {
            return this.capsule();
        }

        public DataflowProblem copy$default$2() {
            return this.problem();
        }

        public MoleCapsule _1() {
            return this.capsule();
        }

        public DataflowProblem _2() {
            return this.problem();
        }
    }

    public static interface SlotDataflowProblem
    extends DataflowProblem {
        public TransitionSlot slot();

        public static MoleCapsule capsule$(SlotDataflowProblem $this) {
            return $this.capsule();
        }

        @Override
        default public MoleCapsule capsule() {
            return this.slot().capsule();
        }
    }

    public static interface SlotType {
    }

    public static interface SourceProblem
    extends SlotDataflowProblem {
    }

    public static class WrongHookType
    implements HookProblem,
    Product,
    Serializable {
        private final MoleCapsule capsule;
        private final Hook hook;
        private final Val input;
        private final Val found;

        public static WrongHookType apply(MoleCapsule moleCapsule, Hook hook, Val<?> val, Val<?> val2) {
            return DataflowProblem$WrongHookType$.MODULE$.apply(moleCapsule, hook, val, val2);
        }

        public static WrongHookType fromProduct(Product product) {
            return DataflowProblem$WrongHookType$.MODULE$.fromProduct(product);
        }

        public static WrongHookType unapply(WrongHookType wrongHookType) {
            return DataflowProblem$WrongHookType$.MODULE$.unapply(wrongHookType);
        }

        public WrongHookType(MoleCapsule capsule, Hook hook, Val<?> input, Val<?> found) {
            this.capsule = capsule;
            this.hook = hook;
            this.input = input;
            this.found = found;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WrongHookType)) return false;
            WrongHookType wrongHookType = (WrongHookType)object;
            MoleCapsule moleCapsule = this.capsule();
            MoleCapsule moleCapsule2 = wrongHookType.capsule();
            if (moleCapsule == null) {
                if (moleCapsule2 != null) {
                    return false;
                }
            } else if (!moleCapsule.equals(moleCapsule2)) return false;
            Hook hook = this.hook();
            Hook hook2 = wrongHookType.hook();
            if (hook == null) {
                if (hook2 != null) {
                    return false;
                }
            } else if (!hook.equals(hook2)) return false;
            Val<?> val = this.input();
            Val<?> val2 = wrongHookType.input();
            if (val == null) {
                if (val2 != null) {
                    return false;
                }
            } else if (!val.equals(val2)) return false;
            Val<?> val3 = this.found();
            Val<?> val4 = wrongHookType.found();
            if (val3 == null) {
                if (val4 != null) {
                    return false;
                }
            } else if (!val3.equals(val4)) return false;
            if (!wrongHookType.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof WrongHookType;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "WrongHookType";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "capsule";
                }
                case 1: {
                    return "hook";
                }
                case 2: {
                    return "input";
                }
                case 3: {
                    return "found";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public MoleCapsule capsule() {
            return this.capsule;
        }

        public Hook hook() {
            return this.hook;
        }

        public Val<?> input() {
            return this.input;
        }

        public Val<?> found() {
            return this.found;
        }

        public String toString() {
            return "Input has incompatible type " + this.found() + " whereas " + this.input() + " was expected for hook " + this.hook() + " of capsule " + this.capsule();
        }

        public WrongHookType copy(MoleCapsule capsule, Hook hook, Val<?> input, Val<?> found) {
            return new WrongHookType(capsule, hook, input, found);
        }

        public MoleCapsule copy$default$1() {
            return this.capsule();
        }

        public Hook copy$default$2() {
            return this.hook();
        }

        public Val<?> copy$default$3() {
            return this.input();
        }

        public Val<?> copy$default$4() {
            return this.found();
        }

        public MoleCapsule _1() {
            return this.capsule();
        }

        public Hook _2() {
            return this.hook();
        }

        public Val<?> _3() {
            return this.input();
        }

        public Val<?> _4() {
            return this.found();
        }
    }

    public static class WrongSourceType
    implements SlotDataflowProblem,
    SourceProblem,
    Product,
    Serializable {
        private final TransitionSlot slot;
        private final Source source;
        private final Val expected;
        private final Val provided;

        public static WrongSourceType apply(TransitionSlot transitionSlot, Source source, Val<?> val, Val<?> val2) {
            return DataflowProblem$WrongSourceType$.MODULE$.apply(transitionSlot, source, val, val2);
        }

        public static WrongSourceType fromProduct(Product product) {
            return DataflowProblem$WrongSourceType$.MODULE$.fromProduct(product);
        }

        public static WrongSourceType unapply(WrongSourceType wrongSourceType) {
            return DataflowProblem$WrongSourceType$.MODULE$.unapply(wrongSourceType);
        }

        public WrongSourceType(TransitionSlot slot, Source source, Val<?> expected, Val<?> provided) {
            this.slot = slot;
            this.source = source;
            this.expected = expected;
            this.provided = provided;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WrongSourceType)) return false;
            WrongSourceType wrongSourceType = (WrongSourceType)object;
            TransitionSlot transitionSlot = this.slot();
            TransitionSlot transitionSlot2 = wrongSourceType.slot();
            if (transitionSlot == null) {
                if (transitionSlot2 != null) {
                    return false;
                }
            } else if (!transitionSlot.equals(transitionSlot2)) return false;
            Source source = this.source();
            Source source2 = wrongSourceType.source();
            if (source == null) {
                if (source2 != null) {
                    return false;
                }
            } else if (!source.equals(source2)) return false;
            Val<?> val = this.expected();
            Val<?> val2 = wrongSourceType.expected();
            if (val == null) {
                if (val2 != null) {
                    return false;
                }
            } else if (!val.equals(val2)) return false;
            Val<?> val3 = this.provided();
            Val<?> val4 = wrongSourceType.provided();
            if (val3 == null) {
                if (val4 != null) {
                    return false;
                }
            } else if (!val3.equals(val4)) return false;
            if (!wrongSourceType.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof WrongSourceType;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "WrongSourceType";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "slot";
                }
                case 1: {
                    return "source";
                }
                case 2: {
                    return "expected";
                }
                case 3: {
                    return "provided";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public TransitionSlot slot() {
            return this.slot;
        }

        public Source source() {
            return this.source;
        }

        public Val<?> expected() {
            return this.expected;
        }

        public Val<?> provided() {
            return this.provided;
        }

        public String toString() {
            return "Wrong type received for source " + this.source() + " at " + this.slot() + ", " + this.expected() + " is expected but " + this.provided() + " is provided.";
        }

        public WrongSourceType copy(TransitionSlot slot, Source source, Val<?> expected, Val<?> provided) {
            return new WrongSourceType(slot, source, expected, provided);
        }

        public TransitionSlot copy$default$1() {
            return this.slot();
        }

        public Source copy$default$2() {
            return this.source();
        }

        public Val<?> copy$default$3() {
            return this.expected();
        }

        public Val<?> copy$default$4() {
            return this.provided();
        }

        public TransitionSlot _1() {
            return this.slot();
        }

        public Source _2() {
            return this.source();
        }

        public Val<?> _3() {
            return this.expected();
        }

        public Val<?> _4() {
            return this.provided();
        }
    }

    public static class WrongType
    implements SlotDataflowProblem,
    Product,
    Serializable {
        private final TransitionSlot slot;
        private final Val expected;
        private final Val provided;

        public static WrongType apply(TransitionSlot transitionSlot, Val<?> val, Val<?> val2) {
            return DataflowProblem$WrongType$.MODULE$.apply(transitionSlot, val, val2);
        }

        public static WrongType fromProduct(Product product) {
            return DataflowProblem$WrongType$.MODULE$.fromProduct(product);
        }

        public static WrongType unapply(WrongType wrongType) {
            return DataflowProblem$WrongType$.MODULE$.unapply(wrongType);
        }

        public WrongType(TransitionSlot slot, Val<?> expected, Val<?> provided) {
            this.slot = slot;
            this.expected = expected;
            this.provided = provided;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WrongType)) return false;
            WrongType wrongType = (WrongType)object;
            TransitionSlot transitionSlot = this.slot();
            TransitionSlot transitionSlot2 = wrongType.slot();
            if (transitionSlot == null) {
                if (transitionSlot2 != null) {
                    return false;
                }
            } else if (!transitionSlot.equals(transitionSlot2)) return false;
            Val<?> val = this.expected();
            Val<?> val2 = wrongType.expected();
            if (val == null) {
                if (val2 != null) {
                    return false;
                }
            } else if (!val.equals(val2)) return false;
            Val<?> val3 = this.provided();
            Val<?> val4 = wrongType.provided();
            if (val3 == null) {
                if (val4 != null) {
                    return false;
                }
            } else if (!val3.equals(val4)) return false;
            if (!wrongType.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof WrongType;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "WrongType";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "slot";
                }
                case 1: {
                    return "expected";
                }
                case 2: {
                    return "provided";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public TransitionSlot slot() {
            return this.slot;
        }

        public Val<?> expected() {
            return this.expected;
        }

        public Val<?> provided() {
            return this.provided;
        }

        public String toString() {
            return "Wrong type received at " + this.slot() + ", " + this.expected() + " is expected but " + this.provided() + " is provided.";
        }

        public WrongType copy(TransitionSlot slot, Val<?> expected, Val<?> provided) {
            return new WrongType(slot, expected, provided);
        }

        public TransitionSlot copy$default$1() {
            return this.slot();
        }

        public Val<?> copy$default$2() {
            return this.expected();
        }

        public Val<?> copy$default$3() {
            return this.provided();
        }

        public TransitionSlot _1() {
            return this.slot();
        }

        public Val<?> _2() {
            return this.expected();
        }

        public Val<?> _3() {
            return this.provided();
        }
    }
}

