/*
 * Decompiled with CFR 0.152.
 */
package gridscale.ssh;

import gridscale.effectaside.package;
import gridscale.package;
import gridscale.ssh.package;
import gridscale.ssh.package$ConnectionError$;
import gridscale.ssh.package$ExecutionError$;
import gridscale.ssh.package$FilePermission$;
import gridscale.ssh.package$JobId$;
import gridscale.ssh.package$ReturnCodeError$;
import gridscale.ssh.package$SFTPError$;
import gridscale.ssh.package$SSH$;
import gridscale.ssh.package$SSHAuthentication$;
import gridscale.ssh.package$SSHCache$;
import gridscale.ssh.package$SSHJobDescription$;
import gridscale.ssh.package$SSHServer$;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;

public final class package$
implements Serializable {
    public static final package$SSHAuthentication$ SSHAuthentication;
    public static final package$SSH$ SSH;
    public static final package$SSHCache$ SSHCache;
    public static final package$ConnectionError$ ConnectionError;
    public static final package$ExecutionError$ ExecutionError;
    public static final package$SFTPError$ SFTPError;
    public static final package$ReturnCodeError$ ReturnCodeError;
    public static final package$SSHServer$ SSHServer;
    public static final package$JobId$ JobId;
    public static final package$SSHJobDescription$ SSHJobDescription;
    public static final package$FilePermission$ FilePermission;
    public static final package$ MODULE$;

    private package$() {
    }

    static {
        MODULE$ = new package$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$.class);
    }

    public package.JobId submit(package.SSHServer server, package.SSHJobDescription description, package.Effect<package.SSH> ssh, package.Effect<package.System> system) {
        Tuple2<String, String> tuple2 = package$SSHJobDescription$.MODULE$.jobScript(server, description, system, ssh);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String command = (String)tuple2._1();
        String jobId = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)command, (Object)jobId);
        String command2 = (String)tuple22._1();
        String jobId2 = (String)tuple22._2();
        ((package.SSH)ssh.apply()).launch(server, command2);
        return package$JobId$.MODULE$.apply(jobId2, description.workDirectory());
    }

    public package.ExecutionResult run(package.SSHServer server, String command, boolean verbose, package.Effect<package.SSH> ssh) {
        return ((package.SSH)ssh.apply()).execute(server, package$SSHJobDescription$.MODULE$.commandLine(server, command, verbose));
    }

    public boolean run$default$3() {
        return false;
    }

    public String stdOut(package.SSHServer server, package.JobId jobId, package.Effect<package.SSH> ssh) {
        return (String)this.readFile(server, package$SSHJobDescription$.MODULE$.outFile(jobId.workDirectory(), jobId.jobId()), (Function1 & Serializable)_$3 -> Source$.MODULE$.fromInputStream(_$3, Codec$.MODULE$.fallbackSystemCodec()).mkString(), ssh);
    }

    public String stdErr(package.SSHServer server, package.JobId jobId, package.Effect<package.SSH> ssh) {
        return (String)this.readFile(server, package$SSHJobDescription$.MODULE$.errFile(jobId.workDirectory(), jobId.jobId()), (Function1 & Serializable)_$4 -> Source$.MODULE$.fromInputStream(_$4, Codec$.MODULE$.fallbackSystemCodec()).mkString(), ssh);
    }

    public package.JobState state(package.SSHServer server, package.JobId jobId, package.Effect<package.SSH> ssh) {
        boolean bl = package$SSHJobDescription$.MODULE$.jobIsRunning(server, jobId, ssh);
        if (bl) {
            return package.JobState$.Running$.MODULE$;
        }
        if (!bl) {
            boolean bl2 = this.exists(server, package$SSHJobDescription$.MODULE$.endCodeFile(jobId.workDirectory(), jobId.jobId()), ssh);
            if (bl2) {
                String content = (String)((package.SSH)ssh.apply()).readFile(server, package$SSHJobDescription$.MODULE$.endCodeFile(jobId.workDirectory(), jobId.jobId()), (Function1 & Serializable)is -> Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString());
                int exitCode = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(content), (Function1 & Serializable)_$5 -> this.$anonfun$5(BoxesRunTime.unboxToChar((Object)_$5)))));
                return package$SSHJobDescription$.MODULE$.translateState(exitCode);
            }
            if (!bl2) {
                return package.JobState$.Failed$.MODULE$;
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public void clean(package.SSHServer server, package.JobId job, package.Effect<package.SSH> ssh) {
        String kill = "pid=`cat " + package$SSHJobDescription$.MODULE$.pidFile(job.workDirectory(), job.jobId()) + "` ; kill -9 $pid `ps --ppid $pid -o pid=`";
        String rm = "rm -rf " + job.workDirectory() + "/" + job.jobId() + "*";
        package.ExecutionResult k = ((package.SSH)ssh.apply()).execute(server, kill);
        ((package.SSH)ssh.apply()).execute(server, rm);
        int n = k.returnCode();
        if (0 == n || 1 == n) {
            return;
        }
        throw ((package.SSH)ssh.apply()).wrongReturnCode(server.toString(), kill, k);
    }

    public <T> T readFile(package.SSHServer server, String path, Function1<InputStream, T> f, package.Effect<package.SSH> ssh) {
        return ((package.SSH)ssh.apply()).readFile(server, path, f);
    }

    public void writeFile(package.SSHServer server, Function0<InputStream> is, String path, package.Effect<package.SSH> ssh) {
        ((package.SSH)ssh.apply()).writeFile(server, is, path);
    }

    public String home(package.SSHServer server, package.Effect<package.SSH> ssh) {
        return (String)((package.SSH)ssh.apply()).withSFTP(server, (Function1 & Serializable)_$6 -> (String)_$6.canonicalize(".").get());
    }

    public boolean exists(package.SSHServer server, String path, package.Effect<package.SSH> ssh) {
        return BoxesRunTime.unboxToBoolean(((package.SSH)ssh.apply()).withSFTP(server, (Function1 & Serializable)_$7 -> BoxesRunTime.unboxToBoolean((Object)_$7.exists(path).get())));
    }

    public Try<BoxedUnit> chmod(package.SSHServer server, String path, Seq<package.FilePermission.FilePermission> perms, package.Effect<package.SSH> ssh) {
        return (Try)((package.SSH)ssh.apply()).withSFTP(server, (Function1 & Serializable)_$8 -> _$8.chmod(path, package$FilePermission$.MODULE$.toMask((Set<package.FilePermission.FilePermission>)perms.toSet())));
    }

    public Vector<package.ListEntry> list(package.SSHServer server, String path, package.Effect<package.SSH> ssh) {
        return (Vector)((Try)((package.SSH)ssh.apply()).withSFTP(server, (Function1 & Serializable)_$9 -> _$9.ls(path, (Function1<String, Object>)(Function1 & Serializable)e -> {
            String string = e;
            String string2 = ".";
            if (string == null) {
                if (string2 != null) {
                    return true;
                }
            } else if (!string.equals(string2)) return true;
            String string3 = e;
            String string4 = "..";
            if (string3 == null) {
                if (string4 == null) return false;
                return true;
            } else if (string3.equals(string4)) return false;
            return true;
        }))).get();
    }

    public Try<BoxedUnit> makeDir(package.SSHServer server, String path, package.Effect<package.SSH> ssh) {
        return (Try)((package.SSH)ssh.apply()).withSFTP(server, (Function1 & Serializable)_$10 -> _$10.mkdir(path));
    }

    public void rmDir(package.SSHServer server, String path, package.Effect<package.SSH> ssh) {
        this.list(server, path, ssh).foreach((Function1)(JProcedure1 & Serializable)entry -> this.remove$1(server, path, (package.Effect)ssh, (package.ListEntry)entry));
        ((package.SSH)ssh.apply()).withSFTP(server, (Function1 & Serializable)_$11 -> _$11.rmdir(path));
    }

    public void rmFile(package.SSHServer server, String path, package.Effect<package.SSH> ssh) {
        ((Try)((package.SSH)ssh.apply()).withSFTP(server, (Function1 & Serializable)_$12 -> _$12.rm(path))).get();
    }

    public void mv(package.SSHServer server, String from, String to, package.Effect<package.SSH> ssh) {
        ((Try)((package.SSH)ssh.apply()).withSFTP(server, (Function1 & Serializable)_$13 -> _$13.rename(from, to))).get();
    }

    private final /* synthetic */ boolean $anonfun$5(char _$5) {
        return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(_$5));
    }

    private final void remove$1(package.SSHServer server$5, String path$9, package.Effect ssh$1, package.ListEntry entry) {
        String child = path$9 + "/" + entry.name();
        package.FileType fileType = entry.type();
        if (package.FileType$.File$.MODULE$.equals(fileType)) {
            this.rmFile(server$5, child, (package.Effect<package.SSH>)ssh$1);
            return;
        }
        if (package.FileType$.Link$.MODULE$.equals(fileType)) {
            this.rmFile(server$5, child, (package.Effect<package.SSH>)ssh$1);
            return;
        }
        if (package.FileType$.Directory$.MODULE$.equals(fileType)) {
            this.rmDir(server$5, child, (package.Effect<package.SSH>)ssh$1);
            return;
        }
        if (package.FileType$.Unknown$.MODULE$.equals(fileType)) {
            this.rmFile(server$5, child, (package.Effect<package.SSH>)ssh$1);
            return;
        }
        throw new MatchError((Object)fileType);
    }
}

