/*
 * Decompiled with CFR 0.152.
 */
package gridscale.ssh;

import gridscale.authentication.package;
import gridscale.effectaside.package;
import gridscale.package;
import gridscale.ssh.package;
import gridscale.ssh.package$;
import gridscale.ssh.package$ConnectionError$;
import gridscale.ssh.package$ExecutionError$;
import gridscale.ssh.package$JobId$;
import gridscale.ssh.package$ReturnCodeError$;
import gridscale.ssh.package$SFTPError$;
import gridscale.ssh.package$SSH$;
import gridscale.ssh.package$SSHAuthentication$;
import gridscale.ssh.package$SSHCache$;
import gridscale.ssh.package$SSHJobDescription$;
import gridscale.ssh.package$SSHServer$;
import gridscale.ssh.sshj.SFTPClient;
import gridscale.ssh.sshj.SSHClient;
import gridscale.ssh.sshj.SSHClient$;
import gridscale.tools.cache.package;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;
import squants.time.Time;

public final class package {
    public static Try<BoxedUnit> chmod(SSHServer sSHServer, String string, Seq<FilePermission.FilePermission> seq, package.Effect<SSH> effect) {
        return package$.MODULE$.chmod(sSHServer, string, seq, effect);
    }

    public static void clean(SSHServer sSHServer, JobId jobId, package.Effect<SSH> effect) {
        package$.MODULE$.clean(sSHServer, jobId, effect);
    }

    public static boolean exists(SSHServer sSHServer, String string, package.Effect<SSH> effect) {
        return package$.MODULE$.exists(sSHServer, string, effect);
    }

    public static String home(SSHServer sSHServer, package.Effect<SSH> effect) {
        return package$.MODULE$.home(sSHServer, effect);
    }

    public static Vector<package.ListEntry> list(SSHServer sSHServer, String string, package.Effect<SSH> effect) {
        return package$.MODULE$.list(sSHServer, string, effect);
    }

    public static Try<BoxedUnit> makeDir(SSHServer sSHServer, String string, package.Effect<SSH> effect) {
        return package$.MODULE$.makeDir(sSHServer, string, effect);
    }

    public static void mv(SSHServer sSHServer, String string, String string2, package.Effect<SSH> effect) {
        package$.MODULE$.mv(sSHServer, string, string2, effect);
    }

    public static <T> T readFile(SSHServer sSHServer, String string, Function1<InputStream, T> function1, package.Effect<SSH> effect) {
        return package$.MODULE$.readFile(sSHServer, string, function1, effect);
    }

    public static void rmDir(SSHServer sSHServer, String string, package.Effect<SSH> effect) {
        package$.MODULE$.rmDir(sSHServer, string, effect);
    }

    public static void rmFile(SSHServer sSHServer, String string, package.Effect<SSH> effect) {
        package$.MODULE$.rmFile(sSHServer, string, effect);
    }

    public static package.ExecutionResult run(SSHServer sSHServer, String string, boolean bl, package.Effect<SSH> effect) {
        return package$.MODULE$.run(sSHServer, string, bl, effect);
    }

    public static package.JobState state(SSHServer sSHServer, JobId jobId, package.Effect<SSH> effect) {
        return package$.MODULE$.state(sSHServer, jobId, effect);
    }

    public static String stdErr(SSHServer sSHServer, JobId jobId, package.Effect<SSH> effect) {
        return package$.MODULE$.stdErr(sSHServer, jobId, effect);
    }

    public static String stdOut(SSHServer sSHServer, JobId jobId, package.Effect<SSH> effect) {
        return package$.MODULE$.stdOut(sSHServer, jobId, effect);
    }

    public static JobId submit(SSHServer sSHServer, SSHJobDescription sSHJobDescription, package.Effect<SSH> effect, package.Effect<package.System> effect2) {
        return package$.MODULE$.submit(sSHServer, sSHJobDescription, effect, effect2);
    }

    public static void writeFile(SSHServer sSHServer, Function0<InputStream> function0, String string, package.Effect<SSH> effect) {
        package$.MODULE$.writeFile(sSHServer, function0, string, effect);
    }

    public static boolean run$default$3() {
        return package$.MODULE$.run$default$3();
    }

    public static class ConnectionError
    extends Exception
    implements Product {
        private final String message;
        private final Throwable t;

        public static ConnectionError apply(String string, Throwable throwable) {
            return package$ConnectionError$.MODULE$.apply(string, throwable);
        }

        public static ConnectionError fromProduct(Product product) {
            return package$ConnectionError$.MODULE$.fromProduct(product);
        }

        public static ConnectionError unapply(ConnectionError connectionError) {
            return package$ConnectionError$.MODULE$.unapply(connectionError);
        }

        public ConnectionError(String message, Throwable t) {
            this.message = message;
            this.t = t;
            super(message, t);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConnectionError)) return false;
            ConnectionError connectionError = (ConnectionError)object;
            String string = this.message();
            String string2 = connectionError.message();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.t();
            Throwable throwable2 = connectionError.t();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!connectionError.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ConnectionError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ConnectionError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            if (1 == n2) {
                return "t";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String message() {
            return this.message;
        }

        public Throwable t() {
            return this.t;
        }

        public ConnectionError copy(String message, Throwable t) {
            return new ConnectionError(message, t);
        }

        public String copy$default$1() {
            return this.message();
        }

        public Throwable copy$default$2() {
            return this.t();
        }

        public String _1() {
            return this.message();
        }

        public Throwable _2() {
            return this.t();
        }
    }

    public static class ExecutionError
    extends Exception
    implements Product {
        private final String message;
        private final Throwable t;

        public static ExecutionError apply(String string, Throwable throwable) {
            return package$ExecutionError$.MODULE$.apply(string, throwable);
        }

        public static ExecutionError fromProduct(Product product) {
            return package$ExecutionError$.MODULE$.fromProduct(product);
        }

        public static ExecutionError unapply(ExecutionError executionError) {
            return package$ExecutionError$.MODULE$.unapply(executionError);
        }

        public ExecutionError(String message, Throwable t) {
            this.message = message;
            this.t = t;
            super(message, t);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExecutionError)) return false;
            ExecutionError executionError = (ExecutionError)object;
            String string = this.message();
            String string2 = executionError.message();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.t();
            Throwable throwable2 = executionError.t();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!executionError.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ExecutionError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ExecutionError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            if (1 == n2) {
                return "t";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String message() {
            return this.message;
        }

        public Throwable t() {
            return this.t;
        }

        public ExecutionError copy(String message, Throwable t) {
            return new ExecutionError(message, t);
        }

        public String copy$default$1() {
            return this.message();
        }

        public Throwable copy$default$2() {
            return this.t();
        }

        public String _1() {
            return this.message();
        }

        public Throwable _2() {
            return this.t();
        }
    }

    public static class JobId
    implements Product,
    Serializable {
        private final String jobId;
        private final String workDirectory;

        public static JobId apply(String string, String string2) {
            return package$JobId$.MODULE$.apply(string, string2);
        }

        public static JobId fromProduct(Product product) {
            return package$JobId$.MODULE$.fromProduct(product);
        }

        public static JobId unapply(JobId jobId) {
            return package$JobId$.MODULE$.unapply(jobId);
        }

        public JobId(String jobId, String workDirectory) {
            this.jobId = jobId;
            this.workDirectory = workDirectory;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof JobId)) return false;
            JobId jobId = (JobId)object;
            String string = this.jobId();
            String string2 = jobId.jobId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.workDirectory();
            String string4 = jobId.workDirectory();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!jobId.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof JobId;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "JobId";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "jobId";
            }
            if (1 == n2) {
                return "workDirectory";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String jobId() {
            return this.jobId;
        }

        public String workDirectory() {
            return this.workDirectory;
        }

        public JobId copy(String jobId, String workDirectory) {
            return new JobId(jobId, workDirectory);
        }

        public String copy$default$1() {
            return this.jobId();
        }

        public String copy$default$2() {
            return this.workDirectory();
        }

        public String _1() {
            return this.jobId();
        }

        public String _2() {
            return this.workDirectory();
        }
    }

    public static class ReturnCodeError
    extends Exception
    implements Product {
        private final String server;
        private final String command;
        private final package.ExecutionResult executionResult;

        public static ReturnCodeError apply(String string, String string2, package.ExecutionResult executionResult) {
            return package$ReturnCodeError$.MODULE$.apply(string, string2, executionResult);
        }

        public static ReturnCodeError fromProduct(Product product) {
            return package$ReturnCodeError$.MODULE$.fromProduct(product);
        }

        public static ReturnCodeError unapply(ReturnCodeError returnCodeError) {
            return package$ReturnCodeError$.MODULE$.unapply(returnCodeError);
        }

        public ReturnCodeError(String server, String command, package.ExecutionResult executionResult) {
            this.server = server;
            this.command = command;
            this.executionResult = executionResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReturnCodeError)) return false;
            ReturnCodeError returnCodeError = (ReturnCodeError)object;
            String string = this.server();
            String string2 = returnCodeError.server();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.command();
            String string4 = returnCodeError.command();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            package.ExecutionResult executionResult = this.executionResult();
            package.ExecutionResult executionResult2 = returnCodeError.executionResult();
            if (executionResult == null) {
                if (executionResult2 != null) {
                    return false;
                }
            } else if (!executionResult.equals(executionResult2)) return false;
            if (!returnCodeError.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ReturnCodeError;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ReturnCodeError";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "server";
                }
                case 1: {
                    return "command";
                }
                case 2: {
                    return "executionResult";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String server() {
            return this.server;
        }

        public String command() {
            return this.command;
        }

        public package.ExecutionResult executionResult() {
            return this.executionResult;
        }

        @Override
        public String toString() {
            return package.ExecutionResult$.MODULE$.error(this.command(), this.executionResult()) + (" on server " + this.server());
        }

        public ReturnCodeError copy(String server, String command, package.ExecutionResult executionResult) {
            return new ReturnCodeError(server, command, executionResult);
        }

        public String copy$default$1() {
            return this.server();
        }

        public String copy$default$2() {
            return this.command();
        }

        public package.ExecutionResult copy$default$3() {
            return this.executionResult();
        }

        public String _1() {
            return this.server();
        }

        public String _2() {
            return this.command();
        }

        public package.ExecutionResult _3() {
            return this.executionResult();
        }
    }

    public static class SFTPError
    extends Exception
    implements Product {
        private final String message;
        private final Throwable t;

        public static SFTPError apply(String string, Throwable throwable) {
            return package$SFTPError$.MODULE$.apply(string, throwable);
        }

        public static SFTPError fromProduct(Product product) {
            return package$SFTPError$.MODULE$.fromProduct(product);
        }

        public static SFTPError unapply(SFTPError sFTPError) {
            return package$SFTPError$.MODULE$.unapply(sFTPError);
        }

        public SFTPError(String message, Throwable t) {
            this.message = message;
            this.t = t;
            super(message, t);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SFTPError)) return false;
            SFTPError sFTPError = (SFTPError)object;
            String string = this.message();
            String string2 = sFTPError.message();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.t();
            Throwable throwable2 = sFTPError.t();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!sFTPError.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof SFTPError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SFTPError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            if (1 == n2) {
                return "t";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String message() {
            return this.message;
        }

        public Throwable t() {
            return this.t;
        }

        public SFTPError copy(String message, Throwable t) {
            return new SFTPError(message, t);
        }

        public String copy$default$1() {
            return this.message();
        }

        public Throwable copy$default$2() {
            return this.t();
        }

        public String _1() {
            return this.message();
        }

        public Throwable _2() {
            return this.t();
        }
    }

    public static class SSH
    implements AutoCloseable {
        private final package.KeyValueCache clientCache;

        public static package.Effect<SSH> apply(package.KeyValueCache<SSHServer, SSHClient> keyValueCache) {
            return package$SSH$.MODULE$.apply(keyValueCache);
        }

        public static SSHClient authenticate(SSHServer sSHServer, SSHClient sSHClient) {
            return package$SSH$.MODULE$.authenticate(sSHServer, sSHClient);
        }

        public static SSHClient client(SSHServer sSHServer) {
            return package$SSH$.MODULE$.client(sSHServer);
        }

        public static package.KeyValueCache<SSHServer, SSHClient> apply$default$1() {
            return package$SSH$.MODULE$.apply$default$1();
        }

        public SSH(package.KeyValueCache<SSHServer, SSHClient> clientCache) {
            this.clientCache = clientCache;
        }

        public package.KeyValueCache<SSHServer, SSHClient> clientCache() {
            return this.clientCache;
        }

        public package.ExecutionResult execute(SSHServer server, String s) {
            return (package.ExecutionResult)package$SSHCache$.MODULE$.withCache(this.clientCache(), server, (Function1 & Serializable)c -> {
                package.ExecutionResult executionResult;
                try {
                    executionResult = (package.ExecutionResult)SSHClient$.MODULE$.run((SSHClient)c, s).get();
                }
                catch (Throwable t) {
                    throw package$ExecutionError$.MODULE$.apply("Error executing " + s + " on " + server, t);
                }
                return executionResult;
            });
        }

        public void launch(SSHServer server, String s) {
            package$SSHCache$.MODULE$.withCache(this.clientCache(), server, (JProcedure1 & Serializable)c -> SSHClient$.MODULE$.launchInBackground((SSHClient)c, s));
        }

        public <T> T withSFTP(SSHServer server, Function1<SFTPClient, T> f) {
            return package$SSHCache$.MODULE$.withCache(this.clientCache(), server, (Function1 & Serializable)c -> {
                Object t;
                try {
                    t = SSHClient$.MODULE$.withSFTP((SSHClient)c, f);
                }
                catch (Throwable t2) {
                    throw package$SFTPError$.MODULE$.apply("Error in sftp transfer on " + server, t2);
                }
                return t;
            });
        }

        public <T> T readFile(SSHServer server, String path, Function1<InputStream, T> f) {
            return package$SSHCache$.MODULE$.withCache(this.clientCache(), server, (Function1 & Serializable)c -> {
                Object object;
                try {
                    object = ((Try)SSHClient$.MODULE$.withSFTP((SSHClient)c, (Function1 & Serializable)s -> s.readAheadFileInputStream(path).map(f))).get();
                }
                catch (SFTPError t) {
                    throw t;
                }
                catch (Throwable t) {
                    throw package$SFTPError$.MODULE$.apply("Error while reading " + path + " via sftp on " + server, t);
                }
                return object;
            });
        }

        public void writeFile(SSHServer server, Function0<InputStream> is, String path) {
            try {
                package$SSHCache$.MODULE$.withCache(this.clientCache(), server, (JProcedure1 & Serializable)c -> this.write$1((Function0)is, path, (SSHClient)c));
            }
            catch (SFTPError t) {
                throw t;
            }
            catch (Throwable t) {
                throw package$SFTPError$.MODULE$.apply("Error while writing to " + path + " via sftp on " + server, t);
            }
        }

        public Nothing$ wrongReturnCode(String server, String command, package.ExecutionResult executionResult) {
            throw package$ReturnCodeError$.MODULE$.apply(server, command, executionResult);
        }

        @Override
        public void close() {
            this.clientCache().values().foreach((Function1 & Serializable)c -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
                this.close$$anonfun$1$$anonfun$1((SSHClient)c);
                return BoxedUnit.UNIT;
            }));
            this.clientCache().clear();
        }

        private final void write$1(Function0 is$1, String path$3, SSHClient client) {
            try (InputStream ois = (InputStream)is$1.apply();){
                ((Try)SSHClient$.MODULE$.withSFTP(client, (Function1 & Serializable)_$2 -> _$2.writeFile(ois, path$3))).get();
            }
        }

        private final void close$$anonfun$1$$anonfun$1(SSHClient c$2) {
            c$2.close();
        }
    }

    public static interface SSHAuthentication<T> {
        public static SSHAuthentication<package.PrivateKey> key() {
            return package$SSHAuthentication$.MODULE$.key();
        }

        public static SSHAuthentication<package.UserPassword> userPassword() {
            return package$SSHAuthentication$.MODULE$.userPassword();
        }

        public String login(T var1);

        public void authenticate(T var1, SSHClient var2);
    }

    public static class SSHJobDescription
    implements Product,
    Serializable {
        private final String command;
        private final String workDirectory;
        private final Option timeout;

        public static SSHJobDescription apply(String string, String string2, Option<Time> option) {
            return package$SSHJobDescription$.MODULE$.apply(string, string2, option);
        }

        public static String commandLine(SSHServer sSHServer, String string, boolean bl) {
            return package$SSHJobDescription$.MODULE$.commandLine(sSHServer, string, bl);
        }

        public static String endCodeFile(String string, String string2) {
            return package$SSHJobDescription$.MODULE$.endCodeFile(string, string2);
        }

        public static String errFile(String string, String string2) {
            return package$SSHJobDescription$.MODULE$.errFile(string, string2);
        }

        public static String file(String string, String string2, String string3) {
            return package$SSHJobDescription$.MODULE$.file(string, string2, string3);
        }

        public static SSHJobDescription fromProduct(Product product) {
            return package$SSHJobDescription$.MODULE$.fromProduct(product);
        }

        public static boolean jobIsRunning(SSHServer sSHServer, JobId jobId, package.Effect<SSH> effect) {
            return package$SSHJobDescription$.MODULE$.jobIsRunning(sSHServer, jobId, effect);
        }

        public static Tuple2<String, String> jobScript(SSHServer sSHServer, SSHJobDescription sSHJobDescription, package.Effect<package.System> effect, package.Effect<SSH> effect2) {
            return package$SSHJobDescription$.MODULE$.jobScript(sSHServer, sSHJobDescription, effect, effect2);
        }

        public static String outFile(String string, String string2) {
            return package$SSHJobDescription$.MODULE$.outFile(string, string2);
        }

        public static String pidFile(String string, String string2) {
            return package$SSHJobDescription$.MODULE$.pidFile(string, string2);
        }

        public static String scriptFile(String string, String string2) {
            return package$SSHJobDescription$.MODULE$.scriptFile(string, string2);
        }

        public static package.JobState translateState(int n) {
            return package$SSHJobDescription$.MODULE$.translateState(n);
        }

        public static SSHJobDescription unapply(SSHJobDescription sSHJobDescription) {
            return package$SSHJobDescription$.MODULE$.unapply(sSHJobDescription);
        }

        public static Option<Time> $lessinit$greater$default$3() {
            return package$SSHJobDescription$.MODULE$.$lessinit$greater$default$3();
        }

        public static boolean commandLine$default$3() {
            return package$SSHJobDescription$.MODULE$.commandLine$default$3();
        }

        public SSHJobDescription(String command, String workDirectory, Option<Time> timeout) {
            this.command = command;
            this.workDirectory = workDirectory;
            this.timeout = timeout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SSHJobDescription)) return false;
            SSHJobDescription sSHJobDescription = (SSHJobDescription)object;
            String string = this.command();
            String string2 = sSHJobDescription.command();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.workDirectory();
            String string4 = sSHJobDescription.workDirectory();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<Time> option = this.timeout();
            Option<Time> option2 = sSHJobDescription.timeout();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!sSHJobDescription.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SSHJobDescription;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SSHJobDescription";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "command";
                }
                case 1: {
                    return "workDirectory";
                }
                case 2: {
                    return "timeout";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String command() {
            return this.command;
        }

        public String workDirectory() {
            return this.workDirectory;
        }

        public Option<Time> timeout() {
            return this.timeout;
        }

        public SSHJobDescription copy(String command, String workDirectory, Option<Time> timeout) {
            return new SSHJobDescription(command, workDirectory, timeout);
        }

        public String copy$default$1() {
            return this.command();
        }

        public String copy$default$2() {
            return this.workDirectory();
        }

        public Option<Time> copy$default$3() {
            return this.timeout();
        }

        public String _1() {
            return this.command();
        }

        public String _2() {
            return this.workDirectory();
        }

        public Option<Time> _3() {
            return this.timeout();
        }
    }

    public static class SSHServer
    implements Product,
    Serializable {
        private final String login;
        private final String host;
        private final int port;
        private final Time timeout;
        private final Function1 authenticate;
        private final Option keepAlive;
        private final Option sshProxy;

        public static <A> SSHServer apply(String string, int n, Time time, Option<Time> option, Option<SSHServer> option2, A a, SSHAuthentication<A> sSHAuthentication) {
            return package$SSHServer$.MODULE$.apply(string, n, time, option, option2, a, sSHAuthentication);
        }

        public static SSHServer apply(String string, String string2, int n, Time time, Function1<SSHClient, BoxedUnit> function1, Option<Time> option, Option<SSHServer> option2) {
            return package$SSHServer$.MODULE$.apply(string, string2, n, time, function1, option, option2);
        }

        public static SSHServer unapply(SSHServer sSHServer) {
            return package$SSHServer$.MODULE$.unapply(sSHServer);
        }

        public static <A> int apply$default$2() {
            return package$SSHServer$.MODULE$.apply$default$2();
        }

        public static <A> Time apply$default$3() {
            return package$SSHServer$.MODULE$.apply$default$3();
        }

        public static <A> Option<Time> apply$default$4() {
            return package$SSHServer$.MODULE$.apply$default$4();
        }

        public static <A> Option<SSHServer> apply$default$5() {
            return package$SSHServer$.MODULE$.apply$default$5();
        }

        public SSHServer(String login, String host, int port, Time timeout, Function1<SSHClient, BoxedUnit> authenticate, Option<Time> keepAlive, Option<SSHServer> sshProxy) {
            this.login = login;
            this.host = host;
            this.port = port;
            this.timeout = timeout;
            this.authenticate = authenticate;
            this.keepAlive = keepAlive;
            this.sshProxy = sshProxy;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.login()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.host()));
            n = Statics.mix((int)n, (int)this.port());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SSHServer)) return false;
            SSHServer sSHServer = (SSHServer)object;
            if (this.port() != sSHServer.port()) return false;
            String string = this.login();
            String string2 = sSHServer.login();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.host();
            String string4 = sSHServer.host();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!sSHServer.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof SSHServer;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SSHServer";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "login";
                }
                case 1: {
                    return "host";
                }
                case 2: {
                    return "port";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String login() {
            return this.login;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public Time timeout() {
            return this.timeout;
        }

        public Function1<SSHClient, BoxedUnit> authenticate() {
            return this.authenticate;
        }

        public Option<Time> keepAlive() {
            return this.keepAlive;
        }

        public Option<SSHServer> sshProxy() {
            return this.sshProxy;
        }

        public String toString() {
            return "ssh server " + this.host() + ":" + this.port();
        }

        public SSHServer copy(String login, String host, int port, Time timeout, Function1<SSHClient, BoxedUnit> authenticate, Option<Time> keepAlive, Option<SSHServer> sshProxy) {
            return new SSHServer(login, host, port, timeout, authenticate, keepAlive, sshProxy);
        }

        public String copy$default$1() {
            return this.login();
        }

        public String copy$default$2() {
            return this.host();
        }

        public int copy$default$3() {
            return this.port();
        }

        public String _1() {
            return this.login();
        }

        public String _2() {
            return this.host();
        }

        public int _3() {
            return this.port();
        }
    }
}

