/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw;

import java.util.ArrayList;
import org.openmole.tool.dtw.dtw.DTW;
import org.openmole.tool.dtw.dtw.TimeWarpInfo;
import org.openmole.tool.dtw.dtw.WarpPath;
import org.openmole.tool.dtw.dtw.WarpPathWindow;
import org.openmole.tool.dtw.timeseries.PAA;
import org.openmole.tool.dtw.timeseries.TimeSeries;
import org.openmole.tool.dtw.util.DistanceFunction;
import org.openmole.tool.dtw.util.DistanceFunctionFactory;

public class AbstractionTest {
    public static void main(String[] stringArray) {
        if (stringArray.length != 3 && stringArray.length != 4) {
            System.out.println("USAGE:  java AbstractionTest timeSeries1 timeSeries2 radius [EuclideanDistance|ManhattanDistance|BinaryDistance]");
            System.exit(1);
        } else {
            TimeSeries timeSeries = new TimeSeries(stringArray[0], false, false, ',');
            TimeSeries timeSeries2 = new TimeSeries(stringArray[1], false, false, ',');
            DistanceFunction distanceFunction = stringArray.length < 4 ? DistanceFunctionFactory.getDistFnByName("EuclideanDistance") : DistanceFunctionFactory.getDistFnByName(stringArray[3]);
            PAA pAA = new PAA(timeSeries, (int)Math.round(Math.sqrt(timeSeries.size())));
            PAA pAA2 = new PAA(timeSeries2, (int)Math.round(Math.sqrt(timeSeries2.size())));
            WarpPath warpPath = DTW.getWarpPathBetween(pAA, pAA2, distanceFunction);
            WarpPath warpPath2 = AbstractionTest.expandPath(warpPath, pAA, pAA2);
            WarpPathWindow warpPathWindow = new WarpPathWindow(warpPath2, Integer.parseInt(stringArray[2]));
            TimeWarpInfo timeWarpInfo = DTW.getWarpInfoBetween(timeSeries, timeSeries2, warpPathWindow, distanceFunction);
            System.out.println("Warp Distance: " + timeWarpInfo.getDistance());
            System.out.println("Warp Path:     " + timeWarpInfo.getPath());
        }
    }

    private static WarpPath expandPath(WarpPath warpPath, PAA pAA, PAA pAA2) {
        int n;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList.add(new Integer(0));
        arrayList2.add(new Integer(0));
        int n3 = 0;
        int n4 = 0;
        n3 = warpPath.get(1).getCol() != 0 ? pAA.aggregatePtSize(0) - 1 : (pAA.aggregatePtSize(0) - 1) / 2;
        n4 = warpPath.get(1).getRow() != 0 ? pAA2.aggregatePtSize(0) - 1 : (pAA2.aggregatePtSize(0) - 1) / 2;
        int n5 = 0;
        int n6 = 0;
        for (int i = 1; i < warpPath.size() - 1; ++i) {
            n2 = warpPath.get(i).getCol();
            n = warpPath.get(i).getRow();
            if (n5 != n2) {
                if (n5 == 0) {
                    n3 = pAA.aggregatePtSize(0) - 1;
                }
                if (n2 == warpPath.get(warpPath.size() - 1).getCol()) {
                    n3 -= pAA.aggregatePtSize(n2) / 2;
                }
                arrayList.add(new Integer(n3 + pAA.aggregatePtSize(n2) / 2));
                n3 += pAA.aggregatePtSize(n2);
                n5 = n2;
            } else {
                arrayList.add(new Integer(n3));
            }
            if (n6 != n) {
                if (n6 == 0) {
                    n4 = pAA2.aggregatePtSize(0) - 1;
                }
                if (n == warpPath.get(warpPath.size() - 1).getRow()) {
                    n4 -= pAA2.aggregatePtSize(n) / 2;
                }
                arrayList2.add(new Integer(n4 + pAA2.aggregatePtSize(n) / 2));
                n4 += pAA2.aggregatePtSize(n);
                n6 = n;
                continue;
            }
            arrayList2.add(new Integer(n4));
        }
        arrayList.add(new Integer(pAA.originalSize() - 1));
        arrayList2.add(new Integer(pAA2.originalSize() - 1));
        WarpPath warpPath2 = new WarpPath();
        n3 = 0;
        n4 = 0;
        for (int i = 1; i < arrayList.size(); ++i) {
            int n7;
            n2 = (Integer)arrayList.get(i);
            n = (Integer)arrayList2.get(i);
            warpPath2.addLast(n3, n4);
            if (n2 - n3 >= n - n4) {
                for (n7 = n3 + 1; n7 < n2; ++n7) {
                    warpPath2.addLast(n7, (int)Math.round((double)n4 + ((double)n7 - (double)n3) / ((double)n2 - (double)n3) * (double)(n - n4)));
                }
            } else {
                for (n7 = n4 + 1; n7 < n; ++n7) {
                    warpPath2.addLast((int)Math.round((double)n3 + ((double)n7 - (double)n4) / ((double)n - (double)n4) * (double)(n2 - n3)), n7);
                }
            }
            n3 = n2;
            n4 = n;
        }
        warpPath2.addLast(pAA.originalSize() - 1, pAA2.originalSize() - 1);
        return warpPath2;
    }
}

