/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.dtw;

import org.openmole.tool.dtw.dtw.CostMatrix;
import org.openmole.tool.dtw.dtw.SearchWindow;

class MemoryResidentMatrix
implements CostMatrix {
    private static final double OUT_OF_WINDOW_VALUE = Double.POSITIVE_INFINITY;
    private final SearchWindow window;
    private double[] cellValues;
    private int[] colOffsets;

    MemoryResidentMatrix(SearchWindow searchWindow) {
        this.window = searchWindow;
        this.cellValues = new double[this.window.size()];
        this.colOffsets = new int[this.window.maxI() + 1];
        int n = 0;
        for (int i = this.window.minI(); i <= this.window.maxI(); ++i) {
            this.colOffsets[i] = n;
            n += this.window.maxJforI(i) - this.window.minJforI(i) + 1;
        }
    }

    @Override
    public void put(int n, int n2, double d) {
        if (n2 < this.window.minJforI(n) || n2 > this.window.maxJforI(n)) {
            throw new InternalError("CostMatrix is filled in a cell (col=" + n + ", row=" + n2 + ") that is not in the search window");
        }
        this.cellValues[this.colOffsets[n] + n2 - this.window.minJforI((int)n)] = d;
    }

    @Override
    public double get(int n, int n2) {
        if (n2 < this.window.minJforI(n) || n2 > this.window.maxJforI(n)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.cellValues[this.colOffsets[n] + n2 - this.window.minJforI(n)];
    }

    @Override
    public int size() {
        return this.cellValues.length;
    }
}

