/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.dtw;

import org.openmole.tool.dtw.dtw.CostMatrix;
import org.openmole.tool.dtw.dtw.SearchWindow;

class PartialWindowMatrix
implements CostMatrix {
    private static final double OUT_OF_WINDOW_VALUE = Double.POSITIVE_INFINITY;
    private double[] lastCol;
    private double[] currCol;
    private int currColIndex;
    private int minLastRow;
    private int minCurrRow;
    private final SearchWindow window;

    PartialWindowMatrix(SearchWindow searchWindow) {
        this.window = searchWindow;
        if (this.window.maxI() > 0) {
            this.currCol = new double[this.window.maxJforI(1) - this.window.minJforI(1) + 1];
            this.currColIndex = 1;
            this.minLastRow = this.window.minJforI(this.currColIndex - 1);
        } else {
            this.currColIndex = 0;
        }
        this.minCurrRow = this.window.minJforI(this.currColIndex);
        this.lastCol = new double[this.window.maxJforI(0) - this.window.minJforI(0) + 1];
    }

    @Override
    public void put(int n, int n2, double d) {
        if (n2 < this.window.minJforI(n) || n2 > this.window.maxJforI(n)) {
            throw new InternalError("CostMatrix is filled in a cell (col=" + n + ", row=" + n2 + ") that is not in the search window");
        }
        if (n == this.currColIndex) {
            this.currCol[n2 - this.minCurrRow] = d;
        } else if (n == this.currColIndex - 1) {
            this.lastCol[n2 - this.minLastRow] = d;
        } else if (n == this.currColIndex + 1) {
            this.lastCol = this.currCol;
            this.minLastRow = this.minCurrRow;
            ++this.currColIndex;
            this.currCol = new double[this.window.maxJforI(n) - this.window.minJforI(n) + 1];
            this.minCurrRow = this.window.minJforI(n);
            this.currCol[n2 - this.minCurrRow] = d;
        } else {
            throw new InternalError("A PartialWindowMatrix can only fill in 2 adjacentcolumns at a time");
        }
    }

    @Override
    public double get(int n, int n2) {
        if (n2 < this.window.minJforI(n) || n2 > this.window.maxJforI(n)) {
            return Double.POSITIVE_INFINITY;
        }
        if (n == this.currColIndex) {
            return this.currCol[n2 - this.minCurrRow];
        }
        if (n == this.currColIndex - 1) {
            return this.lastCol[n2 - this.minLastRow];
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public int size() {
        return this.lastCol.length + this.currCol.length;
    }

    public int windowSize() {
        return this.window.size();
    }
}

