/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.dtw;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.openmole.tool.dtw.dtw.CostMatrix;
import org.openmole.tool.dtw.dtw.SearchWindow;
import org.openmole.tool.dtw.lang.TypeConversions;

class SwapFileMatrix
implements CostMatrix {
    private static final double OUT_OF_WINDOW_VALUE = Double.POSITIVE_INFINITY;
    private static final Random RAND_GEN = new Random();
    private final SearchWindow window;
    private double[] lastCol;
    private double[] currCol;
    private int currColIndex;
    private int minLastRow;
    private int minCurrRow;
    private final File swapFile;
    private final RandomAccessFile cellValuesFile;
    private boolean isSwapFileFreed;
    private final long[] colOffsets;

    SwapFileMatrix(SearchWindow searchWindow) {
        this.window = searchWindow;
        if (this.window.maxI() > 0) {
            this.currCol = new double[this.window.maxJforI(1) - this.window.minJforI(1) + 1];
            this.currColIndex = 1;
            this.minLastRow = this.window.minJforI(this.currColIndex - 1);
        } else {
            this.currColIndex = 0;
        }
        this.minCurrRow = this.window.minJforI(this.currColIndex);
        this.lastCol = new double[this.window.maxJforI(0) - this.window.minJforI(0) + 1];
        this.swapFile = new File("swap" + RAND_GEN.nextLong());
        this.isSwapFileFreed = false;
        this.colOffsets = new long[this.window.maxI() + 1];
        try {
            this.cellValuesFile = new RandomAccessFile(this.swapFile, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InternalError("ERROR:  Unable to create swap file: " + this.swapFile);
        }
    }

    @Override
    public void put(int n, int n2, double d) {
        if (n2 < this.window.minJforI(n) || n2 > this.window.maxJforI(n)) {
            throw new InternalError("CostMatrix is filled in a cell (col=" + n + ", row=" + n2 + ") that is not in the search window");
        }
        if (n == this.currColIndex) {
            this.currCol[n2 - this.minCurrRow] = d;
        } else if (n == this.currColIndex - 1) {
            this.lastCol[n2 - this.minLastRow] = d;
        } else if (n == this.currColIndex + 1) {
            try {
                if (this.isSwapFileFreed) {
                    throw new InternalError("The SwapFileMatrix has been freeded by the freeMem() method");
                }
                this.cellValuesFile.seek(this.cellValuesFile.length());
                this.colOffsets[this.currColIndex - 1] = this.cellValuesFile.getFilePointer();
                this.cellValuesFile.write(TypeConversions.doubleArrayToByteArray(this.lastCol));
            }
            catch (IOException iOException) {
                throw new InternalError("Unable to fill the CostMatrix in the Swap file (IOException)");
            }
            this.lastCol = this.currCol;
            this.minLastRow = this.minCurrRow;
            this.minCurrRow = this.window.minJforI(n);
            ++this.currColIndex;
            this.currCol = new double[this.window.maxJforI(n) - this.window.minJforI(n) + 1];
            this.currCol[n2 - this.minCurrRow] = d;
        } else {
            throw new InternalError("A SwapFileMatrix can only fill in 2 adjacentcolumns at a time");
        }
    }

    @Override
    public double get(int n, int n2) {
        if (n2 < this.window.minJforI(n) || n2 > this.window.maxJforI(n)) {
            return Double.POSITIVE_INFINITY;
        }
        if (n == this.currColIndex) {
            return this.currCol[n2 - this.minCurrRow];
        }
        if (n == this.currColIndex - 1) {
            return this.lastCol[n2 - this.minLastRow];
        }
        try {
            if (this.isSwapFileFreed) {
                throw new InternalError("The SwapFileMatrix has been freeded by the freeMem() method");
            }
            this.cellValuesFile.seek(this.colOffsets[n] + (long)(8 * (n2 - this.window.minJforI(n))));
            return this.cellValuesFile.readDouble();
        }
        catch (IOException iOException) {
            if (n > this.currColIndex) {
                throw new InternalError("The requested value is in the search window but has not been entered into the org.openmole.tool.dwt.matrix: (col=" + n + "row=" + n2 + ").");
            }
            throw new InternalError("Unable to read CostMatrix in the Swap file (IOException)");
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isSwapFileFreed) {
                this.cellValuesFile.close();
            }
        }
        catch (Exception exception) {
            System.err.println("unable to close swap file '" + this.swapFile.getPath() + "' during finialization");
        }
        finally {
            this.swapFile.delete();
            super.finalize();
        }
    }

    @Override
    public int size() {
        return this.window.size();
    }

    public void freeMem() {
        try {
            this.cellValuesFile.close();
        }
        catch (IOException iOException) {
            System.err.println("unable to close swap file '" + this.swapFile.getPath() + "'");
        }
        finally {
            if (!this.swapFile.delete()) {
                System.err.println("unable to delete swap file '" + this.swapFile.getPath() + "'");
            }
        }
    }
}

