/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.dtw;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.openmole.tool.dtw.matrix.ColMajorCell;

public class WarpPath {
    private final ArrayList tsIindexes = new ArrayList();
    private final ArrayList tsJindexes = new ArrayList();

    public WarpPath() {
    }

    public WarpPath(int n) {
        this();
        this.tsIindexes.ensureCapacity(n);
        this.tsJindexes.ensureCapacity(n);
    }

    public WarpPath(String string) {
        this();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",", false);
                if (stringTokenizer.countTokens() == 2) {
                    this.tsIindexes.add(new Integer(stringTokenizer.nextToken()));
                    this.tsJindexes.add(new Integer(stringTokenizer.nextToken()));
                    continue;
                }
                throw new InternalError("The Warp Path File '" + string + "' has an incorrect format.  There must be\ntwo numbers per line separated by commas");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InternalError("ERROR:  The file '" + string + "' was not found.");
        }
        catch (IOException iOException) {
            throw new InternalError("ERROR:  Problem reading the file '" + string + "'.");
        }
    }

    public int size() {
        return this.tsIindexes.size();
    }

    public int minI() {
        return (Integer)this.tsIindexes.get(0);
    }

    public int minJ() {
        return (Integer)this.tsJindexes.get(0);
    }

    public int maxI() {
        return (Integer)this.tsIindexes.get(this.tsIindexes.size() - 1);
    }

    public int maxJ() {
        return (Integer)this.tsJindexes.get(this.tsJindexes.size() - 1);
    }

    public void addFirst(int n, int n2) {
        this.tsIindexes.add(0, new Integer(n));
        this.tsJindexes.add(0, new Integer(n2));
    }

    public void addLast(int n, int n2) {
        this.tsIindexes.add(new Integer(n));
        this.tsJindexes.add(new Integer(n2));
    }

    public ArrayList getMatchingIndexesForI(int n) {
        int n2 = this.tsIindexes.indexOf(new Integer(n));
        if (n2 < 0) {
            throw new InternalError("ERROR:  index '" + n + " is not in the warp path.");
        }
        ArrayList arrayList = new ArrayList();
        while (n2 < this.tsIindexes.size() && this.tsIindexes.get(n2).equals(new Integer(n))) {
            arrayList.add(this.tsJindexes.get(n2++));
        }
        return arrayList;
    }

    public ArrayList getMatchingIndexesForJ(int n) {
        int n2 = this.tsJindexes.indexOf(new Integer(n));
        if (n2 < 0) {
            throw new InternalError("ERROR:  index '" + n + " is not in the warp path.");
        }
        ArrayList arrayList = new ArrayList();
        while (n2 < this.tsJindexes.size() && this.tsJindexes.get(n2).equals(new Integer(n))) {
            arrayList.add(this.tsIindexes.get(n2++));
        }
        return arrayList;
    }

    public WarpPath invertedCopy() {
        WarpPath warpPath = new WarpPath();
        for (int i = 0; i < this.tsIindexes.size(); ++i) {
            warpPath.addLast((Integer)this.tsJindexes.get(i), (Integer)this.tsIindexes.get(i));
        }
        return warpPath;
    }

    public void invert() {
        for (int i = 0; i < this.tsIindexes.size(); ++i) {
            Object e = this.tsIindexes.get(i);
            this.tsIindexes.set(i, this.tsJindexes.get(i));
            this.tsJindexes.set(i, e);
        }
    }

    public ColMajorCell get(int n) {
        if (n > this.size() || n < 0) {
            throw new NoSuchElementException();
        }
        return new ColMajorCell((Integer)this.tsIindexes.get(n), (Integer)this.tsJindexes.get(n));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.tsIindexes.size(); ++i) {
            stringBuffer.append("(" + this.tsIindexes.get(i) + "," + this.tsJindexes.get(i) + ")");
            if (i >= this.tsIindexes.size() - 1) continue;
            stringBuffer.append(",");
        }
        return new String(stringBuffer.append("]"));
    }

    public boolean equals(Object object) {
        if (object instanceof WarpPath) {
            WarpPath warpPath = (WarpPath)object;
            if (warpPath.size() == this.size() && warpPath.maxI() == this.maxI() && warpPath.maxJ() == this.maxJ()) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).equals(warpPath.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.tsIindexes.hashCode() * this.tsJindexes.hashCode();
    }
}

