/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.dtw;

import org.openmole.tool.dtw.dtw.CostMatrix;
import org.openmole.tool.dtw.dtw.MemoryResidentMatrix;
import org.openmole.tool.dtw.dtw.SearchWindow;
import org.openmole.tool.dtw.dtw.SwapFileMatrix;

class WindowMatrix
implements CostMatrix {
    private CostMatrix windowCells;

    WindowMatrix(SearchWindow searchWindow) {
        try {
            this.windowCells = new MemoryResidentMatrix(searchWindow);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.err.println("Ran out of memory initializing window org.openmole.tool.dwt.matrix, all cells in the window cannot fit into main memory.  Will use a swap file instead (will run ~50% slower)");
            System.gc();
            this.windowCells = new SwapFileMatrix(searchWindow);
        }
    }

    @Override
    public void put(int n, int n2, double d) {
        this.windowCells.put(n, n2, d);
    }

    @Override
    public double get(int n, int n2) {
        return this.windowCells.get(n, n2);
    }

    @Override
    public int size() {
        return this.windowCells.size();
    }

    public void freeMem() {
        if (this.windowCells instanceof SwapFileMatrix) {
            try {
                ((SwapFileMatrix)this.windowCells).freeMem();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

