/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.timeseries;

import org.openmole.tool.dtw.timeseries.TimeSeries;
import org.openmole.tool.dtw.timeseries.TimeSeriesPoint;

public class PAA
extends TimeSeries {
    private int[] aggPtSize;
    private final int originalLength;

    public PAA(TimeSeries timeSeries, int n) {
        if (n > timeSeries.size()) {
            throw new InternalError("ERROR:  The size of an aggregate representation may not be largerr than the \noriginal time series (shrunkSize=" + n + " , origSize=" + timeSeries.size() + ").");
        }
        if (n <= 0) {
            throw new InternalError("ERROR:  The size of an aggregate representation must be greater than zero and \nno larger than the original time series.");
        }
        this.originalLength = timeSeries.size();
        this.aggPtSize = new int[n];
        super.setMaxCapacity(n);
        this.setLabels(timeSeries.getLabels());
        double d = (double)timeSeries.size() / (double)n;
        int n2 = 0;
        while (n2 < timeSeries.size()) {
            int n3;
            int n4 = (int)Math.round(d * (double)(this.size() + 1)) - 1;
            int n5 = n4 - n2 + 1;
            double d2 = 0.0;
            double[] dArray = new double[timeSeries.numOfDimensions()];
            for (n3 = n2; n3 <= n4; ++n3) {
                double[] dArray2 = timeSeries.getMeasurementVector(n3);
                d2 += timeSeries.getTimeAtNthPoint(n3);
                for (int i = 0; i < timeSeries.numOfDimensions(); ++i) {
                    int n6 = i;
                    dArray[n6] = dArray[n6] + dArray2[i];
                }
            }
            d2 /= (double)n5;
            for (n3 = 0; n3 < timeSeries.numOfDimensions(); ++n3) {
                dArray[n3] = dArray[n3] / (double)n5;
            }
            this.aggPtSize[super.size()] = n5;
            this.addLast(d2, new TimeSeriesPoint(dArray));
            n2 = n4 + 1;
        }
    }

    public int originalSize() {
        return this.originalLength;
    }

    public int aggregatePtSize(int n) {
        return this.aggPtSize[n];
    }

    @Override
    public String toString() {
        return "(" + this.originalLength + " point time series represented as " + this.size() + " points)\n" + super.toString();
    }
}

