/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.timeseries;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import org.openmole.tool.dtw.timeseries.TimeSeriesPoint;

public class TimeSeries {
    private static final int[] ZERO_ARRAY = new int[0];
    private static final boolean DEFAULT_IS_TIME_1ST_COL = true;
    private static final char DEFAULT_DELIMITER = ',';
    private static final boolean DEFAULT_IS_LABELED = true;
    private final ArrayList labels;
    private final ArrayList timeReadings;
    private final ArrayList tsArray;

    public TimeSeries(double[] dArray) {
        AtomicInteger atomicInteger = new AtomicInteger();
        this.timeReadings = new ArrayList();
        this.labels = new ArrayList();
        this.labels.add("Time");
        this.labels.add("c1");
        this.tsArray = new ArrayList();
        for (double d : dArray) {
            this.timeReadings.add(Double.valueOf(atomicInteger.getAndIncrement()));
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(d);
            TimeSeriesPoint timeSeriesPoint = new TimeSeriesPoint(arrayList);
            this.tsArray.add(timeSeriesPoint);
        }
    }

    TimeSeries() {
        this.labels = new ArrayList();
        this.timeReadings = new ArrayList();
        this.tsArray = new ArrayList();
    }

    public TimeSeries(int n) {
        this();
        this.labels.add("Time");
        for (int i = 0; i < n; ++i) {
            this.labels.add("" + i);
        }
    }

    public TimeSeries(TimeSeries timeSeries) {
        this.labels = new ArrayList(timeSeries.labels);
        this.timeReadings = new ArrayList(timeSeries.timeReadings);
        this.tsArray = new ArrayList(timeSeries.tsArray);
    }

    public TimeSeries(String string, boolean bl) {
        this(string, ZERO_ARRAY, bl);
    }

    public TimeSeries(String string, char c) {
        this(string, ZERO_ARRAY, true, true, c);
    }

    public TimeSeries(String string, boolean bl, char c) {
        this(string, ZERO_ARRAY, bl, true, c);
    }

    public TimeSeries(String string, boolean bl, boolean bl2, char c) {
        this(string, ZERO_ARRAY, bl, bl2, c);
    }

    public TimeSeries(String string, int[] nArray, boolean bl) {
        this(string, nArray, bl, true, ',');
    }

    public TimeSeries(String string, int[] nArray, boolean bl, boolean bl2, char c) {
        this();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, String.valueOf(c));
            if (bl2) {
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (nArray.length == 0 || org.openmole.tool.dtw.util.Arrays.contains(nArray, n)) {
                        this.labels.add(string3);
                    }
                    ++n;
                }
                if (this.labels.size() == 0) {
                    throw new InternalError("ERROR:  The first row must contain label information, it is empty!");
                }
                if (!bl) {
                    this.labels.add(0, "Time");
                } else if (bl && !((String)this.labels.get(0)).equalsIgnoreCase("Time")) {
                    throw new InternalError("ERROR:  The time column (1st col) in a time series must be labeled as 'Time', '" + this.labels.get(0) + "' was found instead");
                }
            } else {
                int n;
                if (nArray == null || nArray.length == 0) {
                    this.labels.add("Time");
                    if (bl) {
                        stringTokenizer.nextToken();
                    }
                    n = 1;
                    while (stringTokenizer.hasMoreTokens()) {
                        stringTokenizer.nextToken();
                        this.labels.add(new String("c" + n++));
                    }
                } else {
                    Arrays.sort(nArray);
                    this.labels.add("Time");
                    for (n = 0; n < nArray.length; ++n) {
                        if (nArray[n] <= 0) continue;
                        this.labels.add(new String("c" + n));
                    }
                }
                bufferedReader.close();
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object;
                if (string2.length() <= 0) continue;
                stringTokenizer = new StringTokenizer(string2, String.valueOf(c));
                ArrayList<Double> arrayList = new ArrayList<Double>();
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (nArray.length == 0 || org.openmole.tool.dtw.util.Arrays.contains(nArray, n)) {
                        try {
                            object = Double.valueOf(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InternalError("ERROR:  '" + string4 + "' is not a valid number");
                        }
                        arrayList.add((Double)object);
                    }
                    ++n;
                }
                if (bl) {
                    this.timeReadings.add(arrayList.get(0));
                } else {
                    this.timeReadings.add(new Double(this.timeReadings.size()));
                }
                int n2 = bl ? 1 : 0;
                object = new TimeSeriesPoint(arrayList.subList(n2, arrayList.size()));
                this.tsArray.add(object);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InternalError("ERROR:  The file '" + string + "' was not found.");
        }
        catch (IOException iOException) {
            throw new InternalError("ERROR:  Problem reading the file '" + string + "'.");
        }
    }

    private static char determineDelimiter(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine().trim();
            if (!Character.isDigit(string2.charAt(0))) {
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            for (int i = 0; i < string2.length(); ++i) {
                if (Character.isDigit(string2.charAt(i)) || string2.charAt(i) == '.' || string2.charAt(i) == '-' || Character.toUpperCase(string2.charAt(i)) == 'E') continue;
                return string2.charAt(i);
            }
            return ',';
        }
        catch (IOException iOException) {
            return ',';
        }
    }

    private static double extractFirstNumber(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i)) || string.charAt(i) == '.' || string.charAt(i) == '-' || Character.toUpperCase(string.charAt(i)) == 'E') {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            Double.parseDouble(stringBuffer.toString());
        }
        return -1.0;
    }

    private static boolean determineIsFirstColTime(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            Vector<Double> vector = new Vector<Double>(100);
            String string2 = bufferedReader.readLine();
            while (vector.size() < 100 && (string2 = bufferedReader.readLine()) != null) {
                vector.add(new Double(TimeSeries.extractFirstNumber(string2)));
            }
            if (vector.size() <= 1) {
                return false;
            }
            if (vector.size() > 1 && vector.get(1).equals(vector.get(0))) {
                return false;
            }
            double d = (Double)vector.get(1) - (Double)vector.get(0);
            double d2 = d * 0.001;
            for (int i = 1; i < vector.size(); ++i) {
                if (!(Math.abs((Double)vector.get(i) - (Double)vector.get(i - 1) - d) > Math.abs(d2))) continue;
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void save(File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.write(this.toString());
        printWriter.flush();
        printWriter.close();
    }

    public void clear() {
        this.labels.clear();
        this.timeReadings.clear();
        this.tsArray.clear();
    }

    public int size() {
        return this.timeReadings.size();
    }

    public int numOfPts() {
        return this.size();
    }

    public int numOfDimensions() {
        return this.labels.size() - 1;
    }

    public double getTimeAtNthPoint(int n) {
        return (Double)this.timeReadings.get(n);
    }

    public String getLabel(int n) {
        return (String)this.labels.get(n);
    }

    public String[] getLabelsArr() {
        String[] stringArray = new String[this.labels.size()];
        for (int i = 0; i < this.labels.size(); ++i) {
            stringArray[i] = (String)this.labels.get(i);
        }
        return stringArray;
    }

    public ArrayList getLabels() {
        return this.labels;
    }

    public void setLabels(ArrayList arrayList) {
        this.labels.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.labels.add(arrayList.get(i));
        }
    }

    public void setLabels(String[] stringArray) {
        this.labels.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.labels.add(stringArray[i]);
        }
    }

    public double getMeasurement(int n, int n2) {
        return ((TimeSeriesPoint)this.tsArray.get(n)).get(n2);
    }

    public double getMeasurement(int n, String string) {
        int n2 = this.labels.indexOf(string);
        if (n2 < 0) {
            throw new InternalError("ERROR:  the label '" + string + "' was not one of:  " + this.labels);
        }
        return ((TimeSeriesPoint)this.tsArray.get(n)).get(n2 - 1);
    }

    public double[] getMeasurementVector(int n) {
        return ((TimeSeriesPoint)this.tsArray.get(n)).toArray();
    }

    public void setMeasurement(int n, int n2, double d) {
        ((TimeSeriesPoint)this.tsArray.get(n)).set(n2, d);
    }

    public void addFirst(double d, TimeSeriesPoint timeSeriesPoint) {
        if (this.labels.size() != timeSeriesPoint.size() + 1) {
            throw new InternalError("ERROR:  The TimeSeriesPoint: " + timeSeriesPoint + " contains the wrong number of values. expected:  " + this.labels.size() + ", found: " + timeSeriesPoint.size());
        }
        if (d >= (Double)this.timeReadings.get(0)) {
            throw new InternalError("ERROR:  The point being inserted into the beginning of the time series does not have the correct time sequence. ");
        }
        this.timeReadings.add(0, new Double(d));
        this.tsArray.add(0, timeSeriesPoint);
    }

    public void addLast(double d, TimeSeriesPoint timeSeriesPoint) {
        if (this.labels.size() != timeSeriesPoint.size() + 1) {
            throw new InternalError("ERROR:  The TimeSeriesPoint: " + timeSeriesPoint + " contains the wrong number of values. expected:  " + this.labels.size() + ", found: " + timeSeriesPoint.size());
        }
        if (this.size() > 0 && d <= (Double)this.timeReadings.get(this.timeReadings.size() - 1)) {
            throw new InternalError("ERROR:  The point being inserted at the end of the time series does not have the correct time sequence. ");
        }
        this.timeReadings.add(new Double(d));
        this.tsArray.add(timeSeriesPoint);
    }

    public void removeFirst() {
        if (this.size() == 0) {
            System.err.println("WARNING:  TimeSeriesPoint:removeFirst() called on an empty time series!");
        } else {
            this.timeReadings.remove(0);
            this.tsArray.remove(0);
        }
    }

    public void removeLast() {
        if (this.size() == 0) {
            System.err.println("WARNING:  TimeSeriesPoint:removeLast() called on an empty time series!");
        } else {
            this.tsArray.remove(this.timeReadings.size() - 1);
            this.timeReadings.remove(this.timeReadings.size() - 1);
        }
    }

    public void normalize() {
        int n;
        double[] dArray = new double[this.numOfDimensions()];
        for (int i = 0; i < this.numOfDimensions(); ++i) {
            double d = 0.0;
            for (int j = 0; j < this.size(); ++j) {
                d += this.getMeasurement(j, i);
            }
            dArray[i] = d / (double)this.size();
        }
        double[] dArray2 = new double[this.numOfDimensions()];
        for (n = 0; n < this.numOfDimensions(); ++n) {
            double d = 0.0;
            for (int i = 0; i < this.size(); ++i) {
                d += Math.abs(this.getMeasurement(i, n) - dArray[n]);
            }
            dArray2[n] = d / (double)this.size();
        }
        for (n = 0; n < this.size(); ++n) {
            for (int i = 0; i < this.numOfDimensions(); ++i) {
                if (dArray2[i] == 0.0) {
                    this.setMeasurement(n, i, 0.0);
                    continue;
                }
                this.setMeasurement(n, i, (this.getMeasurement(n, i) - dArray[i]) / dArray2[i]);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.timeReadings.size(); ++i) {
            TimeSeriesPoint timeSeriesPoint = (TimeSeriesPoint)this.tsArray.get(i);
            for (int j = 0; j < timeSeriesPoint.size(); ++j) {
                stringBuffer.append(timeSeriesPoint.get(j));
            }
            if (i >= this.timeReadings.size() - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected void setMaxCapacity(int n) {
        this.timeReadings.ensureCapacity(n);
        this.tsArray.ensureCapacity(n);
    }
}

