/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.openmole.tool.archive.TarEntry;
import org.openmole.tool.archive.TarInputStream;
import org.openmole.tool.archive.TarOutputStream;

public class Tar {
    private static final int BUFFER_SIZE = 1024;
    private static final Logger logger = Logger.getLogger(Tar.class.getName());

    public static void extractFiles(File file, File file2) throws IOException {
        if (file2.exists() && file2.isFile()) {
            throw new IOException("Destination is not a directory!");
        }
        if (!file2.exists()) {
            file2.mkdir();
        }
        if (!file.isFile()) {
            throw new IOException("Source tar is not a file.");
        }
        TarInputStream tarInputStream = null;
        InputStream inputStream = null;
        FileInputStream fileInputStream = null;
        String string = file.getName().toLowerCase();
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        try {
            if (string2.equalsIgnoreCase("gz") && string.contains("tar.gz")) {
                fileInputStream = new FileInputStream(file);
                inputStream = new GZIPInputStream(fileInputStream);
                tarInputStream = new TarInputStream(inputStream);
            } else if (string2.equalsIgnoreCase("tar")) {
                fileInputStream = new FileInputStream(file);
                tarInputStream = new TarInputStream(fileInputStream);
            } else {
                throw new IOException("Invalid file extension. Supported: tar.gz, tar");
            }
            TarEntry tarEntry = tarInputStream.getNextEntry();
            while (tarEntry != null) {
                File file3 = new File(file2.getAbsolutePath() + File.separatorChar + tarEntry.getName());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Extracting " + file3.getAbsolutePath());
                }
                if (tarEntry.isDirectory()) {
                    file3.mkdirs();
                } else {
                    if (!file3.getParentFile().exists()) {
                        file3.getParentFile().mkdirs();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    tarInputStream.copyEntryContents(fileOutputStream);
                    fileOutputStream.close();
                }
                tarEntry = tarInputStream.getNextEntry();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (tarInputStream != null) {
                try {
                    tarInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void createDirectoryTar(File file, File file2) throws IOException {
        if (!file2.getName().toLowerCase().endsWith(".tar")) {
            throw new IOException("Destination tar file is not a tar. " + file2.getName().toLowerCase());
        }
        if (file.exists() && !file.isDirectory()) {
            throw new IOException("Source directory is not a directory.");
        }
        if (!file.exists()) {
            throw new IOException("Source directory does not exist.");
        }
        FileOutputStream fileOutputStream = null;
        TarOutputStream tarOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            tarOutputStream = new TarOutputStream(fileOutputStream);
            Tar.recursiveTar(file, file, file2, tarOutputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (tarOutputStream != null) {
                try {
                    tarOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void recursiveTar(File file, File file2, File file3, TarOutputStream tarOutputStream) throws IOException {
        if (file2 == null || file == null || tarOutputStream == null) {
            return;
        }
        File[] fileArray = file2.listFiles();
        if (fileArray == null) {
            return;
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        byte[] byArray = new byte[1024];
        int n = fileArray.length;
        File file4 = null;
        for (int i = 0; i < n; ++i) {
            file4 = fileArray[i];
            if (!file4.canRead()) {
                logger.info("Could not read file... ");
                if (file4.getAbsolutePath() == null) continue;
                logger.info("Unread File: " + file4.getAbsolutePath());
                continue;
            }
            if (file4.isDirectory()) {
                linkedList.add(file4);
                continue;
            }
            String string = file.getAbsolutePath();
            String string2 = file4.getAbsolutePath();
            if (!file3.getAbsolutePath().equals(string2)) {
                if (string2.startsWith(string) && (string2 = string2.substring(string.length())).startsWith(File.separator)) {
                    string2 = string2.substring(1);
                }
                logger.info("Adding " + string2);
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file4);
                    TarEntry tarEntry = new TarEntry(string2);
                    tarEntry.setSize(file4.length());
                    tarOutputStream.putNextEntry(tarEntry);
                    int n2 = 0;
                    while ((n2 = fileInputStream.read(byArray, 0, 1024)) != -1) {
                        tarOutputStream.write(byArray, 0, n2);
                    }
                    continue;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                finally {
                    if (tarOutputStream != null) {
                        try {
                            tarOutputStream.closeEntry();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            logger.info("Skipping currently writing archive: " + string2);
        }
        fileArray = null;
        while (!linkedList.isEmpty()) {
            file4 = (File)linkedList.poll();
            Tar.recursiveTar(file, file4, file3, tarOutputStream);
        }
    }

    public static void gzipTarFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        if (!file.exists()) {
            throw new IOException("Source tar file does not exist.");
        }
        if (file.getName().toLowerCase().endsWith(".tar")) {
            throw new IOException("Source tar file is not a tar.");
        }
        if (file2.getName().toLowerCase().endsWith(".tar.gz")) {
            throw new IOException("Destination tar.gz file does not end with the proper extension.");
        }
        try {
            int n;
            fileOutputStream = new FileOutputStream(file2);
            deflaterOutputStream = new GZIPOutputStream(fileOutputStream);
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) > 0) {
                ((GZIPOutputStream)deflaterOutputStream).write(byArray, 0, n);
            }
            ((GZIPOutputStream)deflaterOutputStream).finish();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (deflaterOutputStream != null) {
                try {
                    deflaterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

