/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.archive;

import java.io.File;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openmole.tool.archive.InvalidHeaderException;
import org.openmole.tool.archive.TarFileUtil;

public class TarEntry
implements Cloneable {
    private static final Logger logger = Logger.getLogger(TarEntry.class.getName());
    public static final int GNU_FORMAT = 0;
    public static final int USTAR_FORMAT = 1;
    public static final int UNIX_FORMAT = 2;
    public static final int MAX_NAMELEN = 31;
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    public static final int MILLIS_PER_SECOND = 1000;
    private File file;
    private String name = null;
    private int mode;
    private int userId;
    private int groupId;
    private long size;
    private long modTime;
    private int checkSum;
    private byte linkFlag;
    private String linkName = "";
    private String magic = "ustar  ";
    private String userName;
    private String groupName;
    private int devMajor;
    private int devMinor;
    private long offB;
    private int tarFormat = 0;

    private TarEntry() {
        String string = System.getProperty("user.name", "");
        if (string.length() > 31) {
            string = string.substring(0, 31);
        }
        this.userId = 0;
        this.groupId = 0;
        this.userName = string;
        this.groupName = "";
        this.file = null;
    }

    public TarEntry(byte[] byArray) throws InvalidHeaderException {
        this();
        this.parseTarHeader(byArray);
    }

    public TarEntry(File file) throws InvalidHeaderException {
        this();
        this.parseFileTarHeader(file);
    }

    public TarEntry(String string) {
        this();
        this.nameTarHeader(string);
    }

    public TarEntry(String string, byte by) {
        this(string);
        this.linkFlag = by;
        if (this.linkFlag == 76) {
            this.magic = "ustar  ";
        }
    }

    public boolean equals(TarEntry tarEntry) {
        return this.name.equals(tarEntry.getName());
    }

    public TarEntry[] getDirectoryEntries() throws InvalidHeaderException {
        if (this.file == null || !this.file.isDirectory()) {
            return new TarEntry[0];
        }
        String[] stringArray = this.file.list();
        TarEntry[] tarEntryArray = new TarEntry[stringArray.length];
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            tarEntryArray[i] = new TarEntry(new File(this.file, stringArray[i]));
        }
        return tarEntryArray;
    }

    public File getFile() {
        return this.file;
    }

    public int getMode() {
        return this.mode;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public long getModTime() {
        return this.modTime * 1000L;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public int getTarFormat() {
        return this.tarFormat;
    }

    public String getLinkName() {
        return this.linkName.toString();
    }

    public int getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isDescendent(TarEntry tarEntry) {
        return tarEntry.getName().startsWith(this.name);
    }

    public boolean isDirectory() {
        if (this.file != null) {
            return this.file.isDirectory();
        }
        if (this != null) {
            if (this.linkFlag == 53) {
                return true;
            }
            if (this.name.endsWith("/")) {
                return true;
            }
        }
        return false;
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76 && this.name.equals("././@LongLink");
    }

    public void nameTarHeader(String string) {
        boolean bl = string.endsWith("/");
        this.checkSum = 0;
        this.devMajor = 0;
        this.devMinor = 0;
        this.name = string;
        this.mode = bl ? 16877 : 33188;
        this.userId = 0;
        this.groupId = 0;
        this.size = 0L;
        this.checkSum = 0;
        this.modTime = new Date().getTime() / 1000L;
        this.linkFlag = (byte)(bl ? 53 : 48);
        this.linkName = "";
        this.userName = "";
        this.groupName = "";
        this.devMajor = 0;
        this.devMinor = 0;
    }

    public void parseFileTarHeader(File file) throws InvalidHeaderException {
        CharSequence charSequence;
        this.file = file;
        String string = file.getPath();
        String string2 = System.getProperty("os.name");
        if (string2 != null) {
            charSequence = "windows";
            if (string2.toLowerCase().startsWith((String)charSequence) && string.length() > 2) {
                char c = string.charAt(0);
                char c2 = string.charAt(1);
                if (c2 == ':' && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    string = string.substring(2);
                }
            }
        }
        string = string.replace(File.separatorChar, '/');
        while (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.linkName = "";
        charSequence = new StringBuilder(string);
        if (file.isDirectory()) {
            this.size = 0L;
            this.mode = 16877;
            this.linkFlag = (byte)53;
            if (this.name.charAt(this.name.length() - 1) != '/') {
                ((StringBuilder)charSequence).append("/");
            }
        } else {
            this.size = file.length();
            this.mode = 33188;
            this.linkFlag = (byte)48;
        }
        this.name = ((StringBuilder)charSequence).toString();
        this.modTime = file.lastModified() / 1000L;
        this.checkSum = 0;
        this.devMajor = 0;
        this.devMinor = 0;
    }

    public void parseTarHeader(byte[] byArray) throws InvalidHeaderException {
        int n = 0;
        if (byArray[257] == 0 && byArray[258] == 0 && byArray[259] == 0 && byArray[260] == 0 && byArray[261] == 0) {
            this.tarFormat = 2;
        } else if (byArray[257] == 117 && byArray[258] == 115 && byArray[259] == 116 && byArray[260] == 97 && byArray[261] == 114 && byArray[262] == 0) {
            this.tarFormat = 1;
        } else if (byArray[257] == 117 && byArray[258] == 115 && byArray[259] == 116 && byArray[260] == 97 && byArray[261] == 114 && byArray[262] != 0 && byArray[263] != 0) {
            this.tarFormat = 0;
        } else if (byArray[257] == 117 && byArray[258] == 115 && byArray[259] == 116 && byArray[260] == 97 && byArray[261] == 114 && byArray[262] == 32 && byArray[263] == 0) {
            this.tarFormat = 0;
        } else {
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("header magic is not 'ustar' or unix-style zeros, it is '");
            stringBuffer.append(byArray[257]);
            stringBuffer.append(byArray[258]);
            stringBuffer.append(byArray[259]);
            stringBuffer.append(byArray[260]);
            stringBuffer.append(byArray[261]);
            stringBuffer.append(byArray[262]);
            stringBuffer.append(byArray[263]);
            stringBuffer.append("', or (dec) ");
            stringBuffer.append(byArray[257]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[258]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[259]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[260]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[261]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[262]);
            stringBuffer.append(", ");
            stringBuffer.append(byArray[263]);
            throw new InvalidHeaderException(stringBuffer.toString());
        }
        this.name = TarFileUtil.parseFileName(byArray);
        n = 100;
        this.mode = (int)TarFileUtil.parseOctal(byArray, n, 8);
        this.userId = (int)TarFileUtil.parseOctal(byArray, n += 8, 8);
        this.groupId = (int)TarFileUtil.parseOctal(byArray, n += 8, 8);
        this.size = this.tarFormat == 0 ? TarFileUtil.getSize(byArray, n, 12) : TarFileUtil.parseOctal(byArray, n += 8, 12);
        this.modTime = TarFileUtil.parseOctal(byArray, n += 12, 12);
        this.checkSum = (int)TarFileUtil.parseOctal(byArray, n += 12, 8);
        n += 8;
        this.linkFlag = byArray[n++];
        this.linkName = TarFileUtil.parseName(byArray, n, 100);
        n += 100;
        if (this.tarFormat == 1) {
            this.magic = TarFileUtil.parseName(byArray, n, 8);
            this.userName = TarFileUtil.parseName(byArray, n += 8, 32);
            this.groupName = TarFileUtil.parseName(byArray, n += 32, 32);
            this.devMajor = (int)TarFileUtil.parseOctal(byArray, n += 32, 8);
            this.devMinor = (int)TarFileUtil.parseOctal(byArray, n += 8, 8);
            this.offB = TarFileUtil.parseOctal(byArray, 369, 12);
        } else {
            this.devMajor = 0;
            this.devMinor = 0;
            this.magic = "";
            this.userName = "";
            this.groupName = "";
        }
    }

    public void setGroupId(int n) {
        this.groupId = n;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void setIds(int n, int n2) {
        this.setUserId(n);
        this.setGroupId(n2);
    }

    public void setModTime(Date date) {
        this.modTime = date.getTime() / 1000L;
    }

    public void setModTime(long l) {
        this.modTime = l / 1000L;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setLinkName(String string) {
        this.linkName = string;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setNames(String string, String string2) {
        this.setUserName(string);
        this.setGroupName(string2);
    }

    public void setSize(long l) {
        this.size = l;
    }

    public void setTarFormat(int n) throws Exception {
        if (n != 0 && n != 2 && n != 1) {
            throw new Exception("Invalid format specified.");
        }
        this.tarFormat = n;
        if (n == 2) {
            this.magic = "";
        } else if (n == 1) {
            this.magic = "ustar";
        } else if (n == 0) {
            this.magic = "ustar  ";
        }
    }

    public void setUserId(int n) {
        this.userId = n;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        return stringBuffer.append("[TarEntry name=").append(this.getName()).append(", isDir=").append(this.isDirectory()).append(", size=").append(this.getSize()).append(", userId=").append(this.getUserId()).append(", user=").append(this.getUserName()).append(", groupId=").append(this.getGroupId()).append(", group=").append(this.getGroupName()).append("]").toString();
    }

    public void writeEntryHeader(byte[] byArray) throws InvalidHeaderException {
        int n;
        int n2 = 0;
        if (this.tarFormat == 2 && this.name.length() > 100) {
            throw new InvalidHeaderException("file path is greater than 100 characters, " + this.name);
        }
        n2 = TarFileUtil.getFileNameBytes(this.name, byArray, this.tarFormat == 0);
        n2 = TarFileUtil.getOctalBytes(this.mode, byArray, n2, 8, (byte)48);
        n2 = TarFileUtil.getOctalBytes(this.userId, byArray, n2, 8, (byte)48);
        n2 = TarFileUtil.getOctalBytes(this.groupId, byArray, n2, 8, (byte)48);
        long l = this.size;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Size is at: " + n2);
        }
        n2 = TarFileUtil.getLongOctalBytes(l, byArray, n2, 12);
        int n3 = n2 = TarFileUtil.getLongOctalBytes(this.modTime, byArray, n2, 12);
        for (n = 0; n < 8; ++n) {
            byArray[n2++] = 32;
        }
        byArray[n2++] = this.linkFlag;
        n2 = TarFileUtil.getNameBytes(this.linkName, byArray, n2, 100);
        if (this.tarFormat == 2) {
            for (n = 0; n < 8; ++n) {
                byArray[n2++] = 0;
            }
        } else {
            n2 = TarFileUtil.getNameBytes(this.magic, byArray, n2, 8);
            if (this.tarFormat == 1) {
                byArray[n2 - 2] = 48;
                byArray[n2 - 1] = 48;
            }
        }
        n2 = TarFileUtil.getNameBytes(this.userName, byArray, n2, 32);
        n2 = TarFileUtil.getNameBytes(this.groupName, byArray, n2, 32);
        n2 = TarFileUtil.getOctalBytes(this.devMajor, byArray, n2, 8, (byte)48);
        n2 = TarFileUtil.getOctalBytes(this.devMinor, byArray, n2, 8, (byte)48);
        while (n2 < byArray.length) {
            byArray[n2++] = 0;
        }
        if (this.tarFormat != 1 && l > 0x200000000L) {
            n2 = TarFileUtil.setRealSize(l, byArray, 124, 12);
        }
        long l2 = TarFileUtil.computeCheckSum(byArray);
        TarFileUtil.getCheckSumOctalBytes(l2, byArray, n3, 8);
    }

    public void writeEntryHeaderMulti(byte[] byArray, int n) throws InvalidHeaderException {
        int n2;
        int n3 = 0;
        if (this.tarFormat == 2 && this.name.length() > 100) {
            throw new InvalidHeaderException("file path is greater than 100 characters, " + this.name);
        }
        n3 = TarFileUtil.getFileNameBytes(this.name, byArray, this.tarFormat == 0);
        n3 = TarFileUtil.getOctalBytes(this.mode, byArray, n3, 8, (byte)48);
        n3 = TarFileUtil.getOctalBytes(this.userId, byArray, n3, 8, (byte)48);
        n3 = TarFileUtil.getOctalBytes(this.groupId, byArray, n3, 8, (byte)48);
        long l = this.size;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "The header size in the multi: " + l);
        }
        n3 = TarFileUtil.getLongOctalBytes(l, byArray, n3, 12);
        int n4 = n3 = TarFileUtil.getLongOctalBytes(this.modTime, byArray, n3, 12);
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n3++] = 32;
        }
        if (n != -1) {
            this.linkFlag = (byte)77;
        }
        byArray[n3++] = this.linkFlag;
        n3 = TarFileUtil.getNameBytes(this.linkName, byArray, n3, 100);
        if (this.tarFormat == 2) {
            for (n2 = 0; n2 < 8; ++n2) {
                byArray[n3++] = 0;
            }
        } else {
            n3 = TarFileUtil.getNameBytes(this.magic, byArray, n3, 8);
            if (this.tarFormat == 1) {
                byArray[n3 - 2] = 48;
                byArray[n3 - 1] = 48;
            }
        }
        n3 = TarFileUtil.getNameBytes(this.userName, byArray, n3, 32);
        n3 = TarFileUtil.getNameBytes(this.groupName, byArray, n3, 32);
        n3 = TarFileUtil.getOctalBytes(this.devMajor, byArray, n3, 8, (byte)48);
        n3 = TarFileUtil.getOctalBytes(this.devMinor, byArray, n3, 8, (byte)48);
        while (n3 < byArray.length) {
            byArray[n3++] = 0;
        }
        if (l > 0x200000000L) {
            n3 = TarFileUtil.setRealSize(l, byArray, 124, 12);
        }
        n3 = TarFileUtil.getLongOctalBytesMulti(n, byArray, 369, 12);
        if (this.tarFormat != 1 && l > 0x200000000L) {
            n3 = TarFileUtil.setRealSize(l, byArray, 124, 12);
        }
        this.linkFlag = (byte)77;
        long l2 = TarFileUtil.computeCheckSum(byArray);
        TarFileUtil.getCheckSumOctalBytes(l2, byArray, n4, 8);
    }
}

