/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.archive;

import java.math.BigInteger;
import java.util.ArrayList;
import org.openmole.tool.archive.InvalidHeaderException;

public class TarFileUtil {
    private static final int BYTE_MASK = 255;

    public static int getCheckSumOctalBytes(long l, byte[] byArray, int n, int n2) {
        TarFileUtil.getPostfixOctalBytes(l, byArray, n, n2, (byte)32);
        return n + n2;
    }

    public static long computeCheckSum(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; ++i) {
            l += (long)(0xFF & byArray[i]);
        }
        return l;
    }

    public static int getFileNameBytes(String string, byte[] byArray, boolean bl) throws InvalidHeaderException {
        if (!bl && string.length() > 100) {
            int n = string.indexOf("/", string.length() - 100);
            if (n == -1) {
                throw new InvalidHeaderException("file name is greater than 100 characters, " + string);
            }
            String string2 = string.substring(n + 1);
            String string3 = string.substring(0, n);
            if (string3.length() > 155) {
                throw new InvalidHeaderException("file prefix is greater than 155 characters");
            }
            TarFileUtil.getNameBytes(string2, byArray, 0, 100);
            TarFileUtil.getNameBytes(string3, byArray, 345, 155);
        } else {
            TarFileUtil.getNameBytes(string, byArray, 0, 100);
        }
        return 100;
    }

    public static int getLongOctalBytes(long l, byte[] byArray, int n, int n2) {
        TarFileUtil.getOctalBytes(l, byArray, n, n2, (byte)48);
        return n + n2;
    }

    public static int getLongOctalBytesMulti(long l, byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = new byte[n2 + 1];
        TarFileUtil.getOctalBytes(l, byArray2, 0, n2 + 1, (byte)48);
        for (n3 = 0; n3 < n2 + 1; ++n3) {
            if (byArray2[n3] != 32) continue;
            byArray2[n3] = 48;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            byArray[n + n3] = n3 > 0 ? byArray2[n3 - 1] : 48;
        }
        byArray2 = null;
        return n + n2;
    }

    public static int getNameBytes(String string, byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = string.length();
        for (n3 = 0; n3 < n2 && n3 < n4; ++n3) {
            byArray[n + n3] = (byte)string.charAt(n3);
        }
        while (n3 < n2) {
            byArray[n + n3] = 0;
            ++n3;
        }
        return n + n2;
    }

    public static int getOctalBytes(long l, byte[] byArray, int n, int n2, byte by) {
        int n3 = n2 - 1;
        byArray[n + n3] = 0;
        --n3;
        if (l == 0L) {
            byArray[n + n3] = 48;
            --n3;
        } else {
            for (long i = l; n3 >= 0 && i > 0L; i >>= 3, --n3) {
                byArray[n + n3] = (byte)(48 + (byte)(i & 7L));
            }
        }
        while (n3 >= 0) {
            byArray[n + n3] = by;
            --n3;
        }
        return n + n2;
    }

    public static int getPostfixOctalBytes(long l, byte[] byArray, int n, int n2, byte by) {
        int n3 = 0;
        if (l == 0L) {
            byArray[n + n3] = 48;
            ++n3;
        } else {
            ArrayList<Byte> arrayList = new ArrayList<Byte>();
            for (long i = l; i > 0L; i >>= 3) {
                arrayList.add((byte)(48 + (byte)(i & 7L)));
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                byArray[n + n3] = (Byte)arrayList.get(i);
                ++n3;
            }
            arrayList.clear();
        }
        byArray[n + n3] = 0;
        ++n3;
        while (n3 < n2) {
            byArray[n + n3] = by;
            ++n3;
        }
        return n + n2;
    }

    public static int getOffBytes(StringBuffer stringBuffer, byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2 && n3 < stringBuffer.length(); ++n3) {
            byArray[n + n3] = (byte)stringBuffer.charAt(n3);
        }
        while (n3 < n2) {
            byArray[n + n3] = 0;
            ++n3;
        }
        return n + n2;
    }

    public static long getSize(byte[] byArray, int n, int n2) {
        long l = TarFileUtil.parseOctal(byArray, n, n2);
        if (l <= 0L && byArray[n] == -128) {
            byte[] byArray2 = new byte[n2];
            for (int i = 0; i < n2; ++i) {
                byArray2[i] = byArray[n + i];
            }
            byArray2[0] = 0;
            long l2 = new BigInteger(byArray2).longValue();
            byArray2 = null;
            return l2;
        }
        return l;
    }

    public static String parseFileName(byte[] byArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(256);
        if (byArray[345] != 0) {
            for (n = 345; n < 500 && byArray[n] != 0; ++n) {
                stringBuilder.append((char)byArray[n]);
            }
            stringBuilder.append("/");
        }
        for (n = 0; n < 100 && byArray[n] != 0; ++n) {
            stringBuilder.append((char)byArray[n]);
        }
        return stringBuilder.toString();
    }

    public static String parseName(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n3 = n + n2;
        for (int i = n; i < n3 && byArray[i] != 0; ++i) {
            stringBuilder.append((char)byArray[i]);
        }
        return stringBuilder.toString();
    }

    public static long parseOctal(byte[] byArray, int n, int n2) {
        long l = 0L;
        boolean bl = true;
        int n3 = n + n2;
        for (int i = n; i < n3 && byArray[i] != 0; ++i) {
            if (byArray[i] == 32 || byArray[i] == 48) {
                if (bl) continue;
                if (byArray[i] == 32) break;
            }
            bl = false;
            l = (l << 3) + (long)(byArray[i] - 48);
        }
        return l;
    }

    public static int setRealSize(long l, byte[] byArray, int n, int n2) {
        BigInteger bigInteger = new BigInteger("" + l);
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = bigInteger.toByteArray();
        for (int i = 0; i < byArray3.length; ++i) {
            byArray2[byArray2.length - byArray3.length + i] = byArray3[i];
        }
        byArray2[0] = -128;
        for (byte byArray[n + var9_8] : byArray2) {
        }
        byArray2 = null;
        byArray3 = null;
        return n + n2;
    }
}

