/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.archive;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openmole.tool.archive.InvalidHeaderException;
import org.openmole.tool.archive.TarBuffer;
import org.openmole.tool.archive.TarEntry;

public class TarInputStream
extends FilterInputStream {
    private static final Logger logger = Logger.getLogger(TarInputStream.class.getName());
    private static final int BYTE_MASK = 255;
    private boolean hasHitEOF;
    private long entrySize;
    private long entryOffset;
    private byte[] oneBuf;
    private byte[] readBuf;
    private TarBuffer buffer;
    private TarEntry currEntry;

    public TarInputStream(InputStream inputStream) {
        this(inputStream, 10240, 512);
    }

    public TarInputStream(InputStream inputStream, int n) {
        this(inputStream, n, 512);
    }

    public TarInputStream(InputStream inputStream, int n, int n2) {
        super(inputStream);
        this.buffer = new TarBuffer(inputStream, n, n2);
        this.readBuf = null;
        this.oneBuf = new byte[1];
        this.hasHitEOF = false;
    }

    @Override
    public int available() throws IOException {
        if (this.entrySize - this.entryOffset > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.entrySize - this.entryOffset);
    }

    @Override
    public void close() throws IOException {
        this.currEntry = null;
        this.buffer.close();
    }

    public void copyEntryContents(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[32768];
        int n = -1;
        while ((n = this.read(byArray, 0, 32768)) > -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        byArray = null;
    }

    public long getEntryPosition() {
        return this.entryOffset;
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] byArray;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            long l = this.entrySize - this.entryOffset;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "TarInputStream: SKIP currENTRY '" + this.currEntry.getName() + "' SZ " + this.entrySize + " OFF " + this.entryOffset + "  skipping " + l + " bytes");
            }
            if (l > 0L) {
                this.skip(l);
            }
            this.currEntry = null;
            this.readBuf = null;
        }
        if ((byArray = this.buffer.readRecord()) == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "READ NULL RECORD");
            }
            this.hasHitEOF = true;
        } else if (this.buffer.isEOFRecord(byArray)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "READ EOF RECORD");
            }
            this.hasHitEOF = true;
        }
        if (this.hasHitEOF) {
            this.currEntry = null;
        } else {
            try {
                this.currEntry = new TarEntry(byArray);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "TarInputStream: SET CURR ENTRY '" + this.currEntry.getName() + "' size = " + this.currEntry.getSize());
                }
                this.entryOffset = 0L;
                this.entrySize = this.currEntry.getSize();
            }
            catch (InvalidHeaderException invalidHeaderException) {
                this.entrySize = 0L;
                this.entryOffset = 0L;
                this.currEntry = null;
                throw new InvalidHeaderException("bad header in block " + this.buffer.getCurrentBlockNum() + " record " + this.buffer.getCurrentRecordNum() + ", " + invalidHeaderException.getMessage());
            }
        }
        if (this.currEntry != null && this.currEntry.isGNULongNameEntry()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "LongLink File Detected");
            }
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray2 = new byte[256];
            int n = 0;
            while ((n = this.read(byArray2)) >= 0) {
                stringBuffer.append(new String(byArray2, 0, n));
            }
            byArray2 = null;
            this.getNextEntry();
            if (this.currEntry == null) {
                return null;
            }
            int n2 = stringBuffer.length();
            if (n2 > 0 && stringBuffer.charAt(n2 - 1) == '\u0000') {
                stringBuffer.deleteCharAt(n2 - 1);
            }
            this.currEntry.setName(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer = null;
        }
        return this.currEntry;
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    public long getStreamPosition() {
        return this.buffer.getBlockSize() * this.buffer.getCurrentBlockNum() + this.buffer.getCurrentRecordNum();
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.oneBuf, 0, 1);
        return n == -1 ? -1 : this.oneBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (this.entryOffset >= this.entrySize) {
            return -1;
        }
        if ((long)n2 + this.entryOffset > this.entrySize) {
            n2 = (int)(this.entrySize - this.entryOffset);
        }
        if (this.readBuf != null) {
            int n5 = n2 > this.readBuf.length ? this.readBuf.length : n2;
            System.arraycopy(this.readBuf, 0, byArray, n, n5);
            if (n5 >= this.readBuf.length) {
                this.readBuf = null;
            } else {
                n3 = this.readBuf.length - n5;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(this.readBuf, n5, byArray2, 0, n3);
                this.readBuf = byArray2;
            }
            n4 += n5;
            n2 -= n5;
            n += n5;
        }
        while (n2 > 0) {
            byte[] byArray3 = this.buffer.readRecord();
            if (byArray3 == null) {
                throw new IOException("unexpected EOF with " + n2 + " bytes unread");
            }
            int n6 = byArray3.length;
            n3 = n2;
            if (n6 > n3) {
                System.arraycopy(byArray3, 0, byArray, n, n3);
                this.readBuf = new byte[n6 - n3];
                System.arraycopy(byArray3, n3, this.readBuf, 0, n6 - n3);
            } else {
                n3 = n6;
                System.arraycopy(byArray3, 0, byArray, n, n6);
            }
            n4 += n3;
            n2 -= n3;
            n += n3;
        }
        this.entryOffset += (long)n4;
        return n4;
    }

    @Override
    public void reset() {
    }

    @Override
    public long skip(long l) throws IOException {
        long l2;
        byte[] byArray = new byte[8192];
        int n = -1;
        int n2 = -1;
        for (l2 = l; l2 > 0L && (n2 = this.read(byArray, 0, n = l2 > (long)byArray.length ? byArray.length : (int)l2)) != -1; l2 -= (long)n2) {
        }
        byArray = null;
        return l - l2;
    }
}

