/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.archive;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openmole.tool.archive.InvalidHeaderException;
import org.openmole.tool.archive.TarBuffer;
import org.openmole.tool.archive.TarEntry;

public class TarOutputStream
extends FilterOutputStream {
    private static final Logger logger = Logger.getLogger(TarOutputStream.class.getName());
    private long currSize;
    private long currBytes;
    private byte[] oneBuf;
    private byte[] recordBuf;
    private int assemLen;
    private byte[] assemBuf;
    private TarBuffer buffer;

    public TarOutputStream(OutputStream outputStream) {
        this(outputStream, 10240, 512);
    }

    public TarOutputStream(OutputStream outputStream, int n) {
        this(outputStream, n, 512);
    }

    public TarOutputStream(OutputStream outputStream, int n, int n2) {
        super(outputStream);
        this.buffer = new TarBuffer(outputStream, n, n2);
        this.assemLen = 0;
        this.assemBuf = new byte[n2];
        this.recordBuf = new byte[n2];
        this.oneBuf = new byte[1];
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.buffer.close();
    }

    public void closeMulti() throws IOException {
        this.flush();
        this.buffer.close();
    }

    public void closeEntry() throws IOException {
        if (this.assemLen > 0) {
            for (int i = this.assemLen; i < this.assemBuf.length; ++i) {
                this.assemBuf[i] = 0;
            }
            this.buffer.writeRecord(this.assemBuf);
            this.currBytes += (long)this.assemLen;
            this.assemLen = 0;
        }
        if (this.currBytes < this.currSize) {
            throw new IOException("entry closed at '" + this.currBytes + "' before the '" + this.currSize + "' bytes specified in the header were written");
        }
    }

    public void closeEntryMulti() throws IOException {
        if (this.assemLen > 0) {
            this.buffer.writeRecord(this.assemBuf);
            this.currBytes += (long)this.assemLen;
            this.assemLen = 0;
        }
    }

    public void finish() throws IOException {
        this.writeEOFRecord();
    }

    public int getRecordSize() {
        return this.buffer.getRecordSize();
    }

    public void putNextEntry(TarEntry tarEntry) throws IOException {
        String string = tarEntry.getName();
        if (tarEntry.getName().length() >= 100 || tarEntry.getTarFormat() != 2 && string.length() > 255) {
            if (tarEntry.getTarFormat() == 0) {
                TarEntry tarEntry2 = new TarEntry("././@LongLink", 76);
                tarEntry2.setModTime(tarEntry.getModTime());
                tarEntry2.setSize(tarEntry.getName().length() + 1);
                this.putNextEntry(tarEntry2);
                this.write(tarEntry.getName().getBytes());
                this.write(0);
                this.closeEntry();
                tarEntry2 = null;
            } else {
                throw new InvalidHeaderException("file name '" + string + "' is too long ( " + string.length() + " > " + (tarEntry.getTarFormat() == 2 ? 100 : 255) + " bytes )");
            }
        }
        tarEntry.writeEntryHeader(this.recordBuf);
        this.buffer.writeRecord(this.recordBuf);
        this.currBytes = 0L;
        this.currSize = tarEntry.isDirectory() ? 0L : tarEntry.getSize();
    }

    public void putNextEntry(TarEntry tarEntry, long l, long l2) throws IOException {
        String string = tarEntry.getName();
        if (tarEntry.getName().length() >= 100 || tarEntry.getTarFormat() != 2 && string.length() > 255) {
            if (tarEntry.getTarFormat() == 0) {
                TarEntry tarEntry2 = new TarEntry("././@LongLink", 76);
                tarEntry2.setModTime(tarEntry.getModTime());
                tarEntry2.setSize(tarEntry.getName().length() + 1);
                this.putNextEntry(tarEntry2);
                this.write(tarEntry.getName().getBytes());
                this.write(0);
                this.closeEntry();
            } else {
                throw new InvalidHeaderException("file name '" + string + "' is too long ( " + string.length() + " > " + (tarEntry.getTarFormat() == 2 ? 100 : 255) + " bytes )");
            }
        }
        if (l2 != -1L) {
            tarEntry.setSize(new Long(l2));
        }
        tarEntry.writeEntryHeaderMulti(this.recordBuf, new Long(l).intValue());
        this.buffer.writeRecord(this.recordBuf);
        this.currBytes = 0L;
        this.currSize = tarEntry.isDirectory() ? 0L : tarEntry.getSize();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.currBytes != 0L && this.currBytes + (long)n2 > this.currSize) {
            throw new IOException("request to write '" + n2 + "' bytes exceeds size in header of '" + this.currSize + "' bytes");
        }
        if (this.assemLen > 0) {
            if (this.assemLen + n2 >= this.recordBuf.length) {
                int n3 = this.recordBuf.length - this.assemLen;
                System.arraycopy(this.assemBuf, 0, this.recordBuf, 0, this.assemLen);
                System.arraycopy(byArray, n, this.recordBuf, this.assemLen, n3);
                this.buffer.writeRecord(this.recordBuf);
                this.currBytes += (long)this.recordBuf.length;
                n += n3;
                n2 -= n3;
                this.assemLen = 0;
            } else {
                System.arraycopy(byArray, n, this.assemBuf, this.assemLen, n2);
                n += n2;
                this.assemLen += n2;
                n2 -= n2;
            }
        }
        while (n2 > 0) {
            if (n2 < this.recordBuf.length) {
                System.arraycopy(byArray, n, this.assemBuf, this.assemLen, n2);
                this.assemLen += n2;
                break;
            }
            this.buffer.writeRecord(byArray, n);
            long l = this.recordBuf.length;
            this.currBytes += l;
            n2 = (int)((long)n2 - l);
            n = (int)((long)n + l);
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.oneBuf[0] = (byte)n;
        this.write(this.oneBuf, 0, 1);
    }

    private void writeEOFRecord() throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "********************Writting end of file *************************");
        }
        for (int i = 0; i < this.recordBuf.length; ++i) {
            this.recordBuf[i] = 0;
        }
        this.buffer.writeRecord(this.recordBuf);
    }
}

