/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.archive;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.openmole.tool.archive.ArchiveEntry;
import org.openmole.tool.archive.ArchiveType;
import org.openmole.tool.archive.TarConstants;
import org.openmole.tool.archive.TarEntry;
import org.openmole.tool.archive.TarInputStream;
import org.openmole.tool.archive.TarOutputStream;
import org.openmole.tool.archive.package$package$;
import org.openmole.tool.file.FilePackage;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class package$package {
    public static TarInputStreamDecorator TarInputStreamDecorator(TarInputStream tarInputStream) {
        return package$package$.MODULE$.TarInputStreamDecorator(tarInputStream);
    }

    public static TarOutputStreamDecorator TarOutputStreamDecorator(TarOutputStream tarOutputStream) {
        return package$package$.MODULE$.TarOutputStreamDecorator(tarOutputStream);
    }

    public static void archive(File file, File file2, boolean bl, ArchiveType archiveType) {
        package$package$.MODULE$.archive(file, file2, bl, archiveType);
    }

    public static File copyCompress(File file, File file2) {
        return package$package$.MODULE$.copyCompress(file, file2);
    }

    public static void extract(File file, File file2, boolean bl, ArchiveType archiveType) {
        package$package$.MODULE$.extract(file, file2, bl, archiveType);
    }

    public static Seq<ArchiveEntry> listArchive(File file, ArchiveType archiveType) {
        return package$package$.MODULE$.listArchive(file, archiveType);
    }

    public static boolean archive$default$3(File file) {
        return package$package$.MODULE$.archive$default$3(file);
    }

    public static boolean extract$default$3(File file) {
        return package$package$.MODULE$.extract$default$3(file);
    }

    public static ArchiveType archive$default$4(File file) {
        return package$package$.MODULE$.archive$default$4(file);
    }

    public static class TarInputStreamDecorator {
        private final TarInputStream tis;

        public TarInputStreamDecorator(TarInputStream tis) {
            this.tis = tis;
        }

        public Iterator<TarEntry> entryIterator() {
            return package$.MODULE$.Iterator().continually(this::entryIterator$$anonfun$1).takeWhile((Function1 & Serializable)_$14 -> _$14 != null);
        }

        /*
         * WARNING - void declaration
         */
        public <T> Iterable<T> applyAndClose(Function1<TarEntry, T> f) {
            void v0;
            try {
                void var2_2;
                ListBuffer ret = new ListBuffer();
                TarEntry e = this.tis.getNextEntry();
                while (e != null) {
                    ret.$plus$eq(f.apply((Object)e));
                    e = this.tis.getNextEntry();
                }
                v0 = var2_2;
            }
            finally {
                this.tis.close();
            }
            return v0;
        }

        public void extract(File directory, boolean overwrite) {
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!Files.isDirectory(org.openmole.tool.file.package$.MODULE$.file2Path(directory), new LinkOption[0])) {
                throw new IOException(directory.toString() + " is not a directory.");
            }
            ListBuffer directoryRights = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            package$.MODULE$.Iterator().continually(this::extract$$anonfun$2).takeWhile((Function1 & Serializable)_$15 -> _$15 != null).foreach((Function1 & Serializable)e -> {
                Object object;
                Path dest = Paths.get(directory.toString(), e.getName());
                if (e.isDirectory()) {
                    Files.createDirectories(dest, new FileAttribute[0]);
                    Path path = (Path)Predef$.MODULE$.ArrowAssoc((Object)dest);
                    object = directoryRights.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)path, (Object)BoxesRunTime.boxToInteger((int)e.getMode())));
                } else {
                    Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                    if (!e.getLinkName().isEmpty()) {
                        object = Files.createSymbolicLink(dest, Paths.get(e.getLinkName(), new String[0]), new FileAttribute[0]);
                    } else {
                        Files.copy(this.tis, dest, (CopyOption[])((StandardCopyOption[])Arrays$.MODULE$.seqToArray((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardCopyOption[]{StandardCopyOption.REPLACE_EXISTING})).filter((Function1 & Serializable)_$16 -> overwrite), StandardCopyOption.class)));
                        object = BoxesRunTime.boxToBoolean((boolean)org.openmole.tool.file.package$.MODULE$.FileDecorator(dest.toFile()).mode_$eq(e.getMode()));
                    }
                }
                return org.openmole.tool.file.package$.MODULE$.path2File(dest).setLastModified(e.getModTime());
            });
            directoryRights.withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    int mode = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return true;
                }
                return false;
            }).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Path path = (Path)tuple2._1();
                    int mode = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return org.openmole.tool.file.package$.MODULE$.FileDecorator(path.toFile()).mode_$eq(mode);
                }
                throw new MatchError((Object)tuple2);
            });
        }

        public boolean extract$default$2() {
            return false;
        }

        private final TarEntry entryIterator$$anonfun$1() {
            return this.tis.getNextEntry();
        }

        private final TarEntry extract$$anonfun$2() {
            return this.tis.getNextEntry();
        }
    }

    public static class TarOutputStreamDecorator {
        private final TarOutputStream tos;

        public TarOutputStreamDecorator(TarOutputStream tos) {
            this.tos = tos;
        }

        public long addFile(File f, String name) {
            long l;
            TarEntry entry = new TarEntry(name);
            entry.setSize(Files.size(org.openmole.tool.file.package$.MODULE$.file2Path(f)));
            entry.setMode(org.openmole.tool.file.package$.MODULE$.FileDecorator(f).mode());
            this.tos.putNextEntry(entry);
            try {
                l = Files.copy(org.openmole.tool.file.package$.MODULE$.file2Path(f), this.tos);
            }
            finally {
                this.tos.closeEntry();
            }
            return l;
        }

        public void archive(File directory, boolean time, boolean includeTopDirectoryName) {
            this.createDirArchiveWithRelativePathWithAdditionalCommand(this.tos, directory, (Function1<TarEntry, BoxedUnit>)(time ? (JProcedure1 & Serializable)_$12 -> Predef$.MODULE$.identity(_$12) : (JProcedure1 & Serializable)_$13 -> _$13.setModTime(0L)), includeTopDirectoryName);
        }

        public boolean archive$default$2() {
            return true;
        }

        public boolean archive$default$3() {
            return false;
        }

        private void createDirArchiveWithRelativePathWithAdditionalCommand(TarOutputStream tos, File directory, Function1<TarEntry, BoxedUnit> additionalCommand, boolean includeDirectoryName) {
            Stack stack;
            if (!Files.isDirectory(org.openmole.tool.file.package$.MODULE$.file2Path(directory), new LinkOption[0])) {
                throw new IOException(directory.toString() + " is not a directory.");
            }
            Stack toArchive = new Stack(Stack$.MODULE$.$lessinit$greater$default$1());
            if (!includeDirectoryName) {
                File file = (File)Predef$.MODULE$.ArrowAssoc((Object)directory);
                stack = toArchive.push((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)file, (Object)""));
            } else {
                File file = (File)Predef$.MODULE$.ArrowAssoc((Object)directory);
                stack = toArchive.push((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)file, (Object)directory.getName()));
            }
            while (!toArchive.isEmpty()) {
                TarEntry tarEntry;
                Tuple2 tuple2 = (Tuple2)toArchive.pop();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                File source = (File)tuple2._1();
                String entryName = (String)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)entryName);
                File source2 = (File)tuple22._1();
                String entryName2 = (String)tuple22._2();
                boolean isSymbolicLink = Files.isSymbolicLink(org.openmole.tool.file.package$.MODULE$.file2Path(source2));
                boolean isDirectory = Files.isDirectory(org.openmole.tool.file.package$.MODULE$.file2Path(source2), new LinkOption[0]);
                if (isDirectory && !isSymbolicLink) {
                    TarEntry e;
                    FilePackage.FileDecorator fileDecorator = org.openmole.tool.file.package$.MODULE$.FileDecorator(source2);
                    fileDecorator.withDirectoryStream(fileDecorator.withDirectoryStream$default$1(), (Function1)(JProcedure1 & Serializable)stream -> CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)stream).asScala().foreach((Function1 & Serializable)f -> {
                        Path newSource = org.openmole.tool.file.package$.MODULE$.file2Path(source2).resolve(f.getFileName());
                        String newEntryName = entryName2 + '/' + f.getFileName();
                        return toArchive.push((Object)Tuple2$.MODULE$.apply((Object)org.openmole.tool.file.package$.MODULE$.path2File(newSource), (Object)newEntryName));
                    }));
                    tarEntry = e = new TarEntry(entryName2 + '/');
                } else if (isSymbolicLink) {
                    TarEntry e = new TarEntry(entryName2, TarConstants.LF_SYMLINK);
                    e.setLinkName(Files.readSymbolicLink(org.openmole.tool.file.package$.MODULE$.file2Path(source2)).toString());
                    tarEntry = e;
                } else {
                    TarEntry e = new TarEntry(entryName2);
                    e.setSize(Files.size(org.openmole.tool.file.package$.MODULE$.file2Path(source2)));
                    tarEntry = e;
                }
                TarEntry e = tarEntry;
                File file = source2;
                File file2 = directory;
                if (!(file == null ? file2 != null : !((Object)file).equals(file2))) continue;
                if (!isSymbolicLink) {
                    e.setMode(org.openmole.tool.file.package$.MODULE$.FileDecorator(source2).mode());
                }
                e.setModTime(source2.lastModified());
                additionalCommand.apply((Object)e);
                tos.putNextEntry(e);
                if (!Files.isRegularFile(org.openmole.tool.file.package$.MODULE$.file2Path(source2), LinkOption.NOFOLLOW_LINKS)) continue;
                try {
                    Files.copy(org.openmole.tool.file.package$.MODULE$.file2Path(source2), tos);
                }
                finally {
                    tos.closeEntry();
                }
            }
        }
    }
}

