/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.serializer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.core.DefaultConverterLookup;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.binary.BinaryStreamDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.serializer.PluginAndFilesListing;
import org.openmole.core.serializer.SerializerService$;
import org.openmole.core.serializer.converter.Serialiser;
import org.openmole.core.serializer.file.FileInjection;
import org.openmole.core.serializer.file.FileSerialisation$;
import org.openmole.core.serializer.file.FileWithGCConverter;
import org.openmole.core.serializer.structure.PluginClassAndFiles;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.tool.archive.TarInputStream;
import org.openmole.tool.archive.TarOutputStream;
import org.openmole.tool.archive.package;
import org.openmole.tool.archive.package$package$;
import org.openmole.tool.file.FilePackage;
import org.openmole.tool.file.package$;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Map;
import scala.collection.immutable.TreeSet;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class SerializerService {
    private final String content;

    public static SerializerService apply() {
        return SerializerService$.MODULE$.apply();
    }

    public SerializerService() {
        this.content = "content.xml";
    }

    public XStream buildXStream(boolean json) {
        DefaultConverterLookup lookup = new DefaultConverterLookup();
        JsonHierarchicalStreamDriver driver = json ? new JsonHierarchicalStreamDriver() : new BinaryStreamDriver();
        XStream xs = new XStream(null, (HierarchicalStreamDriver)driver, new ClassLoaderReference(this.getClass().getClassLoader()), null, (ConverterLookup)lookup, new ConverterRegistry(lookup){
            private final DefaultConverterLookup lookup$1;
            {
                this.lookup$1 = lookup$2;
            }

            public void registerConverter(Converter c, int p) {
                this.lookup$1.registerConverter(c, p);
            }
        });
        xs.addPermission(NoTypePermission.NONE);
        xs.addPermission(new TypePermission(){

            public boolean allows(Class type) {
                return true;
            }
        });
        xs.registerConverter((Converter)new FileWithGCConverter());
        return xs;
    }

    public boolean buildXStream$default$1() {
        return false;
    }

    private XStream fileSerialisation() {
        return this.buildXStream(this.buildXStream$default$1());
    }

    private Serialiser pluginAndFileListing() {
        return new PluginAndFilesListing(this){
            public static final long OFFSET$0;
            private volatile Object reflectionConverter$lzy1;
            private TreeSet org$openmole$core$serializer$PluginAndFilesListing$$plugins;
            private TreeSet org$openmole$core$serializer$PluginAndFilesListing$$listedFiles;
            private HashSet org$openmole$core$serializer$PluginAndFilesListing$$seenClasses;
            private HashSet org$openmole$core$serializer$PluginAndFilesListing$$replClasses;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer);
                PluginAndFilesListing.$init$(this);
            }

            static {
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$3.class.getDeclaredField("reflectionConverter$lzy1"));
            }

            public ReflectionConverter reflectionConverter() {
                Object object = this.reflectionConverter$lzy1;
                if (object instanceof ReflectionConverter) {
                    return (ReflectionConverter)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (ReflectionConverter)this.reflectionConverter$lzyINIT1();
            }

            private Object reflectionConverter$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.reflectionConverter$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            ReflectionConverter reflectionConverter = null;
                            try {
                                reflectionConverter = PluginAndFilesListing.reflectionConverter$(this);
                                object2 = reflectionConverter == null ? LazyVals.NullValue$.MODULE$ : reflectionConverter;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.reflectionConverter$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return reflectionConverter;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            public TreeSet org$openmole$core$serializer$PluginAndFilesListing$$plugins() {
                return this.org$openmole$core$serializer$PluginAndFilesListing$$plugins;
            }

            public TreeSet org$openmole$core$serializer$PluginAndFilesListing$$listedFiles() {
                return this.org$openmole$core$serializer$PluginAndFilesListing$$listedFiles;
            }

            public HashSet org$openmole$core$serializer$PluginAndFilesListing$$seenClasses() {
                return this.org$openmole$core$serializer$PluginAndFilesListing$$seenClasses;
            }

            public HashSet org$openmole$core$serializer$PluginAndFilesListing$$replClasses() {
                return this.org$openmole$core$serializer$PluginAndFilesListing$$replClasses;
            }

            public void org$openmole$core$serializer$PluginAndFilesListing$$plugins_$eq(TreeSet x$1) {
                this.org$openmole$core$serializer$PluginAndFilesListing$$plugins = x$1;
            }

            public void org$openmole$core$serializer$PluginAndFilesListing$$listedFiles_$eq(TreeSet x$1) {
                this.org$openmole$core$serializer$PluginAndFilesListing$$listedFiles = x$1;
            }

            public void org$openmole$core$serializer$PluginAndFilesListing$$seenClasses_$eq(HashSet x$1) {
                this.org$openmole$core$serializer$PluginAndFilesListing$$seenClasses = x$1;
            }

            public void org$openmole$core$serializer$PluginAndFilesListing$$replClasses_$eq(HashSet x$1) {
                this.org$openmole$core$serializer$PluginAndFilesListing$$replClasses = x$1;
            }
        };
    }

    private FileInjection deserializerWithFileInjection() {
        return new FileInjection(this){
            private Map injectedFiles;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer);
                FileInjection.$init$(this);
            }

            public Map injectedFiles() {
                return this.injectedFiles;
            }

            public void injectedFiles_$eq(Map x$1) {
                this.injectedFiles = x$1;
            }

            public /* synthetic */ void org$openmole$core$serializer$file$FileInjection$$super$clean() {
                super.clean();
            }
        };
    }

    public <T> T deserialize(File file) {
        T t;
        try (FileInputStream is = new FileInputStream(file);){
            t = this.deserialize(is);
        }
        return t;
    }

    public <T> T deserialize(InputStream is) {
        return (T)this.buildXStream(this.buildXStream$default$1()).fromXML(is);
    }

    public <T> T deserializeFromString(String s, boolean json) {
        return (T)this.buildXStream(json).fromXML(s);
    }

    public boolean deserializeFromString$default$2() {
        return false;
    }

    public <T> T deserializeAndExtractFiles(File file, boolean deleteFilesOnGC, boolean gz, TmpDirectory newFile, FileService fileService) {
        T t;
        try (TarInputStream tis = new TarInputStream((InputStream)package$.MODULE$.FileDecorator(file).bufferedInputStream(gz));){
            t = this.deserializeAndExtractFiles(tis, deleteFilesOnGC, newFile, fileService);
        }
        return t;
    }

    public boolean deserializeAndExtractFiles$default$3() {
        return false;
    }

    public <T> T deserializeAndExtractFiles(TarInputStream tis, boolean deleteFilesOnGC, TmpDirectory newFile, FileService fileService) {
        return (T)newFile.withTmpDir((Function1 & Serializable)archiveExtractDir -> {
            package.package.TarInputStreamDecorator tarInputStreamDecorator = package$package$.MODULE$.TarInputStreamDecorator(tis);
            tarInputStreamDecorator.extract(archiveExtractDir, tarInputStreamDecorator.extract$default$2());
            Map<String, File> fileReplacement = FileSerialisation$.MODULE$.deserialiseFileReplacements((File)archiveExtractDir, this.fileSerialisation(), deleteFilesOnGC, newFile, fileService);
            File contentFile = new File((File)archiveExtractDir, this.content);
            return this.deserializeReplaceFiles(contentFile, fileReplacement, false);
        });
    }

    public void serializeAndArchiveFiles(Object obj, File f, boolean gz, TmpDirectory newFile) {
        FilePackage.FileDecorator fileDecorator = package$.MODULE$.FileDecorator(f);
        try (TarOutputStream os = new TarOutputStream((OutputStream)fileDecorator.bufferedOutputStream(fileDecorator.bufferedOutputStream$default$1(), gz));){
            this.serializeAndArchiveFiles(obj, os, newFile);
        }
    }

    public boolean serializeAndArchiveFiles$default$3() {
        return false;
    }

    public void serializeAndArchiveFiles(Object obj, TarOutputStream tos, TmpDirectory newFile) {
        newFile.withTmpFile((Function1 & Serializable)objSerial -> {
            this.serialize(obj, (File)objSerial, this.serialize$default$3(), this.serialize$default$4());
            return package$package$.MODULE$.TarOutputStreamDecorator(tos).addFile(objSerial, this.content);
        });
        PluginClassAndFiles serializationResult = this.pluginsAndFiles(obj);
        FileSerialisation$.MODULE$.serialiseFiles((Iterable<File>)serializationResult.files(), tos, this.fileSerialisation(), newFile);
    }

    public PluginClassAndFiles pluginsAndFiles(Object obj) {
        return ((PluginAndFilesListing)((Object)this.pluginAndFileListing())).list(obj);
    }

    public <T> T deserializeReplaceFiles(File file, Map<String, File> files, boolean gz) {
        T t;
        try (FilterInputStream is = package$.MODULE$.FileDecorator(file).bufferedInputStream(gz);){
            t = this.deserializeReplaceFiles(is, files);
        }
        return t;
    }

    public boolean deserializeReplaceFiles$default$3() {
        return false;
    }

    public <T> T deserializeReplaceFiles(InputStream is, Map<String, File> files) {
        FileInjection serializer = this.deserializerWithFileInjection();
        serializer.injectedFiles_$eq(files);
        return serializer.fromXML(is);
    }

    public String serializeToString(Object obj, boolean json) {
        return this.buildXStream(json).toXML(obj);
    }

    public boolean serializeToString$default$2() {
        return false;
    }

    public void serialize(Object obj, OutputStream os) {
        this.buildXStream(this.buildXStream$default$1()).toXML(obj, os);
    }

    public void serialize(Object obj, File file, boolean json, boolean gz) {
        FilePackage.FileDecorator fileDecorator = package$.MODULE$.FileDecorator(file);
        try (BufferedOutputStream os = fileDecorator.bufferedOutputStream(fileDecorator.bufferedOutputStream$default$1(), gz);){
            this.buildXStream(json).toXML(obj, (OutputStream)os);
        }
    }

    public boolean serialize$default$3() {
        return false;
    }

    public boolean serialize$default$4() {
        return false;
    }
}

