/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.compiler;

import dotty.tools.dotc.interfaces.Diagnostic;
import dotty.tools.dotc.interfaces.SourcePosition;
import dotty.tools.repl.AbstractFileClassLoader;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Optional;
import org.openmole.core.compiler.CompositeClassLoader;
import org.openmole.core.compiler.Interpreter;
import org.openmole.core.compiler.Interpreter$CompilationError$;
import org.openmole.core.compiler.Interpreter$CompletionCandidate$;
import org.openmole.core.compiler.Interpreter$ErrorMessage$;
import org.openmole.core.compiler.Interpreter$ErrorPosition$;
import org.openmole.core.compiler.Interpreter$HeaderInfo$;
import org.openmole.core.compiler.Interpreter$RawCompiled$;
import org.openmole.core.compiler.repl.REPLDriver;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.pluginmanager.Activator$;
import org.openmole.core.pluginmanager.PluginManager$;
import org.openmole.core.workspace.TmpDirectory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class Interpreter$
implements Serializable {
    public static final Interpreter$CompilationError$ CompilationError;
    public static final Interpreter$ErrorMessage$ ErrorMessage;
    public static final Interpreter$ErrorPosition$ ErrorPosition;
    public static final Interpreter$CompletionCandidate$ CompletionCandidate;
    public static final Interpreter$HeaderInfo$ HeaderInfo;
    public static final Interpreter$RawCompiled$ RawCompiled;
    public static final Interpreter$ MODULE$;

    private Interpreter$() {
    }

    static {
        MODULE$ = new Interpreter$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Interpreter$.class);
    }

    public boolean isInterpretedClass(Class<?> c) {
        return c.getClassLoader() != null && AbstractFileClassLoader.class.isAssignableFrom(c.getClassLoader().getClass());
    }

    public String compilationMessage(List<Interpreter.ErrorMessage> errorMessages, String code, int lineOffset) {
        Tuple2 tuple2 = errorMessages.partition((Function1 & Serializable)e -> BoxesRunTime.unboxToBoolean((Object)e.position().map((Function1 & Serializable)_$1 -> _$1.line() < 0).getOrElse(this::$anonfun$1$$anonfun$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List importsErrors = (List)tuple2._1();
        List codeErrors = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)importsErrors, (Object)codeErrors);
        List importsErrors2 = (List)tuple22._1();
        List codeErrors2 = (List)tuple22._2();
        return (String)(!codeErrors2.isEmpty() ? codeErrors2.map((Function1 & Serializable)error -> this.readableErrorMessages$1(lineOffset, (Interpreter.ErrorMessage)error)).mkString("\n") + "\n" : "") + (String)(!importsErrors2.filter((Function1 & Serializable)_$2 -> _$2.error()).isEmpty() ? "Error in imports header:\n" + importsErrors2.filter((Function1 & Serializable)_$3 -> _$3.error()).map((Function1 & Serializable)error -> this.readableErrorMessages$1(lineOffset, (Interpreter.ErrorMessage)error)).mkString("\n") + "\n" : "") + StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Compiling code:\n        |" + code));
    }

    public int compilationMessage$default$3() {
        return 0;
    }

    public Throwable errorMessagesToException(List<Interpreter.ErrorMessage> messages, String code) {
        return Interpreter$CompilationError$.MODULE$.apply(messages, code);
    }

    public Interpreter.HeaderInfo firstLine(String file) {
        return Interpreter$HeaderInfo$.MODULE$.apply(file);
    }

    public Interpreter.ErrorMessage diagnosticToErrorMessage(Diagnostic diagnostic) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(diagnostic.position());
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
        if (None$.MODULE$.equals(option)) {
            return Interpreter$ErrorMessage$.MODULE$.apply(diagnostic.message(), diagnostic.message(), (Option<Interpreter.ErrorPosition>)None$.MODULE$, diagnostic.level() == 2);
        }
        if (option instanceof Some) {
            SourcePosition pos = (SourcePosition)((Some)option).value();
            Object[] compiled = new String(pos.source().content()).split("\n");
            int firstLine = 0;
            Object object = Predef$.MODULE$.refArrayOps(compiled);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(object, firstLine));
            int offset = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$4 -> _$4.length() + 1, ClassTag$.MODULE$.apply(Integer.TYPE))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            return Interpreter$ErrorMessage$.MODULE$.apply(this.decoratedMessage$1(diagnostic, pos, (String[])compiled), diagnostic.message(), (Option<Interpreter.ErrorPosition>)Some$.MODULE$.apply((Object)this.errorPos$1(pos, firstLine, offset)), diagnostic.level() == 2);
        }
        throw new MatchError((Object)option);
    }

    public CompositeClassLoader classLoader(Function0<Seq<Bundle>> priorityBundles, Seq<File> jars) {
        Object[] objectArray = new URLClassLoader[1];
        Object object = Predef$.MODULE$.refArrayOps((Object[])jars.toArray(ClassTag$.MODULE$.apply(File.class)));
        objectArray[0] = new URLClassLoader((URL[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$7 -> _$7.toURI().toURL(), ClassTag$.MODULE$.apply(URL.class)));
        return new CompositeClassLoader((Seq<ClassLoader>)((Seq)((IterableOps)((IterableOps)((IterableOps)priorityBundles.apply()).map((Function1 & Serializable)_$6 -> org.openmole.core.pluginmanager.package$.MODULE$.BundleDecorator(_$6).classLoader())).$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ClassLoader[]{Interpreter.class.getClassLoader()})))));
    }

    public Seq<String> classPath(Seq<Bundle> priorityBundles, Seq<File> jars) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])((BundleContext)Activator$.MODULE$.context().get()).getBundles());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$9 -> !org.openmole.core.pluginmanager.package$.MODULE$.BundleDecorator(_$9).isSystem()));
        return (Seq)((SeqOps)((IterableOps)((IterableOps)((IterableOps)priorityBundles.map((Function1 & Serializable)b -> this.toPath$1((Bundle)b))).$plus$plus((IterableOnce)jars.map((Function1 & Serializable)_$8 -> _$8.getCanonicalPath()))).$plus$plus((IterableOnce)PluginManager$.MODULE$.bundlesForClass(this.getClass()).map((Function1 & Serializable)b -> this.toPath$1((Bundle)b)))).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)b -> this.toPath$1((Bundle)b), ClassTag$.MODULE$.apply(String.class))))).distinct();
    }

    public REPLDriver driver(File classDirectory, Seq<Bundle> priorityBundles, Seq<File> jars, boolean quiet) {
        classDirectory.mkdirs();
        Option option = Activator$.MODULE$.context();
        if (option instanceof Some) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])new String[]{"-classpath", this.classPath(priorityBundles, jars).mkString(":"), "-color:never", "-d", classDirectory.getAbsolutePath()});
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(object, (IterableOnce)(quiet ? package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-Xrepl-disable-display"})) : package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))), ClassTag$.MODULE$.apply(String.class)));
            return new REPLDriver((String[])ArrayOps$.MODULE$.$plus$plus$extension(object2, (IterableOnce)this.commonOptions$1(), ClassTag$.MODULE$.apply(String.class)), Console$.MODULE$.out(), (Option<ClassLoader>)Some$.MODULE$.apply((Object)this.classLoader((Function0<Seq<Bundle>>)((Function0 & Serializable)() -> this.driver$$anonfun$1(priorityBundles)), jars)));
        }
        if (None$.MODULE$.equals(option)) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])new String[]{"-classpath", System.getProperty("java.class.path"), "-color:never", "-d", classDirectory.getAbsolutePath()});
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(object, (IterableOnce)(quiet ? package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-Xrepl-disable-display"})) : package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))), ClassTag$.MODULE$.apply(String.class)));
            return new REPLDriver((String[])ArrayOps$.MODULE$.$plus$plus$extension(object3, (IterableOnce)this.commonOptions$1(), ClassTag$.MODULE$.apply(String.class)), Console$.MODULE$.out(), (Option<ClassLoader>)Some$.MODULE$.apply((Object)this.classLoader((Function0<Seq<Bundle>>)((Function0 & Serializable)() -> this.driver$$anonfun$2(priorityBundles)), jars)));
        }
        throw new MatchError((Object)option);
    }

    public Interpreter apply(Function0<Seq<Bundle>> priorityBundles, Seq<File> jars, boolean quiet, TmpDirectory newFile, FileService fileService) {
        File classDirectory = fileService.wrapRemoveOnGC(newFile.newDir("classDirectory", newFile.newDir$default$2()));
        REPLDriver drv = this.driver(classDirectory, (Seq<Bundle>)((Seq)priorityBundles.apply()), jars, quiet);
        return new Interpreter(drv, classDirectory);
    }

    public Nil$ apply$default$1() {
        return package$.MODULE$.Nil();
    }

    public Seq<File> apply$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean apply$default$3() {
        return true;
    }

    private final String readableErrorMessages$1$$anonfun$2() {
        return "";
    }

    private final String readableErrorMessages$1(int lineOffset$1, Interpreter.ErrorMessage error) {
        return (String)error.position().map((Function1 & Serializable)p -> "(line " + (p.line() - lineOffset$1) + ") ").getOrElse(this::readableErrorMessages$1$$anonfun$2) + error.decoratedMessage();
    }

    private final boolean $anonfun$1$$anonfun$2() {
        return false;
    }

    private final Interpreter.ErrorPosition errorPos$1(SourcePosition pos$1, int firstLine$1, int offset$1) {
        return Interpreter$ErrorPosition$.MODULE$.apply(pos$1.line() - firstLine$1, pos$1.start() - offset$1, pos$1.end() - offset$1, pos$1.point() - offset$1);
    }

    private final String decoratedMessage$1(Diagnostic diagnostic$1, SourcePosition pos$2, String[] compiled$2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])compiled$2);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(object, pos$2.line()));
        int offsetOfError = pos$2.point() - BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$5 -> _$5.length() + 1, ClassTag$.MODULE$.apply(Integer.TYPE))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(diagnostic$1.message() + "\n                |" + compiled$2[pos$2.line()] + "\n                |" + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), offsetOfError) + "^"));
    }

    private final String toPath$1(Bundle b) {
        return new URL(b.getLocation()).getPath();
    }

    private final Seq commonOptions$1() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-language:postfixOps", "-language:implicitConversions", "-nowarn"}));
    }

    private final Seq driver$$anonfun$1(Seq priorityBundles$1) {
        return priorityBundles$1;
    }

    private final Seq driver$$anonfun$2(Seq priorityBundles$2) {
        return priorityBundles$2;
    }
}

