/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.compiler.repl;

import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.printing.Formatting;
import dotty.tools.dotc.printing.Highlighting;
import dotty.tools.dotc.printing.SyntaxHighlighting$;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.reporting.Diagnostic$;
import dotty.tools.dotc.reporting.ErrorMessageID;
import dotty.tools.dotc.reporting.ErrorMessageID$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.dotc.reporting.MessageKind;
import dotty.tools.dotc.reporting.MessageKind$;
import dotty.tools.dotc.util.NoSourcePosition$;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import java.io.Serializable;
import org.openmole.core.compiler.repl.Highlight$;
import org.openmole.core.compiler.repl.Highlight$Level$;
import org.openmole.core.compiler.repl.Offsets$;
import org.openmole.core.compiler.repl.Offsets$Offset$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyInt;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public interface MessageRendering {
    public static String stripColor$(MessageRendering $this, String str) {
        return $this.stripColor(str);
    }

    default public String stripColor(String str) {
        return str.replaceAll("\u001b\\[.*?m", "");
    }

    public static List inlinePosStack$(MessageRendering $this, SourcePosition pos) {
        return $this.inlinePosStack(pos);
    }

    default public List<SourcePosition> inlinePosStack(SourcePosition pos) {
        if (pos.outer() != null && pos.outer().exists()) {
            return this.inlinePosStack(pos.outer()).$colon$colon((Object)pos);
        }
        return package$.MODULE$.Nil();
    }

    private Tuple3<List<String>, List<String>, Object> sourceLines(SourcePosition pos, Contexts.Context x$2, int x$3, int x$4) {
        if (!pos.exists() || !pos.source().file().exists()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        IntRef maxLen = IntRef.create((int)Integer.MIN_VALUE);
        Object object = Settings.Setting$.MODULE$.value(x$2.settings().color(), x$2);
        String string = "never";
        char[] syntax = (object == null ? string != null : !object.equals(string)) ? SyntaxHighlighting$.MODULE$.highlight(new String(pos.linesSlice()), x$2).toCharArray() : pos.linesSlice();
        List lines = MessageRendering.linesFrom$1(syntax);
        Tuple2 tuple2 = pos.beforeAndAfterPoint();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List before = (List)tuple2._1();
        List after = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)before, (Object)after);
        List before2 = (List)tuple22._1();
        List after2 = (List)tuple22._2();
        return Tuple3$.MODULE$.apply((Object)((List)before2.zip((IterableOnce)lines)).map((Function1 & Serializable)offsetAndLine -> this.render$1(pos, x$2, x$3, x$4, maxLen, (Tuple2)offsetAndLine)), (Object)((List)after2.zip((IterableOnce)lines.drop(before2.length()))).map((Function1 & Serializable)offsetAndLine -> this.render$1(pos, x$2, x$3, x$4, maxLen, (Tuple2)offsetAndLine)), (Object)BoxesRunTime.boxToInteger((int)maxLen.elem));
    }

    private String boxTitle(String title, Contexts.Context x$2, int x$3, int x$4) {
        int pageWidth = BoxesRunTime.unboxToInt((Object)Settings.Setting$.MODULE$.value(x$2.settings().pageWidth(), x$2));
        String line = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), pageWidth - title.length() - 4);
        return this.hl("-- " + title + " " + line, x$2, x$3);
    }

    private String positionMarker(SourcePosition pos, Contexts.Context x$2, int x$3, int x$4) {
        String padding = pos.startColumnPadding();
        String carets = pos.startLine() == pos.endLine() ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("^"), scala.math.package$.MODULE$.max(1, pos.endColumn() - pos.startColumn())) : "^";
        return this.hl(this.offsetBox(x$2, x$3, x$4) + padding + carets, x$2, x$3);
    }

    private String offsetBox(Contexts.Context x$1, int x$2, int x$3) {
        String prefix = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), Offsets$.MODULE$.offset(x$3) - 1);
        return this.hl(prefix + "|", x$1, x$2);
    }

    private String newBox(boolean soft, Contexts.Context x$2, int x$3, int x$4) {
        int pageWidth = BoxesRunTime.unboxToInt((Object)Settings.Setting$.MODULE$.value(x$2.settings().pageWidth(), x$2));
        String prefix = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), Offsets$.MODULE$.offset(x$4) - 1);
        int lineWidth = pageWidth - Offsets$.MODULE$.offset(x$4);
        String line = soft ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("- "), (lineWidth + 1) / 2).trim() : StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), lineWidth);
        return this.hl(prefix + "|" + line, x$2, x$3);
    }

    private boolean newBox$default$1() {
        return false;
    }

    private String endBox(Contexts.Context x$1, int x$2, int x$3) {
        int pageWidth = BoxesRunTime.unboxToInt((Object)Settings.Setting$.MODULE$.value(x$1.settings().pageWidth(), x$1));
        String prefix = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), Offsets$.MODULE$.offset(x$3) - 1);
        String line = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("-"), pageWidth - Offsets$.MODULE$.offset(x$3));
        return this.hl(prefix + " " + line, x$1, x$2);
    }

    private String errorMsg(SourcePosition pos, String msg, Contexts.Context x$3, int x$4, int x$5) {
        String padding = (String)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(msg)).foldLeft((Object)pos.startColumnPadding(), (Function2 & Serializable)(pad, line) -> {
            int lineLength = this.stripColor((String)line).length();
            int maxPad = scala.math.package$.MODULE$.max(0, BoxesRunTime.unboxToInt((Object)Settings.Setting$.MODULE$.value(x$3.settings().pageWidth(), x$3)) - Offsets$.MODULE$.offset(x$5) - lineLength) - Offsets$.MODULE$.offset(x$5);
            if (maxPad < pad.length()) {
                return StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maxPad);
            }
            return pad;
        });
        return StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(msg)).map((Function1 & Serializable)line -> this.offsetBox(x$3, x$4, x$5) + (String)(line.isEmpty() ? "" : padding + line)).mkString(System.lineSeparator());
    }

    public static String posFileStr$(MessageRendering $this, SourcePosition pos) {
        return $this.posFileStr(pos);
    }

    default public String posFileStr(SourcePosition pos) {
        String path = pos.source().file().path();
        if (pos.exists()) {
            return path + ":" + (pos.line() + 1) + ":" + pos.column();
        }
        return path;
    }

    private String posStr(SourcePosition pos, Message message, String diagnosticString, Contexts.Context x$4, int x$5, int x$6) {
        if (!message.errorId().isActive()) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Attempting to use an ErrorMessageID that is marked as inactive.\n         |The ID either needs to be marked as active or you need to use another.")));
        }
        SourceFile sourceFile = pos.source();
        SourceFile sourceFile2 = NoSourcePosition$.MODULE$.source();
        if (sourceFile == null ? sourceFile2 != null : !sourceFile.equals(sourceFile2)) {
            Object object;
            SourcePosition realPos = pos.nonInlined();
            String fileAndPos = this.posFileStr(realPos);
            ErrorMessageID errorMessageID = message.errorId();
            ErrorMessageID errorMessageID2 = ErrorMessageID$.NoExplanationID;
            if (errorMessageID == null ? errorMessageID2 != null : !errorMessageID.equals(errorMessageID2)) {
                int errorNumber = message.errorId().errorNumber();
                object = "[E" + (StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 3 - BoxesRunTime.boxToInteger((int)errorNumber).toString().length()) + errorNumber) + "] ";
            } else {
                object = "";
            }
            String errId = object;
            MessageKind messageKind = message.kind();
            MessageKind messageKind2 = MessageKind$.NoKind;
            String kind = !(messageKind != null ? !messageKind.equals(messageKind2) : messageKind2 != null) ? diagnosticString : message.kind().message() + " " + diagnosticString;
            String title = fileAndPos.isEmpty() ? errId + kind + ":" : errId + kind + ": " + fileAndPos;
            return this.hl(this.boxTitle(title, x$4, x$5, x$6), x$4, x$5);
        }
        return "";
    }

    public static String explanation$(MessageRendering $this, Message m, Contexts.Context x$2) {
        return $this.explanation(m, x$2);
    }

    default public String explanation(Message m, Contexts.Context x$2) {
        StringBuilder sb = new StringBuilder(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|\n          |" + Highlighting.Blue$.MODULE$.apply("Explanation").show(x$2) + "\n          |" + Highlighting.Blue$.MODULE$.apply("===========").show(x$2))));
        sb.append(System.lineSeparator()).append(m.explanation());
        if (!m.explanation().endsWith(System.lineSeparator())) {
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private void appendFilterHelp(Diagnostic dia, StringBuilder sb) {
        String category;
        boolean hasId = dia.msg().errorId().errorNumber() >= 0;
        Diagnostic diagnostic = dia;
        String string = diagnostic instanceof Diagnostic.UncheckedWarning ? "unchecked" : (diagnostic instanceof Diagnostic.DeprecationWarning ? "deprecation" : (category = diagnostic instanceof Diagnostic.FeatureWarning ? "feature" : ""));
        if (hasId || StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(category))) {
            sb.append(System.lineSeparator()).append("Matching filters for @nowarn or -Wconf:");
            if (hasId) {
                sb.append(System.lineSeparator()).append("  - id=E").append(dia.msg().errorId().errorNumber());
                sb.append(System.lineSeparator()).append("  - name=").append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(dia.msg().errorId().productPrefix()), "ID"));
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(category))) {
                sb.append(System.lineSeparator()).append("  - cat=").append(category);
                return;
            }
            return;
        }
    }

    public static String messageAndPos$(MessageRendering $this, Diagnostic dia, Contexts.Context x$2) {
        return $this.messageAndPos(dia, x$2);
    }

    default public String messageAndPos(Diagnostic dia, Contexts.Context x$2) {
        StringBuilder stringBuilder;
        LazyInt lazyInt = new LazyInt();
        LazyInt lazyInt2 = new LazyInt();
        SourcePosition pos1 = dia.pos().nonInlined();
        List inlineStack = this.inlinePosStack(dia.pos()).filter((Function1 & Serializable)_$2 -> {
            SourcePosition sourcePosition = _$2;
            SourcePosition sourcePosition2 = pos1;
            return sourcePosition == null ? sourcePosition2 != null : !sourcePosition.equals(sourcePosition2);
        });
        int maxLineNumber = dia.pos().exists() ? BoxesRunTime.unboxToInt((Object)inlineStack.$colon$colon((Object)pos1).map((Function1 & Serializable)_$3 -> _$3.endLine()).max((Ordering)Ordering.Int$.MODULE$)) + 1 : 0;
        StringBuilder sb = new StringBuilder();
        String posString = this.posStr(dia.pos(), dia.msg(), this.diagnosticLevel(dia), x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(posString))) {
            sb.append(posString).append(System.lineSeparator());
        }
        if (dia.pos().exists()) {
            SourcePosition pos12 = dia.pos().nonInlined();
            if (pos12.exists() && pos12.source().file().exists()) {
                Tuple3<List<String>, List<String>, Object> tuple3 = this.sourceLines(pos12, x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2));
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                List srcBefore = (List)tuple3._1();
                List srcAfter = (List)tuple3._2();
                int offset = BoxesRunTime.unboxToInt((Object)tuple3._3());
                Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)srcBefore, (Object)srcAfter, (Object)BoxesRunTime.boxToInteger((int)offset));
                List srcBefore2 = (List)tuple32._1();
                List srcAfter2 = (List)tuple32._2();
                int offset2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
                String marker = this.positionMarker(pos12, x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2));
                String err = this.errorMsg(pos12, dia.msg().message(), x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2));
                sb.append(srcAfter2.$colon$colon((Object)err).$colon$colon((Object)marker).$colon$colon$colon(srcBefore2).mkString(System.lineSeparator()));
                if (inlineStack.nonEmpty()) {
                    sb.append(System.lineSeparator()).append(this.newBox(this.newBox$default$1(), x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2)));
                    sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2))).append(Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Inline stack trace"})), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$2));
                    inlineStack.withFilter((Function1 & Serializable)inlinedPos -> {
                        SourcePosition sourcePosition = inlinedPos;
                        SourcePosition sourcePosition2 = pos12;
                        return sourcePosition == null ? sourcePosition2 != null : !sourcePosition.equals(sourcePosition2);
                    }).foreach((Function1)(JProcedure1 & Serializable)inlinedPos -> {
                        sb.append(System.lineSeparator()).append(this.newBox(true, x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2)));
                        sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2))).append(Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"This location contains code that was inlined from ", ""})), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting.ShownDef$.Shown$.MODULE$.given_Conversion_A_Shown(Formatting.ShownDef$.Show$.MODULE$.given_Show_Showable()).apply((Object)dia.pos())}), x$2));
                        if (inlinedPos.source().file().exists()) {
                            Tuple3<List<String>, List<String>, Object> tuple3 = this.sourceLines((SourcePosition)inlinedPos, x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2));
                            if (tuple3 == null) {
                                throw new MatchError(tuple3);
                            }
                            List srcBefore = (List)tuple3._1();
                            List srcAfter = (List)tuple3._2();
                            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)srcBefore, (Object)srcAfter);
                            List srcBefore2 = (List)tuple2._1();
                            List srcAfter2 = (List)tuple2._2();
                            String marker = this.positionMarker((SourcePosition)inlinedPos, x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2));
                            sb.append(System.lineSeparator()).append(srcAfter2.$colon$colon((Object)marker).$colon$colon$colon(srcBefore2).mkString(System.lineSeparator()));
                            return;
                        }
                    });
                    sb.append(System.lineSeparator()).append(this.endBox(x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2)));
                    stringBuilder = BoxedUnit.UNIT;
                } else {
                    stringBuilder = BoxedUnit.UNIT;
                }
            } else {
                stringBuilder = sb.append(dia.msg().message());
            }
        } else {
            stringBuilder = sb.append(dia.msg().message());
        }
        if (dia.isVerbose()) {
            this.appendFilterHelp(dia, sb);
        }
        if (Diagnostic$.MODULE$.shouldExplain(dia, x$2)) {
            sb.append(System.lineSeparator()).append(this.newBox(this.newBox$default$1(), x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2)));
            sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2))).append(" Explanation (enabled by `-explain`)");
            sb.append(System.lineSeparator()).append(this.newBox(true, x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2)));
            Object object = Predef$.MODULE$.refArrayOps((Object[])dia.msg().explanation().split("\\R"));
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)line -> sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2))).append(line.isEmpty() ? "" : " ").append(line));
            sb.append(System.lineSeparator()).append(this.endBox(x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2)));
        } else if (dia.msg().canExplain()) {
            sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2)));
            sb.append(System.lineSeparator()).append(this.offsetBox(x$2, MessageRendering.given_Level$1(dia, lazyInt), MessageRendering.given_Offset$1(maxLineNumber, lazyInt2))).append(" longer explanation available when compiling with `-explain`");
        }
        return sb.toString();
    }

    public static String hl$(MessageRendering $this, String str, Contexts.Context x$2, int x$3) {
        return $this.hl(str, x$2, x$3);
    }

    default public String hl(String str, Contexts.Context x$2, int x$3) {
        int n = Highlight$.MODULE$.value(x$3);
        switch (n) {
            case 2: {
                return Highlighting.Red$.MODULE$.apply(str).show(x$2);
            }
            case 1: {
                return Highlighting.Yellow$.MODULE$.apply(str).show(x$2);
            }
            case 0: {
                return Highlighting.Blue$.MODULE$.apply(str).show(x$2);
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private String diagnosticLevel(Diagnostic dia) {
        Diagnostic diagnostic = dia;
        if (diagnostic instanceof Diagnostic.FeatureWarning) {
            Diagnostic.FeatureWarning dia2 = (Diagnostic.FeatureWarning)diagnostic;
            return "Feature Warning";
        }
        if (diagnostic instanceof Diagnostic.DeprecationWarning) {
            Diagnostic.DeprecationWarning dia3 = (Diagnostic.DeprecationWarning)diagnostic;
            return "Deprecation Warning";
        }
        if (diagnostic instanceof Diagnostic.UncheckedWarning) {
            Diagnostic.UncheckedWarning dia4 = (Diagnostic.UncheckedWarning)diagnostic;
            return "Unchecked Warning";
        }
        if (diagnostic instanceof Diagnostic.MigrationWarning) {
            Diagnostic.MigrationWarning dia5 = (Diagnostic.MigrationWarning)diagnostic;
            return "Migration Warning";
        }
        int n = dia.level();
        switch (n) {
            case 2: {
                return "Error";
            }
            case 1: {
                return "Warning";
            }
            case 0: {
                return "Info";
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private String render$1(SourcePosition pos$1, Contexts.Context x$2$1, int x$3$1, int x$4$1, IntRef maxLen$1, Tuple2 offsetAndLine) {
        int n;
        Tuple2 tuple2 = offsetAndLine;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int offset1 = BoxesRunTime.unboxToInt((Object)tuple2._1());
        String line = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)offset1), (Object)line);
        int offset12 = BoxesRunTime.unboxToInt((Object)tuple22._1());
        String line2 = (String)tuple22._2();
        String lineNbr = BoxesRunTime.boxToInteger((int)(pos$1.source().offsetToLine(offset12) + 1)).toString();
        String prefix = String.format("%" + (Offsets$.MODULE$.offset(x$4$1) - 2) + "s |", lineNbr);
        maxLen$1.elem = n = scala.math.package$.MODULE$.max(maxLen$1.elem, prefix.length());
        String lnum = this.hl(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), scala.math.package$.MODULE$.max(0, maxLen$1.elem - prefix.length() - 1)) + prefix, x$2$1, x$3$1);
        return lnum + StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(line2));
    }

    private static boolean pred$1(char c) {
        char c2 = c;
        switch (c2) {
            case '\n': 
            case '\f': 
            case '\r': 
            case '\u001a': {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ boolean $anonfun$1(char _$1) {
        return !MessageRendering.pred$1(_$1);
    }

    private static List linesFrom$1(char[] arr) {
        Object object = Predef$.MODULE$.charArrayOps(arr);
        Tuple2 tuple2 = ArrayOps$.MODULE$.span$extension(object, (Function1 & Serializable)_$1 -> MessageRendering.$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        char[] line = (char[])tuple2._1();
        char[] rest0 = (char[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)line, (Object)rest0);
        char[] line2 = (char[])tuple22._1();
        char[] rest02 = (char[])tuple22._2();
        Object object2 = Predef$.MODULE$.charArrayOps(rest02);
        Tuple2 tuple23 = ArrayOps$.MODULE$.span$extension(object2, (Function1 & Serializable)c -> MessageRendering.pred$1(BoxesRunTime.unboxToChar((Object)c)));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        char[] rest = (char[])tuple23._2();
        char[] rest2 = rest;
        String string = new String(line2);
        Object object3 = Predef$.MODULE$.charArrayOps(rest2);
        return (ArrayOps$.MODULE$.isEmpty$extension(object3) ? package$.MODULE$.Nil() : MessageRendering.linesFrom$1(rest2)).$colon$colon((Object)string);
    }

    private static int given_Level$lzyINIT1$1(Diagnostic dia$1, LazyInt given_Level$lzy1$1) {
        int n;
        LazyInt lazyInt = given_Level$lzy1$1;
        synchronized (lazyInt) {
            n = given_Level$lzy1$1.initialized() ? given_Level$lzy1$1.value() : given_Level$lzy1$1.initialize(Highlight$Level$.MODULE$.apply(dia$1.level()));
        }
        return n;
    }

    private static int given_Level$1(Diagnostic dia$2, LazyInt given_Level$lzy1$2) {
        if (given_Level$lzy1$2.initialized()) {
            return given_Level$lzy1$2.value();
        }
        return MessageRendering.given_Level$lzyINIT1$1(dia$2, given_Level$lzy1$2);
    }

    private static int given_Offset$lzyINIT1$1(int maxLineNumber$1, LazyInt given_Offset$lzy1$1) {
        int n;
        LazyInt lazyInt = given_Offset$lzy1$1;
        synchronized (lazyInt) {
            n = given_Offset$lzy1$1.initialized() ? given_Offset$lzy1$1.value() : given_Offset$lzy1$1.initialize(Offsets$Offset$.MODULE$.apply(BoxesRunTime.boxToInteger((int)maxLineNumber$1).toString().length() + 2));
        }
        return n;
    }

    private static int given_Offset$1(int maxLineNumber$2, LazyInt given_Offset$lzy1$2) {
        if (given_Offset$lzy1$2.initialized()) {
            return given_Offset$lzy1$2.value();
        }
        return MessageRendering.given_Offset$lzyINIT1$1(maxLineNumber$2, given_Offset$lzy1$2);
    }
}

