/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.openmole.tool.logger.JavaLogger;
import org.openmole.tool.logger.JavaLogger$Log$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class CopyDirVisitor
extends SimpleFileVisitor<Path>
implements JavaLogger {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CopyDirVisitor.class.getDeclaredField("Log$lzy1"));
    private volatile Object Log$lzy1;
    private final Path fromPath;
    private final Path toPath;
    private final CopyOption[] copyOptions;

    public CopyDirVisitor(Path fromPath, Path toPath, CopyOption[] copyOptions) {
        this.fromPath = fromPath;
        this.toPath = toPath;
        this.copyOptions = copyOptions;
    }

    public final JavaLogger$Log$ Log() {
        Object object = this.Log$lzy1;
        if (object instanceof JavaLogger$Log$) {
            return (JavaLogger$Log$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JavaLogger$Log$)this.Log$lzyINIT1();
    }

    private Object Log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JavaLogger$Log$ javaLogger$Log$ = null;
                    try {
                        javaLogger$Log$ = new JavaLogger$Log$((JavaLogger)this);
                        object2 = javaLogger$Log$ == null ? LazyVals.NullValue$.MODULE$ : javaLogger$Log$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return javaLogger$Log$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CopyDirVisitor(Path fromPath, Path toPath, Seq<CopyOption> copyOptions) {
        this(fromPath, toPath, (CopyOption[])copyOptions.toArray(ClassTag$.MODULE$.apply(CopyOption.class)));
    }

    public CopyDirVisitor(Path fromPath, Path toPath) {
        this(fromPath, toPath, (Seq<CopyOption>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CopyOption[]{LinkOption.NOFOLLOW_LINKS, StandardCopyOption.COPY_ATTRIBUTES}));
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path targetPath = this.toPath.resolve(this.fromPath.relativize(dir));
        if (!Files.exists(targetPath, new LinkOption[0])) {
            Files.createDirectory(targetPath, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Object object;
        try {
            object = Files.copy(file, this.toPath.resolve(this.fromPath.relativize(file)), this.copyOptions);
        }
        catch (AccessDeniedException exc) {
            this.Log().logger().warning("Could not read file " + exc.getFile() + " (Permission Denied), skip from copy");
            object = BoxedUnit.UNIT;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        IOException iOException = exc;
        if (!(iOException instanceof AccessDeniedException)) {
            throw exc;
        }
        this.Log().logger().warning("Could not enter directory " + file + " (Permission Denied), content won't be copied");
        return FileVisitResult.CONTINUE;
    }
}

