/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.file;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class FileTools$
implements Serializable {
    private static final HashSet<PosixFilePermission> allPerms;
    private static final boolean isPosix;
    public static final FileTools$ MODULE$;

    private FileTools$() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new FileTools$();
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_WRITE);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        allPerms = var0;
        isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileTools$.class);
    }

    public Object setAllPermissions(Path path) {
        if (isPosix) {
            return Files.setPosixFilePermissions(path, allPerms);
        }
        File f = path.toFile();
        f.setReadable(true);
        f.setWritable(true);
        return BoxesRunTime.boxToBoolean((boolean)f.setExecutable(true));
    }
}

