/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import scala.Option;
import scala.Some$;
import scala.runtime.ModuleSerializationProxy;

public final class Certificate$
implements Serializable {
    public static final Certificate$ MODULE$ = new Certificate$();

    private Certificate$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Certificate$.class);
    }

    public KeyStore loadOrGenerate(File file, String ksPassword, Option<String> hostName) {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        if (file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                ks.load(fis, ksPassword.toCharArray());
            }
        }
        ks.load(null, "".toCharArray());
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048, new SecureRandom());
        KeyPair kp = kpg.generateKeyPair();
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        X500Name issuerDN = new X500Name("CN=" + hostName.getOrElse(this::$anonfun$1) + ", O=o, L=L, ST=il, C= c");
        X500Name subjectDN = new X500Name("CN=" + hostName.getOrElse(this::$anonfun$2) + ", O=o, L=L, ST=il, C= c");
        Date noBefore = new Date(System.currentTimeMillis() - 86400000L);
        Date noAfter = new Date(System.currentTimeMillis() + 31536000000000L);
        SubjectPublicKeyInfo subjectPublicInfo = SubjectPublicKeyInfo.getInstance((Object)kp.getPublic().getEncoded());
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(issuerDN, serialNumber, noBefore, noAfter, subjectDN, subjectPublicInfo);
        ASN1ObjectIdentifier altNameExtension = Extension.subjectAlternativeName;
        GeneralNames subjectAltName = new GeneralNames(new GeneralName(1, "127.0.0.1"));
        certificateBuilder.addExtension(altNameExtension, false, (ASN1Encodable)subjectAltName);
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SHA256withRSA");
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find(sigAlgId);
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
        ContentSigner signer = new BcRSAContentSignerBuilder(sigAlgId, digAlgId).build(PrivateKeyFactory.createKey((PrivateKeyInfo)privateKeyInfo));
        X509CertificateHolder holder = certificateBuilder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(holder);
        ks.setKeyEntry((String)hostName.getOrElse(this::loadOrGenerate$$anonfun$1), kp.getPrivate(), ksPassword.toCharArray(), new Certificate[]{cert});
        try (FileOutputStream fos = new FileOutputStream(file);){
            ks.store(fos, ksPassword.toCharArray());
        }
        return ks;
    }

    public Option<String> loadOrGenerate$default$3() {
        return Some$.MODULE$.apply((Object)"OpenMOLE");
    }

    private final String $anonfun$1() {
        return "cn";
    }

    private final String $anonfun$2() {
        return "cn";
    }

    private final String loadOrGenerate$$anonfun$1() {
        return "";
    }
}

