/*
 * Decompiled with CFR 0.152.
 */
package endpoints4s;

import endpoints4s.Codec;
import endpoints4s.Decoder;
import endpoints4s.Decoder$;
import endpoints4s.Encoder;
import endpoints4s.Encoder$;
import endpoints4s.Invalid$;
import endpoints4s.Valid$;
import endpoints4s.Validated;
import java.io.Serializable;
import java.util.UUID;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.runtime.ModuleSerializationProxy;

public final class Codec$
implements Serializable {
    private static final Codec uuidCodec;
    private static final Codec intCodec;
    private static final Codec longCodec;
    private static final Codec doubleCodec;
    private static final Codec booleanCodec;
    public static final Codec$ MODULE$;

    private Codec$() {
    }

    static {
        MODULE$ = new Codec$();
        uuidCodec = MODULE$.parseStringCatchingExceptions("UUID", (Function1 & Serializable)x$0 -> UUID.fromString(x$0), MODULE$.parseStringCatchingExceptions$default$3());
        intCodec = MODULE$.parseStringCatchingExceptions("integer", (Function1 & Serializable)_$1 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$1)), MODULE$.parseStringCatchingExceptions$default$3());
        longCodec = MODULE$.parseStringCatchingExceptions("integer", (Function1 & Serializable)_$2 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$2)), MODULE$.parseStringCatchingExceptions$default$3());
        doubleCodec = MODULE$.parseStringCatchingExceptions("number", (Function1 & Serializable)_$3 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$3)), MODULE$.parseStringCatchingExceptions$default$3());
        booleanCodec = MODULE$.parseStringCatchingExceptions("boolean", (Function1 & Serializable)x$1 -> {
            String string = x$1;
            switch (string == null ? 0 : string.hashCode()) {
                case 48: {
                    if ("0".equals(string)) return false;
                    throw new MatchError((Object)string);
                }
                case 49: {
                    if ("1".equals(string)) return true;
                    throw new MatchError((Object)string);
                }
                case 3569038: {
                    if ("true".equals(string)) return true;
                    throw new MatchError((Object)string);
                }
                case 97196323: {
                    if ("false".equals(string)) return false;
                    throw new MatchError((Object)string);
                }
            }
            throw new MatchError((Object)string);
        }, MODULE$.parseStringCatchingExceptions$default$3());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Codec$.class);
    }

    public <E, D> Codec<E, D> fromEncoderAndDecoder(Encoder<D, E> encoder, Decoder<E, D> decoder) {
        return new Codec<E, D>(encoder, decoder){
            private final Encoder encoder$1;
            private final Decoder decoder$1;
            {
                this.encoder$1 = encoder$2;
                this.decoder$1 = decoder$2;
            }

            public Validated decode(Object from) {
                return this.decoder$1.decode(from);
            }

            public Object encode(Object from) {
                return this.encoder$1.encode(from);
            }
        };
    }

    public <A, B, C> Codec<A, C> sequentially(Codec<A, B> ab, Codec<B, C> bc) {
        return this.fromEncoderAndDecoder(Encoder$.MODULE$.sequentially(bc, ab), Decoder$.MODULE$.sequentially(ab, bc));
    }

    public <A> Codec<String, A> parseStringCatchingExceptions(String type, Function1<String, A> parse, Function1<A, String> print) {
        return new Codec<String, A>(type, parse, print){
            private final String type$1;
            private final Function1 parse$1;
            private final Function1 print$1;
            {
                this.type$1 = type$2;
                this.parse$1 = parse$2;
                this.print$1 = print$2;
            }

            public String encode(Object x) {
                return (String)this.print$1.apply(x);
            }

            public Validated decode(String str) {
                Product product;
                try {
                    product = Valid$.MODULE$.apply(this.parse$1.apply((Object)str));
                }
                catch (Throwable throwable) {
                    product = Invalid$.MODULE$.apply(new StringBuilder(17).append("Invalid ").append(this.type$1).append(" value '").append(str).append("'").toString());
                }
                return product;
            }
        };
    }

    public <A> Function1<A, String> parseStringCatchingExceptions$default$3() {
        return (Function1 & Serializable)x -> x.toString();
    }

    public Codec<String, UUID> uuidCodec() {
        return uuidCodec;
    }

    public Codec<String, Object> intCodec() {
        return intCodec;
    }

    public Codec<String, Object> longCodec() {
        return longCodec;
    }

    public Codec<String, Object> doubleCodec() {
        return doubleCodec;
    }

    public Codec<String, Object> booleanCodec() {
        return booleanCodec;
    }
}

