/*
 * Decompiled with CFR 0.152.
 */
package ujson;

import java.io.Serializable;
import scala.Byte$;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.Long$;
import scala.MatchError;
import scala.Predef$;
import scala.Short$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import ujson.Arr;
import ujson.Arr$;
import ujson.AstTransformer;
import ujson.Bool;
import ujson.Bool$;
import ujson.False$;
import ujson.Null$;
import ujson.Num;
import ujson.Num$;
import ujson.Obj;
import ujson.Obj$;
import ujson.Str;
import ujson.Str$;
import ujson.True$;
import ujson.Value;
import ujson.Value$InvalidData$;
import ujson.Value$Selector$;
import upickle.core.ArrVisitor;
import upickle.core.ObjVisitor;
import upickle.core.Util$;
import upickle.core.Visitor;

public final class Value$
implements AstTransformer<Value> {
    public static final Value$Selector$ Selector;
    private static final Str$ Str;
    private static final Obj$ Obj;
    private static final Arr$ Arr;
    private static final Num$ Num;
    private static final Bool$ Bool;
    private static final True$ True;
    private static final False$ False;
    private static final Null$ Null;
    public static final Value$InvalidData$ InvalidData;
    public static final Value$ MODULE$;

    private Value$() {
    }

    static {
        MODULE$ = new Value$();
        Str = Str$.MODULE$;
        Obj = Obj$.MODULE$;
        Arr = Arr$.MODULE$;
        Num = Num$.MODULE$;
        Bool = Bool$.MODULE$;
        True = True$.MODULE$;
        False = False$.MODULE$;
        Null = Null$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Value$.class);
    }

    public Str$ Str() {
        return Str;
    }

    public Obj$ Obj() {
        return Obj;
    }

    public Arr$ Arr() {
        return Arr;
    }

    public Num$ Num() {
        return Num;
    }

    public Bool$ Bool() {
        return Bool;
    }

    public True$ True() {
        return True;
    }

    public False$ False() {
        return False;
    }

    public Null$ Null() {
        return Null;
    }

    public <T> Arr JsonableSeq(IterableOnce<T> items, Function1<T, Value> f) {
        IterableOnce iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods(items);
        return this.Arr().from(IterableOnceExtensionMethods$.MODULE$.map$extension(iterableOnce, f), Predef$.MODULE$.$conforms());
    }

    public <T> Obj JsonableDict(IterableOnce<Tuple2<String, T>> items, Function1<T, Value> f) {
        IterableOnce iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods(items);
        return this.Obj().from((IterableOnce<Tuple2<String, Value>>)IterableOnceExtensionMethods$.MODULE$.map$extension(iterableOnce, (Function1 & Serializable)x -> Tuple2$.MODULE$.apply(x._1(), f.apply(x._2()))));
    }

    public Bool JsonableBoolean(boolean i) {
        return i ? True$.MODULE$ : False$.MODULE$;
    }

    public Num JsonableByte(byte i) {
        return this.Num().apply(Byte$.MODULE$.byte2double(i));
    }

    public Num JsonableShort(short i) {
        return this.Num().apply(Short$.MODULE$.short2double(i));
    }

    public Num JsonableInt(int i) {
        return this.Num().apply(Int$.MODULE$.int2double(i));
    }

    public Str JsonableLong(long i) {
        return this.Str().apply(BoxesRunTime.boxToLong((long)i).toString());
    }

    public Num JsonableFloat(float i) {
        return this.Num().apply(Float$.MODULE$.float2double(i));
    }

    public Num JsonableDouble(double i) {
        return this.Num().apply(i);
    }

    public Null$ JsonableNull(scala.runtime.Null$ i) {
        return this.Null();
    }

    public Str JsonableString(CharSequence s) {
        return this.Str().apply(s.toString());
    }

    @Override
    public <T> T transform(Value j, Visitor<?, T> f) {
        Object object;
        Value value = j;
        if (Null$.MODULE$.equals(value)) {
            object = f.visitNull(-1);
        } else if (True$.MODULE$.equals(value)) {
            object = f.visitTrue(-1);
        } else if (False$.MODULE$.equals(value)) {
            object = f.visitFalse(-1);
        } else if (value instanceof Str) {
            String string;
            Str str = Str$.MODULE$.unapply((Str)value);
            String s = string = str._1();
            object = f.visitString(s, -1);
        } else if (value instanceof Num) {
            double d;
            Num num = Num$.MODULE$.unapply((Num)value);
            double d2 = d = num._1();
            object = f.visitFloat64(d2, -1);
        } else if (value instanceof Arr) {
            ArrayBuffer<Value> arrayBuffer;
            Arr arr = Arr$.MODULE$.unapply((Arr)value);
            ArrayBuffer<Value> items = arrayBuffer = arr._1();
            object = this.transformArray((Visitor)f, (Iterable)items);
        } else if (value instanceof Obj) {
            LinkedHashMap<String, Value> linkedHashMap;
            Obj obj = Obj$.MODULE$.unapply((Obj)value);
            LinkedHashMap<String, Value> items = linkedHashMap = obj._1();
            object = this.transformObject((Visitor)f, (Iterable)items);
        } else {
            throw new MatchError((Object)value);
        }
        return object;
    }

    @Override
    public ArrVisitor<Value, Value> visitArray(int length, int index) {
        return new AstTransformer.AstArrVisitor(this, (Function1 & Serializable)xs -> Arr$.MODULE$.apply((ArrayBuffer<Value>)xs), ArrayBuffer$.MODULE$.iterableFactory());
    }

    @Override
    public ObjVisitor<Value, Value> visitObject(int length, int index) {
        return new AstTransformer.AstObjVisitor(this, (Function1 & Serializable)xs -> Obj$.MODULE$.apply((LinkedHashMap<String, Value>)xs), LinkedHashMap$.MODULE$.mapFactory());
    }

    @Override
    public Value visitNull(int index) {
        return Null$.MODULE$;
    }

    @Override
    public Value visitFalse(int index) {
        return False$.MODULE$;
    }

    @Override
    public Value visitTrue(int index) {
        return this.True();
    }

    @Override
    public Value visitFloat64StringParts(CharSequence s, int decIndex, int expIndex, int index) {
        return Num$.MODULE$.apply(decIndex != -1 || expIndex != -1 ? StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s.toString())) : Long$.MODULE$.long2double(Util$.MODULE$.parseIntegralNum(s, decIndex, expIndex, index)));
    }

    @Override
    public Value visitFloat64(double d, int index) {
        return Num$.MODULE$.apply(d);
    }

    @Override
    public Value visitString(CharSequence s, int index) {
        return Str$.MODULE$.apply(s.toString());
    }
}

