/*
 * Decompiled with CFR 0.152.
 */
package upickle.core;

import scala.Char$;

public abstract class ByteAppendC {
    private int surrogate = -1;

    public abstract void append(byte var1);

    public void appendC(char x) {
        if (x < '\u0080') {
            if (this.surrogate != -1) {
                throw new Exception("Unexpected character following high surrogate " + x);
            }
            this.append((byte)x);
        } else if (x < '\u0800') {
            if (this.surrogate != -1) {
                throw new Exception("Unexpected character following high surrogate " + x);
            }
            this.append((byte)(0xC0 | x >> 6));
            this.append((byte)(0x80 | x & 0x3F));
        } else if (Character.isHighSurrogate(x)) {
            if (this.surrogate != -1) {
                throw new Exception("Duplicate high surrogate " + x);
            }
            this.surrogate = Char$.MODULE$.char2int(x);
        } else if (Character.isLowSurrogate(x)) {
            if (this.surrogate == -1) {
                throw new Exception("Un-paired low surrogate " + x);
            }
            int uc = this.convertSurrogate(this.surrogate, Char$.MODULE$.char2int(x));
            this.surrogate = -1;
            this.append((byte)(0xF0 | uc >> 18));
            this.append((byte)(0x80 | uc >> 12 & 0x3F));
            this.append((byte)(0x80 | uc >> 6 & 0x3F));
            this.append((byte)(0x80 | uc & 0x3F));
        } else {
            this.surrogate = -1;
            this.append((byte)(0xE0 | x >> 12));
            this.append((byte)(0x80 | x >> 6 & 0x3F));
            this.append((byte)(0x80 | x & 0x3F));
        }
    }

    public int convertSurrogate(int firstPart, int secondPart) {
        return 65536 + (firstPart - 55296 << 10) + (secondPart - 56320);
    }
}

