/*
 * Decompiled with CFR 0.152.
 */
package upickle.core;

import java.io.OutputStream;
import java.util.Arrays;
import upickle.core.ByteAppendC;
import upickle.core.ByteBuilder$;

public class ByteBuilder
extends ByteAppendC {
    private byte[] arr;
    private int length;

    public static int $lessinit$greater$default$1() {
        return ByteBuilder$.MODULE$.$lessinit$greater$default$1();
    }

    public ByteBuilder(int startSize) {
        this.arr = new byte[startSize];
        this.length = 0;
    }

    private byte[] getArr() {
        return this.arr;
    }

    public int getLength() {
        return this.length;
    }

    public void reset() {
        this.length = 0;
    }

    public void ensureLength(int increment) {
        int multiple;
        int targetLength = this.length + increment;
        for (multiple = this.arr.length; multiple < targetLength; multiple *= 2) {
        }
        if (multiple != this.arr.length) {
            this.arr = Arrays.copyOf(this.arr, multiple);
        }
    }

    public void append(int x) {
        this.append((byte)x);
    }

    @Override
    public void append(byte x) {
        if (this.length == this.arr.length) {
            this.arr = Arrays.copyOf(this.arr, this.arr.length * 2);
        }
        this.arr[this.length] = x;
        ++this.length;
    }

    public void appendAll(byte[] elems, int elemsLength) {
        this.appendAll(elems, 0, elemsLength);
    }

    public void appendAll(byte[] elems, int elemsStart, int elemsLength) {
        this.ensureLength(elemsLength);
        System.arraycopy(elems, elemsStart, this.arr, this.length, elemsLength);
        this.length += elemsLength;
    }

    public void appendAllUnsafe(ByteBuilder other) {
        int elemsLength = other.getLength();
        System.arraycopy(other.getArr(), 0, this.arr, this.length, elemsLength);
        this.length += elemsLength;
    }

    public void appendUnsafeC(char x) {
        this.appendUnsafe((byte)x);
    }

    public void appendUnsafe(byte x) {
        this.arr[this.length] = x;
        ++this.length;
    }

    public String makeString() {
        return new String(this.arr, 0, this.length);
    }

    public void writeOutToIfLongerThan(OutputStream writer, int threshold) {
        if (this.length > threshold) {
            writer.write(this.arr, 0, this.length);
            this.length = 0;
        }
    }
}

