/*
 * Decompiled with CFR 0.152.
 */
package upickle.core;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Char$;
import scala.runtime.ModuleSerializationProxy;
import upickle.core.ByteBuilder;
import upickle.core.CharBuilder;

public final class RenderUtils$
implements Serializable {
    private static final int[] hexChars;
    public static final RenderUtils$ MODULE$;

    private RenderUtils$() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        int i;
        MODULE$ = new RenderUtils$();
        int[] arr = new int[128];
        for (i = 0; i < 10; ++i) {
            arr[i + 48] = i;
        }
        for (i = 0; i < 16; ++i) {
            arr[i + 97] = 10 + i;
            arr[i + 65] = 10 + i;
        }
        hexChars = var0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RenderUtils$.class);
    }

    public final int[] hexChars() {
        return hexChars;
    }

    public int hex(int i) {
        return this.hexChars()[i];
    }

    private char toHex(int nibble) {
        return (char)(nibble + (nibble >= 10 ? 87 : 48));
    }

    public final void escapeByte(CharBuilder unicodeCharBuilder, ByteBuilder sb, CharSequence s, boolean unicode) {
        int len = s.length();
        int naiveOutLen = len + 2;
        sb.ensureLength(naiveOutLen);
        sb.appendUnsafe((byte)34);
        block9: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    this.escapeSingleByte(sb, i, naiveOutLen, '\"');
                    continue block9;
                }
                case '\\': {
                    this.escapeSingleByte(sb, i, naiveOutLen, '\\');
                    continue block9;
                }
                case '\b': {
                    this.escapeSingleByte(sb, i, naiveOutLen, 'b');
                    continue block9;
                }
                case '\f': {
                    this.escapeSingleByte(sb, i, naiveOutLen, 'f');
                    continue block9;
                }
                case '\n': {
                    this.escapeSingleByte(sb, i, naiveOutLen, 'n');
                    continue block9;
                }
                case '\r': {
                    this.escapeSingleByte(sb, i, naiveOutLen, 'r');
                    continue block9;
                }
                case '\t': {
                    this.escapeSingleByte(sb, i, naiveOutLen, 't');
                    continue block9;
                }
                default: {
                    boolean notUnicodeChar;
                    char c2 = c;
                    boolean notControlChar = c2 >= ' ';
                    boolean bl = notUnicodeChar = c2 <= '~';
                    if (notControlChar && notUnicodeChar) {
                        sb.append(Char$.MODULE$.char2int(c2));
                        continue block9;
                    }
                    if (!notControlChar || !notUnicodeChar && unicode) {
                        this.escapeSingleByteUnicodeEscape(sb, i, naiveOutLen, c2);
                        continue block9;
                    }
                    this.escapeSingleByteUnicodeRaw(unicodeCharBuilder, sb, s, unicode, i, len, naiveOutLen);
                    return;
                }
            }
        }
        sb.appendUnsafe((byte)34);
    }

    public void escapeSingleByteUnicodeRaw(CharBuilder unicodeCharBuilder, ByteBuilder sb, CharSequence s, boolean unicode, int i, int len, int naiveOutLen) {
        unicodeCharBuilder.reset();
        this.escapeChar0(i, naiveOutLen, len, unicodeCharBuilder, s, unicode);
        byte[] bytes = unicodeCharBuilder.makeString().getBytes(StandardCharsets.UTF_8);
        sb.appendAll(bytes, bytes.length);
    }

    public void escapeSingleByteUnicodeEscape(ByteBuilder sb, int i, int naiveOutLen, char c) {
        sb.ensureLength(naiveOutLen - i + 5);
        sb.appendUnsafeC('\\');
        sb.appendUnsafeC('u');
        sb.appendUnsafeC(this.toHex(c >> 12 & 0xF));
        sb.appendUnsafeC(this.toHex(c >> 8 & 0xF));
        sb.appendUnsafeC(this.toHex(c >> 4 & 0xF));
        sb.appendUnsafeC(this.toHex(c & 0xF));
    }

    public void escapeSingleByte(ByteBuilder sb, int i, int naiveOutLen, char c) {
        sb.ensureLength(naiveOutLen - i + 1);
        sb.appendUnsafeC('\\');
        sb.appendUnsafeC(c);
    }

    public CharBuilder escapeChar(CharBuilder unicodeCharBuilder, CharBuilder sb, CharSequence s, boolean unicode) {
        int len = s.length();
        int naiveOutLen = len + 2;
        sb.ensureLength(naiveOutLen);
        sb.appendUnsafe('\"');
        return this.escapeChar0(0, naiveOutLen, len, sb, s, unicode);
    }

    public final CharBuilder escapeChar0(int i0, int naiveOutLen, int len, CharBuilder sb, CharSequence s, boolean unicode) {
        sb.ensureLength(naiveOutLen);
        block9: for (int i = i0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    this.escapeSingleChar(sb, naiveOutLen, i, '\"');
                    continue block9;
                }
                case '\\': {
                    this.escapeSingleChar(sb, naiveOutLen, i, '\\');
                    continue block9;
                }
                case '\b': {
                    this.escapeSingleChar(sb, naiveOutLen, i, 'b');
                    continue block9;
                }
                case '\f': {
                    this.escapeSingleChar(sb, naiveOutLen, i, 'f');
                    continue block9;
                }
                case '\n': {
                    this.escapeSingleChar(sb, naiveOutLen, i, 'n');
                    continue block9;
                }
                case '\r': {
                    this.escapeSingleChar(sb, naiveOutLen, i, 'r');
                    continue block9;
                }
                case '\t': {
                    this.escapeSingleChar(sb, naiveOutLen, i, 't');
                    continue block9;
                }
                default: {
                    char c2 = c;
                    if (c2 < ' ' || c2 > '~' && unicode) {
                        this.escapeSingleCharUnicodeEscape(naiveOutLen, sb, i, c2);
                        continue block9;
                    }
                    sb.append(c2);
                    continue block9;
                }
            }
        }
        sb.appendUnsafe('\"');
        return sb;
    }

    public void escapeSingleCharUnicodeEscape(int naiveOutLen, CharBuilder sb, int i, char c) {
        sb.ensureLength(naiveOutLen - i + 5);
        sb.appendUnsafeC('\\');
        sb.appendUnsafeC('u');
        sb.appendUnsafeC(this.toHex(c >> 12 & 0xF));
        sb.appendUnsafeC(this.toHex(c >> 8 & 0xF));
        sb.appendUnsafeC(this.toHex(c >> 4 & 0xF));
        sb.appendUnsafeC(this.toHex(c & 0xF));
    }

    public void escapeSingleChar(CharBuilder sb, int naiveOutLen, int i, char c) {
        sb.ensureLength(naiveOutLen - i + 1);
        sb.appendUnsafeC('\\');
        sb.appendUnsafeC(c);
    }
}

