/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.replication;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.openmole.core.db.Replica;
import org.openmole.core.db.package;
import org.openmole.core.preference.ClearPreferenceLocation;
import org.openmole.core.preference.ConfigurationString$;
import org.openmole.core.preference.Preference;
import org.openmole.core.replication.ReplicaCatalog$;
import org.openmole.core.replication.ReplicaCatalog$AlreadyInDb$3$;
import org.openmole.core.replication.ReplicaCatalog$Inserted$3$;
import org.openmole.core.workspace.Workspace;
import org.openmole.tool.lock.LockRepository;
import org.openmole.tool.logger.JavaLogger$Log$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import squants.time.Time;
import squants.time.TimeConversions$;

public class ReplicaCatalog {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ReplicaCatalog.class.getDeclaredField("localLock$lzy1"));
    private final package.Transactor database;
    private final Preference preference;
    private volatile Object localLock$lzy1;
    private final Cache replicaCache;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ReplicaCatalog$.class.getDeclaredField("Log$lzy1"));

    public static ClearPreferenceLocation<Time> CheckFileExistsInterval() {
        return ReplicaCatalog$.MODULE$.CheckFileExistsInterval();
    }

    public static ClearPreferenceLocation<Time> LockTimeout() {
        return ReplicaCatalog$.MODULE$.LockTimeout();
    }

    public static JavaLogger$Log$ Log() {
        return ReplicaCatalog$.MODULE$.Log();
    }

    public static ClearPreferenceLocation<Time> NoAccessCleanTime() {
        return ReplicaCatalog$.MODULE$.NoAccessCleanTime();
    }

    public static ClearPreferenceLocation<Object> ReplicaCacheSize() {
        return ReplicaCatalog$.MODULE$.ReplicaCacheSize();
    }

    public static ClearPreferenceLocation<Time> ReplicaCacheTime() {
        return ReplicaCatalog$.MODULE$.ReplicaCacheTime();
    }

    public static ClearPreferenceLocation<Time> ReplicaGraceTime() {
        return ReplicaCatalog$.MODULE$.ReplicaGraceTime();
    }

    public static ReplicaCatalog apply(package.Transactor transactor, Preference preference) {
        return ReplicaCatalog$.MODULE$.apply(transactor, preference);
    }

    public static ReplicaCatalog apply(Workspace workspace, Preference preference) {
        return ReplicaCatalog$.MODULE$.apply(workspace, preference);
    }

    public ReplicaCatalog(package.Transactor database, Preference preference) {
        this.database = database;
        this.preference = preference;
        this.replicaCache = CacheBuilder.newBuilder().maximumSize((long)BoxesRunTime.unboxToInt((Object)preference.apply(ReplicaCatalog$.MODULE$.ReplicaCacheSize(), ConfigurationString$.MODULE$.given_ConfigurationString_Int()))).expireAfterAccess(((Time)preference.apply(ReplicaCatalog$.MODULE$.ReplicaCacheTime(), ConfigurationString$.MODULE$.given_ConfigurationString_Time())).millis(), TimeUnit.MILLISECONDS).build();
    }

    public void close() {
        this.database.close();
    }

    public LockRepository<Tuple3<String, String, String>> localLock() {
        Object object = this.localLock$lzy1;
        if (object instanceof LockRepository) {
            return (LockRepository)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LockRepository)this.localLock$lzyINIT1();
    }

    private Object localLock$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.localLock$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LockRepository lockRepository = null;
                    try {
                        lockRepository = new LockRepository();
                        object2 = lockRepository == null ? LazyVals.NullValue$.MODULE$ : lockRepository;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.localLock$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return lockRepository;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Cache<Tuple3<String, String, String>, Replica> replicaCache() {
        return this.replicaCache;
    }

    public void clean(String storageId, Function1<String, BoxedUnit> removeOnStorage) {
        long time = System.currentTimeMillis();
        this.database.selectOnStorage(storageId).withFilter((Function1 & Serializable)replica -> !new File(replica.source()).exists() || time - replica.lastCheckExists() > ((Time)this.preference.apply(ReplicaCatalog$.MODULE$.NoAccessCleanTime(), ConfigurationString$.MODULE$.given_ConfigurationString_Time())).millis()).foreach((Function1)(JProcedure1 & Serializable)replica -> this.remove(replica.id()));
    }

    public <S> Replica uploadAndGet(Function0<String> upload, Function1<String, Object> exists, Function1<String, BoxedUnit> remove, File srcPath, String hash, String storageId) {
        Tuple3 cacheKey = Tuple3$.MODULE$.apply((Object)srcPath.getCanonicalPath(), (Object)hash, (Object)storageId);
        return (Replica)this.localLock().withLock((Object)cacheKey, () -> this.uploadAndGet$$anonfun$1(upload, exists, remove, srcPath, hash, storageId, cacheKey));
    }

    private Replica uploadAndGetLocked(Function0<String> upload, Function1<String, Object> exists, Function1<String, BoxedUnit> remove, File srcPath, String hash, String storageId, Tuple3<String, String, String> cacheKey) {
        Replica replica;
        while (true) {
            Replica replica2;
            Option option;
            if ((option = Option$.MODULE$.apply(this.replicaCache().getIfPresent(cacheKey))) instanceof Some) {
                Replica r;
                replica2 = r = (Replica)((Some)option).value();
            } else if (None$.MODULE$.equals(option)) {
                this.cleanOldReplicas$1(remove, srcPath, hash, storageId);
                Replica replica3 = this.uploadAndInsertIfNotInCatalog$1(upload, remove, srcPath, hash, storageId);
                this.replicaCache().put(cacheKey, (Object)replica3);
                replica2 = replica3;
            } else {
                throw new MatchError((Object)option);
            }
            replica = replica2;
            if (!this.itsTimeToCheck$1(replica)) break;
            if (ReplicaCatalog.stillExists$1(exists, replica)) {
                long l = System.currentTimeMillis();
                long l2 = replica.copy$default$1();
                String string = replica.copy$default$2();
                String string2 = replica.copy$default$3();
                String string3 = replica.copy$default$4();
                String string4 = replica.copy$default$5();
                Replica newReplica = replica.copy(l2, string, string2, string3, string4, l);
                this.database.updateLastCheckExists(replica.id(), newReplica.lastCheckExists());
                this.replicaCache().put(cacheKey, (Object)newReplica);
                return newReplica;
            }
            this.replicaCache().invalidate(cacheKey);
            this.database.delete(replica.id());
        }
        return replica;
    }

    public Seq<Replica> forPaths(Seq<String> paths, Seq<String> storageId) {
        return this.database.selectPathsStorages(paths, storageId);
    }

    public Seq<Replica> forHashes(Seq<String> hashes, Seq<String> storageId) {
        return this.database.selectHashesStorages(hashes, storageId);
    }

    public void deleteReplicas(String storageId) {
        Vector replica = this.database.deleteOnStorage(storageId);
        replica.foreach((Function1)(JProcedure1 & Serializable)r -> this.replicaCache().invalidate(this.cacheKey((Replica)r)));
    }

    private Tuple3<String, String, String> cacheKey(Replica r) {
        return Tuple3$.MODULE$.apply((Object)r.source(), (Object)r.hash(), (Object)r.storage());
    }

    public void remove(long id) {
        Option replica = this.database.delete(id);
        Tuple3 tuple3 = replica.nonEmpty() ? Tuple3$.MODULE$.apply((Object)((Replica)replica.get()).source(), (Object)((Replica)replica.get()).storage(), (Object)((Replica)replica.get()).path()) : Tuple3$.MODULE$.apply((Object)"None", (Object)"None", (Object)"None");
        String source = (String)tuple3._1();
        String storage = (String)tuple3._2();
        String path = (String)tuple3._3();
        ReplicaCatalog$.MODULE$.Log().logger().fine("Remove replica with id " + id + ", from source " + source + ", storage " + storage + ", path " + path);
        replica.foreach((Function1)(JProcedure1 & Serializable)r -> this.replicaCache().invalidate(this.cacheKey((Replica)r)));
    }

    private final Replica uploadAndGet$$anonfun$1(Function0 upload$1, Function1 exists$1, Function1 remove$1, File srcPath$1, String hash$2, String storageId$1, Tuple3 cacheKey$1) {
        return this.uploadAndGetLocked((Function0<String>)upload$1, (Function1<String, Object>)exists$1, (Function1<String, BoxedUnit>)remove$1, srcPath$1, hash$2, storageId$1, (Tuple3<String, String, String>)cacheKey$1);
    }

    private final void cleanOldReplicas$1(Function1 remove$2, File srcPath$2, String hash$3, String storageId$2) {
        Vector sameSource = this.database.deleteSameSourceWithDifferentHash(srcPath$2.getCanonicalPath(), storageId$2, hash$3);
        sameSource.foreach((Function1)(JProcedure1 & Serializable)replica -> {
            ReplicaCatalog$.MODULE$.Log().logger().fine("Remove obsolete " + replica);
            remove$2.apply((Object)replica.path());
        });
    }

    private final ReplicaCatalog$AlreadyInDb$3$ AlreadyInDb$lzyINIT1$1(LazyRef AlreadyInDb$lzy1$1) {
        ReplicaCatalog$AlreadyInDb$3$ replicaCatalog$AlreadyInDb$3$;
        LazyRef lazyRef = AlreadyInDb$lzy1$1;
        synchronized (lazyRef) {
            replicaCatalog$AlreadyInDb$3$ = (ReplicaCatalog$AlreadyInDb$3$)(AlreadyInDb$lzy1$1.initialized() ? AlreadyInDb$lzy1$1.value() : AlreadyInDb$lzy1$1.initialize((Object)new ReplicaCatalog$AlreadyInDb$3$(this)));
        }
        return replicaCatalog$AlreadyInDb$3$;
    }

    private final ReplicaCatalog$AlreadyInDb$3$ AlreadyInDb$2(LazyRef AlreadyInDb$lzy1$2) {
        return (ReplicaCatalog$AlreadyInDb$3$)(AlreadyInDb$lzy1$2.initialized() ? AlreadyInDb$lzy1$2.value() : this.AlreadyInDb$lzyINIT1$1(AlreadyInDb$lzy1$2));
    }

    private final ReplicaCatalog$Inserted$3$ Inserted$lzyINIT1$1(LazyRef Inserted$lzy1$1) {
        ReplicaCatalog$Inserted$3$ replicaCatalog$Inserted$3$;
        LazyRef lazyRef = Inserted$lzy1$1;
        synchronized (lazyRef) {
            replicaCatalog$Inserted$3$ = (ReplicaCatalog$Inserted$3$)(Inserted$lzy1$1.initialized() ? Inserted$lzy1$1.value() : Inserted$lzy1$1.initialize((Object)new ReplicaCatalog$Inserted$3$(this)));
        }
        return replicaCatalog$Inserted$3$;
    }

    private final ReplicaCatalog$Inserted$3$ Inserted$2(LazyRef Inserted$lzy1$2) {
        return (ReplicaCatalog$Inserted$3$)(Inserted$lzy1$2.initialized() ? Inserted$lzy1$2.value() : this.Inserted$lzyINIT1$1(Inserted$lzy1$2));
    }

    private final Replica uploadAndInsertIfNotInCatalog$1(Function0 upload$2, Function1 remove$4, File srcPath$3, String hash$4, String storageId$3) {
        Vector replicas = this.database.selectSameSource(srcPath$3.getCanonicalPath(), storageId$3, hash$4);
        Option option = replicas.lastOption();
        if (option instanceof Some) {
            Replica r = (Replica)((Some)option).value();
            return r;
        }
        if (None$.MODULE$.equals(option)) {
            LazyRef lazyRef = new LazyRef();
            LazyRef lazyRef2 = new LazyRef();
            String newFile = (String)upload$2.apply();
            package.Transactor$.InsertionResult inserted = this.database.insert(srcPath$3.getCanonicalPath(), storageId$3, newFile, hash$4, System.currentTimeMillis());
            package.Transactor$.InsertionResult insertionResult = inserted;
            if (insertionResult instanceof package.Transactor$.AlreadyInDb) {
                Replica replica;
                package.Transactor$.AlreadyInDb alreadyInDb = package.Transactor$.AlreadyInDb$.MODULE$.unapply((package.Transactor$.AlreadyInDb)insertionResult);
                Replica replica2 = replica = alreadyInDb._1();
                remove$4.apply((Object)newFile);
                return replica2;
            }
            if (insertionResult instanceof package.Transactor$.Inserted) {
                Replica replica;
                package.Transactor$.Inserted inserted2 = package.Transactor$.Inserted$.MODULE$.unapply((package.Transactor$.Inserted)insertionResult);
                Replica replica3 = replica = inserted2._1();
                return replica3;
            }
            throw new MatchError((Object)insertionResult);
        }
        throw new MatchError((Object)option);
    }

    private final boolean itsTimeToCheck$1(Replica r) {
        return r.lastCheckExists() + TimeConversions$.MODULE$.timeToScalaDuration((Time)this.preference.apply(ReplicaCatalog$.MODULE$.CheckFileExistsInterval(), ConfigurationString$.MODULE$.given_ConfigurationString_Time())).toMillis() < System.currentTimeMillis();
    }

    private static final boolean stillExists$1$$anonfun$1(Function1 exists$3, Replica r$1) {
        return BoxesRunTime.unboxToBoolean((Object)exists$3.apply((Object)r$1.path()));
    }

    private static final boolean stillExists$1(Function1 exists$2, Replica r) {
        Try try_ = Try$.MODULE$.apply(() -> ReplicaCatalog.stillExists$1$$anonfun$1(exists$2, r));
        if (try_ instanceof Success) {
            boolean e = BoxesRunTime.unboxToBoolean((Object)((Success)try_).value());
            return e;
        }
        return false;
    }
}

