/*
 * Decompiled with CFR 0.152.
 */
package gridscale.local;

import gridscale.effectaside.package;
import gridscale.local.package$;
import gridscale.local.package$Local$;
import gridscale.local.package$LocalExecutionError$;
import gridscale.local.package$LocalHost$;
import gridscale.local.package$LocalIOError$;
import gridscale.package;
import gridscale.tools.shell.BashShell$;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.sys.process.Process;
import scala.sys.process.ProcessIO;

public final class package {
    public static package.ExecutionResult execute(String string, package.Effect<Local> effect) {
        return package$.MODULE$.execute(string, effect);
    }

    public static boolean exists(String string, package.Effect<Local> effect) {
        return package$.MODULE$.exists(string, effect);
    }

    public static String home(package.Effect<Local> effect) {
        return package$.MODULE$.home(effect);
    }

    public static Path link(String string, String string2, boolean bl, package.Effect<Local> effect) {
        return package$.MODULE$.link(string, string2, bl, effect);
    }

    public static List<package.ListEntry> list(String string, package.Effect<Local> effect) {
        return package$.MODULE$.list(string, effect);
    }

    public static void makeDir(String string, package.Effect<Local> effect) {
        package$.MODULE$.makeDir(string, effect);
    }

    public static Path mv(String string, String string2, package.Effect<Local> effect) {
        return package$.MODULE$.mv(string, string2, effect);
    }

    public static <T> T readFile(String string, Function1<InputStream, T> function1, package.Effect<Local> effect) {
        return package$.MODULE$.readFile(string, function1, effect);
    }

    public static void rmDir(String string, package.Effect<Local> effect) {
        package$.MODULE$.rmDir(string, effect);
    }

    public static void rmFile(String string, package.Effect<Local> effect) {
        package$.MODULE$.rmFile(string, effect);
    }

    public static void writeBytes(byte[] byArray, String string, package.Effect<Local> effect) {
        package$.MODULE$.writeBytes(byArray, string, effect);
    }

    public static void writeFile(Function0<InputStream> function0, String string, package.Effect<Local> effect) {
        package$.MODULE$.writeFile(function0, string, effect);
    }

    public static boolean link$default$3() {
        return package$.MODULE$.link$default$3();
    }

    public static class Local {
        public static package.Effect<Local> apply() {
            return package$Local$.MODULE$.apply();
        }

        public package.ExecutionResult execute(String cmd) {
            package.ExecutionResult executionResult;
            try {
                StringBuilder out = new StringBuilder();
                StringBuilder err = new StringBuilder();
                Tuple2 tuple2 = BashShell$.MODULE$.localBashCommand(cmd);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String shell = (String)tuple2._1();
                String commands = (String)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)shell, (Object)commands);
                String shell2 = (String)tuple22._1();
                String commands2 = (String)tuple22._2();
                ProcessIO io = new ProcessIO((Function1)(JProcedure1 & Serializable)stdin -> {
                    stdin.write(commands2.getBytes());
                    stdin.close();
                }, (Function1)(JProcedure1 & Serializable)stdout -> out.append(Source$.MODULE$.fromInputStream(stdout, Codec$.MODULE$.fallbackSystemCodec()).mkString("")), (Function1)(JProcedure1 & Serializable)stderr -> err.append(Source$.MODULE$.fromInputStream(stderr, Codec$.MODULE$.fallbackSystemCodec()).mkString("")));
                Process proc = scala.sys.process.package$.MODULE$.stringToProcess(shell2).run(io);
                executionResult = package.ExecutionResult$.MODULE$.apply(proc.exitValue(), out.mkString(), err.mkString());
            }
            catch (Throwable e) {
                throw package$LocalExecutionError$.MODULE$.apply("Error executing " + cmd + " on local host", e);
            }
            return executionResult;
        }

        public void writeBytes(byte[] bytes, String path) {
            try {
                Files.write(Paths.get(path, new String[0]), bytes, new OpenOption[0]);
            }
            catch (Throwable e) {
                throw package$LocalIOError$.MODULE$.apply("Could not write file to path " + path + " on local host", e);
            }
        }

        public void writeFile(Function0<InputStream> is, String path) {
            try (InputStream ois = (InputStream)is.apply();){
                Files.copy(ois, Paths.get(path, new String[0]), new CopyOption[0]);
            }
            catch (Throwable e) {
                throw package$LocalIOError$.MODULE$.apply("Could not write file to path " + path + " on local host", e);
            }
        }

        public <T> T readFile(String path, Function1<InputStream, T> f) {
            Object object;
            try (FileInputStream source = new FileInputStream(new File(path));){
                object = f.apply((Object)source);
            }
            return (T)object;
        }

        public void rmFile(String path) {
            try {
                Files.delete(Paths.get(path, new String[0]));
            }
            catch (Throwable e) {
                throw package$LocalIOError$.MODULE$.apply("Could not delete file " + path + " on local host", e);
            }
        }

        public String home() {
            String string;
            try {
                string = System.getProperty("user.home");
            }
            catch (Throwable e) {
                throw package$LocalIOError$.MODULE$.apply("Could not determine homme on local host", e);
            }
            return string;
        }

        public boolean exists(String path) {
            boolean bl;
            try {
                bl = new File(path).exists();
            }
            catch (Throwable e) {
                throw package$LocalIOError$.MODULE$.apply("Could not test if " + path + " exists on local host", e);
            }
            return bl;
        }

        public List<package.ListEntry> list(String path) {
            List list;
            try {
                Object object = Predef$.MODULE$.refArrayOps((Object[])new File(path).listFiles());
                list = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)f -> {
                    package.FileType$.Link$ ftype = Files.isSymbolicLink(f.toPath()) ? package.FileType$.Link$.MODULE$ : (package.FileType)(f.isDirectory() ? package.FileType$.Directory$.MODULE$ : package.FileType$.File$.MODULE$);
                    return package.ListEntry$.MODULE$.apply(f.getName(), (package.FileType)ftype, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)f.lastModified())));
                }, ClassTag$.MODULE$.apply(package.ListEntry.class))).toList();
            }
            catch (Throwable e) {
                throw package$LocalIOError$.MODULE$.apply("Could not list directory " + path + " on local host", e);
            }
            return list;
        }

        public void makeDir(String path) {
            try {
                new File(path).mkdirs();
            }
            catch (Throwable e) {
                throw package$LocalIOError$.MODULE$.apply("Could not make directory " + path + " on local host", e);
            }
        }

        public void rmDir(String path) {
            try {
                this.delete$1(new File(path));
            }
            catch (Throwable e) {
                throw package$LocalIOError$.MODULE$.apply("Could not removet directory " + path + " on local host", e);
            }
        }

        public Path mv(String from, String to) {
            Path path;
            try {
                path = Files.move(Paths.get(from, new String[0]), Paths.get(to, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable e) {
                throw package$LocalIOError$.MODULE$.apply("Could not move " + from + " to " + to + " on local host", e);
            }
            return path;
        }

        public Path link(String target, String link, boolean defaultOnCopy) {
            return this.createLink$1(defaultOnCopy, Paths.get(target, new String[0]), Paths.get(link, new String[0]));
        }

        private final void delete$1(File f2) {
            if (f2.isDirectory()) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])f2.listFiles());
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)f -> this.delete$1((File)f));
            }
            f2.delete();
        }

        private final File getParentFileSafe$1(File file) {
            File file2 = file.getParentFile();
            if (file2 == null) {
                if (file.isAbsolute()) {
                    return file;
                }
                return new File(".");
            }
            File f = file2;
            return f;
        }

        private final Path unsupported$1(Path target$1, Path link$1) {
            Path fullTargetPath = target$1.isAbsolute() ? target$1 : Paths.get(this.getParentFileSafe$1(link$1.toFile()).getPath(), target$1.toFile().getPath());
            Files.copy(fullTargetPath, link$1, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return link$1;
        }

        private final Path createLink$1(boolean defaultOnCopy$1, Path target, Path link) {
            Path path;
            try {
                path = Files.createSymbolicLink(link, target, new FileAttribute[0]);
            }
            catch (UnsupportedOperationException e) {
                if (defaultOnCopy$1) {
                    path = this.unsupported$1(target, link);
                }
                throw e;
            }
            catch (FileAlreadyExistsException e) {
                throw e;
            }
            catch (FileSystemException e) {
                if (defaultOnCopy$1) {
                    path = this.unsupported$1(target, link);
                }
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            return path;
        }
    }

    public static class LocalExecutionError
    extends Exception
    implements Product {
        private final String message;
        private final Throwable t;

        public static LocalExecutionError apply(String string, Throwable throwable) {
            return package$LocalExecutionError$.MODULE$.apply(string, throwable);
        }

        public static LocalExecutionError fromProduct(Product product) {
            return package$LocalExecutionError$.MODULE$.fromProduct(product);
        }

        public static LocalExecutionError unapply(LocalExecutionError localExecutionError) {
            return package$LocalExecutionError$.MODULE$.unapply(localExecutionError);
        }

        public LocalExecutionError(String message, Throwable t) {
            this.message = message;
            this.t = t;
            super(message, t);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LocalExecutionError)) return false;
            LocalExecutionError localExecutionError = (LocalExecutionError)object;
            String string = this.message();
            String string2 = localExecutionError.message();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.t();
            Throwable throwable2 = localExecutionError.t();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!localExecutionError.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof LocalExecutionError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LocalExecutionError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            if (1 == n2) {
                return "t";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String message() {
            return this.message;
        }

        public Throwable t() {
            return this.t;
        }

        public LocalExecutionError copy(String message, Throwable t) {
            return new LocalExecutionError(message, t);
        }

        public String copy$default$1() {
            return this.message();
        }

        public Throwable copy$default$2() {
            return this.t();
        }

        public String _1() {
            return this.message();
        }

        public Throwable _2() {
            return this.t();
        }
    }

    public static class LocalHost
    implements Product,
    Serializable {
        public static LocalHost apply() {
            return package$LocalHost$.MODULE$.apply();
        }

        public static LocalHost fromProduct(Product product) {
            return package$LocalHost$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(LocalHost localHost) {
            return package$LocalHost$.MODULE$.unapply(localHost);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LocalHost)) return false;
            LocalHost localHost = (LocalHost)object;
            boolean bl = localHost.canEqual(this);
            if (!bl) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof LocalHost;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "LocalHost";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String toString() {
            return "localhost";
        }

        public LocalHost copy() {
            return new LocalHost();
        }
    }

    public static class LocalIOError
    extends Exception
    implements Product {
        private final String message;
        private final Throwable t;

        public static LocalIOError apply(String string, Throwable throwable) {
            return package$LocalIOError$.MODULE$.apply(string, throwable);
        }

        public static LocalIOError fromProduct(Product product) {
            return package$LocalIOError$.MODULE$.fromProduct(product);
        }

        public static LocalIOError unapply(LocalIOError localIOError) {
            return package$LocalIOError$.MODULE$.unapply(localIOError);
        }

        public LocalIOError(String message, Throwable t) {
            this.message = message;
            this.t = t;
            super(message, t);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LocalIOError)) return false;
            LocalIOError localIOError = (LocalIOError)object;
            String string = this.message();
            String string2 = localIOError.message();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.t();
            Throwable throwable2 = localIOError.t();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!localIOError.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof LocalIOError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "LocalIOError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            if (1 == n2) {
                return "t";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String message() {
            return this.message;
        }

        public Throwable t() {
            return this.t;
        }

        public LocalIOError copy(String message, Throwable t) {
            return new LocalIOError(message, t);
        }

        public String copy$default$1() {
            return this.message();
        }

        public Throwable copy$default$2() {
            return this.t();
        }

        public String _1() {
            return this.message();
        }

        public Throwable _2() {
            return this.t();
        }
    }
}

