/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.Applicative;
import io.circe.ACursor;
import io.circe.CursorOp;
import io.circe.CursorOp$DownArray$;
import io.circe.CursorOp$DownField$;
import io.circe.CursorOp$DownN$;
import io.circe.FailedCursor;
import io.circe.HCursor$;
import io.circe.Json;
import io.circe.Json$JArray$;
import io.circe.Json$JObject$;
import io.circe.JsonObject;
import io.circe.cursor.ArrayCursor;
import io.circe.cursor.ObjectCursor;
import io.circe.cursor.TopCursor;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;

public abstract class HCursor
extends ACursor {
    public static HCursor fromJson(Json json) {
        return HCursor$.MODULE$.fromJson(json);
    }

    public HCursor(HCursor lastCursor, CursorOp lastOp) {
        super(lastCursor, lastOp);
    }

    public abstract Json value();

    public abstract HCursor replace(Json var1, HCursor var2, CursorOp var3);

    public abstract HCursor addOp(HCursor var1, CursorOp var2);

    @Override
    public final ACursor withFocus(Function1<Json, Json> f) {
        return this.replace((Json)f.apply((Object)this.value()), this, null);
    }

    @Override
    public final <F> Object withFocusM(Function1<Json, Object> f, Applicative<F> F) {
        return F.map(f.apply((Object)this.value()), (Function1 & Serializable)_$2 -> this.replace((Json)_$2, this, null));
    }

    @Override
    public final boolean succeeded() {
        return true;
    }

    @Override
    public final Option<HCursor> success() {
        return Some$.MODULE$.apply((Object)this);
    }

    @Override
    public final Option<Json> focus() {
        return Some$.MODULE$.apply((Object)this.value());
    }

    @Override
    public final Option<Iterable<Json>> values() {
        Json json = this.value();
        if (json instanceof Json.JArray) {
            Vector<Json> vector;
            Json.JArray jArray = Json$JArray$.MODULE$.unapply((Json.JArray)json);
            Vector<Json> vs = vector = jArray._1();
            return Some$.MODULE$.apply(vs);
        }
        return None$.MODULE$;
    }

    @Override
    public final Option<Iterable<String>> keys() {
        Json json = this.value();
        if (json instanceof Json.JObject) {
            JsonObject jsonObject;
            Json.JObject jObject = Json$JObject$.MODULE$.unapply((Json.JObject)json);
            JsonObject o = jsonObject = jObject._1();
            return Some$.MODULE$.apply(o.keys());
        }
        return None$.MODULE$;
    }

    @Override
    public final Option<Json> top() {
        HCursor current = this;
        while (!(current instanceof TopCursor)) {
            current = (HCursor)current.up();
        }
        return Some$.MODULE$.apply((Object)((TopCursor)current).value());
    }

    @Override
    public final HCursor root() {
        HCursor current = this;
        while (!(current instanceof TopCursor)) {
            current = (HCursor)current.up();
        }
        return current;
    }

    @Override
    public final ACursor downArray() {
        Json.JArray jArray;
        Vector<Json> vector;
        Vector<Json> values;
        Json json = this.value();
        if (json instanceof Json.JArray && !(values = (vector = (jArray = Json$JArray$.MODULE$.unapply((Json.JArray)json))._1())).isEmpty()) {
            return new ArrayCursor(values, 0, this, false, this, CursorOp$DownArray$.MODULE$);
        }
        return this.fail(CursorOp$DownArray$.MODULE$);
    }

    public final ACursor find(Function1<Json, Object> p) {
        return HCursor.go$1(p, this);
    }

    @Override
    public final ACursor downField(String k) {
        Json json = this.value();
        if (json instanceof Json.JObject) {
            Json.JObject jObject = Json$JObject$.MODULE$.unapply((Json.JObject)json);
            JsonObject jsonObject = jObject._1();
            JsonObject o = jsonObject;
            if (!o.contains(k)) {
                return this.fail(CursorOp$DownField$.MODULE$.apply(k));
            }
            return new ObjectCursor(o, k, this, false, this, CursorOp$DownField$.MODULE$.apply(k));
        }
        return this.fail(CursorOp$DownField$.MODULE$.apply(k));
    }

    @Override
    public final ACursor downN(int n) {
        Json json = this.value();
        if (json instanceof Json.JArray) {
            Vector<Json> vector;
            Json.JArray jArray = Json$JArray$.MODULE$.unapply((Json.JArray)json);
            Vector<Json> values = vector = jArray._1();
            if (n >= 0 && values.lengthCompare(n) > 0) {
                return new ArrayCursor(values, n, this, false, this, CursorOp$DownN$.MODULE$.apply(n));
            }
        }
        return this.fail(CursorOp$DownN$.MODULE$.apply(n));
    }

    public final ACursor fail(CursorOp op) {
        return new FailedCursor(this, op);
    }

    private static final ACursor go$1(Function1 p$1, ACursor c) {
        ACursor aCursor;
        while ((aCursor = c) instanceof HCursor) {
            HCursor success = (HCursor)aCursor;
            if (BoxesRunTime.unboxToBoolean((Object)p$1.apply((Object)success.value()))) {
                return success;
            }
            c = success.right();
        }
        ACursor other = aCursor;
        return other;
    }
}

