/*
 * Decompiled with CFR 0.152.
 */
package org.typelevel.jawn;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.typelevel.jawn.ByteBasedParser;
import org.typelevel.jawn.ChannelParser$;
import org.typelevel.jawn.FContext;
import org.typelevel.jawn.SyncParser;
import scala.collection.immutable.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ChannelParser<J>
extends SyncParser<J>
implements ByteBasedParser<J> {
    private final ReadableByteChannel ch;
    private int Bufsize;
    private int Mask;
    private int Allsize;
    private byte[] curr;
    private byte[] next;
    private int ncurr;
    private int nnext;
    private int _line;
    private int pos;

    public static int DefaultBufferSize() {
        return ChannelParser$.MODULE$.DefaultBufferSize();
    }

    public static int ParseAsStringThreshold() {
        return ChannelParser$.MODULE$.ParseAsStringThreshold();
    }

    public static int computeBufferSize(int n) {
        return ChannelParser$.MODULE$.computeBufferSize(n);
    }

    public static <J> ChannelParser<J> fromChannel(ReadableByteChannel readableByteChannel, int n) {
        return ChannelParser$.MODULE$.fromChannel(readableByteChannel, n);
    }

    public static <J> SyncParser<J> fromFile(File file, int n) {
        return ChannelParser$.MODULE$.fromFile(file, n);
    }

    public static <J> int fromChannel$default$2() {
        return ChannelParser$.MODULE$.fromChannel$default$2();
    }

    public static <J> int fromFile$default$2() {
        return ChannelParser$.MODULE$.fromFile$default$2();
    }

    public ChannelParser(ReadableByteChannel ch, int bufferSize) {
        this.ch = ch;
        this.Bufsize = ChannelParser$.MODULE$.computeBufferSize(bufferSize);
        this.Mask = this.Bufsize - 1;
        this.Allsize = this.Bufsize * 2;
        this.curr = new byte[this.Bufsize];
        this.next = new byte[this.Bufsize];
        this.ncurr = ch.read(ByteBuffer.wrap(this.curr));
        this.nnext = ch.read(ByteBuffer.wrap(this.next));
        this._line = 0;
        this.pos = 0;
    }

    @Override
    public final void newline(int i) {
        ++this._line;
        this.pos = i + 1;
    }

    @Override
    public final int line() {
        return this._line;
    }

    @Override
    public final int column(int i) {
        return i - this.pos;
    }

    @Override
    public final void close() {
        this.ch.close();
    }

    public final void swap() {
        byte[] tmp = this.curr;
        this.curr = this.next;
        this.next = tmp;
        int ntmp = this.ncurr;
        this.ncurr = this.nnext;
        this.nnext = ntmp;
    }

    public final void grow() {
        byte[] cc = new byte[this.Allsize];
        System.arraycopy(this.curr, 0, cc, 0, this.Bufsize);
        System.arraycopy(this.next, 0, cc, this.Bufsize, this.Bufsize);
        this.curr = cc;
        this.ncurr += this.nnext;
        this.next = new byte[this.Allsize];
        this.nnext = this.ch.read(ByteBuffer.wrap(this.next));
        this.Bufsize = this.Allsize;
        this.Mask = this.Allsize - 1;
        this.Allsize *= 2;
    }

    @Override
    public final int reset(int i) {
        int n;
        if (i >= this.Bufsize) {
            this.swap();
            this.nnext = this.ch.read(ByteBuffer.wrap(this.next));
            this.pos -= this.Bufsize;
            n = i - this.Bufsize;
        } else {
            n = i;
        }
        return n;
    }

    @Override
    public final void checkpoint(int state, int i, FContext<J> context, List<FContext<J>> stack) {
    }

    @Override
    public final byte byte(int i) {
        byte by;
        ChannelParser channelParser = this;
        while (true) {
            if (i < channelParser.Bufsize) {
                by = channelParser.curr[i];
                break;
            }
            if (i < channelParser.Allsize) {
                by = channelParser.next[i & channelParser.Mask];
                break;
            }
            channelParser.grow();
        }
        return by;
    }

    @Override
    public final char at(int i) {
        char c;
        ChannelParser channelParser = this;
        while (true) {
            if (i < channelParser.Bufsize) {
                c = (char)channelParser.curr[i];
                break;
            }
            if (i < channelParser.Allsize) {
                c = (char)channelParser.next[i & channelParser.Mask];
                break;
            }
            channelParser.grow();
        }
        return c;
    }

    @Override
    public final CharSequence at(int i, int k) {
        String string;
        int len;
        ChannelParser channelParser = this;
        while (true) {
            len = k - i;
            if (k <= channelParser.Allsize) break;
            channelParser.grow();
        }
        if (k <= channelParser.Bufsize) {
            string = new String(channelParser.curr, i, len, channelParser.utf8());
        } else if (i >= channelParser.Bufsize) {
            string = new String(channelParser.next, i - channelParser.Bufsize, len, channelParser.utf8());
        } else {
            byte[] arr = new byte[len];
            int mid = channelParser.Bufsize - i;
            System.arraycopy(channelParser.curr, i, arr, 0, mid);
            System.arraycopy(channelParser.next, 0, arr, mid, k - channelParser.Bufsize);
            string = new String(arr, channelParser.utf8());
        }
        return string;
    }

    @Override
    public final boolean atEof(int i) {
        return i < this.Bufsize ? i >= this.ncurr : i >= this.nnext + this.Bufsize;
    }
}

