/*
 * Decompiled with CFR 0.152.
 */
package gridscale.dirac;

import gridscale.authentication.P12Authentication;
import gridscale.dirac.package;
import gridscale.dirac.package$DIRAC$;
import gridscale.dirac.package$DIRACServer$;
import gridscale.dirac.package$DIRACState$;
import gridscale.dirac.package$DIRACState$Checking$;
import gridscale.dirac.package$DIRACState$Completed$;
import gridscale.dirac.package$DIRACState$Deleted$;
import gridscale.dirac.package$DIRACState$Done$;
import gridscale.dirac.package$DIRACState$Failed$;
import gridscale.dirac.package$DIRACState$Killed$;
import gridscale.dirac.package$DIRACState$Matched$;
import gridscale.dirac.package$DIRACState$Received$;
import gridscale.dirac.package$DIRACState$Running$;
import gridscale.dirac.package$DIRACState$Staging$;
import gridscale.dirac.package$DIRACState$Stalled$;
import gridscale.dirac.package$DIRACState$Waiting$;
import gridscale.dirac.package$JobDescription$;
import gridscale.dirac.package$JobID$;
import gridscale.dirac.package$Service$;
import gridscale.dirac.package$Token$;
import gridscale.effectaside.package;
import gridscale.http.package;
import gridscale.package;
import gridscale.tools.package;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import squants.time.Time;
import squants.time.TimeConversions$;

public final class package$
implements Serializable {
    public static final package$JobDescription$ JobDescription;
    public static final package$Token$ Token;
    public static final package$DIRACServer$ DIRACServer;
    public static final package$Service$ Service;
    public static final package$JobID$ JobID;
    public static final package$DIRACState$ DIRACState;
    public static final package$DIRAC$ DIRAC;
    public static final package$ MODULE$;

    private package$() {
    }

    static {
        MODULE$ = new package$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$.class);
    }

    public DefaultFormats format() {
        return DefaultFormats$.MODULE$;
    }

    public package.Service getService(String vo, File certificatesDirectory, Time timeout, package.Effect<package.HTTP> http, package.Effect<package.FileSystem> fileSystem) {
        Map<String, package.Service> services = this.getServices(certificatesDirectory, timeout, this.getServices$default$3(), http, fileSystem);
        return (package.Service)services.getOrElse((Object)vo, () -> this.getService$$anonfun$1(vo));
    }

    public Time getService$default$3() {
        return TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).minutes();
    }

    public Map<String, package.Service> getServices(File certificatesDirectory, Time timeout, String directoryURL, package.Effect<package.HTTP> http, package.Effect<package.FileSystem> fileSystem) {
        Vector certificates = package.HTTPS$.MODULE$.readPEMCertificates(certificatesDirectory, fileSystem, http);
        Function1 factory = package.HTTPS$.MODULE$.socketFactory(certificates, "", false);
        package.HTTPSServer indexServer = package.HTTPSServer$.MODULE$.apply(directoryURL, factory, timeout, package.HTTPSServer$.MODULE$.apply$default$4(), package.HTTPSServer$.MODULE$.apply$default$5());
        return this.getService$1(gridscale.http.package$.MODULE$.read((package.Server)indexServer, "", gridscale.http.package$.MODULE$.read$default$3(), http));
    }

    public Time getServices$default$2() {
        return TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).minutes();
    }

    public String getServices$default$3() {
        return "https://dirac.france-grilles.fr/defaults/DiracServices.json";
    }

    public Iterable<String> supportedVOs(File certificatesDirectory, Time timeout, package.Effect<package.HTTP> http, package.Effect<package.FileSystem> fileSystem) {
        return this.getServices(certificatesDirectory, timeout, this.getServices$default$3(), http, fileSystem).keys();
    }

    public Time supportedVOs$default$2() {
        return TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).minutes();
    }

    public package.DIRACServer server(package.Service service, P12Authentication p12, File certificateDirectory, package.Effect<package.FileSystem> fileSystem, package.Effect<package.HTTP> http) {
        package.HTTPS$.KeyStoreOperations$.Credential userCertificate = package.HTTPS$.MODULE$.readP12(p12.certificate(), p12.password(), fileSystem);
        Vector certificates = package.HTTPS$.MODULE$.readPEMCertificates(certificateDirectory, fileSystem, http);
        Function1 factory = package.HTTPS$.MODULE$.socketFactory((Vector)certificates.$plus$plus((IterableOnce)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.HTTPS$.KeyStoreOperations$.Credential[]{userCertificate}))), p12.password(), package.HTTPS$.MODULE$.socketFactory$default$3());
        package.HTTPSServer server = package.HTTPSServer$.MODULE$.apply(service.service(), factory, package.HTTPSServer$.MODULE$.apply$default$3(), package.HTTPSServer$.MODULE$.apply$default$4(), package.HTTPSServer$.MODULE$.apply$default$5());
        return package$DIRACServer$.MODULE$.apply(server, service);
    }

    public package.Token token(package.DIRACServer server, String setup, package.Effect<package.HTTP> http) {
        URI uri = new URIBuilder().setParameter("grant_type", "client_credentials").setParameter("group", server.service().group()).setParameter("setup", setup).build();
        String r = gridscale.http.package$.MODULE$.read((package.Server)server.server(), this.auth2Auth$1() + "?" + uri.getQuery(), gridscale.http.package$.MODULE$.read$default$3(), http);
        JValue parsed = JsonMethods$.MODULE$.parse((Object)r.trim(), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput());
        return package$Token$.MODULE$.apply((String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(parsed), "token")), (Formats)this.format(), package.ManifestCompat$.MODULE$.classTagToManifest((ClassTag)package.ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class)))), TimeConversions$.MODULE$.TimeConversions(ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(parsed), "expires_in")), (Formats)this.format(), package.ManifestCompat$.MODULE$.classTagToManifest((ClassTag)package.ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(Long.TYPE)))), (Numeric)Numeric.LongIsIntegral$.MODULE$).seconds());
    }

    public String token$default$2() {
        return "Dirac-Production";
    }

    public String jobsLocation() {
        return "/jobs";
    }

    public package.JobID submit(package.DIRACServer server, package.JobDescription jobDescription, package.Token token, Option<String> jobGroup, package.Effect<package.HTTP> http) {
        String r = gridscale.http.package$.MODULE$.read((package.Server)server.server(), this.jobsLocation(), (package.HTTPMethod)package.Post$.MODULE$.apply((Function0 & Serializable)() -> this.files$1(jobDescription, token, jobGroup), package.Post$.MODULE$.$lessinit$greater$default$2()), http);
        String id = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(JsonMethods$.MODULE$.parse((Object)r, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput())), "jids").apply(0)), (Formats)this.format(), package.ManifestCompat$.MODULE$.classTagToManifest((ClassTag)package.ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
        return package$JobID$.MODULE$.apply(id, jobDescription);
    }

    public Option<String> submit$default$4() {
        return None$.MODULE$;
    }

    public package.JobState state(package.DIRACServer server, package.Token token, package.JobID jobId, package.Effect<package.HTTP> http) {
        URI uri = new URIBuilder().setParameter("access_token", token.token()).build();
        String r = gridscale.http.package$.MODULE$.read((package.Server)server.server(), this.jobsLocation() + "/" + jobId.id() + "?" + uri.getQuery(), gridscale.http.package$.MODULE$.read$default$3(), http);
        String s = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(JsonMethods$.MODULE$.parse((Object)r, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput())), "status")), (Formats)this.format(), package.ManifestCompat$.MODULE$.classTagToManifest((ClassTag)package.ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
        return this.translateState(s);
    }

    public package.JobState translateState(String s) {
        package.JobState$.Submitted$ submitted$;
        package.DIRACState dIRACState = package$DIRACState$.MODULE$.withName(s);
        if (package$DIRACState$Received$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Submitted$.MODULE$;
        } else if (package$DIRACState$Checking$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Submitted$.MODULE$;
        } else if (package$DIRACState$Staging$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Submitted$.MODULE$;
        } else if (package$DIRACState$Waiting$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Submitted$.MODULE$;
        } else if (package$DIRACState$Matched$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Submitted$.MODULE$;
        } else if (package$DIRACState$Running$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Running$.MODULE$;
        } else if (package$DIRACState$Completed$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Running$.MODULE$;
        } else if (package$DIRACState$Stalled$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Running$.MODULE$;
        } else if (package$DIRACState$Killed$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Failed$.MODULE$;
        } else if (package$DIRACState$Deleted$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Failed$.MODULE$;
        } else if (package$DIRACState$Done$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Done$.MODULE$;
        } else if (package$DIRACState$Failed$.MODULE$.equals(dIRACState)) {
            submitted$ = package.JobState$.Failed$.MODULE$;
        } else {
            throw new MatchError((Object)dIRACState);
        }
        return (package.JobState)submitted$;
    }

    public Vector<Tuple2<String, package.JobState>> queryState(package.DIRACServer server, package.Token token, Option<String> groupId2, Option<String> userId2, Seq<package.DIRACState> states, package.Effect<package.HTTP> hTTP) {
        URIBuilder uri = new URIBuilder(server.server().url()).setParameter("access_token", token.token()).setParameter("startJob", BoxesRunTime.boxToInteger((int)0).toString()).setParameter("maxJobs", BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE).toString());
        groupId2.foreach((Function1 & Serializable)groupId -> uri.setParameter("jobGroup", groupId));
        userId2.foreach((Function1 & Serializable)userId -> uri.setParameter("owner", userId));
        URI uri2 = uri.build();
        JValue json = (JValue)gridscale.http.package$.MODULE$.readStream((package.Server)server.server(), this.jobsLocation() + "?" + uri2.getQuery() + this.statusesQuery$1(states), (Function1 & Serializable)is -> JsonMethods$.MODULE$.parse(is, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.streamAsJsonInput()), gridscale.http.package$.MODULE$.readStream$default$4(), hTTP);
        return MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(json), "jobs").children().map((Function1 & Serializable)j -> {
            String status = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(j), "status")), (Formats)this.format(), package.ManifestCompat$.MODULE$.classTagToManifest((ClassTag)package.ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
            String string = (String)Predef$.MODULE$.ArrowAssoc(ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(j), "jid")), (Formats)this.format(), package.ManifestCompat$.MODULE$.classTagToManifest((ClassTag)package.ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class)))));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.translateState(status));
        }).toVector();
    }

    public Option<String> queryState$default$3() {
        return None$.MODULE$;
    }

    public Option<String> queryState$default$4() {
        return None$.MODULE$;
    }

    public Seq<package.DIRACState> queryState$default$5() {
        return (Seq)package$DIRACState$.MODULE$.values().filter((Function1 & Serializable)s -> {
            package.DIRACState dIRACState = s;
            package$DIRACState$Killed$ package$DIRACState$Killed$2 = package$DIRACState$Killed$.MODULE$;
            if (dIRACState == null) {
                if (package$DIRACState$Killed$2 == null) return false;
            } else if (dIRACState.equals(package$DIRACState$Killed$2)) return false;
            package.DIRACState dIRACState2 = s;
            package$DIRACState$Deleted$ package$DIRACState$Deleted$2 = package$DIRACState$Deleted$.MODULE$;
            if (dIRACState2 == null) {
                if (package$DIRACState$Deleted$2 == null) return false;
                return true;
            } else if (dIRACState2.equals(package$DIRACState$Deleted$2)) return false;
            return true;
        });
    }

    public IndexedSeq<BoxedUnit> delete(package.DIRACServer server, package.Token token, package.JobID jobId, package.Effect<package.HTTP> http) {
        URI uri = new URIBuilder().setParameter("access_token", token.token()).build();
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(gridscale.http.package$.MODULE$.read((package.Server)server.server(), this.jobsLocation() + "/" + jobId.id() + "?" + uri.getQuery(), (package.HTTPMethod)package.Delete$.MODULE$.apply(package.Delete$.MODULE$.$lessinit$greater$default$1()), http)), (Function1 & Serializable)v1 -> {
            this.delete$$anonfun$1(BoxesRunTime.unboxToChar((Object)v1));
            return BoxedUnit.UNIT;
        });
    }

    public void downloadOutputSandbox(package.DIRACServer server, package.Token token, package.JobID jobId, File outputDirectory, package.Effect<package.HTTP> http, package.Effect<package.FileSystem> fileSystem) {
        URI uri = new URIBuilder().setParameter("access_token", token.token()).build();
        gridscale.http.package$.MODULE$.readStream((package.Server)server.server(), this.jobsLocation() + "/" + jobId.id() + "/outputsandbox?" + uri.getQuery(), (Function1)(JProcedure1 & Serializable)is -> this.extract$1((package.Effect)fileSystem, (InputStream)is, outputDirectory), gridscale.http.package$.MODULE$.readStream$default$4(), http);
    }

    public void delegate(package.DIRACServer server, P12Authentication p12, package.Token token, package.Effect<package.HTTP> http) {
        gridscale.http.package$.MODULE$.read((package.Server)server.server(), this.delegation$1(server), (package.HTTPMethod)package.Post$.MODULE$.apply((Function0 & Serializable)() -> this.entity$1(p12, token), package.Post$.MODULE$.$lessinit$greater$default$2()), http);
    }

    private final package.Service getService$$anonfun$1(String vo$1) {
        throw new RuntimeException("Service not fond for the vo " + vo$1 + " in the DIRAC service directory");
    }

    private final Map getService$1(String json) {
        return JsonMethods$.MODULE$.parse((Object)json, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()).children().map((Function1 & Serializable)s -> {
            String vo = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(s), "DIRACVOName")), (Formats)this.format(), package.ManifestCompat$.MODULE$.classTagToManifest((ClassTag)package.ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
            String server = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(s), "RESTServer")), (Formats)this.format(), package.ManifestCompat$.MODULE$.classTagToManifest((ClassTag)package.ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
            String group = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(s), "DIRACDefaultGroup")), (Formats)this.format(), package.ManifestCompat$.MODULE$.classTagToManifest((ClassTag)package.ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)vo);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package$Service$.MODULE$.apply("https://" + server, group));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final String auth2Auth$1() {
        return "/oauth2/token";
    }

    private final HttpEntity files$1(package.JobDescription jobDescription$4, package.Token token$1, Option jobGroup$1) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        jobDescription$4.inputSandbox().foreach((Function1 & Serializable)f -> builder.addBinaryBody(f.getName(), f));
        builder.addTextBody("access_token", token$1.token());
        builder.addTextBody("manifest", package$JobDescription$.MODULE$.toJSON(jobDescription$4, (Option<String>)jobGroup$1));
        return builder.build();
    }

    private final String statusesQuery$1(Seq states$1) {
        if (states$1.isEmpty()) {
            return "";
        }
        return "&" + ((IterableOnceOps)states$1.map((Function1 & Serializable)s -> "status=" + package$DIRACState$.MODULE$.name((package.DIRACState)s))).mkString("&");
    }

    private final /* synthetic */ void delete$$anonfun$1(char _$1) {
    }

    private final ArchiveEntry extract$1$$anonfun$1(TarArchiveInputStream is$1) {
        return is$1.getNextEntry();
    }

    private final void extract$1(package.Effect fileSystem$1, InputStream str, File outputDirectory) {
        outputDirectory.mkdirs();
        try (TarArchiveInputStream is = new TarArchiveInputStream(new BZip2CompressorInputStream(str));){
            scala.package$.MODULE$.Iterator().continually(() -> this.extract$1$$anonfun$1(is)).takeWhile((Function1 & Serializable)_$2 -> _$2 != null).foreach((Function1 & Serializable)e -> BoxesRunTime.unboxToLong((Object)((package.FileSystem)fileSystem$1.apply()).writeStream(package.Path$.MODULE$.fileToPath(new File(outputDirectory, e.getName())), (Function1 & Serializable)os -> IOUtils.copy(is, os))));
        }
    }

    private final HttpEntity entity$1(P12Authentication p12$1, package.Token token$2) {
        MultipartEntityBuilder entity = MultipartEntityBuilder.create();
        entity.addBinaryBody("p12", p12$1.certificate());
        entity.addTextBody("Password", p12$1.password());
        entity.addTextBody("access_token", token$2.token());
        return entity.build();
    }

    private final String delegation$1(package.DIRACServer server$1) {
        return "/proxy/unknown/" + server$1.service().group();
    }
}

