/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.egi;

import gridscale.dirac.package;
import gridscale.effectaside.package;
import gridscale.package;
import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import org.openmole.core.exception.InternalProcessingError;
import org.openmole.core.exception.InternalProcessingError$;
import org.openmole.core.preference.ConfigurationString$;
import org.openmole.plugin.environment.batch.environment.AccessControl;
import org.openmole.plugin.environment.batch.environment.AccessControl$;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment$;
import org.openmole.plugin.environment.batch.environment.SerializedJob;
import org.openmole.plugin.environment.egi.EGIEnvironment;
import org.openmole.plugin.environment.egi.EGIEnvironment$;
import org.openmole.plugin.environment.egi.EGIJobService$;
import org.openmole.plugin.environment.egi.JobScript$;
import org.openmole.plugin.environment.gridscale.GridScaleJobService$;
import org.openmole.tool.cache.TimeCache;
import org.openmole.tool.cache.TimeCache$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class EGIJobService {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(EGIJobService.class.getDeclaredField("accessControl$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(EGIJobService.class.getDeclaredField("jobStateCache$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(EGIJobService.class.getDeclaredField("diracJobGroup$lzy1"));
    private final package.DIRACServer diracService;
    private final EGIEnvironment<?> environment;
    private volatile Object diracJobGroup$lzy1;
    private volatile Object jobStateCache$lzy1;
    private volatile Object accessControl$lzy1;

    public static EGIJobService apply(package.DIRACServer dIRACServer, EGIEnvironment<?> eGIEnvironment) {
        return EGIJobService$.MODULE$.apply(dIRACServer, eGIEnvironment);
    }

    public EGIJobService(package.DIRACServer diracService, EGIEnvironment<?> environment) {
        this.diracService = diracService;
        this.environment = environment;
    }

    public String diracJobGroup() {
        Object object = this.diracJobGroup$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.diracJobGroup$lzyINIT1();
    }

    private Object diracJobGroup$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.diracJobGroup$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(UUID.randomUUID().toString()), (Function1 & Serializable)_$1 -> EGIJobService.diracJobGroup$lzyINIT1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)));
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.diracJobGroup$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public package.JobID submit(SerializedJob serializedJob, String outputPath, String storageLocation) {
        return (package.JobID)this.environment.services().newFile().withTmpFile("script", ".sh", (Function1 & Serializable)script -> {
            org.openmole.tool.file.package$.MODULE$.FileDecorator(script).content_$eq(JobScript$.MODULE$.create(serializedJob, outputPath, storageLocation, this.environment.voName(), (int)BatchEnvironment$.MODULE$.openMOLEMemoryValue(this.environment.openMOLEMemory(), this.environment.services().preference()).toMegabytes(), 1, this.environment.debug(), JobScript$.MODULE$.create$default$8(), this.environment.services().preference()));
            String string = "-x " + script.getName();
            Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{script}));
            Some some = Some$.MODULE$.apply((Object)EGIEnvironment$.MODULE$.stdOutFileName());
            Some some2 = Some$.MODULE$.apply((Object)EGIEnvironment$.MODULE$.stdErrFileName());
            Seq seq2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{EGIEnvironment$.MODULE$.stdOutFileName(), EGIEnvironment$.MODULE$.stdErrFileName()}));
            Seq seq3 = package.JobDescription$.MODULE$.$lessinit$greater$default$7();
            Option option = package.JobDescription$.MODULE$.$lessinit$greater$default$9();
            Option option2 = package.JobDescription$.MODULE$.$lessinit$greater$default$10();
            package.JobDescription jobDescription = package.JobDescription$.MODULE$.apply("/bin/bash", string, (Option)some, (Option)some2, seq, seq2, seq3, this.environment.cpuTime(), option, option2);
            return (package.JobID)this.accessControl().apply(() -> this.submit$$anonfun$1$$anonfun$1(jobDescription));
        });
    }

    public TimeCache<Map<String, package.JobState>> jobStateCache() {
        Object object = this.jobStateCache$lzy1;
        if (object instanceof TimeCache) {
            return (TimeCache)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (TimeCache)this.jobStateCache$lzyINIT1();
    }

    private Object jobStateCache$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jobStateCache$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    TimeCache timeCache = null;
                    try {
                        timeCache = TimeCache$.MODULE$.apply((Function0 & Serializable)() -> {
                            Vector states = (Vector)this.accessControl().apply(this::$anonfun$1);
                            Map map = (Map)Predef$.MODULE$.ArrowAssoc((Object)states.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)map, this.environment.services().preference().apply(EGIEnvironment$.MODULE$.JobGroupRefreshInterval(), ConfigurationString$.MODULE$.given_ConfigurationString_Time()));
                        });
                        object2 = timeCache == null ? LazyVals.NullValue$.MODULE$ : timeCache;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jobStateCache$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return timeCache;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public byte state(package.JobID id) {
        package.JobState state = (package.JobState)((MapOps)this.jobStateCache().apply()).getOrElse((Object)id.id(), () -> this.$anonfun$2(id));
        return GridScaleJobService$.MODULE$.translateStatus(state);
    }

    public IndexedSeq<BoxedUnit> delete(package.JobID id) {
        return (IndexedSeq)this.accessControl().apply(() -> this.delete$$anonfun$1(id));
    }

    public Tuple2<String, String> stdOutErr(package.JobID id) {
        return (Tuple2)this.environment.services().newFile().withTmpDir((Function1 & Serializable)tmpDir -> {
            tmpDir.mkdirs();
            this.accessControl().apply((Function0 & Serializable)() -> {
                this.stdOutErr$$anonfun$1$$anonfun$1(id, (File)tmpDir);
                return BoxedUnit.UNIT;
            });
            return Tuple2$.MODULE$.apply((Object)EGIJobService.stdOut$2(tmpDir), (Object)EGIJobService.stdErr$2(tmpDir));
        });
    }

    public AccessControl accessControl() {
        Object object = this.accessControl$lzy1;
        if (object instanceof AccessControl) {
            return (AccessControl)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AccessControl)this.accessControl$lzyINIT1();
    }

    private Object accessControl$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.accessControl$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AccessControl accessControl = null;
                    try {
                        accessControl = AccessControl$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)this.environment.services().preference().apply(EGIEnvironment$.MODULE$.ConnectionsToDIRAC(), ConfigurationString$.MODULE$.given_ConfigurationString_Int())));
                        object2 = accessControl == null ? LazyVals.NullValue$.MODULE$ : accessControl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.accessControl$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return accessControl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final /* synthetic */ boolean diracJobGroup$lzyINIT1$$anonfun$1(char _$1) {
        return _$1 != '-';
    }

    private final package.JobID submit$$anonfun$1$$anonfun$1(package.JobDescription jobDescription$1) {
        return gridscale.dirac.package$.MODULE$.submit(this.diracService, jobDescription$1, (package.Token)this.environment.tokenCache().apply(), (Option)Some$.MODULE$.apply((Object)this.diracJobGroup()), this.environment.interpreters().http());
    }

    private final Vector $anonfun$1() {
        return gridscale.dirac.package$.MODULE$.queryState(this.diracService, (package.Token)this.environment.tokenCache().apply(), (Option)Some$.MODULE$.apply((Object)this.diracJobGroup()), gridscale.dirac.package$.MODULE$.queryState$default$4(), gridscale.dirac.package$.MODULE$.queryState$default$5(), this.environment.interpreters().http());
    }

    private final package.JobState $anonfun$2(package.JobID id$1) {
        throw new InternalProcessingError("Job " + id$1.id() + " not found in group " + this.diracJobGroup() + " of DIRAC server.", InternalProcessingError$.MODULE$.$lessinit$greater$default$2());
    }

    private final IndexedSeq delete$$anonfun$1(package.JobID id$2) {
        return gridscale.dirac.package$.MODULE$.delete(this.diracService, (package.Token)this.environment.tokenCache().apply(), id$2, this.environment.interpreters().http());
    }

    private final void stdOutErr$$anonfun$1$$anonfun$1(package.JobID id$4, File tmpDir$1) {
        gridscale.dirac.package$.MODULE$.downloadOutputSandbox(this.diracService, (package.Token)this.environment.tokenCache().apply(), id$4, package.Path$.MODULE$.fileToPath(tmpDir$1), this.environment.interpreters().http(), this.environment.interpreters().fileSystem());
    }

    private static final String stdOut$2(File tmpDir$2) {
        if (org.openmole.tool.file.package$.MODULE$.FileDecorator(tmpDir$2).$div(EGIEnvironment$.MODULE$.stdOutFileName()).exists()) {
            return org.openmole.tool.file.package$.MODULE$.FileDecorator(org.openmole.tool.file.package$.MODULE$.FileDecorator(tmpDir$2).$div(EGIEnvironment$.MODULE$.stdOutFileName())).content();
        }
        return "";
    }

    private static final String stdErr$2(File tmpDir$3) {
        if (org.openmole.tool.file.package$.MODULE$.FileDecorator(tmpDir$3).$div(EGIEnvironment$.MODULE$.stdErrFileName()).exists()) {
            return org.openmole.tool.file.package$.MODULE$.FileDecorator(org.openmole.tool.file.package$.MODULE$.FileDecorator(tmpDir$3).$div(EGIEnvironment$.MODULE$.stdErrFileName())).content();
        }
        return "";
    }
}

