/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.gui.server.ext;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.pluginmanager.PluginManager$;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.core.workspace.Workspace;
import org.openmole.gui.server.ext.utils;
import org.openmole.gui.shared.data.ErrorData;
import org.openmole.gui.shared.data.ErrorData$;
import org.openmole.gui.shared.data.ErrorStateLevel;
import org.openmole.gui.shared.data.ErrorStateLevel$;
import org.openmole.gui.shared.data.FileListData;
import org.openmole.gui.shared.data.FileListData$;
import org.openmole.gui.shared.data.FileSorting;
import org.openmole.gui.shared.data.FileSorting$;
import org.openmole.gui.shared.data.Plugin;
import org.openmole.gui.shared.data.PluginState$;
import org.openmole.gui.shared.data.RelativePath$;
import org.openmole.gui.shared.data.SafePath;
import org.openmole.gui.shared.data.SafePath$;
import org.openmole.gui.shared.data.ServerFileSystemContext;
import org.openmole.gui.shared.data.ServerFileSystemContext$;
import org.openmole.gui.shared.data.TreeNodeData;
import org.openmole.gui.shared.data.TreeNodeData$;
import org.openmole.tool.file.FilePackage;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;

public final class utils$
implements Serializable {
    private static final String openmoleFileName;
    private static final String webpakedOpenmoleFileName;
    private static final String depsFileName;
    private static final String openmoleGrammarName;
    private static final String aceModuleSource;
    private static final String openmoleGrammarMode;
    private static final String githubTheme;
    private static final String webpackConfigTemplateName;
    private static final String webpackJsonPackage;
    public static final utils$ MODULE$;

    private utils$() {
    }

    static {
        MODULE$ = new utils$();
        openmoleFileName = "main.js";
        webpakedOpenmoleFileName = "openmole-webpacked.js";
        depsFileName = "deps.js";
        openmoleGrammarName = "openmole_grammar_template.js";
        aceModuleSource = "ace-builds/src-noconflict";
        openmoleGrammarMode = "mode-openmole.js";
        githubTheme = "theme-github.js";
        webpackConfigTemplateName = "template.webpack.config.js";
        webpackJsonPackage = "package.json";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(utils$.class);
    }

    public File pluginUpdoadDirectory(String tmpDirectory, TmpDirectory newFile) {
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(newFile.directory()).$div(tmpDirectory);
    }

    public File webUIDirectory(Workspace workspace) {
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(workspace.location()).$div$greater("webui");
    }

    public File projectsDirectory(Workspace workspace) {
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(this.webUIDirectory(workspace)).$div$greater("projects");
    }

    public File workspaceRoot(Workspace workspace) {
        return workspace.location();
    }

    public Seq<SafePath> allPluggableIn(SafePath path, Workspace workspace) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])org.openmole.tool.file.package$.MODULE$.FileDecorator(this.SafePathDecorator(path).toFile(workspace)).listFilesSafe());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)f -> PluginManager$.MODULE$.isBundle(f)));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$1 -> {
            utils.SafePathFileDecorator safePathFileDecorator = this.SafePathFileDecorator((File)_$1);
            return safePathFileDecorator.toSafePath(safePathFileDecorator.toSafePath$default$1(), workspace);
        }, ClassTag$.MODULE$.apply(SafePath.class)));
        return ArrayOps$.MODULE$.toSeq$extension(object3);
    }

    public SafePath treeNodeToSafePath(TreeNodeData tnd, SafePath parent) {
        return parent.$plus$plus(tnd.name());
    }

    public final utils.SafePathDecorator SafePathDecorator(SafePath s) {
        return new utils.SafePathDecorator(s);
    }

    public final utils.SafePathFileDecorator SafePathFileDecorator(File f) {
        return new utils.SafePathFileDecorator(f);
    }

    public SafePath fileToSafePath(File f, ServerFileSystemContext context, Workspace workspace) {
        ServerFileSystemContext serverFileSystemContext = context;
        ServerFileSystemContext serverFileSystemContext2 = ServerFileSystemContext$.Project;
        ServerFileSystemContext serverFileSystemContext3 = serverFileSystemContext;
        if (!(serverFileSystemContext2 != null ? !serverFileSystemContext2.equals(serverFileSystemContext3) : serverFileSystemContext3 != null)) {
            return SafePath$.MODULE$.apply(this.getPathArray(f, (Option<File>)Some$.MODULE$.apply((Object)this.projectsDirectory(workspace))), context);
        }
        ServerFileSystemContext serverFileSystemContext4 = ServerFileSystemContext$.Absolute;
        ServerFileSystemContext serverFileSystemContext5 = serverFileSystemContext;
        if (!(serverFileSystemContext4 != null ? !serverFileSystemContext4.equals(serverFileSystemContext5) : serverFileSystemContext5 != null)) {
            return SafePath$.MODULE$.apply(this.getPathArray(f, (Option<File>)None$.MODULE$), context);
        }
        ServerFileSystemContext serverFileSystemContext6 = ServerFileSystemContext$.Authentication;
        ServerFileSystemContext serverFileSystemContext7 = serverFileSystemContext;
        if (!(serverFileSystemContext6 != null ? !serverFileSystemContext6.equals(serverFileSystemContext7) : serverFileSystemContext7 != null)) {
            return SafePath$.MODULE$.apply(this.getPathArray(f, (Option<File>)Some$.MODULE$.apply((Object)this.authenticationKeysDirectory(workspace))), context);
        }
        throw new MatchError((Object)serverFileSystemContext);
    }

    public ServerFileSystemContext fileToSafePath$default$2(File f) {
        return ServerFileSystemContext$.Project;
    }

    public File safePathToFile(SafePath s, Workspace workspace) {
        ServerFileSystemContext serverFileSystemContext = s.context();
        ServerFileSystemContext serverFileSystemContext2 = ServerFileSystemContext$.Project;
        ServerFileSystemContext serverFileSystemContext3 = serverFileSystemContext;
        if (!(serverFileSystemContext2 != null ? !serverFileSystemContext2.equals(serverFileSystemContext3) : serverFileSystemContext3 != null)) {
            return this.getFile$1((Option)Some$.MODULE$.apply((Object)this.projectsDirectory(workspace)), s.path().value());
        }
        ServerFileSystemContext serverFileSystemContext4 = ServerFileSystemContext$.Absolute;
        ServerFileSystemContext serverFileSystemContext5 = serverFileSystemContext;
        if (!(serverFileSystemContext4 != null ? !serverFileSystemContext4.equals(serverFileSystemContext5) : serverFileSystemContext5 != null)) {
            return this.getFile$1((Option)Some$.MODULE$.apply((Object)org.openmole.tool.file.package$.MODULE$.File("/")), s.path().value());
        }
        ServerFileSystemContext serverFileSystemContext6 = ServerFileSystemContext$.Authentication;
        ServerFileSystemContext serverFileSystemContext7 = serverFileSystemContext;
        if (!(serverFileSystemContext6 != null ? !serverFileSystemContext6.equals(serverFileSystemContext7) : serverFileSystemContext7 != null)) {
            return this.getFile$1((Option)Some$.MODULE$.apply((Object)this.authenticationKeysDirectory(workspace)), s.path().value());
        }
        throw new MatchError((Object)serverFileSystemContext);
    }

    public boolean isPlugged(File file, Seq<Plugin> pluggedList, Workspace workspace) {
        SafePath safePath = this.fileToSafePath(file, this.fileToSafePath$default$2(file), workspace);
        return ((SeqOps)pluggedList.map((Function1 & Serializable)_$2 -> _$2.projectSafePath())).contains((Object)safePath);
    }

    public Option<TreeNodeData> fileToTreeNodeData(File f, Seq<Plugin> pluggedList, ServerFileSystemContext context, Workspace workspace) {
        if (f.exists()) {
            None$ dirData = f.isDirectory() ? Some$.MODULE$.apply((Object)TreeNodeData.Directory$.MODULE$.apply(org.openmole.tool.file.package$.MODULE$.FileDecorator(f).isDirectoryEmpty())) : None$.MODULE$;
            long time = Files.readAttributes(org.openmole.tool.file.package$.MODULE$.file2Path(f), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
            return Some$.MODULE$.apply((Object)TreeNodeData$.MODULE$.apply(f.getName(), f.length(), time, (Option)dirData, PluginState$.MODULE$.apply(this.isPlugin$1(f), this.isPlugged(f, pluggedList, workspace))));
        }
        return None$.MODULE$;
    }

    public ServerFileSystemContext fileToTreeNodeData$default$3(File f, Seq<Plugin> pluggedList) {
        return ServerFileSystemContext$.Project;
    }

    public Seq<TreeNodeData> seqfileToSeqTreeNodeData(Seq<File> fs, Seq<Plugin> pluggedList, ServerFileSystemContext context, Workspace workspace) {
        return (Seq)fs.flatMap((Function1 & Serializable)f -> this.fileToTreeNodeData((File)f, pluggedList, context, workspace));
    }

    public Option<SafePath> fileToOptionSafePath(File f, ServerFileSystemContext context, Workspace workspace) {
        return Some$.MODULE$.apply((Object)this.fileToSafePath(f, context, workspace));
    }

    public ErrorStateLevel javaLevelToErrorLevel(Level level) {
        if (level.intValue() >= Level.WARNING.intValue()) {
            return ErrorStateLevel$.Error;
        }
        return ErrorStateLevel$.Debug;
    }

    public Seq<String> getPathArray(File f, Option<File> until) {
        Option canonicalUntil = until.map((Function1 & Serializable)_$3 -> _$3.getCanonicalFile());
        return (Seq)this.getParentsArray0$1(canonicalUntil, f, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]))).$colon$plus((Object)f.getName());
    }

    public FileListData listFiles(SafePath path, FileSorting fileFilter, Seq<Plugin> pluggedList, Workspace workspace) {
        LazyRef lazyRef = new LazyRef();
        Seq sorted = (Seq)this.treeNodesData$1(path, pluggedList, workspace, lazyRef).sorted(FileSorting$.MODULE$.toOrdering(fileFilter));
        int sortedSize = sorted.size();
        Option option = fileFilter.size();
        if (option instanceof Some) {
            int s = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            return FileListData$.MODULE$.apply((Seq)sorted.take(s), s, sortedSize);
        }
        if (None$.MODULE$.equals(option)) {
            return FileListData$.MODULE$.apply(sorted, sortedSize, sortedSize);
        }
        throw new MatchError((Object)option);
    }

    public Seq<Tuple2<SafePath, Object>> recursiveListFiles(SafePath path, Option<String> findString, Workspace workspace) {
        LazyRef lazyRef = new LazyRef();
        String fPath = this.safePathToFile(path, workspace).getAbsolutePath();
        Object[] allFiles = org.openmole.tool.file.package$.MODULE$.FileDecorator(this.safePathToFile(path, workspace)).recursiveListFilesSafe((Function1 & Serializable)f -> {
            String string = fPath;
            String string2 = f.getAbsolutePath();
            return (string == null ? string2 != null : !string.equals(string2)) && BoxesRunTime.unboxToBoolean((Object)findString.map((Function1 & Serializable)s -> f.getName().contains((CharSequence)s)).getOrElse(this::$anonfun$2$$anonfun$2));
        });
        Object object = Predef$.MODULE$.refArrayOps(allFiles);
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)f -> Tuple2$.MODULE$.apply((Object)this.fileToSafePath((File)f, this.given_ServerFileSystemContext$3(path, lazyRef), workspace), (Object)BoxesRunTime.boxToBoolean((boolean)f.isDirectory())), ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public SafePath copyProjectFile(SafePath safePath, String newName, boolean followSymlinks, Workspace workspace) {
        SafePath toPath = safePath.copy(RelativePath$.MODULE$.apply((Seq)((SeqOps)safePath.path().value().dropRight(1)).$colon$plus((Object)newName)), safePath.copy$default$2());
        if (this.SafePathDecorator(toPath).toFile(workspace).isDirectory()) {
            this.SafePathDecorator(toPath).toFile(workspace).mkdir();
        }
        File from = this.SafePathDecorator(safePath).toFile(workspace);
        File replica = this.SafePathDecorator(safePath.parent().$plus$plus(newName)).toFile(workspace);
        org.openmole.tool.file.package$.MODULE$.FileDecorator(from).copy(replica, followSymlinks);
        utils.SafePathFileDecorator safePathFileDecorator = this.SafePathFileDecorator(replica);
        return safePathFileDecorator.toSafePath(safePathFileDecorator.toSafePath$default$1(), workspace);
    }

    public boolean copyProjectFile$default$3() {
        return false;
    }

    public void copyFile(File from, File to, boolean create) {
        if (create) {
            to.mkdirs();
        }
        if (from.exists() && to.exists()) {
            FilePackage.FileDecorator fileDecorator = org.openmole.tool.file.package$.MODULE$.FileDecorator(from);
            fileDecorator.copy(new File(to, from.getName()), fileDecorator.copy$default$2());
            return;
        }
    }

    public boolean copyFile$default$3() {
        return false;
    }

    public boolean exists(SafePath safePath, Workspace workspace) {
        return this.safePathToFile(safePath, workspace).exists();
    }

    public Seq<SafePath> existsIn(Seq<SafePath> safePaths, SafePath to, Workspace workspace) {
        return (Seq)((IterableOps)safePaths.map((Function1 & Serializable)sp -> to.$plus$plus(sp.name()))).filter((Function1 & Serializable)safePath -> this.exists((SafePath)safePath, workspace));
    }

    public Seq<SafePath> copyFiles(Seq<Tuple2<SafePath, SafePath>> safePaths, boolean overwrite, Workspace workspace) {
        ListBuffer existing = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SafePath[0]));
        safePaths.foreach((Function1 & Serializable)x$1 -> {
            SafePath safePath = (SafePath)x$1._1();
            SafePath safePath2 = (SafePath)x$1._2();
            File destination = this.SafePathDecorator(safePath2).toFile(workspace);
            if (destination.exists()) {
                existing.append((Object)safePath2);
                if (overwrite) {
                    FilePackage.FileDecorator fileDecorator = org.openmole.tool.file.package$.MODULE$.FileDecorator(this.SafePathDecorator(safePath).toFile(workspace));
                    return fileDecorator.copy(destination, fileDecorator.copy$default$2());
                }
                return BoxedUnit.UNIT;
            }
            FilePackage.FileDecorator fileDecorator = org.openmole.tool.file.package$.MODULE$.FileDecorator(this.SafePathDecorator(safePath).toFile(workspace));
            return fileDecorator.copy(destination, fileDecorator.copy$default$2());
        });
        return existing.toSeq();
    }

    public void deleteFile(SafePath safePath, Workspace workspace) {
        ServerFileSystemContext ctx = safePath.context();
        org.openmole.tool.file.package$.MODULE$.FileDecorator(this.safePathToFile(safePath, workspace)).recursiveDelete();
    }

    public void deleteFiles(Seq<SafePath> safePaths, Workspace workspace) {
        safePaths.foreach((Function1)(JProcedure1 & Serializable)sp -> this.deleteFile((SafePath)sp, workspace));
    }

    public String openmoleFileName() {
        return openmoleFileName;
    }

    public String webpakedOpenmoleFileName() {
        return webpakedOpenmoleFileName;
    }

    public String depsFileName() {
        return depsFileName;
    }

    public String openmoleGrammarName() {
        return openmoleGrammarName;
    }

    public String aceModuleSource() {
        return aceModuleSource;
    }

    public String openmoleGrammarMode() {
        return openmoleGrammarMode;
    }

    public String githubTheme() {
        return githubTheme;
    }

    public String webpackConfigTemplateName() {
        return webpackConfigTemplateName;
    }

    public String webpackJsonPackage() {
        return webpackJsonPackage;
    }

    public void updateIfChanged(File file, Option<File> hashFile, Function1<File, BoxedUnit> update, FileService fileService, TmpDirectory newFile) {
        org.openmole.tool.file.package$.MODULE$.FileDecorator(org.openmole.core.fileservice.package$.MODULE$.lockFile(file)).withLock((Function1)(JProcedure1 & Serializable)_$4 -> {
            boolean bl;
            LazyRef lazyRef = new LazyRef();
            File hashFile = this.hash$1(hashFile, file);
            if (!file.exists() || !hashFile.exists()) {
                bl = false;
            } else {
                Try try_ = Try$.MODULE$.apply(() -> this.$anonfun$3(hashFile));
                if (try_ instanceof Success) {
                    String v = (String)((Success)try_).value();
                    String string = this.currentHash$1(file, fileService, newFile, lazyRef);
                    String string2 = v;
                    bl = !(string != null ? !string.equals(string2) : string2 != null);
                } else if (try_ instanceof Failure) {
                    hashFile.delete();
                    bl = false;
                } else {
                    throw new MatchError((Object)try_);
                }
            }
            boolean upToDate = bl;
            if (!upToDate) {
                update.apply((Object)file);
                org.openmole.tool.file.package$.MODULE$.FileDecorator(hashFile).content_$eq(this.currentHash$1(file, fileService, newFile, lazyRef));
                return;
            }
        });
    }

    public Option<File> updateIfChanged$default$2() {
        return None$.MODULE$;
    }

    public <T> Try<T> catchAll(Function0<T> f) {
        Success success;
        try {
            success = Success$.MODULE$.apply(f.apply());
        }
        catch (Throwable t) {
            success = Failure$.MODULE$.apply(t);
        }
        Success res = success;
        return res;
    }

    public File authenticationKeysDirectory(Workspace workspace) {
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(workspace.persistentDir()).$div("keys");
    }

    public Seq<ErrorData> addPlugin(SafePath safePath, Workspace workspace, TmpDirectory newFile) {
        File file = this.safePathToFile(safePath, workspace);
        Iterable errors = PluginManager$.MODULE$.tryLoad((Iterable)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{file})));
        return ((IterableOnceOps)errors.map((Function1 & Serializable)e -> ErrorData$.MODULE$.apply((Throwable)e._2()))).toSeq();
    }

    public void removePlugin(SafePath safePath, Workspace workspace) {
        utils$ utils$2 = this;
        synchronized (utils$2) {
            File file = this.safePathToFile(safePath, workspace);
            Option bundle = PluginManager$.MODULE$.bundle(file);
            bundle.foreach((Function1)(JProcedure1 & Serializable)b -> PluginManager$.MODULE$.remove(b));
        }
    }

    public String formatDate(long t) {
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(BoxesRunTime.boxToLong((long)t));
    }

    private final File getFile0$1$$anonfun$1() {
        return new File("");
    }

    private final File getFile0$1(Seq paths, Option accFile) {
        Option option;
        while (true) {
            if (paths.isEmpty()) {
                return (File)accFile.getOrElse(this::getFile0$1$$anonfun$1);
            }
            option = accFile;
            if (None$.MODULE$.equals(option)) {
                return new File((String)paths.head());
            }
            if (!(option instanceof Some)) break;
            File f = (File)((Some)option).value();
            Seq seq = (Seq)paths.tail();
            Some some = Some$.MODULE$.apply((Object)new File(f, (String)paths.head()));
            paths = seq;
            accFile = some;
        }
        throw new MatchError((Object)option);
    }

    private final File getFile$1(Option root, Seq paths) {
        return this.getFile0$1(paths, root);
    }

    private final boolean isPlugin$1(File file) {
        return PluginManager$.MODULE$.isBundle(file);
    }

    private final boolean sameFile$1$$anonfun$2() {
        return false;
    }

    private final boolean sameFile$1(Option canonicalUntil$2, File parent$1) {
        return BoxesRunTime.unboxToBoolean((Object)canonicalUntil$2.map((Function1 & Serializable)c -> {
            if (c.exists() && parent$1.exists()) {
                return Files.isSameFile(parent$1.toPath(), c.toPath());
            }
            String string = parent$1.getPath();
            String string2 = c.getPath();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).getOrElse(this::sameFile$1$$anonfun$2));
    }

    private final Seq getParentsArray0$1(Option canonicalUntil$1, File f, Seq computedParents) {
        File file;
        while ((file = f.getParentFile()) != null) {
            File parent = file;
            if (this.sameFile$1(canonicalUntil$1, parent)) {
                return computedParents;
            }
            String string = parent.getName();
            if ("".equals(string)) {
                return computedParents;
            }
            String parentName = string;
            Seq computed = (Seq)computedParents.$plus$colon((Object)parentName);
            File file2 = parent;
            Seq seq = computed;
            f = file2;
            computedParents = seq;
        }
        return computedParents;
    }

    private final ServerFileSystemContext given_ServerFileSystemContext$lzyINIT2$1(SafePath path$1, LazyRef given_ServerFileSystemContext$lzy2$1) {
        ServerFileSystemContext serverFileSystemContext;
        LazyRef lazyRef = given_ServerFileSystemContext$lzy2$1;
        synchronized (lazyRef) {
            serverFileSystemContext = (ServerFileSystemContext)(given_ServerFileSystemContext$lzy2$1.initialized() ? given_ServerFileSystemContext$lzy2$1.value() : given_ServerFileSystemContext$lzy2$1.initialize((Object)path$1.context()));
        }
        return serverFileSystemContext;
    }

    private final ServerFileSystemContext given_ServerFileSystemContext$2(SafePath path$2, LazyRef given_ServerFileSystemContext$lzy2$2) {
        return (ServerFileSystemContext)(given_ServerFileSystemContext$lzy2$2.initialized() ? given_ServerFileSystemContext$lzy2$2.value() : this.given_ServerFileSystemContext$lzyINIT2$1(path$2, given_ServerFileSystemContext$lzy2$2));
    }

    private final Seq treeNodesData$1(SafePath path$3, Seq pluggedList$2, Workspace workspace$3, LazyRef given_ServerFileSystemContext$lzy2$3) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])org.openmole.tool.file.package$.MODULE$.FileDecorator(this.safePathToFile(path$3, workspace$3)).listFilesSafe());
        return this.seqfileToSeqTreeNodeData((Seq<File>)ArrayOps$.MODULE$.toSeq$extension(object), (Seq<Plugin>)pluggedList$2, this.given_ServerFileSystemContext$2(path$3, given_ServerFileSystemContext$lzy2$3), workspace$3);
    }

    private final ServerFileSystemContext given_ServerFileSystemContext$lzyINIT3$1(SafePath path$4, LazyRef given_ServerFileSystemContext$lzy3$1) {
        ServerFileSystemContext serverFileSystemContext;
        LazyRef lazyRef = given_ServerFileSystemContext$lzy3$1;
        synchronized (lazyRef) {
            serverFileSystemContext = (ServerFileSystemContext)(given_ServerFileSystemContext$lzy3$1.initialized() ? given_ServerFileSystemContext$lzy3$1.value() : given_ServerFileSystemContext$lzy3$1.initialize((Object)path$4.context()));
        }
        return serverFileSystemContext;
    }

    private final ServerFileSystemContext given_ServerFileSystemContext$3(SafePath path$5, LazyRef given_ServerFileSystemContext$lzy3$2) {
        return (ServerFileSystemContext)(given_ServerFileSystemContext$lzy3$2.initialized() ? given_ServerFileSystemContext$lzy3$2.value() : this.given_ServerFileSystemContext$lzyINIT3$1(path$5, given_ServerFileSystemContext$lzy3$2));
    }

    private final boolean $anonfun$2$$anonfun$2() {
        return true;
    }

    private final File hash$1$$anonfun$1(File f$2) {
        return new File(f$2.toString() + "-hash");
    }

    private final File hash$1(Option hashFile$1, File f) {
        return (File)hashFile$1.getOrElse(() -> this.hash$1$$anonfun$1(f));
    }

    private final String currentHash$lzyINIT1$1(File file$2, FileService fileService$2, TmpDirectory newFile$2, LazyRef currentHash$lzy1$1) {
        String string;
        LazyRef lazyRef = currentHash$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(currentHash$lzy1$1.initialized() ? currentHash$lzy1$1.value() : currentHash$lzy1$1.initialize((Object)fileService$2.hashNoCache(file$2, fileService$2.hashNoCache$default$2(), newFile$2).toString()));
        }
        return string;
    }

    private final String currentHash$1(File file$3, FileService fileService$3, TmpDirectory newFile$3, LazyRef currentHash$lzy1$2) {
        return (String)(currentHash$lzy1$2.initialized() ? currentHash$lzy1$2.value() : this.currentHash$lzyINIT1$1(file$3, fileService$3, newFile$3, currentHash$lzy1$2));
    }

    private final String $anonfun$3(File hashFile$3) {
        return org.openmole.tool.file.package$.MODULE$.FileDecorator(hashFile$3).content();
    }
}

