/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.ssh;

import gridscale.effectaside.package;
import gridscale.package;
import gridscale.ssh.package;
import gridscale.ssh.package$;
import java.io.Serializable;
import org.openmole.core.threadprovider.IUpdatable;
import org.openmole.core.workflow.execution.Environment;
import org.openmole.core.workflow.execution.ExceptionEvent;
import org.openmole.core.workflow.execution.ExecutionJob;
import org.openmole.core.workflow.execution.ExecutionState$;
import org.openmole.plugin.environment.batch.environment.AccessControl;
import org.openmole.plugin.environment.batch.environment.BatchEnvironment;
import org.openmole.plugin.environment.batch.environment.BatchExecutionJob;
import org.openmole.plugin.environment.batch.environment.Runtime;
import org.openmole.plugin.environment.batch.environment.SerializedJob;
import org.openmole.plugin.environment.batch.storage.HierarchicalStorageInterface;
import org.openmole.plugin.environment.batch.storage.StorageInterface;
import org.openmole.plugin.environment.gridscale.GridScaleJobService$;
import org.openmole.plugin.environment.ssh.SSHEnvironment;
import org.openmole.plugin.environment.ssh.SSHEnvironment$Failed$;
import org.openmole.plugin.environment.ssh.SSHEnvironment$Submitted$;
import org.openmole.plugin.environment.ssh.SSHJobService$;
import org.openmole.plugin.environment.ssh.SharedStorage;
import org.openmole.plugin.environment.ssh.SharedStorage$;
import org.openmole.plugin.environment.ssh.package;
import org.openmole.tool.logger.JavaLogger$Log$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.ref.WeakReference;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

public class SSHJobService<S> {
    private final S s;
    private final BatchEnvironment.Services services;
    private final package.RuntimeInstallation<?> installation;
    private final SSHEnvironment<?> env;
    private final AccessControl accessControl;
    private final StorageInterface<S> storageInterface;
    private final HierarchicalStorageInterface<S> hierarchicalStorageInterface;
    private final package.Effect<package.SSH> sshEffect;
    private final package.Effect<package.System> systemEffect;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SSHJobService$.class.getDeclaredField("Log$lzy1"));

    public static JavaLogger$Log$ Log() {
        return SSHJobService$.MODULE$.Log();
    }

    public SSHJobService(S s, String tmpDirectory, BatchEnvironment.Services services, package.RuntimeInstallation<?> installation, SSHEnvironment<?> env, AccessControl accessControl, StorageInterface<S> storageInterface, HierarchicalStorageInterface<S> hierarchicalStorageInterface, package.Effect<package.SSH> sshEffect, package.Effect<package.System> systemEffect) {
        this.s = s;
        this.services = services;
        this.installation = installation;
        this.env = env;
        this.accessControl = accessControl;
        this.storageInterface = storageInterface;
        this.hierarchicalStorageInterface = hierarchicalStorageInterface;
        this.sshEffect = sshEffect;
        this.systemEffect = systemEffect;
    }

    public AccessControl accessControl() {
        return this.accessControl;
    }

    public SSHEnvironment.SSHJob register(BatchExecutionJob batchExecutionJob, SerializedJob serializedJob, String outputPath, String jobDirectory) {
        String workDirectory = (String)this.env.workDirectory().getOrElse(SSHJobService::$anonfun$1);
        SharedStorage.JobScript remoteScript = this.buildScript$1(outputPath, jobDirectory, workDirectory, serializedJob);
        package.SSHJobDescription jobDescription = package.SSHJobDescription$.MODULE$.apply("/bin/bash " + remoteScript.content(), jobDirectory, this.env.killAfter());
        return this.env.stateRegistry().registerJob(jobDescription, batchExecutionJob, remoteScript.jobWorkDirectory());
    }

    public Option<SSHEnvironment.SSHRunState> submit(SSHEnvironment.SSHJob job, package.SSHJobDescription description, BatchExecutionJob batchExecutionJob) {
        Option<SSHEnvironment.SSHRunState> option;
        try {
            package.JobId id = package$.MODULE$.submit(this.env.sshServer(), description, this.sshEffect, this.systemEffect);
            option = this.env.stateRegistry().update(job, SSHEnvironment$Submitted$.MODULE$.apply(id));
        }
        catch (Throwable t) {
            this.env.stateRegistry().update(job, SSHEnvironment$Failed$.MODULE$);
            throw t;
        }
        return option;
    }

    public byte state(SSHEnvironment.SSHJob job) {
        Option<SSHEnvironment.SSHRunState> option = this.env.stateRegistry().get(job);
        if (None$.MODULE$.equals(option)) {
            return ExecutionState$.MODULE$.DONE();
        }
        if (option instanceof Some) {
            SSHEnvironment.SSHRunState sSHRunState = (SSHEnvironment.SSHRunState)((Some)option).value();
            if (sSHRunState instanceof SSHEnvironment.Queued) {
                SSHEnvironment.Queued state = (SSHEnvironment.Queued)sSHRunState;
                return ExecutionState$.MODULE$.SUBMITTED();
            }
            if (SSHEnvironment$Failed$.MODULE$.equals(sSHRunState)) {
                return ExecutionState$.MODULE$.FAILED();
            }
            if (sSHRunState instanceof SSHEnvironment.Submitted) {
                package.JobId jobId;
                SSHEnvironment.Submitted submitted = SSHEnvironment$Submitted$.MODULE$.unapply((SSHEnvironment.Submitted)sSHRunState);
                package.JobId id = jobId = submitted._1();
                return BoxesRunTime.unboxToByte((Object)this.accessControl().apply(() -> this.state$$anonfun$1(id)));
            }
        }
        throw new MatchError(option);
    }

    public void delete(SSHEnvironment.SSHJob job) {
        SSHEnvironment.SSHRunState sSHRunState;
        Option<SSHEnvironment.SSHRunState> jobState = this.env.stateRegistry().remove(job);
        Option<SSHEnvironment.SSHRunState> option = jobState;
        if (option instanceof Some && (sSHRunState = (SSHEnvironment.SSHRunState)((Some)option).value()) instanceof SSHEnvironment.Submitted) {
            package.JobId jobId;
            SSHEnvironment.Submitted submitted = SSHEnvironment$Submitted$.MODULE$.unapply((SSHEnvironment.Submitted)sSHRunState);
            package.JobId id = jobId = submitted._1();
            this.accessControl().apply(() -> this.delete$$anonfun$1(job, id));
            return;
        }
    }

    public Tuple2<String, String> stdOutErr(SSHEnvironment.SSHJob j) {
        SSHEnvironment.SSHRunState sSHRunState;
        Option<SSHEnvironment.SSHRunState> jobState = this.env.stateRegistry().get(j);
        Option<SSHEnvironment.SSHRunState> option = jobState;
        if (option instanceof Some && (sSHRunState = (SSHEnvironment.SSHRunState)((Some)option).value()) instanceof SSHEnvironment.Submitted) {
            package.JobId jobId;
            SSHEnvironment.Submitted submitted = SSHEnvironment$Submitted$.MODULE$.unapply((SSHEnvironment.Submitted)sSHRunState);
            package.JobId id = jobId = submitted._1();
            return (Tuple2)this.accessControl().apply(() -> this.stdOutErr$$anonfun$1(id));
        }
        return Tuple2$.MODULE$.apply((Object)"", (Object)"");
    }

    private static final String $anonfun$1() {
        return "/tmp";
    }

    private final SharedStorage.JobScript buildScript$1(String outputPath$1, String jobDirectory$1, String workDirectory$1, SerializedJob serializedJob) {
        return SharedStorage$.MODULE$.buildScript((Function1<Runtime, String>)(Function1 & Serializable)runtime -> this.installation.apply((Runtime)runtime), jobDirectory$1, workDirectory$1, this.env.openMOLEMemory(), this.env.threads(), serializedJob, outputPath$1, this.s, this.env.modules(), this.env.debug(), this.services.newFile(), this.services.preference(), this.storageInterface, this.hierarchicalStorageInterface);
    }

    private final byte state$$anonfun$1(package.JobId id$1) {
        return GridScaleJobService$.MODULE$.translateStatus(package$.MODULE$.state(this.env.sshServer(), id$1, this.sshEffect));
    }

    private final package.ExecutionResult delete$$anonfun$1(SSHEnvironment.SSHJob job$1, package.JobId id$2) {
        package$.MODULE$.clean(this.env.sshServer(), id$2, this.sshEffect);
        return package$.MODULE$.run(this.env.sshServer(), "rm -rf " + job$1.workDirectory(), package$.MODULE$.run$default$3(), this.sshEffect);
    }

    private final Tuple2 stdOutErr$$anonfun$1(package.JobId id$3) {
        return Tuple2$.MODULE$.apply((Object)package$.MODULE$.stdOut(this.env.sshServer(), id$3, this.sshEffect), (Object)package$.MODULE$.stdErr(this.env.sshServer(), id$3, this.sshEffect));
    }

    public static class Updater
    implements IUpdatable {
        private final WeakReference<SSHEnvironment<?>> environment;
        private boolean stop;

        public Updater(WeakReference<SSHEnvironment<?>> environment) {
            this.environment = environment;
            this.stop = false;
        }

        public boolean stop() {
            return this.stop;
        }

        public void stop_$eq(boolean x$1) {
            this.stop = x$1;
        }

        public boolean update() {
            if (this.stop()) {
                return false;
            }
            Option option = this.environment.get();
            if (option instanceof Some) {
                SSHEnvironment env = (SSHEnvironment)((Some)option).value();
                Seq<Tuple2<SSHEnvironment.SSHJob, package.JobId>> sshJobIds = env.stateRegistry().submitted();
                List runningJobResults = (List)env.accessControl().apply(() -> this.$anonfun$2(env, sshJobIds));
                List errors = runningJobResults.collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Try x) {
                        Try try_ = x;
                        if (try_ instanceof Failure) {
                            Throwable x2 = ((Failure)try_).exception();
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Try x, Function1 function1) {
                        Try try_ = x;
                        if (try_ instanceof Failure) {
                            Throwable x2 = ((Failure)try_).exception();
                            return x2;
                        }
                        return function1.apply((Object)x);
                    }
                });
                errors.foreach((Function1)(JProcedure1 & Serializable)e -> env.error((ExceptionEvent)Environment.ExceptionRaised$.MODULE$.apply(e, SSHJobService$.MODULE$.Log().WARNING(), Environment.ExceptionRaised$.MODULE$.$lessinit$greater$default$3())));
                int boundNumberOfRunningJobs = runningJobResults.map((Function1 & Serializable)_$1 -> BoxesRunTime.unboxToBoolean((Object)_$1.getOrElse(this::$anonfun$3$$anonfun$1))).count((Function1 & Serializable)_$2 -> this.$anonfun$4(BoxesRunTime.unboxToBoolean((Object)_$2)));
                int nbSubmit = env.slots() - boundNumberOfRunningJobs;
                Iterable toSubmit = (Iterable)env.stateRegistry().queued().take(nbSubmit);
                toSubmit.withFilter((Function1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 != null) {
                        SSHEnvironment.SSHJob job = (SSHEnvironment.SSHJob)tuple3._1();
                        package.SSHJobDescription desc = (package.SSHJobDescription)tuple3._2();
                        BatchExecutionJob bj = (BatchExecutionJob)tuple3._3();
                        return true;
                    }
                    return false;
                }).foreach((Function1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 != null) {
                        BoxedUnit boxedUnit;
                        SSHEnvironment.SSHJob job = (SSHEnvironment.SSHJob)tuple3._1();
                        package.SSHJobDescription desc = (package.SSHJobDescription)tuple3._2();
                        BatchExecutionJob bj = (BatchExecutionJob)tuple3._3();
                        try {
                            boxedUnit = env.sshJobService().submit(job, desc, bj);
                        }
                        catch (Throwable t) {
                            env.error((ExceptionEvent)Environment.ExecutionJobExceptionRaised$.MODULE$.apply((ExecutionJob)bj, t, SSHJobService$.MODULE$.Log().WARNING(), Environment.ExecutionJobExceptionRaised$.MODULE$.$lessinit$greater$default$4()));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    throw new MatchError((Object)tuple3);
                });
                return !this.stop();
            }
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            throw new MatchError((Object)option);
        }

        private final boolean $anonfun$2$$anonfun$1$$anonfun$1(SSHEnvironment env$3, package.JobId id$4) {
            return package.SSHJobDescription$.MODULE$.jobIsRunning(env$3.sshServer(), id$4, env$3.sshInterpreter());
        }

        private final List $anonfun$2(SSHEnvironment env$1, Seq sshJobIds$1) {
            return sshJobIds$1.toList().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    package.JobId id = (package.JobId)tuple2._2();
                    return Try$.MODULE$.apply(() -> this.$anonfun$2$$anonfun$1$$anonfun$1(env$1, id));
                }
                throw new MatchError((Object)tuple2);
            });
        }

        private final boolean $anonfun$3$$anonfun$1() {
            return true;
        }

        private final /* synthetic */ boolean $anonfun$4(boolean _$2) {
            return _$2;
        }
    }
}

