/*
 * Decompiled with CFR 0.152.
 */
package gridscale.ssh;

import gridscale.package;
import gridscale.ssh.ExecutionError$;
import gridscale.ssh.ReturnCodeError$;
import gridscale.ssh.SFTPError;
import gridscale.ssh.SFTPError$;
import gridscale.ssh.SSH$;
import gridscale.ssh.SSH$ConnectionCache$;
import gridscale.ssh.SSH$SSHCache$;
import gridscale.ssh.SSHServer;
import gridscale.ssh.sshj.SFTPClient;
import gridscale.ssh.sshj.SSHClient;
import gridscale.ssh.sshj.SSHClient$;
import java.io.InputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import squants.time.Time;

public class SSH
implements AutoCloseable {
    private final SSHServer server;
    private final ConnectionCache clientCache;

    public static SSH apply(SSHServer sSHServer, Option<Time> option) {
        return SSH$.MODULE$.apply(sSHServer, option);
    }

    public static SSHClient authenticate(SSHServer sSHServer, SSHClient sSHClient) {
        return SSH$.MODULE$.authenticate(sSHServer, sSHClient);
    }

    public static SSHClient client(SSHServer sSHServer) {
        return SSH$.MODULE$.client(sSHServer);
    }

    public static <T> T withSSH(SSHServer sSHServer, Option<Time> option, Function1<SSH, T> function1) {
        return SSH$.MODULE$.withSSH(sSHServer, option, function1);
    }

    public static Option<Time> apply$default$2() {
        return SSH$.MODULE$.apply$default$2();
    }

    public static <T> Option<Time> withSSH$default$2() {
        return SSH$.MODULE$.withSSH$default$2();
    }

    public SSH(SSHServer server, ConnectionCache clientCache) {
        this.server = server;
        this.clientCache = clientCache;
    }

    public SSHServer server() {
        return this.server;
    }

    public package.ExecutionResult execute(String s) {
        return (package.ExecutionResult)SSH$SSHCache$.MODULE$.withCache(this.clientCache, (Function1 & Serializable)c -> {
            package.ExecutionResult executionResult;
            try {
                executionResult = (package.ExecutionResult)SSHClient$.MODULE$.run((SSHClient)c, s).get();
            }
            catch (Throwable t) {
                throw ExecutionError$.MODULE$.apply("Error executing " + s + " on " + this.server(), t);
            }
            return executionResult;
        });
    }

    public void launch(String s) {
        SSH$SSHCache$.MODULE$.withCache(this.clientCache, (JProcedure1 & Serializable)c -> SSHClient$.MODULE$.launchInBackground((SSHClient)c, s));
    }

    public <T> T withSFTP(Function1<SFTPClient, T> f) {
        return SSH$SSHCache$.MODULE$.withCache(this.clientCache, (Function1 & Serializable)c -> {
            Object t;
            try {
                t = SSHClient$.MODULE$.withSFTP((SSHClient)c, f);
            }
            catch (Throwable t2) {
                throw SFTPError$.MODULE$.apply("Error in sftp transfer on " + this.server(), t2);
            }
            return t;
        });
    }

    public <T> T readFile(String path, Function1<InputStream, T> f) {
        return SSH$SSHCache$.MODULE$.withCache(this.clientCache, (Function1 & Serializable)c -> {
            Object object;
            try {
                object = ((Try)SSHClient$.MODULE$.withSFTP((SSHClient)c, (Function1 & Serializable)s -> s.readAheadFileInputStream(path).map(f))).get();
            }
            catch (SFTPError t) {
                throw t;
            }
            catch (Throwable t) {
                throw SFTPError$.MODULE$.apply("Error while reading " + path + " via sftp on " + this.server(), t);
            }
            return object;
        });
    }

    public void writeFile(Function0<InputStream> is, String path) {
        SSH$SSHCache$.MODULE$.withCache(this.clientCache, (JProcedure1 & Serializable)c -> {
            try {
                SSH.write$1(is, path, c);
            }
            catch (SFTPError t) {
                throw t;
            }
            catch (Throwable t) {
                throw SFTPError$.MODULE$.apply("Error while writing to " + path + " via sftp on " + this.server(), t);
            }
        });
    }

    public Nothing$ wrongReturnCode(String server, String command, package.ExecutionResult executionResult) {
        throw ReturnCodeError$.MODULE$.apply(server, command, executionResult);
    }

    @Override
    public void close() {
        SSH$SSHCache$.MODULE$.close(this.clientCache);
    }

    private static final void write$1(Function0 is$1, String path$3, SSHClient client) {
        try (InputStream ois = (InputStream)is$1.apply();){
            ((Try)SSHClient$.MODULE$.withSFTP(client, (Function1 & Serializable)_$1 -> _$1.writeFile(ois, path$3))).get();
        }
    }

    public static interface ConnectionCache {
        public static void close(ConnectionCache connectionCache) {
            SSH$ConnectionCache$.MODULE$.close(connectionCache);
        }

        public static int ordinal(ConnectionCache connectionCache) {
            return SSH$ConnectionCache$.MODULE$.ordinal(connectionCache);
        }

        public static <T> T use(ConnectionCache connectionCache, Function1<SSHClient, T> function1) {
            return SSH$ConnectionCache$.MODULE$.use(connectionCache, function1);
        }
    }
}

