/*
 * Decompiled with CFR 0.152.
 */
package gridscale.ssh;

import gridscale.package;
import gridscale.ssh.JobId;
import gridscale.ssh.SSH;
import gridscale.ssh.SSHJobDescription;
import gridscale.ssh.package$package$;
import gridscale.tools.shell.BashShell$;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.deriving.Mirror;
import scala.runtime.ModuleSerializationProxy;
import squants.time.Time;

public final class SSHJobDescription$
implements Mirror.Product,
Serializable {
    public static final SSHJobDescription$ MODULE$ = new SSHJobDescription$();

    private SSHJobDescription$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SSHJobDescription$.class);
    }

    public SSHJobDescription apply(String command, String workDirectory, Option<Time> timeout) {
        return new SSHJobDescription(command, workDirectory, timeout);
    }

    public SSHJobDescription unapply(SSHJobDescription x$1) {
        return x$1;
    }

    public Option<Time> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public boolean jobIsRunning(JobId job, SSH ssh) {
        String cde = "kill -0 `cat '" + this.pidFile(job.workDirectory(), job.jobId()) + "'`";
        package.ExecutionResult r = ssh.execute(cde);
        return r.returnCode() == 0;
    }

    public package.JobState translateState(int retCode) {
        int n = retCode;
        if (0 == n) {
            return package.JobState$.Done;
        }
        int r = n;
        return package.JobState$.Failed$.MODULE$.apply("Return code of command checking the state was " + r);
    }

    public String file(String dir, String jobId, String suffix) {
        return dir + "/" + jobId + "." + suffix;
    }

    public String pidFile(String dir, String jobId) {
        return this.file(dir, jobId, "pid");
    }

    public String endCodeFile(String dir, String jobId) {
        return this.file(dir, jobId, "end");
    }

    public String outFile(String dir, String jobId) {
        return this.file(dir, jobId, "out");
    }

    public String errFile(String dir, String jobId) {
        return this.file(dir, jobId, "err");
    }

    public String scriptFile(String dir, String jobId) {
        return this.file(dir, jobId, "sh");
    }

    public String commandLine(String command, boolean verbose) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |env -i bash " + (verbose ? "-x" : "") + " <<EOF\n           |" + BashShell$.MODULE$.source() + "\n           |" + command + "\n           |EOF\n           |"));
    }

    public boolean commandLine$default$2() {
        return false;
    }

    public Tuple2<String, String> jobScript(SSHJobDescription description, SSH ssh) {
        String jobId = UUID.randomUUID().toString();
        String file = this.scriptFile(description.workDirectory(), jobId);
        package$package$.MODULE$.writeFile((Function0<InputStream>)(Function0 & Serializable)() -> new ByteArrayInputStream(this.script$1(description, jobId).getBytes()), file, ssh);
        return Tuple2$.MODULE$.apply((Object)("/bin/bash '" + file + "'"), (Object)jobId);
    }

    public SSHJobDescription fromProduct(Product x$0) {
        String string = (String)x$0.productElement(0);
        String string2 = (String)x$0.productElement(1);
        Option option = (Option)x$0.productElement(2);
        return new SSHJobDescription(string, string2, (Option<Time>)option);
    }

    private final String jobCommand$1(SSHJobDescription description$2) {
        Option<Time> option = description$2.timeout();
        if (None$.MODULE$.equals(option)) {
            return description$2.command();
        }
        if (option instanceof Some) {
            Time t = (Time)((Some)option).value();
            return "timeout --signal=KILL " + (int)t.toSeconds() + "s " + description$2.command();
        }
        throw new MatchError(option);
    }

    private final String script$1(SSHJobDescription description$1, String jobId) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |mkdir -p '" + description$1.workDirectory() + "'\n         |cd '" + description$1.workDirectory() + "'\n         |" + BashShell$.MODULE$.source() + "\n         |\n         |{\n         |  " + this.jobCommand$1(description$1) + " >'" + this.outFile(description$1.workDirectory(), jobId) + "' 2>'" + this.errFile(description$1.workDirectory(), jobId) + "'\n         |  echo $? >'" + this.endCodeFile(description$1.workDirectory(), jobId) + "'\n         |} & pid=$!\n         |\n         |echo $pid >'" + this.pidFile(description$1.workDirectory(), jobId) + "'\n         |\n         |"));
    }
}

