/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.Disposable;
import better.files.Disposable$;
import better.files.Dispose;
import better.files.File$;
import better.files.File$Attributes$;
import better.files.File$CopyOptions$;
import better.files.File$Events$;
import better.files.File$LinkOptions$;
import better.files.File$OpenOptions$;
import better.files.File$PathMatcherSyntax$;
import better.files.File$RandomAccessMode$;
import better.files.File$VisitOptions$;
import better.files.Implicits;
import better.files.NullOutputStream$;
import better.files.Scanner;
import better.files.Scanner$;
import better.files.StringSplitter;
import better.files.StringSplitter$;
import better.files.package$;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public class File
implements Serializable {
    private static final long serialVersionUID = 3435L;
    private final Path path;
    private final FileSystem fileSystem;

    public static File apply(File file, String string, Seq<String> seq) {
        return File$.MODULE$.apply(file, string, seq);
    }

    public static File apply(Path path) {
        return File$.MODULE$.apply(path);
    }

    public static File apply(String string, Seq<String> seq) {
        return File$.MODULE$.apply(string, seq);
    }

    public static File apply(URI uRI) {
        return File$.MODULE$.apply(uRI);
    }

    public static File apply(URL uRL) {
        return File$.MODULE$.apply(uRL);
    }

    public static File currentWorkingDirectory() {
        return File$.MODULE$.currentWorkingDirectory();
    }

    public static File home() {
        return File$.MODULE$.home();
    }

    public static File newTemporaryDirectory(String string, Option<File> option, Seq<FileAttribute<?>> seq) {
        return File$.MODULE$.newTemporaryDirectory(string, option, seq);
    }

    public static File newTemporaryFile(String string, String string2, Option<File> option, Seq<FileAttribute<?>> seq) {
        return File$.MODULE$.newTemporaryFile(string, string2, option, seq);
    }

    public static long numberOfOpenFileDescriptors() {
        return File$.MODULE$.numberOfOpenFileDescriptors();
    }

    public static Iterable<File> roots() {
        return File$.MODULE$.roots();
    }

    public static File temp() {
        return File$.MODULE$.temp();
    }

    public static Dispose<File> temporaryDirectory(String string, Option<File> option, Seq<FileAttribute<?>> seq) {
        return File$.MODULE$.temporaryDirectory(string, option, seq);
    }

    public static <U> Dispose<File> temporaryFile(String string, String string2, Option<File> option, Seq<FileAttribute<?>> seq) {
        return File$.MODULE$.temporaryFile(string, string2, option, seq);
    }

    public static <U> void usingTemporaryDirectory(String string, Option<File> option, Seq<FileAttribute<?>> seq, Function1<File, U> function1) {
        File$.MODULE$.usingTemporaryDirectory(string, option, seq, function1);
    }

    public static <U> void usingTemporaryFile(String string, String string2, Option<File> option, Seq<FileAttribute<?>> seq, Function1<File, U> function1) {
        File$.MODULE$.usingTemporaryFile(string, string2, option, seq, function1);
    }

    public static String newTemporaryDirectory$default$1() {
        return File$.MODULE$.newTemporaryDirectory$default$1();
    }

    public static String newTemporaryFile$default$1() {
        return File$.MODULE$.newTemporaryFile$default$1();
    }

    public static String temporaryDirectory$default$1() {
        return File$.MODULE$.temporaryDirectory$default$1();
    }

    public static <U> String temporaryFile$default$1() {
        return File$.MODULE$.temporaryFile$default$1();
    }

    public static <U> String usingTemporaryDirectory$default$1() {
        return File$.MODULE$.usingTemporaryDirectory$default$1();
    }

    public static <U> String usingTemporaryFile$default$1() {
        return File$.MODULE$.usingTemporaryFile$default$1();
    }

    public static Option<File> newTemporaryDirectory$default$2() {
        return File$.MODULE$.newTemporaryDirectory$default$2();
    }

    public static String newTemporaryFile$default$2() {
        return File$.MODULE$.newTemporaryFile$default$2();
    }

    public static Option<File> temporaryDirectory$default$2() {
        return File$.MODULE$.temporaryDirectory$default$2();
    }

    public static <U> String temporaryFile$default$2() {
        return File$.MODULE$.temporaryFile$default$2();
    }

    public static <U> Option<File> usingTemporaryDirectory$default$2() {
        return File$.MODULE$.usingTemporaryDirectory$default$2();
    }

    public static <U> String usingTemporaryFile$default$2() {
        return File$.MODULE$.usingTemporaryFile$default$2();
    }

    public static Seq<FileAttribute<?>> newTemporaryDirectory$default$3(String string, Option<File> option) {
        return File$.MODULE$.newTemporaryDirectory$default$3(string, option);
    }

    public static Option<File> newTemporaryFile$default$3() {
        return File$.MODULE$.newTemporaryFile$default$3();
    }

    public static Seq<FileAttribute<?>> temporaryDirectory$default$3() {
        return File$.MODULE$.temporaryDirectory$default$3();
    }

    public static <U> Option<File> temporaryFile$default$3() {
        return File$.MODULE$.temporaryFile$default$3();
    }

    public static <U> Seq<FileAttribute<?>> usingTemporaryDirectory$default$3() {
        return File$.MODULE$.usingTemporaryDirectory$default$3();
    }

    public static <U> Option<File> usingTemporaryFile$default$3() {
        return File$.MODULE$.usingTemporaryFile$default$3();
    }

    public static Seq<FileAttribute<?>> newTemporaryFile$default$4(String string, String string2, Option<File> option) {
        return File$.MODULE$.newTemporaryFile$default$4(string, string2, option);
    }

    public static <U> Seq<FileAttribute<?>> temporaryFile$default$4() {
        return File$.MODULE$.temporaryFile$default$4();
    }

    public static <U> Seq<FileAttribute<?>> usingTemporaryFile$default$4() {
        return File$.MODULE$.usingTemporaryFile$default$4();
    }

    public File(Path path, FileSystem fileSystem) {
        this.path = path;
        this.fileSystem = fileSystem;
    }

    public Path path() {
        return this.path;
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public String pathAsString() {
        return this.path().toString();
    }

    public String resourcePathAsString() {
        return this.pathAsString().replace(java.io.File.separatorChar, '/');
    }

    public java.io.File toJava() {
        return new java.io.File(this.path().toAbsolutePath().toString());
    }

    public String name() {
        return (String)this.nameOption().getOrElse(File::name$$anonfun$1);
    }

    public Option<String> nameOption() {
        return Option$.MODULE$.apply((Object)this.path().getFileName()).map((Function1 & Serializable)_$1 -> _$1.toString());
    }

    public File root() {
        return File$.MODULE$.apply(this.path().getRoot());
    }

    public String canonicalPath() {
        return this.toJava().getAbsolutePath();
    }

    public File canonicalFile() {
        return package$.MODULE$.FileExtensions(this.toJava().getCanonicalFile()).toScala();
    }

    public String nameWithoutExtension() {
        return this.nameWithoutExtension(true);
    }

    public String nameWithoutExtension(boolean includeAll) {
        if (this.hasExtension()) {
            return this.name().substring(0, this.indexOfExtension(includeAll));
        }
        return this.name();
    }

    public Option<String> extension() {
        return this.extension(this.extension$default$1(), this.extension$default$2(), this.extension$default$3());
    }

    public Option<String> extension(boolean includeDot, boolean includeAll, boolean toLowerCase) {
        return package$.MODULE$.when(this.hasExtension(), () -> this.extension$$anonfun$1(includeDot, includeAll, toLowerCase));
    }

    public boolean extension$default$1() {
        return true;
    }

    public boolean extension$default$2() {
        return false;
    }

    public boolean extension$default$3() {
        return true;
    }

    private int indexOfExtension(boolean includeAll) {
        if (includeAll) {
            return this.name().indexOf(".");
        }
        return this.name().lastIndexOf(".");
    }

    public boolean hasExtension() {
        return (this.isRegularFile(this.isRegularFile$default$1()) || this.notExists(this.notExists$default$1())) && this.name().contains(".");
    }

    public File changeExtensionTo(String extension) {
        String newName = new StringBuilder(1).append(this.nameWithoutExtension()).append(".").append(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(extension), ".")).toString();
        if (this.isRegularFile(this.isRegularFile$default$1())) {
            return this.renameTo(newName);
        }
        if (this.notExists(this.notExists$default$1())) {
            return File$.MODULE$.apply(newName, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        }
        return this;
    }

    public Option<String> contentType() {
        return Option$.MODULE$.apply((Object)Files.probeContentType(this.path()));
    }

    public File parent() {
        return (File)this.parentOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<File> parentOption() {
        return Option$.MODULE$.apply((Object)this.path().getParent()).map((Function1 & Serializable)path -> File$.MODULE$.apply((Path)path));
    }

    public File $div(String child) {
        return File$.MODULE$.apply(this.path().resolve(child));
    }

    public File $div(Symbol child) {
        return this.$div(child.name());
    }

    public File createChild(String child, boolean asDirectory, boolean createParents, Seq<FileAttribute<?>> attributes, Seq<LinkOption> linkOptions) {
        return this.$div(child).createIfNotExists(asDirectory, createParents, attributes, linkOptions);
    }

    public boolean createChild$default$2() {
        return false;
    }

    public boolean createChild$default$3() {
        return false;
    }

    public Seq<FileAttribute<?>> createChild$default$4(String child, boolean asDirectory, boolean createParents) {
        return File$Attributes$.MODULE$.default();
    }

    public Seq<LinkOption> createChild$default$5(String child, boolean asDirectory, boolean createParents) {
        return File$LinkOptions$.MODULE$.default();
    }

    public File createIfNotExists(boolean asDirectory, boolean createParents, Seq<FileAttribute<?>> attributes, Seq<LinkOption> linkOptions) {
        File file;
        if (this.exists(linkOptions)) {
            return this;
        }
        if (asDirectory) {
            return this.createDirectories(attributes, this.createDirectories$default$2());
        }
        if (createParents) {
            File file2 = this.parent();
            file2.createDirectories(attributes, file2.createDirectories$default$2());
        }
        try {
            file = this.createFile(attributes);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof FileAlreadyExistsException) || !this.isRegularFile(linkOptions)) {
                throw throwable;
            }
            file = BoxedUnit.UNIT;
        }
        return this;
    }

    public boolean createIfNotExists$default$1() {
        return false;
    }

    public boolean createIfNotExists$default$2() {
        return false;
    }

    public Seq<FileAttribute<?>> createIfNotExists$default$3(boolean asDirectory, boolean createParents) {
        return File$Attributes$.MODULE$.default();
    }

    public Seq<LinkOption> createIfNotExists$default$4(boolean asDirectory, boolean createParents) {
        return File$LinkOptions$.MODULE$.default();
    }

    public File createFileIfNotExists(boolean createParents, Seq<FileAttribute<?>> attributes, Seq<LinkOption> linkOptions) {
        return this.createIfNotExists(false, createParents, attributes, linkOptions);
    }

    public boolean createFileIfNotExists$default$1() {
        return false;
    }

    public Seq<FileAttribute<?>> createFileIfNotExists$default$2(boolean createParents) {
        return File$Attributes$.MODULE$.default();
    }

    public Seq<LinkOption> createFileIfNotExists$default$3(boolean createParents) {
        return File$LinkOptions$.MODULE$.default();
    }

    public File createDirectoryIfNotExists(boolean createParents, Seq<FileAttribute<?>> attributes, Seq<LinkOption> linkOptions) {
        return this.createIfNotExists(true, createParents, attributes, linkOptions);
    }

    public boolean createDirectoryIfNotExists$default$1() {
        return false;
    }

    public Seq<FileAttribute<?>> createDirectoryIfNotExists$default$2(boolean createParents) {
        return File$Attributes$.MODULE$.default();
    }

    public Seq<LinkOption> createDirectoryIfNotExists$default$3(boolean createParents) {
        return File$LinkOptions$.MODULE$.default();
    }

    public File createFile(Seq<FileAttribute<?>> attributes) {
        Files.createFile(this.path(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes, FileAttribute.class));
        return this;
    }

    public Seq<FileAttribute<?>> createFile$default$1() {
        return File$Attributes$.MODULE$.default();
    }

    public boolean exists(Seq<LinkOption> linkOptions) {
        return Files.exists(this.path(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class));
    }

    public Seq<LinkOption> exists$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean notExists(Seq<LinkOption> linkOptions) {
        return Files.notExists(this.path(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class));
    }

    public Seq<LinkOption> notExists$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public File sibling(String name) {
        return File$.MODULE$.apply(this.path().resolveSibling(name));
    }

    public boolean isSiblingOf(File sibling) {
        return sibling.isChildOf(this.parent());
    }

    public Iterator<File> siblings() {
        return this.parent().list().filterNot((Function1 & Serializable)_$2 -> {
            File file = _$2;
            File file2 = this;
            return !(file != null ? !((Object)file).equals(file2) : file2 != null);
        });
    }

    public boolean isChildOf(File parent) {
        return parent.isParentOf(this);
    }

    public boolean contains(File file, boolean strict) {
        return this.isDirectory(this.isDirectory$default$1()) && file.path().startsWith(this.path()) && (!strict || !this.isSamePathAs(file));
    }

    public boolean contains$default$2() {
        return true;
    }

    public boolean isParentOf(File child) {
        return this.contains(child, this.contains$default$2());
    }

    public Iterator<Object> bytes() {
        return package$.MODULE$.InputStreamExtensions(package$.MODULE$.InputStreamExtensions(this.newInputStream(this.newInputStream$default$1())).buffered()).bytes();
    }

    public byte[] loadBytes() {
        return Files.readAllBytes(this.path());
    }

    public byte[] byteArray() {
        return this.loadBytes();
    }

    public File createDirectory(Seq<FileAttribute<?>> attributes) {
        Files.createDirectory(this.path(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes, FileAttribute.class));
        return this;
    }

    public Seq<FileAttribute<?>> createDirectory$default$1() {
        return File$Attributes$.MODULE$.default();
    }

    public File createDirectories(Seq<FileAttribute<?>> attributes, Seq<LinkOption> linkOptions) {
        Path path;
        try {
            path = Files.createDirectories(this.path(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes, FileAttribute.class));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof FileAlreadyExistsException) || !this.isDirectory(linkOptions)) {
                throw throwable;
            }
            path = BoxedUnit.UNIT;
        }
        return this;
    }

    public Seq<FileAttribute<?>> createDirectories$default$1() {
        return File$Attributes$.MODULE$.default();
    }

    public Seq<LinkOption> createDirectories$default$2() {
        return File$LinkOptions$.MODULE$.default();
    }

    public Iterator<Object> chars(Charset charset) {
        return package$.MODULE$.ReaderExtensions(this.newBufferedReader(charset)).chars();
    }

    public Charset chars$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public Iterable<String> lines(Charset charset) {
        return (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.path(), charset)).asScala();
    }

    public Charset lines$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public long lineCount(Charset charset) {
        return Files.lines(this.path(), charset).count();
    }

    public Charset lineCount$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public Iterator<String> lineIterator(Charset charset) {
        return package$.MODULE$.JStreamExtensions(Files.lines(this.path(), charset)).toAutoClosedIterator();
    }

    public Charset lineIterator$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public Iterator<String> tokens(StringSplitter splitter, Charset charset) {
        return package$.MODULE$.BufferedReaderExtensions(this.newBufferedReader(charset)).tokens(splitter);
    }

    public StringSplitter tokens$default$1() {
        return StringSplitter$.MODULE$.Default();
    }

    public Charset tokens$default$2(StringSplitter splitter) {
        return package$.MODULE$.DefaultCharset();
    }

    public String contentAsString(Charset charset) {
        return new String(this.byteArray(), charset);
    }

    public Charset contentAsString$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public File printLines(IterableOnce<?> lines, Seq<OpenOption> openOptions) {
        this.printWriter(this.printWriter$default$1(), openOptions).foreach((Function1 & Serializable)_$3 -> package$.MODULE$.PrintWriterExtensions((PrintWriter)_$3).printLines(lines));
        return this;
    }

    public Seq<OpenOption> printLines$default$2(IterableOnce<?> lines) {
        return File$OpenOptions$.MODULE$.append();
    }

    public File appendLines(Seq<String> lines, Charset charset) {
        Files.write(this.path(), (java.lang.Iterable<? extends CharSequence>)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(lines).asJava()), charset, (OpenOption[])Arrays$.MODULE$.seqToArray(File$OpenOptions$.MODULE$.append(), OpenOption.class));
        return this;
    }

    public Charset appendLines$default$2(Seq<String> lines) {
        return package$.MODULE$.DefaultCharset();
    }

    public File appendLine(String line, Charset charset) {
        return this.appendLines((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{line}), charset);
    }

    public String appendLine$default$1() {
        return "";
    }

    public Charset appendLine$default$2(String line) {
        return package$.MODULE$.DefaultCharset();
    }

    public File append(String text, Charset charset) {
        return this.appendByteArray(text.getBytes(charset));
    }

    public Charset append$default$2(String text) {
        return package$.MODULE$.DefaultCharset();
    }

    public File appendText(String text, Charset charset) {
        return this.append(text, charset);
    }

    public Charset appendText$default$2(String text) {
        return package$.MODULE$.DefaultCharset();
    }

    public File appendByteArray(byte[] bytes) {
        Files.write(this.path(), bytes, (OpenOption[])Arrays$.MODULE$.seqToArray(File$OpenOptions$.MODULE$.append(), OpenOption.class));
        return this;
    }

    public File appendBytes(Iterator<Object> bytes) {
        return this.writeBytes(bytes, File$OpenOptions$.MODULE$.append());
    }

    public File writeByteArray(byte[] bytes, Seq<OpenOption> openOptions) {
        Files.write(this.path(), bytes, (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions, OpenOption.class));
        return this;
    }

    public Seq<OpenOption> writeByteArray$default$2(byte[] bytes) {
        return File$OpenOptions$.MODULE$.default();
    }

    public File writeBytes(Iterator<Object> bytes, Seq<OpenOption> openOptions) {
        this.outputStream(openOptions).foreach((Function1 & Serializable)_$4 -> {
            Implicits.OutputStreamExtensions outputStreamExtensions = package$.MODULE$.OutputStreamExtensions(package$.MODULE$.OutputStreamExtensions((OutputStream)_$4).buffered());
            return outputStreamExtensions.write(bytes, outputStreamExtensions.write$default$2());
        });
        return this;
    }

    public Seq<OpenOption> writeBytes$default$2(Iterator<Object> bytes) {
        return File$OpenOptions$.MODULE$.default();
    }

    public File write(String text, Seq<OpenOption> openOptions, Charset charset) {
        return this.writeByteArray(text.getBytes(charset), openOptions);
    }

    public Seq<OpenOption> write$default$2(String text) {
        return File$OpenOptions$.MODULE$.default();
    }

    public Charset write$default$3(String text) {
        return package$.MODULE$.DefaultCharset();
    }

    public File writeText(String text, Seq<OpenOption> openOptions, Charset charset) {
        return this.write(text, openOptions, charset);
    }

    public Seq<OpenOption> writeText$default$2(String text) {
        return File$OpenOptions$.MODULE$.default();
    }

    public Charset writeText$default$3(String text) {
        return package$.MODULE$.DefaultCharset();
    }

    public File overwrite(String text, Seq<OpenOption> openOptions, Charset charset) {
        return this.write(text, openOptions, charset);
    }

    public Seq<OpenOption> overwrite$default$2(String text) {
        return File$OpenOptions$.MODULE$.default();
    }

    public Charset overwrite$default$3(String text) {
        return package$.MODULE$.DefaultCharset();
    }

    public RandomAccessFile newRandomAccess(RandomAccessMode mode) {
        return new RandomAccessFile(this.toJava(), mode.value());
    }

    public RandomAccessMode newRandomAccess$default$1() {
        return File$RandomAccessMode$.MODULE$.read();
    }

    public Dispose<RandomAccessFile> randomAccess(RandomAccessMode mode) {
        return package$.MODULE$.DisposeableExtensions(this.newRandomAccess(mode), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public RandomAccessMode randomAccess$default$1() {
        return File$RandomAccessMode$.MODULE$.read();
    }

    public BufferedReader newBufferedReader(Charset charset) {
        return Files.newBufferedReader(this.path(), charset);
    }

    public Charset newBufferedReader$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public Dispose<BufferedReader> bufferedReader(Charset charset) {
        return package$.MODULE$.DisposeableExtensions(this.newBufferedReader(charset), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public Charset bufferedReader$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public BufferedWriter newBufferedWriter(Charset charset, Seq<OpenOption> openOptions) {
        return Files.newBufferedWriter(this.path(), charset, (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions, OpenOption.class));
    }

    public Charset newBufferedWriter$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public Seq<OpenOption> newBufferedWriter$default$2() {
        return File$OpenOptions$.MODULE$.default();
    }

    public Dispose<BufferedWriter> bufferedWriter(Charset charset, Seq<OpenOption> openOptions) {
        return package$.MODULE$.DisposeableExtensions(this.newBufferedWriter(charset, openOptions), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public Charset bufferedWriter$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public Seq<OpenOption> bufferedWriter$default$2() {
        return File$OpenOptions$.MODULE$.default();
    }

    public FileReader newFileReader() {
        return new FileReader(this.toJava());
    }

    public Dispose<FileReader> fileReader() {
        return package$.MODULE$.DisposeableExtensions(this.newFileReader(), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public FileWriter newFileWriter(boolean append) {
        return new FileWriter(this.toJava(), append);
    }

    public boolean newFileWriter$default$1() {
        return false;
    }

    public Dispose<FileWriter> fileWriter(boolean append) {
        return package$.MODULE$.DisposeableExtensions(this.newFileWriter(append), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public boolean fileWriter$default$1() {
        return false;
    }

    public PrintWriter newPrintWriter(boolean autoFlush, Seq<OpenOption> openOptions) {
        return new PrintWriter(this.newOutputStream(openOptions), autoFlush);
    }

    public boolean newPrintWriter$default$1() {
        return false;
    }

    public Seq<OpenOption> newPrintWriter$default$2(boolean autoFlush) {
        return File$OpenOptions$.MODULE$.default();
    }

    public Dispose<PrintWriter> printWriter(boolean autoFlush, Seq<OpenOption> openOptions) {
        return package$.MODULE$.DisposeableExtensions(this.newPrintWriter(autoFlush, openOptions), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public boolean printWriter$default$1() {
        return false;
    }

    public Seq<OpenOption> printWriter$default$2(boolean autoFlush) {
        return File$OpenOptions$.MODULE$.default();
    }

    public InputStream newInputStream(Seq<OpenOption> openOptions) {
        return Files.newInputStream(this.path(), (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions, OpenOption.class));
    }

    public Seq<OpenOption> newInputStream$default$1() {
        return File$OpenOptions$.MODULE$.default();
    }

    public Dispose<InputStream> inputStream(Seq<OpenOption> openOptions) {
        return package$.MODULE$.DisposeableExtensions(this.newInputStream(openOptions), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public Seq<OpenOption> inputStream$default$1() {
        return File$OpenOptions$.MODULE$.default();
    }

    public FileInputStream newFileInputStream() {
        return new FileInputStream(this.toJava());
    }

    public Dispose<FileInputStream> fileInputStream() {
        return package$.MODULE$.DisposeableExtensions(this.newFileInputStream(), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public FileOutputStream newFileOutputStream(boolean append) {
        return new FileOutputStream(this.toJava(), append);
    }

    public boolean newFileOutputStream$default$1() {
        return false;
    }

    public Dispose<FileOutputStream> fileOutputStream(boolean append) {
        return package$.MODULE$.DisposeableExtensions(this.newFileOutputStream(append), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public boolean fileOutputStream$default$1() {
        return false;
    }

    public Scanner newScanner(StringSplitter splitter, Charset charset) {
        return Scanner$.MODULE$.apply(this.newBufferedReader(charset), splitter, package$.MODULE$.bufferedReaderSource());
    }

    public StringSplitter newScanner$default$1() {
        return StringSplitter$.MODULE$.Default();
    }

    public Charset newScanner$default$2(StringSplitter splitter) {
        return package$.MODULE$.DefaultCharset();
    }

    public Dispose<Scanner> scanner(StringSplitter splitter, Charset charset) {
        return package$.MODULE$.DisposeableExtensions(this.newScanner(splitter, charset), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public StringSplitter scanner$default$1() {
        return StringSplitter$.MODULE$.Default();
    }

    public Charset scanner$default$2(StringSplitter splitter) {
        return package$.MODULE$.DefaultCharset();
    }

    public OutputStream newOutputStream(Seq<OpenOption> openOptions) {
        return Files.newOutputStream(this.path(), (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions, OpenOption.class));
    }

    public Seq<OpenOption> newOutputStream$default$1() {
        return File$OpenOptions$.MODULE$.default();
    }

    public Dispose<OutputStream> outputStream(Seq<OpenOption> openOptions) {
        return package$.MODULE$.DisposeableExtensions(this.newOutputStream(openOptions), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public Seq<OpenOption> outputStream$default$1() {
        return File$OpenOptions$.MODULE$.default();
    }

    public ZipOutputStream newZipOutputStream(Seq<OpenOption> openOptions, Charset charset) {
        return new ZipOutputStream(this.newOutputStream(openOptions), charset);
    }

    public Seq<OpenOption> newZipOutputStream$default$1() {
        return File$OpenOptions$.MODULE$.default();
    }

    public Charset newZipOutputStream$default$2() {
        return package$.MODULE$.DefaultCharset();
    }

    public Dispose<ZipInputStream> zipInputStream(Charset charset) {
        return package$.MODULE$.DisposeableExtensions(this.newZipInputStream(charset), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public Charset zipInputStream$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public ZipInputStream newZipInputStream(Charset charset) {
        return new ZipInputStream((InputStream)package$.MODULE$.InputStreamExtensions(this.newFileInputStream()).buffered(), charset);
    }

    public Charset newZipInputStream$default$1() {
        return package$.MODULE$.DefaultCharset();
    }

    public Dispose<ZipOutputStream> zipOutputStream(Seq<OpenOption> openOptions, Charset charset) {
        return package$.MODULE$.DisposeableExtensions(this.newZipOutputStream(openOptions, charset), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public Seq<OpenOption> zipOutputStream$default$1() {
        return File$OpenOptions$.MODULE$.default();
    }

    public Charset zipOutputStream$default$2() {
        return package$.MODULE$.DefaultCharset();
    }

    public GZIPOutputStream newGzipOutputStream(int bufferSize, boolean syncFlush, boolean append) {
        return new GZIPOutputStream((OutputStream)this.newFileOutputStream(append), bufferSize, syncFlush);
    }

    public int newGzipOutputStream$default$1() {
        return package$.MODULE$.DefaultBufferSize();
    }

    public boolean newGzipOutputStream$default$2() {
        return false;
    }

    public boolean newGzipOutputStream$default$3() {
        return false;
    }

    public Dispose<GZIPOutputStream> gzipOutputStream(int bufferSize, boolean syncFlush, boolean append) {
        return package$.MODULE$.DisposeableExtensions(this.newGzipOutputStream(bufferSize, syncFlush, append), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public int gzipOutputStream$default$1() {
        return package$.MODULE$.DefaultBufferSize();
    }

    public boolean gzipOutputStream$default$2() {
        return false;
    }

    public boolean gzipOutputStream$default$3() {
        return false;
    }

    public GZIPInputStream newGzipInputStream(int bufferSize) {
        return new GZIPInputStream((InputStream)this.newFileInputStream(), bufferSize);
    }

    public int newGzipInputStream$default$1() {
        return package$.MODULE$.DefaultBufferSize();
    }

    public Dispose<GZIPInputStream> gzipInputStream(int bufferSize) {
        return package$.MODULE$.DisposeableExtensions(this.newGzipInputStream(bufferSize), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public int gzipInputStream$default$1() {
        return package$.MODULE$.DefaultBufferSize();
    }

    public FileChannel newFileChannel(Seq<OpenOption> openOptions, Seq<FileAttribute<?>> attributes) {
        return FileChannel.open(this.path(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)openOptions.toSet()).asJava(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes, FileAttribute.class));
    }

    public Seq<OpenOption> newFileChannel$default$1() {
        return File$OpenOptions$.MODULE$.default();
    }

    public Seq<FileAttribute<?>> newFileChannel$default$2() {
        return File$Attributes$.MODULE$.default();
    }

    public Dispose<FileChannel> fileChannel(Seq<OpenOption> openOptions, Seq<FileAttribute<?>> attributes) {
        return package$.MODULE$.DisposeableExtensions(this.newFileChannel(openOptions, attributes), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public Seq<OpenOption> fileChannel$default$1() {
        return File$OpenOptions$.MODULE$.default();
    }

    public Seq<FileAttribute<?>> fileChannel$default$2() {
        return File$Attributes$.MODULE$.default();
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Seq<OpenOption> openOptions) {
        return AsynchronousFileChannel.open(this.path(), (OpenOption[])Arrays$.MODULE$.seqToArray(openOptions, OpenOption.class));
    }

    public Seq<OpenOption> newAsynchronousFileChannel$default$1() {
        return File$OpenOptions$.MODULE$.default();
    }

    public Dispose<AsynchronousFileChannel> asynchronousFileChannel(Seq<OpenOption> openOptions) {
        return package$.MODULE$.DisposeableExtensions(this.newAsynchronousFileChannel(openOptions), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public Seq<OpenOption> asynchronousFileChannel$default$1() {
        return File$OpenOptions$.MODULE$.default();
    }

    public WatchService newWatchService() {
        return this.fileSystem().newWatchService();
    }

    public Dispose<WatchService> watchService() {
        return package$.MODULE$.DisposeableExtensions(this.newWatchService(), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed();
    }

    public File writeSerialized(Serializable obj, int bufferSize, Seq<OpenOption> openOptions) {
        this.createFileIfNotExists(true, this.createFileIfNotExists$default$2(true), this.createFileIfNotExists$default$3(true)).outputStream(openOptions).foreach((JProcedure1 & Serializable)_$5 -> package$.MODULE$.ObjectOutputStreamExtensions(package$.MODULE$.OutputStreamExtensions((OutputStream)_$5).asObjectOutputStream(bufferSize)).serialize(obj).flush());
        return this;
    }

    public int writeSerialized$default$2() {
        return package$.MODULE$.DefaultBufferSize();
    }

    public Seq<OpenOption> writeSerialized$default$3(Serializable obj, int bufferSize) {
        return File$OpenOptions$.MODULE$.default();
    }

    public <A> A readDeserialized(Option<ClassLoader> classLoaderOverride, int bufferSize, Seq<OpenOption> openOptions) {
        Option<ClassLoader> option = classLoaderOverride;
        if (option instanceof Some) {
            ClassLoader classLoader = (ClassLoader)((Some)option).value();
            return (A)this.inputStream(openOptions).apply((Function1 & Serializable)_$6 -> package$.MODULE$.ObjectInputStreamExtensions(package$.MODULE$.InputStreamExtensions((InputStream)_$6).asObjectInputStreamUsingClassLoader(classLoader, bufferSize)).deserialize());
        }
        return (A)this.inputStream(openOptions).apply((Function1 & Serializable)_$7 -> package$.MODULE$.ObjectInputStreamExtensions(package$.MODULE$.InputStreamExtensions((InputStream)_$7).asObjectInputStream(bufferSize)).deserialize());
    }

    public <A> Option<ClassLoader> readDeserialized$default$1() {
        return None$.MODULE$;
    }

    public int readDeserialized$default$2() {
        return package$.MODULE$.DefaultBufferSize();
    }

    public <A> Seq<OpenOption> readDeserialized$default$3(Option<ClassLoader> classLoaderOverride, int bufferSize) {
        return File$OpenOptions$.MODULE$.default();
    }

    public File register(WatchService service, Seq<WatchEvent.Kind<?>> events) {
        this.path().register(service, (WatchEvent.Kind[])events.toArray(ClassTag$.MODULE$.apply(WatchEvent.Kind.class)), new WatchEvent.Modifier[0]);
        return this;
    }

    public Seq<WatchEvent.Kind<?>> register$default$2() {
        return File$Events$.MODULE$.all();
    }

    public byte[] digest(MessageDigest algorithm) {
        ((IterableOnceOps)this.listRelativePaths(this.listRelativePaths$default$1()).toSeq().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).foreach((Function1)(JProcedure1 & Serializable)relativePath -> {
            File file = File$.MODULE$.apply(this.path().resolve((Path)relativePath));
            if (file.isDirectory(file.isDirectory$default$1())) {
                algorithm.update(relativePath.toString().getBytes());
                return;
            }
            package$.MODULE$.DisposeableExtensions(package$.MODULE$.InputStreamExtensions(file.newInputStream(file.newInputStream$default$1())).withMessageDigest(algorithm), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed().foreach((Function1 & Serializable)_$8 -> {
                Implicits.InputStreamExtensions inputStreamExtensions = package$.MODULE$.InputStreamExtensions((InputStream)_$8);
                return (NullOutputStream$)inputStreamExtensions.pipeTo((OutputStream)NullOutputStream$.MODULE$, inputStreamExtensions.pipeTo$default$2());
            });
        });
        return algorithm.digest();
    }

    public File update(String attribute, Object value, Seq<LinkOption> linkOptions) {
        Files.setAttribute(this.path(), attribute, value, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class));
        return this;
    }

    public Seq<LinkOption> update$default$3(String attribute, Object value) {
        return File$LinkOptions$.MODULE$.default();
    }

    public String checksum(MessageDigest algorithm) {
        return package$.MODULE$.toHex(this.digest(algorithm));
    }

    public String md5() {
        return this.checksum(package$.MODULE$.stringToMessageDigest("MD5"));
    }

    public String sha1() {
        return this.checksum(package$.MODULE$.stringToMessageDigest("SHA-1"));
    }

    public String sha256() {
        return this.checksum(package$.MODULE$.stringToMessageDigest("SHA-256"));
    }

    public String sha512() {
        return this.checksum(package$.MODULE$.stringToMessageDigest("SHA-512"));
    }

    public Option<File> symbolicLink() {
        return package$.MODULE$.when(this.isSymbolicLink(), this::symbolicLink$$anonfun$1);
    }

    public boolean isDirectory(Seq<LinkOption> linkOptions) {
        return Files.isDirectory(this.path(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class));
    }

    public Seq<LinkOption> isDirectory$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isRegularFile(Seq<LinkOption> linkOptions) {
        return Files.isRegularFile(this.path(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class));
    }

    public Seq<LinkOption> isRegularFile$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isSymbolicLink() {
        return Files.isSymbolicLink(this.path());
    }

    public boolean isHidden() {
        return Files.isHidden(this.path());
    }

    public Iterator<File> list(Function1<File, Object> filter, int maxDepth, Seq<FileVisitOption> visitOptions) {
        BiPredicate<Path, BasicFileAttributes> predicate = new BiPredicate<Path, BasicFileAttributes>(filter){
            private final Function1 filter$1;
            {
                this.filter$1 = filter$2;
            }

            public boolean test(Path p, BasicFileAttributes a) {
                return BoxesRunTime.unboxToBoolean((Object)this.filter$1.apply((Object)File$.MODULE$.apply(p)));
            }
        };
        return package$.MODULE$.pathStreamToFiles((Stream)Files.find(this.path(), maxDepth, predicate, (FileVisitOption[])Arrays$.MODULE$.seqToArray(visitOptions, FileVisitOption.class)));
    }

    public int list$default$2() {
        return Integer.MAX_VALUE;
    }

    public Seq<FileVisitOption> list$default$3() {
        return File$VisitOptions$.MODULE$.default();
    }

    public boolean isLocked(RandomAccessMode mode, long position, long size, boolean isShared, Seq<LinkOption> linkOptions) {
        boolean bl;
        try {
            bl = BoxesRunTime.unboxToBoolean(this.usingLock(mode, (Function1 & Serializable)channel -> {
                channel.tryLock(position, size, isShared).release();
                return false;
            }));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof OverlappingFileLockException || throwable2 instanceof NonWritableChannelException || throwable2 instanceof NonReadableChannelException) {
                bl = true;
            }
            if (throwable2 instanceof FileNotFoundException && BoxesRunTime.unboxToBoolean((Object)this.verifiedExists(linkOptions).getOrElse(File::isLocked$$anonfun$2))) {
                bl = true;
            }
            throw throwable;
        }
        return bl;
    }

    public long isLocked$default$2() {
        return 0L;
    }

    public long isLocked$default$3() {
        return Long.MAX_VALUE;
    }

    public boolean isLocked$default$4() {
        return false;
    }

    public Seq<LinkOption> isLocked$default$5(RandomAccessMode mode, long position, long size, boolean isShared) {
        return File$LinkOptions$.MODULE$.default();
    }

    public Option<Object> verifiedExists(Seq<LinkOption> linkOptions) {
        if (this.exists(linkOptions)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (this.notExists(linkOptions)) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return None$.MODULE$;
    }

    public Seq<LinkOption> verifiedExists$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public <U> U usingLock(RandomAccessMode mode, Function1<FileChannel, U> f) {
        return package$.MODULE$.DisposeableExtensions(this.newRandomAccess(mode).getChannel(), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed().apply(f);
    }

    public boolean isReadLocked(long position, long size, boolean isShared) {
        RandomAccessMode randomAccessMode = File$RandomAccessMode$.MODULE$.read();
        return this.isLocked(randomAccessMode, position, size, isShared, this.isLocked$default$5(randomAccessMode, position, size, isShared));
    }

    public long isReadLocked$default$1() {
        return 0L;
    }

    public long isReadLocked$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean isReadLocked$default$3() {
        return false;
    }

    public boolean isWriteLocked(long position, long size, boolean isShared) {
        RandomAccessMode randomAccessMode = File$RandomAccessMode$.MODULE$.readWrite();
        return this.isLocked(randomAccessMode, position, size, isShared, this.isLocked$default$5(randomAccessMode, position, size, isShared));
    }

    public long isWriteLocked$default$1() {
        return 0L;
    }

    public long isWriteLocked$default$2() {
        return Long.MAX_VALUE;
    }

    public boolean isWriteLocked$default$3() {
        return false;
    }

    public Iterator<File> list() {
        return package$.MODULE$.pathStreamToFiles((Stream)Files.list(this.path()));
    }

    public Iterator<File> children() {
        return this.list();
    }

    public Iterator<File> entries() {
        return this.list();
    }

    public Iterator<File> listRecursively(Seq<FileVisitOption> visitOptions) {
        return this.walk(this.walk$default$1(), visitOptions).filterNot((Function1 & Serializable)that -> this.isSamePathAs((File)that));
    }

    public Seq<FileVisitOption> listRecursively$default$1() {
        return File$VisitOptions$.MODULE$.default();
    }

    public Iterator<File> walk(int maxDepth, Seq<FileVisitOption> visitOptions) {
        return package$.MODULE$.pathStreamToFiles((Stream)Files.walk(this.path(), maxDepth, (FileVisitOption[])Arrays$.MODULE$.seqToArray(visitOptions, FileVisitOption.class)));
    }

    public int walk$default$1() {
        return Integer.MAX_VALUE;
    }

    public Seq<FileVisitOption> walk$default$2(int maxDepth) {
        return File$VisitOptions$.MODULE$.default();
    }

    public PathMatcher pathMatcher(PathMatcherSyntax syntax, boolean includePath, String pattern) {
        return syntax.apply(this, pattern, includePath);
    }

    public Iterator<File> glob(String pattern, boolean includePath, int maxDepth, PathMatcherSyntax syntax, Seq<FileVisitOption> visitOptions) {
        return package$.MODULE$.PathMatcherExtensions(this.pathMatcher(syntax, includePath, pattern)).matches(this, maxDepth, visitOptions);
    }

    public boolean glob$default$2() {
        return true;
    }

    public int glob$default$3() {
        return Integer.MAX_VALUE;
    }

    public PathMatcherSyntax glob$default$4(String pattern, boolean includePath, int maxDepth) {
        return File$PathMatcherSyntax$.MODULE$.default();
    }

    public Seq<FileVisitOption> glob$default$5(String pattern, boolean includePath, int maxDepth) {
        return File$VisitOptions$.MODULE$.default();
    }

    public Iterator<File> globRegex(Regex pattern, boolean includePath, int maxDepth, Seq<FileVisitOption> visitOptions) {
        return this.glob(pattern.regex(), includePath, maxDepth, File$PathMatcherSyntax$.MODULE$.regex(), visitOptions);
    }

    public boolean globRegex$default$2() {
        return true;
    }

    public int globRegex$default$3() {
        return Integer.MAX_VALUE;
    }

    public Seq<FileVisitOption> globRegex$default$4(Regex pattern, boolean includePath, int maxDepth) {
        return File$VisitOptions$.MODULE$.default();
    }

    public Iterator<File> collectChildren(Function1<File, Object> matchFilter, int maxDepth, Seq<FileVisitOption> visitOptions) {
        return this.walk(maxDepth, visitOptions).filter(matchFilter);
    }

    public int collectChildren$default$2() {
        return Integer.MAX_VALUE;
    }

    public Seq<FileVisitOption> collectChildren$default$3(Function1<File, Object> matchFilter, int maxDepth) {
        return File$VisitOptions$.MODULE$.default();
    }

    public URI uri() {
        return this.path().toUri();
    }

    public URL url() {
        return this.uri().toURL();
    }

    public long size(Seq<FileVisitOption> visitOptions) {
        return this.size(this.isDirectory(this.isDirectory$default$1()), visitOptions);
    }

    public Seq<FileVisitOption> size$default$1() {
        return File$VisitOptions$.MODULE$.default();
    }

    public long size(boolean returnZeroIfMissing, Seq<FileVisitOption> visitOptions) {
        return BoxesRunTime.unboxToLong((Object)this.walk(this.walk$default$1(), visitOptions).map((Function1 & Serializable)f -> {
            long l;
            try {
                l = Files.size(f.path());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof FileNotFoundException || throwable2 instanceof NoSuchFileException) {
                    if (returnZeroIfMissing) {
                        l = 0L;
                    }
                }
                throw throwable;
            }
            return l;
        }).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public scala.collection.immutable.Set<PosixFilePermission> permissions(Seq<LinkOption> linkOptions) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(Files.getPosixFilePermissions(this.path(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class))).asScala()).toSet();
    }

    public Seq<LinkOption> permissions$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public String permissionsAsString(Seq<LinkOption> linkOptions) {
        return PosixFilePermissions.toString((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.permissions(linkOptions)).asJava());
    }

    public Seq<LinkOption> permissionsAsString$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public File setPermissions(scala.collection.immutable.Set<PosixFilePermission> permissions) {
        Files.setPosixFilePermissions(this.path(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(permissions).asJava());
        return this;
    }

    public File addPermission(PosixFilePermission permission, Seq<LinkOption> linkOptions) {
        return this.setPermissions((scala.collection.immutable.Set<PosixFilePermission>)((scala.collection.immutable.Set)this.permissions(linkOptions).$plus((Object)permission)));
    }

    public Seq<LinkOption> addPermission$default$2(PosixFilePermission permission) {
        return File$LinkOptions$.MODULE$.default();
    }

    public File removePermission(PosixFilePermission permission, Seq<LinkOption> linkOptions) {
        return this.setPermissions((scala.collection.immutable.Set<PosixFilePermission>)((scala.collection.immutable.Set)this.permissions(linkOptions).$minus((Object)permission)));
    }

    public Seq<LinkOption> removePermission$default$2(PosixFilePermission permission) {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean testPermission(PosixFilePermission permission, Seq<LinkOption> linkOptions) {
        return this.permissions(linkOptions).apply((Object)permission);
    }

    public Seq<LinkOption> testPermission$default$2(PosixFilePermission permission) {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isOwnerReadable(Seq<LinkOption> linkOptions) {
        return this.testPermission(PosixFilePermission.OWNER_READ, linkOptions);
    }

    public Seq<LinkOption> isOwnerReadable$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isOwnerWritable(Seq<LinkOption> linkOptions) {
        return this.testPermission(PosixFilePermission.OWNER_WRITE, linkOptions);
    }

    public Seq<LinkOption> isOwnerWritable$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isOwnerExecutable(Seq<LinkOption> linkOptions) {
        return this.testPermission(PosixFilePermission.OWNER_EXECUTE, linkOptions);
    }

    public Seq<LinkOption> isOwnerExecutable$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isGroupReadable(Seq<LinkOption> linkOptions) {
        return this.testPermission(PosixFilePermission.GROUP_READ, linkOptions);
    }

    public Seq<LinkOption> isGroupReadable$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isGroupWritable(Seq<LinkOption> linkOptions) {
        return this.testPermission(PosixFilePermission.GROUP_WRITE, linkOptions);
    }

    public Seq<LinkOption> isGroupWritable$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isGroupExecutable(Seq<LinkOption> linkOptions) {
        return this.testPermission(PosixFilePermission.GROUP_EXECUTE, linkOptions);
    }

    public Seq<LinkOption> isGroupExecutable$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isOthersReadable(Seq<LinkOption> linkOptions) {
        return this.testPermission(PosixFilePermission.OTHERS_READ, linkOptions);
    }

    public Seq<LinkOption> isOthersReadable$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isOthersWritable(Seq<LinkOption> linkOptions) {
        return this.testPermission(PosixFilePermission.OTHERS_WRITE, linkOptions);
    }

    public Seq<LinkOption> isOthersWritable$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isOthersExecutable(Seq<LinkOption> linkOptions) {
        return this.testPermission(PosixFilePermission.OTHERS_EXECUTE, linkOptions);
    }

    public Seq<LinkOption> isOthersExecutable$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean isReadable() {
        return this.toJava().canRead();
    }

    public boolean isWritable() {
        return this.toJava().canWrite();
    }

    public boolean isExecutable() {
        return this.toJava().canExecute();
    }

    public BasicFileAttributes attributes(Seq<LinkOption> linkOptions) {
        return Files.readAttributes(this.path(), BasicFileAttributes.class, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class));
    }

    public Seq<LinkOption> attributes$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public PosixFileAttributes posixAttributes(Seq<LinkOption> linkOptions) {
        return Files.readAttributes(this.path(), PosixFileAttributes.class, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class));
    }

    public Seq<LinkOption> posixAttributes$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public DosFileAttributes dosAttributes(Seq<LinkOption> linkOptions) {
        return Files.readAttributes(this.path(), DosFileAttributes.class, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class));
    }

    public Seq<LinkOption> dosAttributes$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public UserPrincipal owner(Seq<LinkOption> linkOptions) {
        return Files.getOwner(this.path(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class));
    }

    public Seq<LinkOption> owner$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public String ownerName(Seq<LinkOption> linkOptions) {
        return this.owner(linkOptions).getName();
    }

    public Seq<LinkOption> ownerName$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public GroupPrincipal group(Seq<LinkOption> linkOptions) {
        return this.posixAttributes(linkOptions).group();
    }

    public Seq<LinkOption> group$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public String groupName(Seq<LinkOption> linkOptions) {
        return this.group(linkOptions).getName();
    }

    public Seq<LinkOption> groupName$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public File setOwner(String owner) {
        Files.setOwner(this.path(), this.fileSystem().getUserPrincipalLookupService().lookupPrincipalByName(owner));
        return this;
    }

    public File setGroup(String group, Seq<LinkOption> linkOptions) {
        Files.getFileAttributeView(this.path(), PosixFileAttributeView.class, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)).setGroup(this.fileSystem().getUserPrincipalLookupService().lookupPrincipalByGroupName(group));
        return this;
    }

    public Seq<LinkOption> setGroup$default$2(String group) {
        return File$LinkOptions$.MODULE$.default();
    }

    public File touch(Instant time, Seq<FileAttribute<?>> attributes, Seq<LinkOption> linkOptions) {
        Files.setLastModifiedTime(this.createFileIfNotExists(this.createFileIfNotExists$default$1(), attributes, linkOptions).path(), FileTime.from(time));
        return this;
    }

    public Instant touch$default$1() {
        return Instant.now();
    }

    public Seq<FileAttribute<?>> touch$default$2(Instant time) {
        return File$Attributes$.MODULE$.default();
    }

    public Seq<LinkOption> touch$default$3(Instant time) {
        return File$LinkOptions$.MODULE$.default();
    }

    public Instant lastModifiedTime(Seq<LinkOption> linkOptions) {
        return Files.getLastModifiedTime(this.path(), (LinkOption[])Arrays$.MODULE$.seqToArray(linkOptions, LinkOption.class)).toInstant();
    }

    public Seq<LinkOption> lastModifiedTime$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public File delete(boolean swallowIOExceptions, Seq<LinkOption> linkOption) {
        block3: {
            try {
                if (this.isDirectory(linkOption)) {
                    this.list().toList().foreach((Function1 & Serializable)_$9 -> _$9.delete(swallowIOExceptions, linkOption));
                }
                Files.delete(this.path());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException && swallowIOExceptions) break block3;
                throw throwable;
            }
        }
        return this;
    }

    public boolean delete$default$1() {
        return false;
    }

    public Seq<LinkOption> delete$default$2() {
        return File$LinkOptions$.MODULE$.noFollow();
    }

    public File renameTo(String newName) {
        File file = File$.MODULE$.apply(this.path().resolveSibling(newName));
        return this.moveTo(file, this.moveTo$default$2(file));
    }

    public File moveTo(File destination, Seq<CopyOption> copyOptions) {
        Files.move(this.path(), destination.path(), (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions, CopyOption.class));
        return destination;
    }

    public Seq<CopyOption> moveTo$default$2(File destination) {
        return File$CopyOptions$.MODULE$.apply(false);
    }

    public File moveToDirectory(File directory, Seq<LinkOption> linkOptions) {
        Predef$.MODULE$.require(directory.isDirectory(linkOptions), () -> File.moveToDirectory$$anonfun$1(directory));
        return this.moveTo(directory.$div(this.name()), linkOptions);
    }

    public Seq<LinkOption> moveToDirectory$default$2(File directory) {
        return File$LinkOptions$.MODULE$.default();
    }

    public File copyTo(File destination, boolean overwrite, Seq<CopyOption> copyOptions) {
        Path path = this.isDirectory(this.isDirectory$default$1()) ? Files.walkFileTree(this.path(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(destination, copyOptions, this){
            private final File destination$2;
            private final Seq copyOptions$1;
            private final /* synthetic */ File $outer;
            {
                this.destination$2 = destination$7;
                this.copyOptions$1 = copyOptions$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Path newPath(Path subPath) {
                return this.destination$2.path().resolve(this.$outer.path().relativize(subPath));
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Files.createDirectories(this.newPath(dir), new FileAttribute[0]);
                return super.preVisitDirectory(dir, attrs);
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.copy(file, this.newPath(file), (CopyOption[])Arrays$.MODULE$.seqToArray(this.copyOptions$1, CopyOption.class));
                return super.visitFile(file, attrs);
            }
        }) : Files.copy(this.path(), destination.path(), (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions, CopyOption.class));
        return destination;
    }

    public boolean copyTo$default$2() {
        return false;
    }

    public Seq<CopyOption> copyTo$default$3(File destination, boolean overwrite) {
        return File$CopyOptions$.MODULE$.apply(overwrite);
    }

    public File copyToDirectory(File directory, Seq<LinkOption> linkOptions, Seq<CopyOption> copyOptions) {
        Predef$.MODULE$.require(directory.isDirectory(linkOptions), () -> File.copyToDirectory$$anonfun$1(directory));
        return this.copyTo(directory.$div(this.name()), this.copyTo$default$2(), copyOptions);
    }

    public Seq<LinkOption> copyToDirectory$default$2(File directory) {
        return File$LinkOptions$.MODULE$.default();
    }

    public Seq<CopyOption> copyToDirectory$default$3(File directory) {
        return File$CopyOptions$.MODULE$.default();
    }

    public File symbolicLinkTo(File destination, Seq<FileAttribute<?>> attributes) {
        Files.createSymbolicLink(this.path(), destination.path(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes, FileAttribute.class));
        return destination;
    }

    public Seq<FileAttribute<?>> symbolicLinkTo$default$2(File destination) {
        return File$Attributes$.MODULE$.default();
    }

    public File linkTo(File destination, boolean symbolic, Seq<FileAttribute<?>> attributes) {
        if (symbolic) {
            return this.symbolicLinkTo(destination, attributes);
        }
        Files.createLink(destination.path(), this.path());
        return destination;
    }

    public boolean linkTo$default$2() {
        return false;
    }

    public Seq<FileAttribute<?>> linkTo$default$3(File destination, boolean symbolic) {
        return File$Attributes$.MODULE$.default();
    }

    public Iterator<Path> listRelativePaths(Seq<FileVisitOption> visitOptions) {
        return this.walk(this.walk$default$1(), visitOptions).map((Function1 & Serializable)destination -> this.relativize((File)destination));
    }

    public Seq<FileVisitOption> listRelativePaths$default$1() {
        return File$VisitOptions$.MODULE$.default();
    }

    public Path relativize(File destination) {
        return this.path().relativize(destination.path());
    }

    public boolean isSamePathAs(File that) {
        Path path = this.path();
        Path path2 = that.path();
        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
    }

    public boolean isSameFileAs(File that) {
        return Files.isSameFile(this.path(), that.path());
    }

    public boolean isSameContentAs(File that) {
        return this.isSimilarContentAs(that);
    }

    public boolean isSimilarContentAs(File that) {
        String string = this.md5();
        String string2 = that.md5();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof File) {
            File file = (File)object;
            return this.isSamePathAs(file);
        }
        return false;
    }

    public boolean isEmpty(Seq<LinkOption> linkOptions) {
        if (this.isDirectory(linkOptions)) {
            return BoxesRunTime.unboxToLong(package$.MODULE$.DisposeableExtensions(Files.list(this.path()), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed().apply((Function1 & Serializable)_$10 -> _$10.count())) == 0L;
        }
        if (this.isRegularFile(linkOptions)) {
            return this.toJava().length() == 0L;
        }
        return this.notExists(linkOptions);
    }

    public Seq<LinkOption> isEmpty$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public boolean nonEmpty(Seq<LinkOption> linkOptions) {
        return !this.isEmpty(linkOptions);
    }

    public Seq<LinkOption> nonEmpty$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public File clear(Seq<LinkOption> linkOptions) {
        Object object;
        if (this.isDirectory(linkOptions)) {
            this.children().foreach((Function1 & Serializable)_$11 -> _$11.delete(_$11.delete$default$1(), _$11.delete$default$2()));
            object = BoxedUnit.UNIT;
        } else {
            object = this.writeByteArray(Array$.MODULE$.emptyByteArray(), File$OpenOptions$.MODULE$.default());
        }
        return this;
    }

    public Seq<LinkOption> clear$default$1() {
        return File$LinkOptions$.MODULE$.default();
    }

    public File deleteOnExit(boolean swallowIOExceptions, Seq<LinkOption> linkOption) {
        block3: {
            try {
                if (this.isDirectory(linkOption)) {
                    this.list().toList().foreach((Function1 & Serializable)_$12 -> _$12.deleteOnExit(swallowIOExceptions, linkOption));
                }
                this.toJava().deleteOnExit();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException && swallowIOExceptions) break block3;
                throw throwable;
            }
        }
        return this;
    }

    public boolean deleteOnExit$default$1() {
        return false;
    }

    public Seq<LinkOption> deleteOnExit$default$2() {
        return File$LinkOptions$.MODULE$.noFollow();
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    public String toString() {
        return this.pathAsString();
    }

    public File zipTo(File destination, int compressionLevel, Charset charset) {
        Iterator files = this.isDirectory(this.isDirectory$default$1()) ? this.children() : scala.package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{this}));
        return destination.zipIn(files, compressionLevel, charset);
    }

    public int zipTo$default$2() {
        return -1;
    }

    public Charset zipTo$default$3(File destination, int compressionLevel) {
        return package$.MODULE$.DefaultCharset();
    }

    public File zip(int compressionLevel, Charset charset) {
        String string = this.name();
        Option<File> option = File$.MODULE$.newTemporaryFile$default$3();
        return this.zipTo(File$.MODULE$.newTemporaryFile(string, ".zip", option, File$.MODULE$.newTemporaryFile$default$4(string, ".zip", option)), compressionLevel, charset);
    }

    public int zip$default$1() {
        return -1;
    }

    public Charset zip$default$2(int compressionLevel) {
        return package$.MODULE$.DefaultCharset();
    }

    public File unzipTo(File destination, Function1<ZipEntry, Object> zipFilter, Charset charset) {
        package$.MODULE$.DisposeableExtensions(new ZipFile(this.toJava(), charset), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed().foreach((JProcedure1 & Serializable)zipFile -> ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(zipFile.entries()).asScala()).withFilter(zipFilter).foreach((Function1 & Serializable)entry -> package$.MODULE$.ZipEntryExtensions((ZipEntry)entry).extractTo(destination, (Function0<InputStream>)((Function0 & Serializable)() -> File.unzipTo$$anonfun$1$$anonfun$1$$anonfun$1(zipFile, entry)))));
        return destination;
    }

    public File unzipTo$default$1() {
        String string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.name()), ".zip");
        Option<File> option = File$.MODULE$.newTemporaryDirectory$default$2();
        return File$.MODULE$.newTemporaryDirectory(string, option, File$.MODULE$.newTemporaryDirectory$default$3(string, option));
    }

    public Function1<ZipEntry, Object> unzipTo$default$2() {
        return (Function1 & Serializable)_$13 -> true;
    }

    public Charset unzipTo$default$3(File destination, Function1<ZipEntry, Object> zipFilter) {
        return package$.MODULE$.DefaultCharset();
    }

    public File streamedUnzip(File destinationDirectory, Charset charset) {
        this.zipInputStream(charset).foreach((Function1 & Serializable)zipIn -> package$.MODULE$.ZipInputStreamExtensions((ZipInputStream)zipIn).mapEntries((Function1 & Serializable)_$14 -> package$.MODULE$.ZipEntryExtensions((ZipEntry)_$14).extractTo(destinationDirectory, (Function0<InputStream>)((Function0 & Serializable)() -> File.streamedUnzip$$anonfun$1$$anonfun$1$$anonfun$1(zipIn)))).size());
        return destinationDirectory;
    }

    public File streamedUnzip$default$1() {
        String string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.name()), ".zip");
        Option<File> option = File$.MODULE$.newTemporaryDirectory$default$2();
        return File$.MODULE$.newTemporaryDirectory(string, option, File$.MODULE$.newTemporaryDirectory$default$3(string, option));
    }

    public Charset streamedUnzip$default$2(File destinationDirectory) {
        return package$.MODULE$.DefaultCharset();
    }

    public File unGzipTo(File destination, boolean append, int bufferSize) {
        this.gzipInputStream(bufferSize).foreach((JProcedure1 & Serializable)in -> destination.createFileIfNotExists(true, destination.createFileIfNotExists$default$2(true), destination.createFileIfNotExists$default$3(true)).fileOutputStream(append).foreach((Function1 & Serializable)out -> (FileOutputStream)package$.MODULE$.InputStreamExtensions((InputStream)in).pipeTo((OutputStream)out, bufferSize)));
        return destination;
    }

    public File unGzipTo$default$1() {
        String string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.name()), ".gz");
        String string2 = File$.MODULE$.newTemporaryFile$default$1();
        Option<File> option = File$.MODULE$.newTemporaryFile$default$3();
        return File$.MODULE$.newTemporaryFile(string2, string, option, File$.MODULE$.newTemporaryFile$default$4(string2, string, option));
    }

    public boolean unGzipTo$default$2() {
        return false;
    }

    public int unGzipTo$default$3() {
        return package$.MODULE$.DefaultBufferSize();
    }

    public File gzipTo(File destination, int bufferSize, boolean syncFlush, boolean append) {
        this.fileInputStream().foreach((JProcedure1 & Serializable)in -> destination.createFileIfNotExists(true, destination.createFileIfNotExists$default$2(true), destination.createFileIfNotExists$default$3(true)).gzipOutputStream(bufferSize, syncFlush, append).foreach((Function1 & Serializable)out -> (GZIPOutputStream)package$.MODULE$.InputStreamExtensions(package$.MODULE$.InputStreamExtensions((InputStream)in).buffered(bufferSize)).pipeTo((OutputStream)out, bufferSize)));
        return destination;
    }

    public File gzipTo$default$1() {
        String string = new StringBuilder(3).append(this.name()).append(".gz").toString();
        String string2 = File$.MODULE$.newTemporaryFile$default$1();
        Option<File> option = File$.MODULE$.newTemporaryFile$default$3();
        return File$.MODULE$.newTemporaryFile(string2, string, option, File$.MODULE$.newTemporaryFile$default$4(string2, string, option));
    }

    public int gzipTo$default$2() {
        return package$.MODULE$.DefaultBufferSize();
    }

    public boolean gzipTo$default$3() {
        return false;
    }

    public boolean gzipTo$default$4() {
        return false;
    }

    public File zipIn(Iterator<File> files, int compressionLevel, Charset charset) {
        package$.MODULE$.DisposeableExtensions(package$.MODULE$.ZipOutputStreamExtensions(this.newZipOutputStream(File$OpenOptions$.MODULE$.default(), charset)).withCompressionLevel(compressionLevel), (Disposable)Disposable$.MODULE$.closableDisposer()).autoClosed().foreach((JProcedure1 & Serializable)output -> files.foreach((Function1)(JProcedure1 & Serializable)input -> {
            int n = input.walk$default$1();
            input.walk(n, input.walk$default$2(n)).withFilter((Function1 & Serializable)file -> !this.name().contentEquals(file.name())).map((Function1 & Serializable)file -> {
                Path name = input.parent().relativize((File)file);
                return Tuple2$.MODULE$.apply(file, (Object)name);
            }).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    File file = (File)tuple2._1();
                    Path name = (Path)tuple2._2();
                    return package$.MODULE$.ZipOutputStreamExtensions((ZipOutputStream)output).add(file, name.toString());
                }
                throw new MatchError((Object)tuple2);
            });
        }));
        return this;
    }

    public int zipIn$default$2() {
        return -1;
    }

    public Charset zipIn$default$3(Iterator<File> files, int compressionLevel) {
        return package$.MODULE$.DefaultCharset();
    }

    public File unzip(Function1<ZipEntry, Object> zipFilter, Charset charset) {
        String string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.name()), ".zip");
        Option<File> option = File$.MODULE$.newTemporaryDirectory$default$2();
        return this.unzipTo(File$.MODULE$.newTemporaryDirectory(string, option, File$.MODULE$.newTemporaryDirectory$default$3(string, option)), zipFilter, charset);
    }

    public Function1<ZipEntry, Object> unzip$default$1() {
        return (Function1 & Serializable)_$15 -> true;
    }

    public Charset unzip$default$2(Function1<ZipEntry, Object> zipFilter) {
        return package$.MODULE$.DefaultCharset();
    }

    public Dispose<File> toTemporary() {
        return new Dispose<File>(this, Disposable$.MODULE$.fileDisposer());
    }

    private static final String name$$anonfun$1() {
        return "";
    }

    private final String extension$$anonfun$1(boolean includeDot$1, boolean includeAll$1, boolean toLowerCase$1) {
        int dot = this.indexOfExtension(includeAll$1);
        int index = includeDot$1 ? dot : dot + 1;
        String extension = this.name().substring(index);
        if (toLowerCase$1) {
            return extension.toLowerCase();
        }
        return extension;
    }

    private final File symbolicLink$$anonfun$1() {
        return new File(Files.readSymbolicLink(this.path()), this.fileSystem());
    }

    private static final boolean isLocked$$anonfun$2() {
        return true;
    }

    private static final Object moveToDirectory$$anonfun$1(File directory$1) {
        return new StringBuilder(20).append(directory$1).append(" must be a directory").toString();
    }

    private static final Object copyToDirectory$$anonfun$1(File directory$2) {
        return new StringBuilder(20).append(directory$2).append(" must be a directory").toString();
    }

    private static final InputStream unzipTo$$anonfun$1$$anonfun$1$$anonfun$1(ZipFile zipFile$2, ZipEntry entry$1) {
        return zipFile$2.getInputStream(entry$1);
    }

    private static final InputStream streamedUnzip$$anonfun$1$$anonfun$1$$anonfun$1(ZipInputStream zipIn$2) {
        return zipIn$2;
    }

    public static interface Monitor
    extends AutoCloseable {
        public File root();

        public static void onEvent$(Monitor $this, WatchEvent.Kind eventType, File file, int count) {
            $this.onEvent(eventType, file, count);
        }

        default public void onEvent(WatchEvent.Kind<Path> eventType, File file, int count) {
            WatchEvent.Kind<Path> kind = eventType;
            WatchEvent.Kind<Path> kind2 = StandardWatchEventKinds.ENTRY_CREATE;
            WatchEvent.Kind<Path> kind3 = kind;
            if (!(kind2 != null ? !kind2.equals(kind3) : kind3 != null)) {
                this.onCreate(file, count);
                return;
            }
            WatchEvent.Kind<Path> kind4 = StandardWatchEventKinds.ENTRY_MODIFY;
            WatchEvent.Kind<Path> kind5 = kind;
            if (!(kind4 != null ? !kind4.equals(kind5) : kind5 != null)) {
                this.onModify(file, count);
                return;
            }
            WatchEvent.Kind<Path> kind6 = StandardWatchEventKinds.ENTRY_DELETE;
            WatchEvent.Kind<Path> kind7 = kind;
            if (!(kind6 != null ? !kind6.equals(kind7) : kind7 != null)) {
                this.onDelete(file, count);
                return;
            }
            throw new MatchError(kind);
        }

        public void start(ExecutionContext var1);

        public void onCreate(File var1, int var2);

        public void onModify(File var1, int var2);

        public void onDelete(File var1, int var2);

        public void onUnknownEvent(WatchEvent<?> var1);

        public void onException(Throwable var1);

        public static void stop$(Monitor $this) {
            $this.stop();
        }

        default public void stop() {
            this.close();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class PathMatcherSyntax {
        private final String name;

        public static PathMatcherSyntax default() {
            return File$PathMatcherSyntax$.MODULE$.default();
        }

        public static PathMatcherSyntax glob() {
            return File$PathMatcherSyntax$.MODULE$.glob();
        }

        public static PathMatcherSyntax regex() {
            return File$PathMatcherSyntax$.MODULE$.regex();
        }

        public PathMatcherSyntax(String name) {
            this.name = name;
        }

        public PathMatcher apply(File file, String pattern, boolean includePath) {
            String escapedPath = includePath ? this.escapePath(new StringBuilder(0).append(file.path().toString()).append(file.fileSystem().getSeparator()).toString()) : "";
            return file.fileSystem().getPathMatcher(new StringBuilder(1).append(this.name).append(":").append(escapedPath).append(pattern).toString());
        }

        public abstract String escapePath(String var1);
    }

    public static class RandomAccessMode {
        private final String value;

        public static RandomAccessMode read() {
            return File$RandomAccessMode$.MODULE$.read();
        }

        public static RandomAccessMode readWrite() {
            return File$RandomAccessMode$.MODULE$.readWrite();
        }

        public static RandomAccessMode readWriteContentSynchronous() {
            return File$RandomAccessMode$.MODULE$.readWriteContentSynchronous();
        }

        public static RandomAccessMode readWriteMetadataSynchronous() {
            return File$RandomAccessMode$.MODULE$.readWriteMetadataSynchronous();
        }

        public RandomAccessMode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

