/*
 * Decompiled with CFR 0.152.
 */
package better.files;

import better.files.ReaderInputStream$;
import better.files.package$;
import java.io.InputStream;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;

public class ReaderInputStream
extends InputStream {
    private final Reader reader;
    private final CharsetEncoder encoder;
    private final CharBuffer encoderIn;
    private final ByteBuffer encoderOut;
    private CoderResult lastCoderResult;
    private boolean endOfInput;

    public static int $lessinit$greater$default$2() {
        return ReaderInputStream$.MODULE$.$lessinit$greater$default$2();
    }

    public static Charset $lessinit$greater$default$3(Reader reader, int n) {
        return ReaderInputStream$.MODULE$.$lessinit$greater$default$3(reader, n);
    }

    public ReaderInputStream(Reader reader, CharsetEncoder encoder, int bufferSize) {
        this.reader = reader;
        this.encoder = encoder;
        this.encoderIn = (CharBuffer)CharBuffer.allocate(bufferSize).flip();
        this.encoderOut = (ByteBuffer)ByteBuffer.allocate(bufferSize >> 4).flip();
        this.lastCoderResult = CoderResult.UNDERFLOW;
        this.endOfInput = false;
    }

    public ReaderInputStream(Reader reader, int bufferSize, Charset charset) {
        this(reader, charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE), bufferSize);
    }

    private Buffer fillBuffer() {
        if (this.endOfInput) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        if (this.lastCoderResult.isUnderflow()) {
            Object object;
            int position = this.encoderIn.compact().position();
            int n = this.reader.read(this.encoderIn.array(), position, this.encoderIn.remaining());
            if (package$.MODULE$.EOF() == n) {
                this.endOfInput = true;
                object = BoxedUnit.UNIT;
            } else {
                int c = n;
                object = this.encoderIn.position(position + c);
            }
            this.encoderIn.flip();
        }
        this.lastCoderResult = this.encoder.encode(this.encoderIn, this.encoderOut.compact(), this.endOfInput);
        return this.encoderOut.flip();
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (len < 0 || off < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException(new StringBuilder(29).append("Array Size=").append(b.length).append(", offset=").append(off).append(", length=").append(len).toString());
        }
        if (len == 0) {
            return 0;
        }
        IntRef read = IntRef.create((int)0);
        this.loop$1(b, read, off, len);
        if (read.elem == 0 && this.endOfInput) {
            return package$.MODULE$.EOF();
        }
        return read.elem;
    }

    @Override
    public final int read() {
        while (!this.encoderOut.hasRemaining()) {
            if (this.endOfInput) {
                return package$.MODULE$.EOF();
            }
            this.fillBuffer();
        }
        return this.encoderOut.get() & 0xFF;
    }

    @Override
    public void close() {
        this.reader.close();
    }

    private final void loop$1(byte[] b$1, IntRef read$1, int off, int len) {
        while (len > 0) {
            if (this.encoderOut.hasRemaining()) {
                int n;
                int c = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.encoderOut.remaining()), len);
                this.encoderOut.get(b$1, off, c);
                read$1.elem = n = read$1.elem + c;
                int n2 = off + c;
                int n3 = len - c;
                off = n2;
                len = n3;
                continue;
            }
            if (!this.endOfInput) {
                this.fillBuffer();
                continue;
            }
            return;
        }
    }
}

