/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.classpath;

import dotty.tools.dotc.classpath.FileUtils$;
import dotty.tools.dotc.classpath.PackageEntry;
import dotty.tools.dotc.classpath.PackageEntryImpl;
import dotty.tools.dotc.classpath.PackageEntryImpl$;
import dotty.tools.dotc.classpath.PackageName;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.ClassRepresentation;
import dotty.tools.io.EfficientClassPath;
import dotty.tools.io.FileZipArchive;
import dotty.tools.io.ZipArchive;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;

public interface ZipArchiveFileLookup<FileEntryType extends ClassRepresentation>
extends EfficientClassPath {
    public static void $init$(ZipArchiveFileLookup $this) {
        if (!(!($this.zipFile() == null))) {
            throw Scala3RunTime$.MODULE$.assertFailed("Zip file in ZipArchiveFileLookup cannot be null");
        }
        $this.dotty$tools$dotc$classpath$ZipArchiveFileLookup$_setter_$dotty$tools$dotc$classpath$ZipArchiveFileLookup$$archive_$eq(new FileZipArchive($this.zipFile().toPath(), $this.release()));
    }

    public File zipFile();

    public Option<String> release();

    public static Seq asURLs$(ZipArchiveFileLookup $this) {
        return $this.asURLs();
    }

    @Override
    default public Seq<URL> asURLs() {
        return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)this.zipFile().toURI().toURL()), Nil$.MODULE$));
    }

    public static Seq asClassPathStrings$(ZipArchiveFileLookup $this) {
        return $this.asClassPathStrings();
    }

    @Override
    default public Seq<String> asClassPathStrings() {
        return (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)this.zipFile().getPath()), Nil$.MODULE$));
    }

    public FileZipArchive dotty$tools$dotc$classpath$ZipArchiveFileLookup$$archive();

    public void dotty$tools$dotc$classpath$ZipArchiveFileLookup$_setter_$dotty$tools$dotc$classpath$ZipArchiveFileLookup$$archive_$eq(FileZipArchive var1);

    public static Seq packages$(ZipArchiveFileLookup $this, PackageName inPackage) {
        return $this.packages(inPackage);
    }

    @Override
    default public Seq<PackageEntry> packages(PackageName inPackage) {
        return (Seq)Option$.MODULE$.option2Iterable(this.findDirEntry(inPackage)).toSeq().flatMap((Function1<ZipArchive.DirEntry, IterableOnce> & Serializable)dirEntry -> dirEntry.iterator().withFilter((Function1<ZipArchive.Entry, Object>)(Function1<ZipArchive.Entry, Boolean> & Serializable)entry -> FileUtils$.MODULE$.isPackage((AbstractFile)entry)).map((Function1<ZipArchive.Entry, PackageEntryImpl> & Serializable)entry -> PackageEntryImpl$.MODULE$.apply(inPackage.entryName(entry.name()))));
    }

    public static Seq files$(ZipArchiveFileLookup $this, PackageName inPackage) {
        return $this.files(inPackage);
    }

    default public Seq<FileEntryType> files(PackageName inPackage) {
        return (Seq)Option$.MODULE$.option2Iterable(this.findDirEntry(inPackage)).toSeq().flatMap((Function1<ZipArchive.DirEntry, IterableOnce> & Serializable)dirEntry -> dirEntry.iterator().withFilter((Function1<ZipArchive.Entry, Object>)(Function1<ZipArchive.Entry, Boolean> & Serializable)entry -> this.isRequiredFileType((AbstractFile)entry)).map((Function1<ZipArchive.Entry, ClassRepresentation> & Serializable)entry -> this.createFileEntry((ZipArchive.Entry)entry)));
    }

    public static Option file$(ZipArchiveFileLookup $this, PackageName inPackage, String name) {
        return $this.file(inPackage, name);
    }

    default public Option<FileEntryType> file(PackageName inPackage, String name) {
        return this.findDirEntry(inPackage).flatMap((Function1<ZipArchive.DirEntry, Option> & Serializable)dirEntry -> Option$.MODULE$.apply(dirEntry.lookupName(name, false)).withFilter((Function1<ZipArchive.Entry, Object>)(Function1<ZipArchive.Entry, Boolean> & Serializable)entry -> this.isRequiredFileType((AbstractFile)entry)).map((Function1<ZipArchive.Entry, ClassRepresentation> & Serializable)entry -> this.createFileEntry((ZipArchive.Entry)entry)));
    }

    public static boolean hasPackage$(ZipArchiveFileLookup $this, PackageName pkg) {
        return $this.hasPackage(pkg);
    }

    @Override
    default public boolean hasPackage(PackageName pkg) {
        return this.findDirEntry(pkg).isDefined();
    }

    public static void list$(ZipArchiveFileLookup $this, PackageName inPackage, Function1 onPackageEntry, Function1 onClassesAndSources) {
        $this.list(inPackage, onPackageEntry, onClassesAndSources);
    }

    @Override
    default public void list(PackageName inPackage, Function1<PackageEntry, BoxedUnit> onPackageEntry, Function1<ClassRepresentation, BoxedUnit> onClassesAndSources) {
        Option<ZipArchive.DirEntry> option = this.findDirEntry(inPackage);
        if (option instanceof Some) {
            ZipArchive.DirEntry dirEntry = (ZipArchive.DirEntry)((Some)option).value();
            dirEntry.iterator().foreach(entry -> {
                if (FileUtils$.MODULE$.isPackage((AbstractFile)entry)) {
                    onPackageEntry.apply(PackageEntryImpl$.MODULE$.apply(inPackage.entryName(entry.name())));
                    return;
                }
                if (this.isRequiredFileType((AbstractFile)entry)) {
                    onClassesAndSources.apply((ClassRepresentation)this.createFileEntry((ZipArchive.Entry)entry));
                    return;
                }
            });
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private Option<ZipArchive.DirEntry> findDirEntry(PackageName pkg) {
        return this.dotty$tools$dotc$classpath$ZipArchiveFileLookup$$archive().allDirs().get(pkg.dirPathTrailingSlashJar());
    }

    public FileEntryType createFileEntry(ZipArchive.Entry var1);

    public boolean isRequiredFileType(AbstractFile var1);
}

